/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class Native {
    private static Unsafe unsafe = XlibWrapper.unsafe;
    static int longSize;
    static int dataModel;

    Native() {
    }

    static boolean getBool(long ptr) {
        return Native.getInt(ptr) != 0;
    }

    static boolean getBool(long ptr, int index) {
        return Native.getInt(ptr, index) != 0;
    }

    static void putBool(long ptr, boolean data) {
        Native.putInt(ptr, data ? 1 : 0);
    }

    static void putBool(long ptr, int index, boolean data) {
        Native.putInt(ptr, index, data ? 1 : 0);
    }

    static int getByteSize() {
        return 1;
    }

    static byte getByte(long ptr) {
        return unsafe.getByte(ptr);
    }

    static byte getByte(long ptr, int index) {
        return Native.getByte(ptr + (long)index);
    }

    static void putByte(long ptr, byte data) {
        unsafe.putByte(ptr, data);
    }

    static void putByte(long ptr, int index, byte data) {
        Native.putByte(ptr + (long)index, data);
    }

    static byte[] toBytes(long data, int length) {
        if (data == 0L) {
            return null;
        }
        byte[] res = new byte[length];
        int i = 0;
        while (i < length) {
            res[i] = Native.getByte(data);
            ++i;
            ++data;
        }
        return res;
    }

    static long toData(byte[] bytes) {
        if (bytes == null) {
            return 0L;
        }
        long res = XlibWrapper.unsafe.allocateMemory(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            Native.putByte(res + (long)i, bytes[i]);
        }
        return res;
    }

    static int getUByteSize() {
        return 1;
    }

    static short getUByte(long ptr) {
        return (short)(0xFF & unsafe.getByte(ptr));
    }

    static short getUByte(long ptr, int index) {
        return Native.getUByte(ptr + (long)index);
    }

    static void putUByte(long ptr, short data) {
        unsafe.putByte(ptr, (byte)data);
    }

    static void putUByte(long ptr, int index, short data) {
        Native.putUByte(ptr + (long)index, data);
    }

    static short[] toUBytes(long data, int length) {
        if (data == 0L) {
            return null;
        }
        short[] res = new short[length];
        int i = 0;
        while (i < length) {
            res[i] = Native.getUByte(data);
            ++i;
            ++data;
        }
        return res;
    }

    static long toUData(short[] bytes) {
        if (bytes == null) {
            return 0L;
        }
        long res = XlibWrapper.unsafe.allocateMemory(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            Native.putUByte(res + (long)i, bytes[i]);
        }
        return res;
    }

    static int getShortSize() {
        return 2;
    }

    static short getShort(long ptr) {
        return unsafe.getShort(ptr);
    }

    static void putShort(long ptr, short data) {
        unsafe.putShort(ptr, data);
    }

    static void putShort(long ptr, int index, short data) {
        Native.putShort(ptr + (long)(index * Native.getShortSize()), data);
    }

    static long toData(short[] shorts) {
        if (shorts == null) {
            return 0L;
        }
        long res = XlibWrapper.unsafe.allocateMemory(shorts.length * Native.getShortSize());
        for (int i = 0; i < shorts.length; ++i) {
            Native.putShort(res, i, shorts[i]);
        }
        return res;
    }

    static int getUShortSize() {
        return 2;
    }

    static int getUShort(long ptr) {
        return 0xFFFF & unsafe.getShort(ptr);
    }

    static void putUShort(long ptr, int data) {
        unsafe.putShort(ptr, (short)data);
    }

    static void putUShort(long ptr, int index, int data) {
        Native.putUShort(ptr + (long)(index * Native.getShortSize()), data);
    }

    static long toUData(int[] shorts) {
        if (shorts == null) {
            return 0L;
        }
        long res = XlibWrapper.unsafe.allocateMemory(shorts.length * Native.getShortSize());
        for (int i = 0; i < shorts.length; ++i) {
            Native.putUShort(res, i, shorts[i]);
        }
        return res;
    }

    static int getIntSize() {
        return 4;
    }

    static int getInt(long ptr) {
        return unsafe.getInt(ptr);
    }

    static int getInt(long ptr, int index) {
        return Native.getInt(ptr + (long)(Native.getIntSize() * index));
    }

    static void putInt(long ptr, int data) {
        unsafe.putInt(ptr, data);
    }

    static void putInt(long ptr, int index, int data) {
        Native.putInt(ptr + (long)(index * Native.getIntSize()), data);
    }

    static long toData(int[] ints) {
        if (ints == null) {
            return 0L;
        }
        long res = XlibWrapper.unsafe.allocateMemory(ints.length * Native.getIntSize());
        for (int i = 0; i < ints.length; ++i) {
            Native.putInt(res, i, ints[i]);
        }
        return res;
    }

    static int getUIntSize() {
        return 4;
    }

    static long getUInt(long ptr) {
        return 0xFFFFFFFFL & (long)unsafe.getInt(ptr);
    }

    static long getUInt(long ptr, int index) {
        return Native.getUInt(ptr + (long)(Native.getIntSize() * index));
    }

    static void putUInt(long ptr, long data) {
        unsafe.putInt(ptr, (int)data);
    }

    static void putUInt(long ptr, int index, long data) {
        Native.putUInt(ptr + (long)(index * Native.getIntSize()), data);
    }

    static long toUData(long[] ints) {
        if (ints == null) {
            return 0L;
        }
        long res = XlibWrapper.unsafe.allocateMemory(ints.length * Native.getIntSize());
        for (int i = 0; i < ints.length; ++i) {
            Native.putUInt(res, i, ints[i]);
        }
        return res;
    }

    static int getLongSize() {
        return longSize;
    }

    static long getLong(long ptr) {
        if (XlibWrapper.dataModel == 32) {
            return unsafe.getInt(ptr);
        }
        return unsafe.getLong(ptr);
    }

    static void putLong(long ptr, long data) {
        if (XlibWrapper.dataModel == 32) {
            unsafe.putInt(ptr, (int)data);
        } else {
            unsafe.putLong(ptr, data);
        }
    }

    static void putLong(long ptr, int index, long data) {
        Native.putLong(ptr + (long)(index * Native.getLongSize()), data);
    }

    static long getLong(long ptr, int index) {
        return Native.getLong(ptr + (long)(index * Native.getLongSize()));
    }

    static void put(long ptr, long[] arr) {
        int i = 0;
        while (i < arr.length) {
            Native.putLong(ptr, arr[i]);
            ++i;
            ptr += (long)Native.getLongSize();
        }
    }

    static void putLong(long ptr, Vector arr) {
        int i = 0;
        while (i < arr.size()) {
            Native.putLong(ptr, (Long)arr.elementAt(i));
            ++i;
            ptr += (long)Native.getLongSize();
        }
    }

    static void putLongReverse(long ptr, Vector arr) {
        int i = arr.size() - 1;
        while (i >= 0) {
            Native.putLong(ptr, (Long)arr.elementAt(i));
            --i;
            ptr += (long)Native.getLongSize();
        }
    }

    static long[] toLongs(long data, int length) {
        if (data == 0L) {
            return null;
        }
        long[] res = new long[length];
        int i = 0;
        while (i < length) {
            res[i] = Native.getLong(data);
            ++i;
            data += (long)Native.getLongSize();
        }
        return res;
    }

    static long toData(long[] longs) {
        if (longs == null) {
            return 0L;
        }
        long res = XlibWrapper.unsafe.allocateMemory(longs.length * Native.getLongSize());
        for (int i = 0; i < longs.length; ++i) {
            Native.putLong(res, i, longs[i]);
        }
        return res;
    }

    static long getULong(long ptr) {
        if (XlibWrapper.dataModel == 32) {
            return (long)unsafe.getInt(ptr) & 0xFFFFFFFFL;
        }
        return unsafe.getLong(ptr);
    }

    static void putULong(long ptr, long value) {
        Native.putLong(ptr, value);
    }

    static long allocateLongArray(int length) {
        return unsafe.allocateMemory(Native.getLongSize() * length);
    }

    static long getWindow(long ptr) {
        return Native.getLong(ptr);
    }

    static long getWindow(long ptr, int index) {
        return Native.getLong(ptr + (long)(Native.getWindowSize() * index));
    }

    static void putWindow(long ptr, long window) {
        Native.putLong(ptr, window);
    }

    static void putWindow(long ptr, int index, long window) {
        Native.putLong(ptr, index, window);
    }

    static int getWindowSize() {
        return Native.getLongSize();
    }

    static long getCard32(long ptr) {
        return Native.getLong(ptr);
    }

    static void putCard32(long ptr, long value) {
        Native.putLong(ptr, value);
    }

    static long getCard32(long ptr, int index) {
        return Native.getLong(ptr, index);
    }

    static void putCard32(long ptr, int index, long value) {
        Native.putLong(ptr, index, value);
    }

    static int getCard32Size() {
        return Native.getLongSize();
    }

    static long[] card32ToArray(long ptr, int length) {
        return Native.toLongs(ptr, length);
    }

    static long card32ToData(long[] arr) {
        return Native.toData(arr);
    }

    static {
        String dataModelProp = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("sun.arch.data.model");
            }
        });
        try {
            dataModel = Integer.parseInt(dataModelProp);
        }
        catch (Exception e) {
            dataModel = 32;
        }
        longSize = dataModel == 32 ? 4 : 8;
    }
}

