/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XKeyboardState
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 56;
    }

    @Override
    public int getDataSize() {
        return XKeyboardState.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XKeyboardState(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XKeyboardState() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XKeyboardState.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_key_click_percent() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_key_click_percent(int v) {
        log.finest("");
        Native.putInt(this.pData + 0L, v);
    }

    public int get_bell_percent() {
        log.finest("");
        return Native.getInt(this.pData + 4L);
    }

    public void set_bell_percent(int v) {
        log.finest("");
        Native.putInt(this.pData + 4L, v);
    }

    public int get_bell_pitch() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_bell_pitch(int v) {
        log.finest("");
        Native.putInt(this.pData + 8L, v);
    }

    public int get_bell_duration() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_bell_duration(int v) {
        log.finest("");
        Native.putInt(this.pData + 12L, v);
    }

    public long get_led_mask() {
        log.finest("");
        return Native.getLong(this.pData + 16L);
    }

    public void set_led_mask(long v) {
        log.finest("");
        Native.putLong(this.pData + 16L, v);
    }

    public int get_global_auto_repeat() {
        log.finest("");
        return Native.getInt(this.pData + 20L);
    }

    public void set_global_auto_repeat(int v) {
        log.finest("");
        Native.putInt(this.pData + 20L, v);
    }

    public byte get_auto_repeats(int index) {
        log.finest("");
        return Native.getByte(this.pData + 24L + (long)(index * 1));
    }

    public void set_auto_repeats(int index, byte v) {
        log.finest("");
        Native.putByte(this.pData + 24L + (long)(index * 1), v);
    }

    public long get_auto_repeats() {
        log.finest("");
        return this.pData + 24L;
    }

    @Override
    String getName() {
        return "XKeyboardState";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(280);
        ret.append("key_click_percent = ").append(this.get_key_click_percent()).append(", ");
        ret.append("bell_percent = ").append(this.get_bell_percent()).append(", ");
        ret.append("bell_pitch = ").append(this.get_bell_pitch()).append(", ");
        ret.append("bell_duration = ").append(this.get_bell_duration()).append(", ");
        ret.append("led_mask = ").append(this.get_led_mask()).append(", ");
        ret.append("global_auto_repeat = ").append(this.get_global_auto_repeat()).append(", ");
        ret.append("{").append(this.get_auto_repeats(0)).append(" ").append(this.get_auto_repeats(1)).append(" ").append(this.get_auto_repeats(2)).append(" ").append(this.get_auto_repeats(3)).append(" ").append(this.get_auto_repeats(4)).append(" ").append(this.get_auto_repeats(5)).append(" ").append(this.get_auto_repeats(6)).append(" ").append(this.get_auto_repeats(7)).append(" ").append(this.get_auto_repeats(8)).append(" ").append(this.get_auto_repeats(9)).append(" ").append(this.get_auto_repeats(10)).append(" ").append(this.get_auto_repeats(11)).append(" ").append(this.get_auto_repeats(12)).append(" ").append(this.get_auto_repeats(13)).append(" ").append(this.get_auto_repeats(14)).append(" ").append(this.get_auto_repeats(15)).append(" ").append(this.get_auto_repeats(16)).append(" ").append(this.get_auto_repeats(17)).append(" ").append(this.get_auto_repeats(18)).append(" ").append(this.get_auto_repeats(19)).append(" ").append(this.get_auto_repeats(20)).append(" ").append(this.get_auto_repeats(21)).append(" ").append(this.get_auto_repeats(22)).append(" ").append(this.get_auto_repeats(23)).append(" ").append(this.get_auto_repeats(24)).append(" ").append(this.get_auto_repeats(25)).append(" ").append(this.get_auto_repeats(26)).append(" ").append(this.get_auto_repeats(27)).append(" ").append(this.get_auto_repeats(28)).append(" ").append(this.get_auto_repeats(29)).append(" ").append(this.get_auto_repeats(30)).append(" ").append(this.get_auto_repeats(31)).append(" ").append("}");
        return ret.toString();
    }
}

