/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.font.LineMetrics;
import sun.font.FontLineMetrics;

public final class CoreMetrics {
    public final float ascent;
    public final float descent;
    public final float leading;
    public final float height;
    public final int baselineIndex;
    public final float[] baselineOffsets;
    public final float strikethroughOffset;
    public final float strikethroughThickness;
    public final float underlineOffset;
    public final float underlineThickness;
    public final float ssOffset;
    public final float italicAngle;

    public CoreMetrics(float ascent, float descent, float leading, float height, int baselineIndex, float[] baselineOffsets, float strikethroughOffset, float strikethroughThickness, float underlineOffset, float underlineThickness, float ssOffset, float italicAngle) {
        this.ascent = ascent;
        this.descent = descent;
        this.leading = leading;
        this.height = height;
        this.baselineIndex = baselineIndex;
        this.baselineOffsets = baselineOffsets;
        this.strikethroughOffset = strikethroughOffset;
        this.strikethroughThickness = strikethroughThickness;
        this.underlineOffset = underlineOffset;
        this.underlineThickness = underlineThickness;
        this.ssOffset = ssOffset;
        this.italicAngle = italicAngle;
    }

    public static CoreMetrics get(LineMetrics lm) {
        return ((FontLineMetrics)lm).cm;
    }

    public final int hashCode() {
        return Float.floatToIntBits(this.ascent + this.ssOffset);
    }

    public final boolean equals(Object rhs) {
        try {
            return this.equals((CoreMetrics)rhs);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public final boolean equals(CoreMetrics rhs) {
        if (rhs != null) {
            if (this == rhs) {
                return true;
            }
            return this.ascent == rhs.ascent && this.descent == rhs.descent && this.leading == rhs.leading && this.baselineIndex == rhs.baselineIndex && this.baselineOffsets[0] == rhs.baselineOffsets[0] && this.baselineOffsets[1] == rhs.baselineOffsets[1] && this.baselineOffsets[2] == rhs.baselineOffsets[2] && this.strikethroughOffset == rhs.strikethroughOffset && this.strikethroughThickness == rhs.strikethroughThickness && this.underlineOffset == rhs.underlineOffset && this.underlineThickness == rhs.underlineThickness && this.ssOffset == rhs.ssOffset && this.italicAngle == rhs.italicAngle;
        }
        return false;
    }

    public final float effectiveBaselineOffset(float[] fullOffsets) {
        switch (this.baselineIndex) {
            case -1: {
                return fullOffsets[4] + this.ascent;
            }
            case -2: {
                return fullOffsets[3] - this.descent;
            }
        }
        return fullOffsets[this.baselineIndex];
    }
}

