/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import sun.invoke.util.Wrapper;

public class ValueConversions {
    private static final Class<?> THIS_CLASS = ValueConversions.class;
    private static final int MAX_ARITY;
    private static final MethodHandles.Lookup IMPL_LOOKUP;
    private static final EnumMap<Wrapper, MethodHandle>[] UNBOX_CONVERSIONS;
    private static final Integer ZERO_INT;
    private static final Integer ONE_INT;
    private static final EnumMap<Wrapper, MethodHandle>[] BOX_CONVERSIONS;
    private static final EnumMap<Wrapper, MethodHandle>[] CONSTANT_FUNCTIONS;
    private static final MethodHandle IDENTITY;
    private static final MethodHandle CAST_REFERENCE;
    private static final MethodHandle ZERO_OBJECT;
    private static final MethodHandle IGNORE;
    private static final MethodHandle EMPTY;
    private static final MethodHandle ARRAY_IDENTITY;
    private static final MethodHandle FILL_NEW_TYPED_ARRAY;
    private static final MethodHandle FILL_NEW_ARRAY;
    private static final MethodHandle COLLECT_ARGUMENTS;
    private static final EnumMap<Wrapper, MethodHandle>[] WRAPPER_CASTS;
    private static final EnumMap<Wrapper, MethodHandle>[] CONVERT_PRIMITIVE_FUNCTIONS;
    private static final Object[] NO_ARGS_ARRAY;
    private static final MethodHandle[] ARRAYS;
    private static final MethodHandle[] FILL_ARRAYS;
    private static final int LEFT_ARGS;
    private static final MethodHandle[] FILL_ARRAY_TO_RIGHT;
    private static final ClassValue<MethodHandle[]> TYPED_COLLECTORS;
    static final int MAX_JVM_ARITY = 255;
    private static final List<Object> NO_ARGS_LIST;
    private static final MethodHandle[] LISTS;

    private static EnumMap<Wrapper, MethodHandle>[] newWrapperCaches(int n) {
        EnumMap[] caches = new EnumMap[n];
        for (int i = 0; i < n; ++i) {
            caches[i] = new EnumMap(Wrapper.class);
        }
        return caches;
    }

    static int unboxInteger(Object x, boolean cast) {
        if (x instanceof Integer) {
            return (Integer)x;
        }
        return ValueConversions.primitiveConversion(Wrapper.INT, x, cast).intValue();
    }

    static byte unboxByte(Object x, boolean cast) {
        if (x instanceof Byte) {
            return (Byte)x;
        }
        return ValueConversions.primitiveConversion(Wrapper.BYTE, x, cast).byteValue();
    }

    static short unboxShort(Object x, boolean cast) {
        if (x instanceof Short) {
            return (Short)x;
        }
        return ValueConversions.primitiveConversion(Wrapper.SHORT, x, cast).shortValue();
    }

    static boolean unboxBoolean(Object x, boolean cast) {
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        return (ValueConversions.primitiveConversion(Wrapper.BOOLEAN, x, cast).intValue() & 1) != 0;
    }

    static char unboxCharacter(Object x, boolean cast) {
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        return (char)ValueConversions.primitiveConversion(Wrapper.CHAR, x, cast).intValue();
    }

    static long unboxLong(Object x, boolean cast) {
        if (x instanceof Long) {
            return (Long)x;
        }
        return ValueConversions.primitiveConversion(Wrapper.LONG, x, cast).longValue();
    }

    static float unboxFloat(Object x, boolean cast) {
        if (x instanceof Float) {
            return ((Float)x).floatValue();
        }
        return ValueConversions.primitiveConversion(Wrapper.FLOAT, x, cast).floatValue();
    }

    static double unboxDouble(Object x, boolean cast) {
        if (x instanceof Double) {
            return (Double)x;
        }
        return ValueConversions.primitiveConversion(Wrapper.DOUBLE, x, cast).doubleValue();
    }

    private static MethodType unboxType(Wrapper wrap) {
        return MethodType.methodType(wrap.primitiveType(), Object.class, Boolean.TYPE);
    }

    private static MethodHandle unbox(Wrapper wrap, boolean cast) {
        EnumMap<Wrapper, MethodHandle> cache = UNBOX_CONVERSIONS[cast ? 1 : 0];
        MethodHandle mh = cache.get((Object)wrap);
        if (mh != null) {
            return mh;
        }
        switch (wrap) {
            case OBJECT: {
                mh = IDENTITY;
                break;
            }
            case VOID: {
                mh = IGNORE;
            }
        }
        if (mh != null) {
            cache.put(wrap, mh);
            return mh;
        }
        String name = "unbox" + wrap.wrapperSimpleName();
        MethodType type = ValueConversions.unboxType(wrap);
        try {
            mh = IMPL_LOOKUP.findStatic(THIS_CLASS, name, type);
        }
        catch (ReflectiveOperationException ex) {
            mh = null;
        }
        if (mh != null) {
            mh = MethodHandles.insertArguments(mh, 1, cast);
            cache.put(wrap, mh);
            return mh;
        }
        throw new IllegalArgumentException("cannot find unbox adapter for " + (Object)((Object)wrap) + (cast ? " (cast)" : ""));
    }

    public static MethodHandle unboxCast(Wrapper type) {
        return ValueConversions.unbox(type, true);
    }

    public static MethodHandle unbox(Class<?> type) {
        return ValueConversions.unbox(Wrapper.forPrimitiveType(type), false);
    }

    public static MethodHandle unboxCast(Class<?> type) {
        return ValueConversions.unbox(Wrapper.forPrimitiveType(type), true);
    }

    public static Number primitiveConversion(Wrapper wrap, Object x, boolean cast) {
        if (x == null) {
            if (!cast) {
                return null;
            }
            return ZERO_INT;
        }
        Number res = x instanceof Number ? (Number)((Number)x) : (Number)(x instanceof Boolean ? (Number)((Boolean)x != false ? ONE_INT : ZERO_INT) : (Number)(x instanceof Character ? (Number)Integer.valueOf(((Character)x).charValue()) : (Number)((Number)x)));
        Wrapper xwrap = Wrapper.findWrapperType(x.getClass());
        if (xwrap == null || !cast && !wrap.isConvertibleFrom(xwrap)) {
            return (Number)wrap.wrapperType().cast(x);
        }
        return res;
    }

    public static int widenSubword(Object x) {
        if (x instanceof Integer) {
            return (Integer)x;
        }
        if (x instanceof Boolean) {
            return ValueConversions.fromBoolean((Boolean)x);
        }
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        if (x instanceof Short) {
            return ((Short)x).shortValue();
        }
        if (x instanceof Byte) {
            return ((Byte)x).byteValue();
        }
        return (Integer)x;
    }

    static Integer boxInteger(int x) {
        return x;
    }

    static Byte boxByte(byte x) {
        return x;
    }

    static Short boxShort(short x) {
        return x;
    }

    static Boolean boxBoolean(boolean x) {
        return x;
    }

    static Character boxCharacter(char x) {
        return Character.valueOf(x);
    }

    static Long boxLong(long x) {
        return x;
    }

    static Float boxFloat(float x) {
        return Float.valueOf(x);
    }

    static Double boxDouble(double x) {
        return x;
    }

    private static MethodType boxType(Wrapper wrap) {
        Class<?> boxType = wrap.wrapperType();
        return MethodType.methodType(boxType, wrap.primitiveType());
    }

    private static MethodHandle box(Wrapper wrap, boolean exact) {
        EnumMap<Wrapper, MethodHandle> cache = BOX_CONVERSIONS[exact ? 1 : 0];
        MethodHandle mh = cache.get((Object)wrap);
        if (mh != null) {
            return mh;
        }
        switch (wrap) {
            case OBJECT: {
                mh = IDENTITY;
                break;
            }
            case VOID: {
                mh = ZERO_OBJECT;
            }
        }
        if (mh != null) {
            cache.put(wrap, mh);
            return mh;
        }
        String name = "box" + wrap.wrapperSimpleName();
        MethodType type = ValueConversions.boxType(wrap);
        if (exact) {
            try {
                mh = IMPL_LOOKUP.findStatic(THIS_CLASS, name, type);
            }
            catch (ReflectiveOperationException ex) {
                mh = null;
            }
        } else {
            mh = ValueConversions.box(wrap, !exact).asType(type.erase());
        }
        if (mh != null) {
            cache.put(wrap, mh);
            return mh;
        }
        throw new IllegalArgumentException("cannot find box adapter for " + (Object)((Object)wrap) + (exact ? " (exact)" : ""));
    }

    public static MethodHandle box(Class<?> type) {
        boolean exact = false;
        return ValueConversions.box(Wrapper.forPrimitiveType(type), exact);
    }

    public static MethodHandle box(Wrapper type) {
        boolean exact = false;
        return ValueConversions.box(type, exact);
    }

    static void ignore(Object x) {
    }

    static void empty() {
    }

    static Object zeroObject() {
        return null;
    }

    static int zeroInteger() {
        return 0;
    }

    static long zeroLong() {
        return 0L;
    }

    static float zeroFloat() {
        return 0.0f;
    }

    static double zeroDouble() {
        return 0.0;
    }

    public static MethodHandle zeroConstantFunction(Wrapper wrap) {
        EnumMap<Wrapper, MethodHandle> cache = CONSTANT_FUNCTIONS[0];
        MethodHandle mh = cache.get((Object)wrap);
        if (mh != null) {
            return mh;
        }
        MethodType type = MethodType.methodType(wrap.primitiveType());
        switch (wrap) {
            case VOID: {
                mh = EMPTY;
                break;
            }
            case OBJECT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                try {
                    mh = IMPL_LOOKUP.findStatic(THIS_CLASS, "zero" + wrap.wrapperSimpleName(), type);
                    break;
                }
                catch (ReflectiveOperationException ex) {
                    mh = null;
                }
            }
        }
        if (mh != null) {
            cache.put(wrap, mh);
            return mh;
        }
        if (wrap.isSubwordOrInt() && wrap != Wrapper.INT) {
            mh = MethodHandles.explicitCastArguments(ValueConversions.zeroConstantFunction(Wrapper.INT), type);
            cache.put(wrap, mh);
            return mh;
        }
        throw new IllegalArgumentException("cannot find zero constant for " + (Object)((Object)wrap));
    }

    static <T> T identity(T x) {
        return x;
    }

    static <T> T[] identity(T[] x) {
        return x;
    }

    static int identity(int x) {
        return x;
    }

    static byte identity(byte x) {
        return x;
    }

    static short identity(short x) {
        return x;
    }

    static boolean identity(boolean x) {
        return x;
    }

    static char identity(char x) {
        return x;
    }

    static long identity(long x) {
        return x;
    }

    static float identity(float x) {
        return x;
    }

    static double identity(double x) {
        return x;
    }

    static <T, U> T castReference(Class<? extends T> t, U x) {
        if (x != null && !t.isInstance(x)) {
            throw ValueConversions.newClassCastException(t, x);
        }
        return (T)x;
    }

    private static ClassCastException newClassCastException(Class<?> t, Object obj) {
        return new ClassCastException("Cannot cast " + obj.getClass().getName() + " to " + t.getName());
    }

    static MethodHandle collectArguments(MethodHandle mh, int pos, MethodHandle collector) {
        if (COLLECT_ARGUMENTS != null) {
            try {
                return COLLECT_ARGUMENTS.invokeExact(mh, pos, collector);
            }
            catch (Throwable ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                throw new Error(ex.getMessage(), ex);
            }
        }
        mh = MethodHandles.dropArguments(mh, 1, collector.type().parameterList());
        mh = MethodHandles.foldArguments(mh, collector);
        return mh;
    }

    public static MethodHandle cast(Class<?> type) {
        MethodHandle mh;
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("cannot cast primitive type " + type);
        }
        Wrapper wrap = null;
        EnumMap<Wrapper, MethodHandle> cache = null;
        if (Wrapper.isWrapperType(type) && (mh = (cache = WRAPPER_CASTS[0]).get((Object)(wrap = Wrapper.forWrapperType(type)))) != null) {
            return mh;
        }
        mh = MethodHandles.insertArguments(CAST_REFERENCE, 0, type);
        if (cache != null) {
            cache.put(wrap, mh);
        }
        return mh;
    }

    public static MethodHandle identity() {
        return IDENTITY;
    }

    public static MethodHandle identity(Class<?> type) {
        if (!type.isPrimitive()) {
            return MethodHandles.identity(type);
        }
        return ValueConversions.identity(Wrapper.findPrimitiveType(type));
    }

    public static MethodHandle identity(Wrapper wrap) {
        EnumMap<Wrapper, MethodHandle> cache = CONSTANT_FUNCTIONS[1];
        MethodHandle mh = cache.get((Object)wrap);
        if (mh != null) {
            return mh;
        }
        MethodType type = MethodType.methodType(wrap.primitiveType());
        if (wrap != Wrapper.VOID) {
            type = type.appendParameterTypes(wrap.primitiveType());
        }
        try {
            mh = IMPL_LOOKUP.findStatic(THIS_CLASS, "identity", type);
        }
        catch (ReflectiveOperationException ex) {
            mh = null;
        }
        if (mh == null && wrap == Wrapper.VOID) {
            mh = EMPTY;
        }
        if (mh != null) {
            cache.put(wrap, mh);
            return mh;
        }
        if (mh != null) {
            cache.put(wrap, mh);
            return mh;
        }
        throw new IllegalArgumentException("cannot find identity for " + (Object)((Object)wrap));
    }

    static float doubleToFloat(double x) {
        return (float)x;
    }

    static long doubleToLong(double x) {
        return (long)x;
    }

    static int doubleToInt(double x) {
        return (int)x;
    }

    static short doubleToShort(double x) {
        return (short)x;
    }

    static char doubleToChar(double x) {
        return (char)x;
    }

    static byte doubleToByte(double x) {
        return (byte)x;
    }

    static boolean doubleToBoolean(double x) {
        return ValueConversions.toBoolean((byte)x);
    }

    static double floatToDouble(float x) {
        return x;
    }

    static long floatToLong(float x) {
        return (long)x;
    }

    static int floatToInt(float x) {
        return (int)x;
    }

    static short floatToShort(float x) {
        return (short)x;
    }

    static char floatToChar(float x) {
        return (char)x;
    }

    static byte floatToByte(float x) {
        return (byte)x;
    }

    static boolean floatToBoolean(float x) {
        return ValueConversions.toBoolean((byte)x);
    }

    static double longToDouble(long x) {
        return x;
    }

    static float longToFloat(long x) {
        return x;
    }

    static int longToInt(long x) {
        return (int)x;
    }

    static short longToShort(long x) {
        return (short)x;
    }

    static char longToChar(long x) {
        return (char)x;
    }

    static byte longToByte(long x) {
        return (byte)x;
    }

    static boolean longToBoolean(long x) {
        return ValueConversions.toBoolean((byte)x);
    }

    static double intToDouble(int x) {
        return x;
    }

    static float intToFloat(int x) {
        return x;
    }

    static long intToLong(int x) {
        return x;
    }

    static short intToShort(int x) {
        return (short)x;
    }

    static char intToChar(int x) {
        return (char)x;
    }

    static byte intToByte(int x) {
        return (byte)x;
    }

    static boolean intToBoolean(int x) {
        return ValueConversions.toBoolean((byte)x);
    }

    static double shortToDouble(short x) {
        return x;
    }

    static float shortToFloat(short x) {
        return x;
    }

    static long shortToLong(short x) {
        return x;
    }

    static int shortToInt(short x) {
        return x;
    }

    static char shortToChar(short x) {
        return (char)x;
    }

    static byte shortToByte(short x) {
        return (byte)x;
    }

    static boolean shortToBoolean(short x) {
        return ValueConversions.toBoolean((byte)x);
    }

    static double charToDouble(char x) {
        return x;
    }

    static float charToFloat(char x) {
        return x;
    }

    static long charToLong(char x) {
        return x;
    }

    static int charToInt(char x) {
        return x;
    }

    static short charToShort(char x) {
        return (short)x;
    }

    static byte charToByte(char x) {
        return (byte)x;
    }

    static boolean charToBoolean(char x) {
        return ValueConversions.toBoolean((byte)x);
    }

    static double byteToDouble(byte x) {
        return x;
    }

    static float byteToFloat(byte x) {
        return x;
    }

    static long byteToLong(byte x) {
        return x;
    }

    static int byteToInt(byte x) {
        return x;
    }

    static short byteToShort(byte x) {
        return x;
    }

    static char byteToChar(byte x) {
        return (char)x;
    }

    static boolean byteToBoolean(byte x) {
        return ValueConversions.toBoolean(x);
    }

    static double booleanToDouble(boolean x) {
        return ValueConversions.fromBoolean(x);
    }

    static float booleanToFloat(boolean x) {
        return ValueConversions.fromBoolean(x);
    }

    static long booleanToLong(boolean x) {
        return ValueConversions.fromBoolean(x);
    }

    static int booleanToInt(boolean x) {
        return ValueConversions.fromBoolean(x);
    }

    static short booleanToShort(boolean x) {
        return ValueConversions.fromBoolean(x);
    }

    static char booleanToChar(boolean x) {
        return (char)ValueConversions.fromBoolean(x);
    }

    static byte booleanToByte(boolean x) {
        return ValueConversions.fromBoolean(x);
    }

    static boolean toBoolean(byte x) {
        return (x & 1) != 0;
    }

    static byte fromBoolean(boolean x) {
        return x ? (byte)1 : 0;
    }

    public static MethodHandle convertPrimitive(Wrapper wsrc, Wrapper wdst) {
        MethodType type;
        EnumMap<Wrapper, MethodHandle> cache = CONVERT_PRIMITIVE_FUNCTIONS[wsrc.ordinal()];
        MethodHandle mh = cache.get((Object)wdst);
        if (mh != null) {
            return mh;
        }
        Class<?> src = wsrc.primitiveType();
        Class<?> dst = wdst.primitiveType();
        MethodType methodType = type = src == Void.TYPE ? MethodType.methodType(dst) : MethodType.methodType(dst, src);
        if (wsrc == wdst) {
            mh = ValueConversions.identity(src);
        } else if (wsrc == Wrapper.VOID) {
            mh = ValueConversions.zeroConstantFunction(wdst);
        } else if (wdst == Wrapper.VOID) {
            mh = MethodHandles.dropArguments(EMPTY, 0, src);
        } else if (wsrc == Wrapper.OBJECT) {
            mh = ValueConversions.unboxCast(dst);
        } else if (wdst == Wrapper.OBJECT) {
            mh = ValueConversions.box(src);
        } else {
            assert (src.isPrimitive() && dst.isPrimitive());
            try {
                mh = IMPL_LOOKUP.findStatic(THIS_CLASS, src.getSimpleName() + "To" + ValueConversions.capitalize(dst.getSimpleName()), type);
            }
            catch (ReflectiveOperationException ex) {
                mh = null;
            }
        }
        if (mh != null) {
            assert (mh.type() == type) : mh;
            cache.put(wdst, mh);
            return mh;
        }
        throw new IllegalArgumentException("cannot find primitive conversion function for " + src.getSimpleName() + " -> " + dst.getSimpleName());
    }

    public static MethodHandle convertPrimitive(Class<?> src, Class<?> dst) {
        return ValueConversions.convertPrimitive(Wrapper.forPrimitiveType(src), Wrapper.forPrimitiveType(dst));
    }

    private static String capitalize(String x) {
        return Character.toUpperCase(x.charAt(0)) + x.substring(1);
    }

    public static Object convertArrayElements(Class<?> arrayType, Object array) {
        Wrapper dw;
        Class<?> src = array.getClass().getComponentType();
        Class<?> dst = arrayType.getComponentType();
        if (src == null || dst == null) {
            throw new IllegalArgumentException("not array type");
        }
        Wrapper sw = src.isPrimitive() ? Wrapper.forPrimitiveType(src) : null;
        Wrapper wrapper = dw = dst.isPrimitive() ? Wrapper.forPrimitiveType(dst) : null;
        if (sw == null) {
            Object[] a = (Object[])array;
            int length = a.length;
            if (dw == null) {
                return Arrays.copyOf(a, length, arrayType.asSubclass(Object[].class));
            }
            Object res = dw.makeArray(length);
            dw.copyArrayUnboxing(a, 0, res, 0, length);
            return res;
        }
        int length = Array.getLength(array);
        Object[] res = dw == null ? Arrays.copyOf(NO_ARGS_ARRAY, length, arrayType.asSubclass(Object[].class)) : new Object[length];
        sw.copyArrayBoxing(array, 0, res, 0, length);
        if (dw == null) {
            return res;
        }
        Object a = dw.makeArray(length);
        dw.copyArrayUnboxing(res, 0, a, 0, length);
        return a;
    }

    private static MethodHandle findCollector(String name, int nargs, Class<?> rtype, Class<?> ... ptypes) {
        MethodType type = MethodType.genericMethodType(nargs).changeReturnType(rtype).insertParameterTypes(0, ptypes);
        try {
            return IMPL_LOOKUP.findStatic(THIS_CLASS, name, type);
        }
        catch (ReflectiveOperationException ex) {
            return null;
        }
    }

    private static Object[] makeArray(Object ... args) {
        return args;
    }

    private static Object[] array() {
        return NO_ARGS_ARRAY;
    }

    private static Object[] array(Object a0) {
        return ValueConversions.makeArray(a0);
    }

    private static Object[] array(Object a0, Object a1) {
        return ValueConversions.makeArray(a0, a1);
    }

    private static Object[] array(Object a0, Object a1, Object a2) {
        return ValueConversions.makeArray(a0, a1, a2);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3) {
        return ValueConversions.makeArray(a0, a1, a2, a3);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4) {
        return ValueConversions.makeArray(a0, a1, a2, a3, a4);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5) {
        return ValueConversions.makeArray(a0, a1, a2, a3, a4, a5);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) {
        return ValueConversions.makeArray(a0, a1, a2, a3, a4, a5, a6);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) {
        return ValueConversions.makeArray(a0, a1, a2, a3, a4, a5, a6, a7);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8) {
        return ValueConversions.makeArray(a0, a1, a2, a3, a4, a5, a6, a7, a8);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8, Object a9) {
        return ValueConversions.makeArray(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
    }

    private static MethodHandle[] makeArrays() {
        MethodHandle mh;
        ArrayList<MethodHandle> mhs = new ArrayList<MethodHandle>();
        while ((mh = ValueConversions.findCollector("array", mhs.size(), Object[].class, new Class[0])) != null) {
            mhs.add(mh);
        }
        assert (mhs.size() == 11);
        return mhs.toArray(new MethodHandle[MAX_ARITY + 1]);
    }

    private static Object[] fillNewArray(Integer len, Object[] args) {
        Object[] a = new Object[len.intValue()];
        ValueConversions.fillWithArguments(a, 0, args);
        return a;
    }

    private static Object[] fillNewTypedArray(Object[] example, Integer len, Object[] args) {
        Object[] a = Arrays.copyOf(example, (int)len);
        ValueConversions.fillWithArguments(a, 0, args);
        return a;
    }

    private static void fillWithArguments(Object[] a, int pos, Object ... args) {
        System.arraycopy(args, 0, a, pos, args.length);
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0) {
        ValueConversions.fillWithArguments(a, pos, a0);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1) {
        ValueConversions.fillWithArguments(a, pos, a0, a1);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2) {
        ValueConversions.fillWithArguments(a, pos, a0, a1, a2);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3) {
        ValueConversions.fillWithArguments(a, pos, a0, a1, a2, a3);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4) {
        ValueConversions.fillWithArguments(a, pos, a0, a1, a2, a3, a4);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5) {
        ValueConversions.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) {
        ValueConversions.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5, a6);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) {
        ValueConversions.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5, a6, a7);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8) {
        ValueConversions.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5, a6, a7, a8);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8, Object a9) {
        ValueConversions.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
        return a;
    }

    private static MethodHandle[] makeFillArrays() {
        MethodHandle mh;
        ArrayList<MethodHandle> mhs = new ArrayList<MethodHandle>();
        mhs.add(null);
        while ((mh = ValueConversions.findCollector("fillArray", mhs.size(), Object[].class, Integer.class, Object[].class)) != null) {
            mhs.add(mh);
        }
        assert (mhs.size() == 11);
        return mhs.toArray(new MethodHandle[0]);
    }

    private static Object[] copyAsReferenceArray(Class<? extends Object[]> arrayType, Object ... a) {
        return Arrays.copyOf(a, a.length, arrayType);
    }

    private static Object copyAsPrimitiveArray(Wrapper w, Object ... boxes) {
        Object a = w.makeArray(boxes.length);
        w.copyArrayUnboxing(boxes, 0, a, 0, boxes.length);
        return a;
    }

    public static MethodHandle varargsArray(int nargs) {
        MethodHandle mh = ARRAYS[nargs];
        if (mh != null) {
            return mh;
        }
        mh = ValueConversions.findCollector("array", nargs, Object[].class, new Class[0]);
        if (mh != null) {
            ValueConversions.ARRAYS[nargs] = mh;
            return ValueConversions.ARRAYS[nargs];
        }
        mh = ValueConversions.buildVarargsArray(FILL_NEW_ARRAY, ARRAY_IDENTITY, nargs);
        assert (ValueConversions.assertCorrectArity(mh, nargs));
        ValueConversions.ARRAYS[nargs] = mh;
        return ValueConversions.ARRAYS[nargs];
    }

    private static boolean assertCorrectArity(MethodHandle mh, int arity) {
        assert (mh.type().parameterCount() == arity) : "arity != " + arity + ": " + mh;
        return true;
    }

    private static MethodHandle buildVarargsArray(MethodHandle newArray, MethodHandle finisher, int nargs) {
        int leftLen = Math.min(nargs, LEFT_ARGS);
        int rightLen = nargs - leftLen;
        MethodHandle leftCollector = newArray.bindTo(nargs);
        leftCollector = leftCollector.asCollector(Object[].class, leftLen);
        MethodHandle mh = finisher;
        if (rightLen > 0) {
            MethodHandle rightFiller = ValueConversions.fillToRight(LEFT_ARGS + rightLen);
            mh = mh == ARRAY_IDENTITY ? rightFiller : ValueConversions.collectArguments(mh, 0, rightFiller);
        }
        mh = mh == ARRAY_IDENTITY ? leftCollector : ValueConversions.collectArguments(mh, 0, leftCollector);
        return mh;
    }

    private static MethodHandle fillToRight(int nargs) {
        MethodHandle filler = FILL_ARRAY_TO_RIGHT[nargs];
        if (filler != null) {
            return filler;
        }
        filler = ValueConversions.buildFiller(nargs);
        assert (ValueConversions.assertCorrectArity(filler, nargs - LEFT_ARGS + 1));
        ValueConversions.FILL_ARRAY_TO_RIGHT[nargs] = filler;
        return ValueConversions.FILL_ARRAY_TO_RIGHT[nargs];
    }

    private static MethodHandle buildFiller(int nargs) {
        if (nargs <= LEFT_ARGS) {
            return ARRAY_IDENTITY;
        }
        int CHUNK = LEFT_ARGS;
        int rightLen = nargs % CHUNK;
        int midLen = nargs - rightLen;
        if (rightLen == 0 && FILL_ARRAY_TO_RIGHT[midLen = nargs - (rightLen = CHUNK)] == null) {
            for (int j = LEFT_ARGS % CHUNK; j < midLen; j += CHUNK) {
                if (j <= LEFT_ARGS) continue;
                ValueConversions.fillToRight(j);
            }
        }
        if (midLen < LEFT_ARGS) {
            midLen = LEFT_ARGS;
            rightLen = nargs - midLen;
        }
        assert (rightLen > 0);
        MethodHandle midFill = ValueConversions.fillToRight(midLen);
        MethodHandle rightFill = FILL_ARRAYS[rightLen].bindTo(midLen);
        assert (midFill.type().parameterCount() == 1 + midLen - LEFT_ARGS);
        assert (rightFill.type().parameterCount() == 1 + rightLen);
        if (midLen == LEFT_ARGS) {
            return rightFill;
        }
        return ValueConversions.collectArguments(rightFill, 0, midFill);
    }

    public static MethodHandle varargsArray(Class<?> arrayType, int nargs) {
        MethodHandle mh;
        Class<?> elemType = arrayType.getComponentType();
        if (elemType == null) {
            throw new IllegalArgumentException("not an array: " + arrayType);
        }
        if (nargs >= 126) {
            int slots = nargs;
            int MAX_ARRAY_SLOTS = 254;
            if (arrayType == double[].class || arrayType == long[].class) {
                slots *= 2;
            }
            if (slots > 254) {
                throw new IllegalArgumentException("too many arguments: " + arrayType.getSimpleName() + ", length " + nargs);
            }
        }
        if (elemType == Object.class) {
            return ValueConversions.varargsArray(nargs);
        }
        MethodHandle[] cache = TYPED_COLLECTORS.get(elemType);
        MethodHandle methodHandle = mh = nargs < cache.length ? cache[nargs] : null;
        if (mh != null) {
            return mh;
        }
        if (elemType.isPrimitive()) {
            MethodHandle builder = FILL_NEW_ARRAY;
            MethodHandle producer = ValueConversions.buildArrayProducer(arrayType);
            mh = ValueConversions.buildVarargsArray(builder, producer, nargs);
        } else {
            Class<?> objArrayType = arrayType;
            T[] example = Arrays.copyOf(NO_ARGS_ARRAY, 0, objArrayType);
            MethodHandle builder = FILL_NEW_TYPED_ARRAY.bindTo(example);
            MethodHandle producer = ARRAY_IDENTITY;
            mh = ValueConversions.buildVarargsArray(builder, producer, nargs);
        }
        mh = mh.asType(MethodType.methodType(arrayType, Collections.nCopies(nargs, elemType)));
        assert (ValueConversions.assertCorrectArity(mh, nargs));
        if (nargs < cache.length) {
            cache[nargs] = mh;
        }
        return mh;
    }

    private static MethodHandle buildArrayProducer(Class<?> arrayType) {
        Class<?> elemType = arrayType.getComponentType();
        if (elemType.isPrimitive()) {
            return LazyStatics.COPY_AS_PRIMITIVE_ARRAY.bindTo((Object)Wrapper.forPrimitiveType(elemType));
        }
        return LazyStatics.COPY_AS_REFERENCE_ARRAY.bindTo(arrayType);
    }

    private static List<Object> makeList(Object ... args) {
        return Arrays.asList(args);
    }

    private static List<Object> list() {
        return NO_ARGS_LIST;
    }

    private static List<Object> list(Object a0) {
        return ValueConversions.makeList(a0);
    }

    private static List<Object> list(Object a0, Object a1) {
        return ValueConversions.makeList(a0, a1);
    }

    private static List<Object> list(Object a0, Object a1, Object a2) {
        return ValueConversions.makeList(a0, a1, a2);
    }

    private static List<Object> list(Object a0, Object a1, Object a2, Object a3) {
        return ValueConversions.makeList(a0, a1, a2, a3);
    }

    private static List<Object> list(Object a0, Object a1, Object a2, Object a3, Object a4) {
        return ValueConversions.makeList(a0, a1, a2, a3, a4);
    }

    private static List<Object> list(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5) {
        return ValueConversions.makeList(a0, a1, a2, a3, a4, a5);
    }

    private static List<Object> list(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) {
        return ValueConversions.makeList(a0, a1, a2, a3, a4, a5, a6);
    }

    private static List<Object> list(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) {
        return ValueConversions.makeList(a0, a1, a2, a3, a4, a5, a6, a7);
    }

    private static List<Object> list(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8) {
        return ValueConversions.makeList(a0, a1, a2, a3, a4, a5, a6, a7, a8);
    }

    private static List<Object> list(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8, Object a9) {
        return ValueConversions.makeList(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
    }

    private static MethodHandle[] makeLists() {
        MethodHandle mh;
        ArrayList<MethodHandle> mhs = new ArrayList<MethodHandle>();
        while ((mh = ValueConversions.findCollector("list", mhs.size(), List.class, new Class[0])) != null) {
            mhs.add(mh);
        }
        assert (mhs.size() == 11);
        return mhs.toArray(new MethodHandle[MAX_ARITY + 1]);
    }

    public static MethodHandle varargsList(int nargs) {
        MethodHandle mh = LISTS[nargs];
        if (mh != null) {
            return mh;
        }
        mh = ValueConversions.findCollector("list", nargs, List.class, new Class[0]);
        if (mh != null) {
            ValueConversions.LISTS[nargs] = mh;
            return ValueConversions.LISTS[nargs];
        }
        ValueConversions.LISTS[nargs] = ValueConversions.buildVarargsList(nargs);
        return ValueConversions.LISTS[nargs];
    }

    private static MethodHandle buildVarargsList(int nargs) {
        return MethodHandles.filterReturnValue(ValueConversions.varargsArray(nargs), LazyStatics.MAKE_LIST);
    }

    private static InternalError newInternalError(String message, Throwable cause) {
        InternalError e = new InternalError(message);
        e.initCause(cause);
        return e;
    }

    private static InternalError newInternalError(Throwable cause) {
        InternalError e = new InternalError();
        e.initCause(cause);
        return e;
    }

    static {
        final Object[] values = new Object[]{255};
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                values[0] = Integer.getInteger(THIS_CLASS.getName() + ".MAX_ARITY", 255);
                return null;
            }
        });
        MAX_ARITY = (Integer)values[0];
        IMPL_LOOKUP = MethodHandles.lookup();
        UNBOX_CONVERSIONS = ValueConversions.newWrapperCaches(2);
        ZERO_INT = 0;
        ONE_INT = 1;
        BOX_CONVERSIONS = ValueConversions.newWrapperCaches(2);
        CONSTANT_FUNCTIONS = ValueConversions.newWrapperCaches(2);
        try {
            MethodType idType = MethodType.genericMethodType(1);
            MethodType castType = idType.insertParameterTypes(0, Class.class);
            MethodType ignoreType = idType.changeReturnType(Void.TYPE);
            MethodType zeroObjectType = MethodType.genericMethodType(0);
            IDENTITY = IMPL_LOOKUP.findStatic(THIS_CLASS, "identity", idType);
            CAST_REFERENCE = IMPL_LOOKUP.findStatic(THIS_CLASS, "castReference", castType);
            ZERO_OBJECT = IMPL_LOOKUP.findStatic(THIS_CLASS, "zeroObject", zeroObjectType);
            IGNORE = IMPL_LOOKUP.findStatic(THIS_CLASS, "ignore", ignoreType);
            EMPTY = IMPL_LOOKUP.findStatic(THIS_CLASS, "empty", ignoreType.dropParameterTypes(0, 1));
            ARRAY_IDENTITY = IMPL_LOOKUP.findStatic(THIS_CLASS, "identity", MethodType.methodType(Object[].class, Object[].class));
            FILL_NEW_ARRAY = IMPL_LOOKUP.findStatic(THIS_CLASS, "fillNewArray", MethodType.methodType(Object[].class, Integer.class, Object[].class));
            FILL_NEW_TYPED_ARRAY = IMPL_LOOKUP.findStatic(THIS_CLASS, "fillNewTypedArray", MethodType.methodType(Object[].class, Object[].class, Integer.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            throw ValueConversions.newInternalError("uncaught exception", ex);
        }
        MethodHandle mh = null;
        try {
            final Method m = MethodHandles.class.getDeclaredMethod("collectArguments", MethodHandle.class, Integer.TYPE, MethodHandle.class);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    m.setAccessible(true);
                    return null;
                }
            });
            mh = IMPL_LOOKUP.unreflect(m);
        }
        catch (ReflectiveOperationException ex) {
            throw ValueConversions.newInternalError(ex);
        }
        COLLECT_ARGUMENTS = mh;
        WRAPPER_CASTS = ValueConversions.newWrapperCaches(1);
        CONVERT_PRIMITIVE_FUNCTIONS = ValueConversions.newWrapperCaches(Wrapper.values().length);
        NO_ARGS_ARRAY = new Object[0];
        ARRAYS = ValueConversions.makeArrays();
        FILL_ARRAYS = ValueConversions.makeFillArrays();
        LEFT_ARGS = FILL_ARRAYS.length - 1;
        FILL_ARRAY_TO_RIGHT = new MethodHandle[MAX_ARITY + 1];
        TYPED_COLLECTORS = new ClassValue<MethodHandle[]>(){

            @Override
            protected MethodHandle[] computeValue(Class<?> type) {
                return new MethodHandle[256];
            }
        };
        NO_ARGS_LIST = Arrays.asList(NO_ARGS_ARRAY);
        LISTS = ValueConversions.makeLists();
    }

    static class LazyStatics {
        private static final MethodHandle COPY_AS_REFERENCE_ARRAY;
        private static final MethodHandle COPY_AS_PRIMITIVE_ARRAY;
        private static final MethodHandle MAKE_LIST;

        LazyStatics() {
        }

        static {
            try {
                COPY_AS_REFERENCE_ARRAY = IMPL_LOOKUP.findStatic(THIS_CLASS, "copyAsReferenceArray", MethodType.methodType(Object[].class, Class.class, Object[].class));
                COPY_AS_PRIMITIVE_ARRAY = IMPL_LOOKUP.findStatic(THIS_CLASS, "copyAsPrimitiveArray", MethodType.methodType(Object.class, Wrapper.class, Object[].class));
                MAKE_LIST = IMPL_LOOKUP.findStatic(THIS_CLASS, "makeList", MethodType.methodType(List.class, Object[].class));
            }
            catch (ReflectiveOperationException ex) {
                throw ValueConversions.newInternalError("uncaught exception", ex);
            }
        }
    }
}

