/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.UnknownCharacterException;

public class ByteToCharASCII
extends ByteToCharConverter {
    @Override
    public String getCharacterEncoding() {
        return "ASCII";
    }

    @Override
    public int flush(char[] output, int outStart, int outEnd) {
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    @Override
    public int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws ConversionBufferFullException, UnknownCharacterException {
        this.charOff = outOff;
        this.byteOff = inOff;
        while (this.byteOff < inEnd) {
            byte inputByte;
            if (this.charOff >= outEnd) {
                throw new ConversionBufferFullException();
            }
            if ((inputByte = input[this.byteOff++]) >= 0) {
                output[this.charOff++] = (char)inputByte;
                continue;
            }
            if (this.subMode) {
                output[this.charOff++] = 65533;
                continue;
            }
            this.badInputLength = 1;
            throw new UnknownCharacterException();
        }
        return this.charOff - outOff;
    }

    @Override
    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
    }
}

