/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.jules;

import java.awt.BasicStroke;
import java.awt.Shape;
import sun.awt.SunToolkit;
import sun.java2d.SunGraphics2D;
import sun.java2d.jules.JulesPathBuf;
import sun.java2d.jules.TrapezoidList;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRSurfaceData;

public class JulesShapePipe
implements ShapeDrawPipe {
    XRCompositeManager compMan;
    JulesPathBuf buf = new JulesPathBuf();

    public JulesShapePipe(XRCompositeManager compMan) {
        this.compMan = compMan;
    }

    private final void validateSurface(SunGraphics2D sg2d) {
        XRSurfaceData xrsd = (XRSurfaceData)sg2d.surfaceData;
        xrsd.validateAsDestination(sg2d, sg2d.getCompClip());
        xrsd.maskBuffer.validateCompositeState(sg2d.composite, sg2d.transform, sg2d.paint, sg2d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(SunGraphics2D sg2d, Shape s) {
        try {
            BasicStroke bs;
            SunToolkit.awtLock();
            this.validateSurface(sg2d);
            XRSurfaceData xrsd = (XRSurfaceData)sg2d.surfaceData;
            if (sg2d.stroke instanceof BasicStroke) {
                bs = (BasicStroke)sg2d.stroke;
            } else {
                s = sg2d.stroke.createStrokedShape(s);
                bs = null;
            }
            boolean adjust = bs != null && sg2d.strokeHint != 2;
            boolean thin = sg2d.strokeState <= 1;
            TrapezoidList traps = this.buf.tesselateStroke(s, bs, thin, adjust, true, sg2d.transform, sg2d.getCompClip());
            this.compMan.XRCompositeTraps(xrsd.picture, sg2d.transX, sg2d.transY, traps);
            this.buf.clear();
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(SunGraphics2D sg2d, Shape s) {
        try {
            SunToolkit.awtLock();
            this.validateSurface(sg2d);
            XRSurfaceData xrsd = (XRSurfaceData)sg2d.surfaceData;
            TrapezoidList traps = this.buf.tesselateFill(s, sg2d.transform, sg2d.getCompClip());
            this.compMan.XRCompositeTraps(xrsd.picture, 0, 0, traps);
            this.buf.clear();
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }
}

