/*
 * Decompiled with CFR 0.152.
 */
package sun.management.counter.perf;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.management.counter.AbstractCounter;
import sun.management.counter.Counter;
import sun.management.counter.Units;
import sun.management.counter.perf.InstrumentationException;
import sun.management.counter.perf.PerfByteArrayCounter;
import sun.management.counter.perf.PerfDataEntry;
import sun.management.counter.perf.PerfDataType;
import sun.management.counter.perf.PerfLongArrayCounter;
import sun.management.counter.perf.PerfLongCounter;
import sun.management.counter.perf.PerfStringCounter;
import sun.management.counter.perf.Prologue;

public class PerfInstrumentation {
    private ByteBuffer buffer;
    private Prologue prologue;
    private long lastModificationTime;
    private long lastUsed;
    private int nextEntry;
    private SortedMap<String, Counter> map;

    public PerfInstrumentation(ByteBuffer b) {
        this.prologue = new Prologue(b);
        this.buffer = b;
        this.buffer.order(this.prologue.getByteOrder());
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        if (major < 2) {
            throw new InstrumentationException("Unsupported version: " + major + "." + minor);
        }
        this.rewind();
    }

    public int getMajorVersion() {
        return this.prologue.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.prologue.getMinorVersion();
    }

    public long getModificationTimeStamp() {
        return this.prologue.getModificationTimeStamp();
    }

    void rewind() {
        this.buffer.rewind();
        this.buffer.position(this.prologue.getEntryOffset());
        this.nextEntry = this.buffer.position();
        this.map = new TreeMap<String, Counter>();
    }

    boolean hasNext() {
        return this.nextEntry < this.prologue.getUsed();
    }

    Counter getNextCounter() {
        if (!this.hasNext()) {
            return null;
        }
        if (this.nextEntry % 4 != 0) {
            throw new InstrumentationException("Entry index not properly aligned: " + this.nextEntry);
        }
        if (this.nextEntry < 0 || this.nextEntry > this.buffer.limit()) {
            throw new InstrumentationException("Entry index out of bounds: nextEntry = " + this.nextEntry + ", limit = " + this.buffer.limit());
        }
        this.buffer.position(this.nextEntry);
        PerfDataEntry entry = new PerfDataEntry(this.buffer);
        this.nextEntry += entry.size();
        AbstractCounter counter = null;
        PerfDataType type = entry.type();
        if (type == PerfDataType.BYTE) {
            if (entry.units() == Units.STRING && entry.vectorLength() > 0) {
                counter = new PerfStringCounter(entry.name(), entry.variability(), entry.flags(), entry.vectorLength(), entry.byteData());
            } else if (entry.vectorLength() > 0) {
                counter = new PerfByteArrayCounter(entry.name(), entry.units(), entry.variability(), entry.flags(), entry.vectorLength(), entry.byteData());
            } else assert (false);
        } else if (type == PerfDataType.LONG) {
            counter = entry.vectorLength() == 0 ? new PerfLongCounter(entry.name(), entry.units(), entry.variability(), entry.flags(), entry.longData()) : new PerfLongArrayCounter(entry.name(), entry.units(), entry.variability(), entry.flags(), entry.vectorLength(), entry.longData());
        } else assert (false);
        return counter;
    }

    public synchronized List<Counter> getAllCounters() {
        while (this.hasNext()) {
            Counter c = this.getNextCounter();
            if (c == null) continue;
            this.map.put(c.getName(), c);
        }
        return new ArrayList<Counter>(this.map.values());
    }

    public synchronized List<Counter> findByPattern(String patternString) {
        while (this.hasNext()) {
            Counter c = this.getNextCounter();
            if (c == null) continue;
            this.map.put(c.getName(), c);
        }
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher("");
        ArrayList<Counter> matches = new ArrayList<Counter>();
        for (Map.Entry<String, Counter> me : this.map.entrySet()) {
            String name = me.getKey();
            matcher.reset(name);
            if (!matcher.lookingAt()) continue;
            matches.add(me.getValue());
        }
        return matches;
    }
}

