/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.nio.ch.EPollArrayWrapper;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;

class EPollSelectorImpl
extends SelectorImpl {
    protected int fd0;
    protected int fd1;
    EPollArrayWrapper pollWrapper;
    private Map<Integer, SelectionKeyImpl> fdToKey;
    private volatile boolean closed = false;
    private final Object interruptLock = new Object();
    private boolean interruptTriggered = false;

    EPollSelectorImpl(SelectorProvider sp) throws IOException {
        super(sp);
        long pipeFds = IOUtil.makePipe(false);
        this.fd0 = (int)(pipeFds >>> 32);
        this.fd1 = (int)pipeFds;
        this.pollWrapper = new EPollArrayWrapper();
        this.pollWrapper.initInterrupt(this.fd0, this.fd1);
        this.fdToKey = new HashMap<Integer, SelectionKeyImpl>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doSelect(long timeout) throws IOException {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        try {
            this.begin();
            this.pollWrapper.poll(timeout);
        }
        finally {
            this.end();
        }
        this.processDeregisterQueue();
        int numKeysUpdated = this.updateSelectedKeys();
        if (this.pollWrapper.interrupted()) {
            this.pollWrapper.putEventOps(this.pollWrapper.interruptedIndex(), 0);
            Object object = this.interruptLock;
            synchronized (object) {
                this.pollWrapper.clearInterrupted();
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return numKeysUpdated;
    }

    private int updateSelectedKeys() {
        int entries = this.pollWrapper.updated;
        int numKeysUpdated = 0;
        for (int i = 0; i < entries; ++i) {
            int nextFD = this.pollWrapper.getDescriptor(i);
            SelectionKeyImpl ski = this.fdToKey.get(nextFD);
            if (ski == null) continue;
            int rOps = this.pollWrapper.getEventOps(i);
            if (this.selectedKeys.contains(ski)) {
                if (!ski.channel.translateAndSetReadyOps(rOps, ski)) continue;
                ++numKeysUpdated;
                continue;
            }
            ski.channel.translateAndSetReadyOps(rOps, ski);
            if ((ski.nioReadyOps() & ski.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(ski);
            ++numKeysUpdated;
        }
        return numKeysUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implClose() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Object object = this.interruptLock;
        synchronized (object) {
            this.interruptTriggered = true;
        }
        FileDispatcherImpl.closeIntFD(this.fd0);
        FileDispatcherImpl.closeIntFD(this.fd1);
        this.pollWrapper.closeEPollFD();
        this.selectedKeys = null;
        Iterator i = this.keys.iterator();
        while (i.hasNext()) {
            SelectionKeyImpl ski = (SelectionKeyImpl)i.next();
            this.deregister(ski);
            SelectableChannel selch = ski.channel();
            if (!selch.isOpen() && !selch.isRegistered()) {
                ((SelChImpl)((Object)selch)).kill();
            }
            i.remove();
        }
        this.fd0 = -1;
        this.fd1 = -1;
    }

    @Override
    protected void implRegister(SelectionKeyImpl ski) {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        SelChImpl ch = ski.channel;
        int fd = ch.getFDVal();
        this.fdToKey.put(fd, ski);
        this.pollWrapper.add(fd);
        this.keys.add(ski);
    }

    @Override
    protected void implDereg(SelectionKeyImpl ski) throws IOException {
        assert (ski.getIndex() >= 0);
        SelChImpl ch = ski.channel;
        int fd = ch.getFDVal();
        this.fdToKey.remove(fd);
        this.pollWrapper.remove(fd);
        ski.setIndex(-1);
        this.keys.remove(ski);
        this.selectedKeys.remove(ski);
        this.deregister(ski);
        SelectableChannel selch = ski.channel();
        if (!selch.isOpen() && !selch.isRegistered()) {
            ((SelChImpl)((Object)selch)).kill();
        }
    }

    @Override
    void putEventOps(SelectionKeyImpl ski, int ops) {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        SelChImpl ch = ski.channel;
        this.pollWrapper.setInterest(ch.getFDVal(), ops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.pollWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }
}

