/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.HashMap;
import java.util.Map;
import sun.nio.fs.DynamicFileAttributeView;

final class FileOwnerAttributeViewImpl
implements FileOwnerAttributeView,
DynamicFileAttributeView {
    private static final String OWNER_NAME = "owner";
    private final FileAttributeView view;
    private final boolean isPosixView;

    FileOwnerAttributeViewImpl(PosixFileAttributeView view) {
        this.view = view;
        this.isPosixView = true;
    }

    FileOwnerAttributeViewImpl(AclFileAttributeView view) {
        this.view = view;
        this.isPosixView = false;
    }

    @Override
    public String name() {
        return OWNER_NAME;
    }

    @Override
    public void setAttribute(String attribute, Object value) throws IOException {
        if (!attribute.equals(OWNER_NAME)) {
            throw new IllegalArgumentException("'" + this.name() + ":" + attribute + "' not recognized");
        }
        this.setOwner((UserPrincipal)value);
    }

    @Override
    public Map<String, Object> readAttributes(String[] attributes) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String attribute : attributes) {
            if (!attribute.equals("*") && !attribute.equals(OWNER_NAME)) {
                throw new IllegalArgumentException("'" + this.name() + ":" + attribute + "' not recognized");
            }
            result.put(OWNER_NAME, this.getOwner());
        }
        return result;
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        if (this.isPosixView) {
            return ((PosixFileAttributeView)this.view).readAttributes().owner();
        }
        return ((AclFileAttributeView)this.view).getOwner();
    }

    @Override
    public void setOwner(UserPrincipal owner) throws IOException {
        if (this.isPosixView) {
            ((PosixFileAttributeView)this.view).setOwner(owner);
        } else {
            ((AclFileAttributeView)this.view).setOwner(owner);
        }
    }
}

