/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.io.Externalizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Objects;
import sun.reflect.BootstrapConstructorAccessorImpl;
import sun.reflect.ConstructorAccessor;
import sun.reflect.ConstructorAccessorImpl;
import sun.reflect.DelegatingConstructorAccessorImpl;
import sun.reflect.DelegatingMethodAccessorImpl;
import sun.reflect.FieldAccessor;
import sun.reflect.InstantiationExceptionConstructorAccessorImpl;
import sun.reflect.LangReflectAccess;
import sun.reflect.MethodAccessor;
import sun.reflect.MethodAccessorGenerator;
import sun.reflect.NativeConstructorAccessorImpl;
import sun.reflect.NativeMethodAccessorImpl;
import sun.reflect.Reflection;
import sun.reflect.SerializationConstructorAccessorImpl;
import sun.reflect.UnsafeFieldAccessorFactory;

public class ReflectionFactory {
    private static boolean initted = false;
    private static final Permission reflectionFactoryAccessPerm = new RuntimePermission("reflectionFactoryAccess");
    private static final ReflectionFactory soleInstance = new ReflectionFactory();
    private static volatile LangReflectAccess langReflectAccess;
    private static volatile Method hasStaticInitializerMethod;
    private static boolean noInflation;
    private static int inflationThreshold;

    private ReflectionFactory() {
    }

    public static ReflectionFactory getReflectionFactory() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(reflectionFactoryAccessPerm);
        }
        return soleInstance;
    }

    public void setLangReflectAccess(LangReflectAccess access) {
        langReflectAccess = access;
    }

    public FieldAccessor newFieldAccessor(Field field, boolean override) {
        ReflectionFactory.checkInitted();
        return UnsafeFieldAccessorFactory.newFieldAccessor(field, override);
    }

    public MethodAccessor newMethodAccessor(Method method) {
        ReflectionFactory.checkInitted();
        if (noInflation) {
            return new MethodAccessorGenerator().generateMethod(method.getDeclaringClass(), method.getName(), method.getParameterTypes(), method.getReturnType(), method.getExceptionTypes(), method.getModifiers());
        }
        NativeMethodAccessorImpl acc = new NativeMethodAccessorImpl(method);
        DelegatingMethodAccessorImpl res = new DelegatingMethodAccessorImpl(acc);
        acc.setParent(res);
        return res;
    }

    public ConstructorAccessor newConstructorAccessor(Constructor<?> c) {
        ReflectionFactory.checkInitted();
        Class<?> declaringClass = c.getDeclaringClass();
        if (Modifier.isAbstract(declaringClass.getModifiers())) {
            return new InstantiationExceptionConstructorAccessorImpl(null);
        }
        if (declaringClass == Class.class) {
            return new InstantiationExceptionConstructorAccessorImpl("Can not instantiate java.lang.Class");
        }
        if (Reflection.isSubclassOf(declaringClass, ConstructorAccessorImpl.class)) {
            return new BootstrapConstructorAccessorImpl(c);
        }
        if (noInflation) {
            return new MethodAccessorGenerator().generateConstructor(c.getDeclaringClass(), c.getParameterTypes(), c.getExceptionTypes(), c.getModifiers());
        }
        NativeConstructorAccessorImpl acc = new NativeConstructorAccessorImpl(c);
        DelegatingConstructorAccessorImpl res = new DelegatingConstructorAccessorImpl(acc);
        acc.setParent(res);
        return res;
    }

    public Field newField(Class<?> declaringClass, String name, Class<?> type, int modifiers, int slot, String signature, byte[] annotations) {
        return ReflectionFactory.langReflectAccess().newField(declaringClass, name, type, modifiers, slot, signature, annotations);
    }

    public Method newMethod(Class<?> declaringClass, String name, Class<?>[] parameterTypes, Class<?> returnType, Class<?>[] checkedExceptions, int modifiers, int slot, String signature, byte[] annotations, byte[] parameterAnnotations, byte[] annotationDefault) {
        return ReflectionFactory.langReflectAccess().newMethod(declaringClass, name, parameterTypes, returnType, checkedExceptions, modifiers, slot, signature, annotations, parameterAnnotations, annotationDefault);
    }

    public Constructor<?> newConstructor(Class<?> declaringClass, Class<?>[] parameterTypes, Class<?>[] checkedExceptions, int modifiers, int slot, String signature, byte[] annotations, byte[] parameterAnnotations) {
        return ReflectionFactory.langReflectAccess().newConstructor(declaringClass, parameterTypes, checkedExceptions, modifiers, slot, signature, annotations, parameterAnnotations);
    }

    public MethodAccessor getMethodAccessor(Method m) {
        return ReflectionFactory.langReflectAccess().getMethodAccessor(m);
    }

    public void setMethodAccessor(Method m, MethodAccessor accessor) {
        ReflectionFactory.langReflectAccess().setMethodAccessor(m, accessor);
    }

    public ConstructorAccessor getConstructorAccessor(Constructor<?> c) {
        return ReflectionFactory.langReflectAccess().getConstructorAccessor(c);
    }

    public void setConstructorAccessor(Constructor<?> c, ConstructorAccessor accessor) {
        ReflectionFactory.langReflectAccess().setConstructorAccessor(c, accessor);
    }

    public Method copyMethod(Method arg) {
        return ReflectionFactory.langReflectAccess().copyMethod(arg);
    }

    public Field copyField(Field arg) {
        return ReflectionFactory.langReflectAccess().copyField(arg);
    }

    public <T> Constructor<T> copyConstructor(Constructor<T> arg) {
        return ReflectionFactory.langReflectAccess().copyConstructor(arg);
    }

    public Constructor<?> newConstructorForSerialization(Class<?> classToInstantiate, Constructor<?> constructorToCall) {
        if (constructorToCall.getDeclaringClass() == classToInstantiate) {
            return constructorToCall;
        }
        return this.generateConstructor(classToInstantiate, constructorToCall);
    }

    public final Constructor<?> newConstructorForSerialization(Class<?> cl) {
        Constructor<?> constructorToCall;
        Class<?> initCl = cl;
        while (Serializable.class.isAssignableFrom(initCl)) {
            if ((initCl = initCl.getSuperclass()) != null) continue;
            return null;
        }
        try {
            constructorToCall = initCl.getDeclaredConstructor(new Class[0]);
            int mods = constructorToCall.getModifiers();
            if ((mods & 2) != 0 || (mods & 5) == 0 && !ReflectionFactory.packageEquals(cl, initCl)) {
                return null;
            }
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        return this.generateConstructor(cl, constructorToCall);
    }

    private final Constructor<?> generateConstructor(Class<?> classToInstantiate, Constructor<?> constructorToCall) {
        SerializationConstructorAccessorImpl acc = new MethodAccessorGenerator().generateSerializationConstructor(classToInstantiate, constructorToCall.getParameterTypes(), constructorToCall.getExceptionTypes(), constructorToCall.getModifiers(), constructorToCall.getDeclaringClass());
        Constructor<?> c = this.newConstructor(constructorToCall.getDeclaringClass(), constructorToCall.getParameterTypes(), constructorToCall.getExceptionTypes(), constructorToCall.getModifiers(), ReflectionFactory.langReflectAccess().getConstructorSlot(constructorToCall), ReflectionFactory.langReflectAccess().getConstructorSignature(constructorToCall), ReflectionFactory.langReflectAccess().getConstructorAnnotations(constructorToCall), ReflectionFactory.langReflectAccess().getConstructorParameterAnnotations(constructorToCall));
        this.setConstructorAccessor(c, acc);
        c.setAccessible(true);
        return c;
    }

    public final Constructor<?> newConstructorForExternalization(Class<?> cl) {
        if (!Externalizable.class.isAssignableFrom(cl)) {
            return null;
        }
        try {
            Constructor<?> cons = cl.getConstructor(new Class[0]);
            cons.setAccessible(true);
            return cons;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public final MethodHandle readObjectForSerialization(Class<?> cl) {
        return this.findReadWriteObjectForSerialization(cl, "readObject", ObjectInputStream.class);
    }

    public final MethodHandle readObjectNoDataForSerialization(Class<?> cl) {
        return this.findReadWriteObjectForSerialization(cl, "readObjectNoData", ObjectInputStream.class);
    }

    public final MethodHandle writeObjectForSerialization(Class<?> cl) {
        return this.findReadWriteObjectForSerialization(cl, "writeObject", ObjectOutputStream.class);
    }

    private final MethodHandle findReadWriteObjectForSerialization(Class<?> cl, String methodName, Class<?> streamClass) {
        if (!Serializable.class.isAssignableFrom(cl)) {
            return null;
        }
        try {
            Method meth = cl.getDeclaredMethod(methodName, streamClass);
            int mods = meth.getModifiers();
            if (meth.getReturnType() != Void.TYPE || Modifier.isStatic(mods) || !Modifier.isPrivate(mods)) {
                return null;
            }
            meth.setAccessible(true);
            return MethodHandles.lookup().unreflect(meth);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (IllegalAccessException ex1) {
            throw (InternalError)new InternalError("Error").initCause(ex1);
        }
    }

    public final MethodHandle readResolveForSerialization(Class<?> cl) {
        return this.getReplaceResolveForSerialization(cl, "readResolve");
    }

    public final MethodHandle writeReplaceForSerialization(Class<?> cl) {
        return this.getReplaceResolveForSerialization(cl, "writeReplace");
    }

    private MethodHandle getReplaceResolveForSerialization(Class<?> cl, String methodName) {
        if (!Serializable.class.isAssignableFrom(cl)) {
            return null;
        }
        for (Class<?> defCl = cl; defCl != null; defCl = defCl.getSuperclass()) {
            try {
                Method m = defCl.getDeclaredMethod(methodName, new Class[0]);
                if (m.getReturnType() != Object.class) {
                    return null;
                }
                int mods = m.getModifiers();
                if (Modifier.isStatic(mods) | Modifier.isAbstract(mods)) {
                    return null;
                }
                if (!(Modifier.isPublic(mods) | Modifier.isProtected(mods))) {
                    if (Modifier.isPrivate(mods) && cl != defCl) {
                        return null;
                    }
                    if (!ReflectionFactory.packageEquals(cl, defCl)) {
                        return null;
                    }
                }
                try {
                    m.setAccessible(true);
                    return MethodHandles.lookup().unreflect(m);
                }
                catch (IllegalAccessException ex0) {
                    throw (InternalError)new InternalError("Error").initCause(ex0);
                }
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        return null;
    }

    public final boolean hasStaticInitializerForSerialization(Class<?> cl) {
        Method m = hasStaticInitializerMethod;
        if (m == null) {
            try {
                m = ObjectStreamClass.class.getDeclaredMethod("hasStaticInitializer", Class.class);
                m.setAccessible(true);
                hasStaticInitializerMethod = m;
            }
            catch (NoSuchMethodException ex) {
                throw (InternalError)new InternalError("No such method hasStaticInitializer on " + ObjectStreamClass.class).initCause(ex);
            }
        }
        try {
            return (Boolean)m.invoke(null, cl);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw (InternalError)new InternalError("Exception invoking hasStaticInitializer").initCause(ex);
        }
    }

    public final OptionalDataException newOptionalDataExceptionForSerialization(boolean bool) {
        try {
            Constructor boolCtor = OptionalDataException.class.getDeclaredConstructor(Boolean.TYPE);
            boolCtor.setAccessible(true);
            return (OptionalDataException)boolCtor.newInstance(bool);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw (InternalError)new InternalError("unable to create OptionalDataException").initCause(ex);
        }
    }

    static int inflationThreshold() {
        return inflationThreshold;
    }

    private static void checkInitted() {
        if (initted) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.out == null) {
                    return null;
                }
                String val = System.getProperty("sun.reflect.noInflation");
                if (val != null && val.equals("true")) {
                    noInflation = true;
                }
                if ((val = System.getProperty("sun.reflect.inflationThreshold")) != null) {
                    try {
                        inflationThreshold = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Unable to parse property sun.reflect.inflationThreshold", e);
                    }
                }
                initted = true;
                return null;
            }
        });
    }

    private static LangReflectAccess langReflectAccess() {
        if (langReflectAccess == null) {
            Modifier.isPublic(1);
        }
        return langReflectAccess;
    }

    private static boolean packageEquals(Class<?> cl1, Class<?> cl2) {
        return cl1.getClassLoader() == cl2.getClassLoader() && Objects.equals(cl1.getPackage(), cl2.getPackage());
    }

    static {
        noInflation = false;
        inflationThreshold = 15;
    }

    public static final class GetReflectionFactoryAction
    implements PrivilegedAction<ReflectionFactory> {
        @Override
        public ReflectionFactory run() {
            return ReflectionFactory.getReflectionFactory();
        }
    }
}

