/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class ETypeInfo {
    private int etype;
    private String salt = null;
    private static final byte TAG_TYPE = 0;
    private static final byte TAG_VALUE = 1;

    private ETypeInfo() {
    }

    public ETypeInfo(int etype, String salt) {
        this.etype = etype;
        this.salt = salt;
    }

    public Object clone() {
        return new ETypeInfo(this.etype, this.salt);
    }

    public ETypeInfo(DerValue encoding) throws Asn1Exception, IOException {
        DerValue der = null;
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.etype = der.getData().getBigInteger().intValue();
        if (encoding.getData().available() > 0 && ((der = encoding.getData().getDerValue()).getTag() & 0x1F) == 1) {
            byte[] saltBytes = der.getData().getOctetString();
            this.salt = KerberosString.MSNAME ? new String(saltBytes, "UTF8") : new String(saltBytes);
        }
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(this.etype);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        if (this.salt != null) {
            temp = new DerOutputStream();
            if (KerberosString.MSNAME) {
                temp.putOctetString(this.salt.getBytes("UTF8"));
            } else {
                temp.putOctetString(this.salt.getBytes());
            }
            bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        }
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public int getEType() {
        return this.etype;
    }

    public String getSalt() {
        return this.salt;
    }
}

