/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.io.IOException;
import java.util.MissingResourceException;
import sun.text.normalizer.UBiDiProps;
import sun.text.normalizer.UCharacterProperty;
import sun.text.normalizer.UTF16;
import sun.text.normalizer.VersionInfo;

public final class UCharacter {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 0x10FFFF;
    public static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    private static final UCharacterProperty PROPERTY_;
    private static final char[] PROPERTY_TRIE_INDEX_;
    private static final char[] PROPERTY_TRIE_DATA_;
    private static final int PROPERTY_INITIAL_VALUE_;
    private static final UBiDiProps gBdp;
    private static final int NUMERIC_TYPE_SHIFT_ = 5;
    private static final int NUMERIC_TYPE_MASK_ = 224;

    public static int digit(int ch, int radix) {
        int props = UCharacter.getProperty(ch);
        int value = UCharacter.getNumericType(props) == 1 ? UCharacterProperty.getUnsignedValue(props) : UCharacter.getEuropeanDigit(ch);
        return 0 <= value && value < radix ? value : -1;
    }

    public static int getDirection(int ch) {
        return gBdp.getClass(ch);
    }

    public static int getCodePoint(char lead, char trail) {
        if (UTF16.isLeadSurrogate(lead) && UTF16.isTrailSurrogate(trail)) {
            return UCharacterProperty.getRawSupplementary(lead, trail);
        }
        throw new IllegalArgumentException("Illegal surrogate characters");
    }

    public static VersionInfo getAge(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return PROPERTY_.getAge(ch);
    }

    private static int getEuropeanDigit(int ch) {
        if (ch > 122 && ch < 65313 || ch < 65 || ch > 90 && ch < 97 || ch > 65370 || ch > 65338 && ch < 65345) {
            return -1;
        }
        if (ch <= 122) {
            return ch + 10 - (ch <= 90 ? 65 : 97);
        }
        if (ch <= 65338) {
            return ch + 10 - 65313;
        }
        return ch + 10 - 65345;
    }

    private static int getNumericType(int props) {
        return (props & 0xE0) >> 5;
    }

    private static final int getProperty(int ch) {
        if (ch < 55296 || ch > 56319 && ch < 65536) {
            try {
                return PROPERTY_TRIE_DATA_[(PROPERTY_TRIE_INDEX_[ch >> 5] << 2) + (ch & 0x1F)];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return PROPERTY_INITIAL_VALUE_;
            }
        }
        if (ch <= 56319) {
            return PROPERTY_TRIE_DATA_[(PROPERTY_TRIE_INDEX_[320 + (ch >> 5)] << 2) + (ch & 0x1F)];
        }
        if (ch <= 0x10FFFF) {
            return UCharacter.PROPERTY_.m_trie_.getSurrogateValue(UTF16.getLeadSurrogate(ch), (char)(ch & 0x3FF));
        }
        return PROPERTY_INITIAL_VALUE_;
    }

    static {
        UBiDiProps bdp;
        try {
            PROPERTY_ = UCharacterProperty.getInstance();
            PROPERTY_TRIE_INDEX_ = UCharacter.PROPERTY_.m_trieIndex_;
            PROPERTY_TRIE_DATA_ = UCharacter.PROPERTY_.m_trieData_;
            PROPERTY_INITIAL_VALUE_ = UCharacter.PROPERTY_.m_trieInitialValue_;
        }
        catch (Exception e) {
            throw new MissingResourceException(e.getMessage(), "", "");
        }
        try {
            bdp = UBiDiProps.getSingleton();
        }
        catch (IOException e) {
            bdp = UBiDiProps.getDummy();
        }
        gBdp = bdp;
    }

    public static interface NumericType {
        public static final int DECIMAL = 1;
    }
}

