/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing.dtrace;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import sun.tracing.dtrace.Activation;
import sun.tracing.dtrace.JVM;

class SystemResource
extends WeakReference<Activation> {
    private long handle;
    private static ReferenceQueue<Activation> referenceQueue = new ReferenceQueue();
    static HashSet<SystemResource> resources = new HashSet();

    SystemResource(Activation activation, long handle) {
        super(activation, referenceQueue);
        this.handle = handle;
        SystemResource.flush();
        resources.add(this);
    }

    void dispose() {
        JVM.dispose(this.handle);
        resources.remove(this);
        this.handle = 0L;
    }

    static void flush() {
        SystemResource resource = null;
        while ((resource = (SystemResource)referenceQueue.poll()) != null) {
            if (resource.handle == 0L) continue;
            resource.dispose();
        }
    }
}

