/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_VCL_IDLE_HXX
#define INCLUDED_VCL_IDLE_HXX

#include <tools/link.hxx>
#include <vcl/scheduler.hxx>

class VCL_DLLPUBLIC Idle : public Scheduler
{
protected:
    Link<Idle *, void> maIdleHdl;          // Callback Link

public:
    Idle( const sal_Char *pDebugName = NULL );
    Idle( const Idle& rIdle );

    virtual void    Start();

    /// Make it possible to associate a callback with this idle handler
    /// of course, you can also sub-class and override 'Invoke'
    void            SetIdleHdl( const Link<Idle *, void>& rLink ) { maIdleHdl = rLink; }
    const Link<Idle *, void>& GetIdleHdl() const { return maIdleHdl; }
    virtual void Invoke() SAL_OVERRIDE;
    virtual bool ReadyForSchedule( bool bTimer ) SAL_OVERRIDE;
    virtual sal_uInt64 UpdateMinPeriod( sal_uInt64 nMinPeriod, sal_uInt64 nTime ) SAL_OVERRIDE;
    Idle&           operator=( const Idle& rIdle );
};

#endif // INCLUDED_VCL_IDLE_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
