(function() {
  var escope, expect, harmony;

  expect = require('chai').expect;

  harmony = require('../third_party/esprima');

  escope = require('..');

  describe('ES6 iteration scope', function() {
    it('let materialize iteration scope for ForInStatement#1', function() {
      var ast, iterScope, scope, scopeManager;
      ast = harmony.parse("(function () {\n    let i = 20;\n    for (let i in i) {\n        console.log(i);\n    }\n}());");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(5);
      scope = scopeManager.scopes[0];
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(2);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.variables[1].name).to.be.equal('i');
      expect(scope.references).to.have.length(1);
      expect(scope.references[0].identifier.name).to.be.equal('i');
      expect(scope.references[0].resolved).to.be.equal(scope.variables[1]);
      iterScope = scope = scopeManager.scopes[2];
      expect(scope.type).to.be.equal('TDZ');
      expect(scope.variables).to.have.length(1);
      expect(scope.variables[0].name).to.be.equal('i');
      expect(scope.variables[0].defs[0].type).to.be.equal('TDZ');
      expect(scope.references).to.have.length(1);
      expect(scope.references[0].identifier.name).to.be.equal('i');
      expect(scope.references[0].resolved).to.be.equal(scope.variables[0]);
      iterScope = scope = scopeManager.scopes[3];
      expect(scope.type).to.be.equal('for');
      expect(scope.variables).to.have.length(1);
      expect(scope.variables[0].name).to.be.equal('i');
      expect(scope.references).to.have.length(1);
      expect(scope.references[0].identifier.name).to.be.equal('i');
      expect(scope.references[0].resolved).to.be.equal(scope.variables[0]);
      scope = scopeManager.scopes[4];
      expect(scope.type).to.be.equal('block');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(2);
      expect(scope.references[0].identifier.name).to.be.equal('console');
      expect(scope.references[0].resolved).to.be.equal(null);
      expect(scope.references[1].identifier.name).to.be.equal('i');
      return expect(scope.references[1].resolved).to.be.equal(iterScope.variables[0]);
    });
    it('let materialize iteration scope for ForInStatement#2', function() {
      var ast, iterScope, scope, scopeManager;
      ast = harmony.parse("(function () {\n    let i = 20;\n    for (let { i, j, k } in i) {\n        console.log(i);\n    }\n}());");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(5);
      scope = scopeManager.scopes[0];
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(2);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.variables[1].name).to.be.equal('i');
      expect(scope.references).to.have.length(1);
      expect(scope.references[0].identifier.name).to.be.equal('i');
      expect(scope.references[0].resolved).to.be.equal(scope.variables[1]);
      iterScope = scope = scopeManager.scopes[2];
      expect(scope.type).to.be.equal('TDZ');
      expect(scope.variables).to.have.length(3);
      expect(scope.variables[0].name).to.be.equal('i');
      expect(scope.variables[0].defs[0].type).to.be.equal('TDZ');
      expect(scope.variables[1].name).to.be.equal('j');
      expect(scope.variables[1].defs[0].type).to.be.equal('TDZ');
      expect(scope.variables[2].name).to.be.equal('k');
      expect(scope.variables[2].defs[0].type).to.be.equal('TDZ');
      expect(scope.references).to.have.length(1);
      expect(scope.references[0].identifier.name).to.be.equal('i');
      expect(scope.references[0].resolved).to.be.equal(scope.variables[0]);
      iterScope = scope = scopeManager.scopes[3];
      expect(scope.type).to.be.equal('for');
      expect(scope.variables).to.have.length(3);
      expect(scope.variables[0].name).to.be.equal('i');
      expect(scope.variables[1].name).to.be.equal('j');
      expect(scope.variables[2].name).to.be.equal('k');
      expect(scope.references).to.have.length(3);
      expect(scope.references[0].identifier.name).to.be.equal('i');
      expect(scope.references[0].resolved).to.be.equal(scope.variables[0]);
      expect(scope.references[1].identifier.name).to.be.equal('j');
      expect(scope.references[1].resolved).to.be.equal(scope.variables[1]);
      expect(scope.references[2].identifier.name).to.be.equal('k');
      expect(scope.references[2].resolved).to.be.equal(scope.variables[2]);
      scope = scopeManager.scopes[4];
      expect(scope.type).to.be.equal('block');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(2);
      expect(scope.references[0].identifier.name).to.be.equal('console');
      expect(scope.references[0].resolved).to.be.equal(null);
      expect(scope.references[1].identifier.name).to.be.equal('i');
      return expect(scope.references[1].resolved).to.be.equal(iterScope.variables[0]);
    });
    return it('let materialize iteration scope for ForStatement#2', function() {
      var ast, functionScope, iterScope, scope, scopeManager;
      ast = harmony.parse("(function () {\n    let i = 20;\n    let obj = {};\n    for (let { i, j, k } = obj; i < okok; ++i) {\n        console.log(i, j, k);\n    }\n}());");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(4);
      scope = scopeManager.scopes[0];
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      functionScope = scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(3);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.variables[1].name).to.be.equal('i');
      expect(scope.variables[2].name).to.be.equal('obj');
      expect(scope.references).to.have.length(2);
      expect(scope.references[0].identifier.name).to.be.equal('i');
      expect(scope.references[0].resolved).to.be.equal(scope.variables[1]);
      expect(scope.references[1].identifier.name).to.be.equal('obj');
      expect(scope.references[1].resolved).to.be.equal(scope.variables[2]);
      iterScope = scope = scopeManager.scopes[2];
      expect(scope.type).to.be.equal('for');
      expect(scope.variables).to.have.length(3);
      expect(scope.variables[0].name).to.be.equal('i');
      expect(scope.variables[0].defs[0].type).to.be.equal('Variable');
      expect(scope.variables[1].name).to.be.equal('j');
      expect(scope.variables[1].defs[0].type).to.be.equal('Variable');
      expect(scope.variables[2].name).to.be.equal('k');
      expect(scope.variables[2].defs[0].type).to.be.equal('Variable');
      expect(scope.references).to.have.length(7);
      expect(scope.references[0].identifier.name).to.be.equal('i');
      expect(scope.references[0].resolved).to.be.equal(scope.variables[0]);
      expect(scope.references[1].identifier.name).to.be.equal('j');
      expect(scope.references[1].resolved).to.be.equal(scope.variables[1]);
      expect(scope.references[2].identifier.name).to.be.equal('k');
      expect(scope.references[2].resolved).to.be.equal(scope.variables[2]);
      expect(scope.references[3].identifier.name).to.be.equal('obj');
      expect(scope.references[3].resolved).to.be.equal(functionScope.variables[2]);
      expect(scope.references[4].identifier.name).to.be.equal('i');
      expect(scope.references[4].resolved).to.be.equal(scope.variables[0]);
      expect(scope.references[5].identifier.name).to.be.equal('okok');
      expect(scope.references[5].resolved).to.be["null"];
      expect(scope.references[6].identifier.name).to.be.equal('i');
      expect(scope.references[6].resolved).to.be.equal(scope.variables[0]);
      scope = scopeManager.scopes[3];
      expect(scope.type).to.be.equal('block');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(4);
      expect(scope.references[0].identifier.name).to.be.equal('console');
      expect(scope.references[0].resolved).to.be["null"];
      expect(scope.references[1].identifier.name).to.be.equal('i');
      expect(scope.references[1].resolved).to.be.equal(iterScope.variables[0]);
      expect(scope.references[2].identifier.name).to.be.equal('j');
      expect(scope.references[2].resolved).to.be.equal(iterScope.variables[1]);
      expect(scope.references[3].identifier.name).to.be.equal('k');
      return expect(scope.references[3].resolved).to.be.equal(iterScope.variables[2]);
    });
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVzNi1pdGVyYXRpb24tc2NvcGUuY29mZmVlIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQXVCQTtBQUFBLE1BQUEsdUJBQUE7O0FBQUEsRUFBQSxNQUFBLEdBQVMsT0FBQSxDQUFTLE1BQVQsQ0FBZSxDQUFDLE1BQXpCLENBQUE7O0FBQUEsRUFDQSxPQUFBLEdBQVUsT0FBQSxDQUFTLHdCQUFULENBRFYsQ0FBQTs7QUFBQSxFQUVBLE1BQUEsR0FBUyxPQUFBLENBQVMsSUFBVCxDQUZULENBQUE7O0FBQUEsRUFJQSxRQUFBLENBQVUscUJBQVYsRUFBZ0MsU0FBQSxHQUFBO0FBQzVCLElBQUEsRUFBQSxDQUFJLHNEQUFKLEVBQTJELFNBQUEsR0FBQTtBQUN2RCxVQUFBLG1DQUFBO0FBQUEsTUFBQSxHQUFBLEdBQU0sT0FBTyxDQUFDLEtBQVIsQ0FBaUIsZ0dBQWpCLENBQU4sQ0FBQTtBQUFBLE1BU0EsWUFBQSxHQUFlLE1BQU0sQ0FBQyxPQUFQLENBQWUsR0FBZixFQUFvQjtBQUFBLFFBQUEsV0FBQSxFQUFhLENBQWI7T0FBcEIsQ0FUZixDQUFBO0FBQUEsTUFVQSxNQUFBLENBQU8sWUFBWSxDQUFDLE1BQXBCLENBQTJCLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFwQyxDQUEyQyxDQUEzQyxDQVZBLENBQUE7QUFBQSxNQVlBLEtBQUEsR0FBUSxZQUFZLENBQUMsTUFBTyxDQUFBLENBQUEsQ0FaNUIsQ0FBQTtBQUFBLE1BYUEsTUFBQSxDQUFPLEtBQUssQ0FBQyxJQUFiLENBQWtCLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUF6QixDQUFnQyxRQUFoQyxDQWJBLENBQUE7QUFBQSxNQWNBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBYixDQUF1QixDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBaEMsQ0FBdUMsQ0FBdkMsQ0FkQSxDQUFBO0FBQUEsTUFnQkEsS0FBQSxHQUFRLFlBQVksQ0FBQyxNQUFPLENBQUEsQ0FBQSxDQWhCNUIsQ0FBQTtBQUFBLE1BaUJBLE1BQUEsQ0FBTyxLQUFLLENBQUMsSUFBYixDQUFrQixDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBekIsQ0FBZ0MsVUFBaEMsQ0FqQkEsQ0FBQTtBQUFBLE1Ba0JBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBYixDQUF1QixDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBaEMsQ0FBdUMsQ0FBdkMsQ0FsQkEsQ0FBQTtBQUFBLE1BbUJBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBRSxDQUFDLElBQTFCLENBQStCLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUF0QyxDQUE2QyxXQUE3QyxDQW5CQSxDQUFBO0FBQUEsTUFvQkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxTQUFVLENBQUEsQ0FBQSxDQUFFLENBQUMsSUFBMUIsQ0FBK0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQXRDLENBQTZDLEdBQTdDLENBcEJBLENBQUE7QUFBQSxNQXFCQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQWIsQ0FBd0IsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQWpDLENBQXdDLENBQXhDLENBckJBLENBQUE7QUFBQSxNQXNCQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxVQUFVLENBQUMsSUFBdEMsQ0FBMkMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQWxELENBQXlELEdBQXpELENBdEJBLENBQUE7QUFBQSxNQXVCQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxRQUEzQixDQUFvQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBM0MsQ0FBaUQsS0FBSyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQWpFLENBdkJBLENBQUE7QUFBQSxNQXlCQSxTQUFBLEdBQVksS0FBQSxHQUFRLFlBQVksQ0FBQyxNQUFPLENBQUEsQ0FBQSxDQXpCeEMsQ0FBQTtBQUFBLE1BMEJBLE1BQUEsQ0FBTyxLQUFLLENBQUMsSUFBYixDQUFrQixDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBekIsQ0FBZ0MsS0FBaEMsQ0ExQkEsQ0FBQTtBQUFBLE1BMkJBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBYixDQUF1QixDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBaEMsQ0FBdUMsQ0FBdkMsQ0EzQkEsQ0FBQTtBQUFBLE1BNEJBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBRSxDQUFDLElBQTFCLENBQStCLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUF0QyxDQUE2QyxHQUE3QyxDQTVCQSxDQUFBO0FBQUEsTUE2QkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxTQUFVLENBQUEsQ0FBQSxDQUFFLENBQUMsSUFBSyxDQUFBLENBQUEsQ0FBRSxDQUFDLElBQWxDLENBQXVDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUE5QyxDQUFxRCxLQUFyRCxDQTdCQSxDQUFBO0FBQUEsTUE4QkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxVQUFiLENBQXdCLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFqQyxDQUF3QyxDQUF4QyxDQTlCQSxDQUFBO0FBQUEsTUErQkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxVQUFXLENBQUEsQ0FBQSxDQUFFLENBQUMsVUFBVSxDQUFDLElBQXRDLENBQTJDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUFsRCxDQUF5RCxHQUF6RCxDQS9CQSxDQUFBO0FBQUEsTUFnQ0EsTUFBQSxDQUFPLEtBQUssQ0FBQyxVQUFXLENBQUEsQ0FBQSxDQUFFLENBQUMsUUFBM0IsQ0FBb0MsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQTNDLENBQWlELEtBQUssQ0FBQyxTQUFVLENBQUEsQ0FBQSxDQUFqRSxDQWhDQSxDQUFBO0FBQUEsTUFrQ0EsU0FBQSxHQUFZLEtBQUEsR0FBUSxZQUFZLENBQUMsTUFBTyxDQUFBLENBQUEsQ0FsQ3hDLENBQUE7QUFBQSxNQW1DQSxNQUFBLENBQU8sS0FBSyxDQUFDLElBQWIsQ0FBa0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQXpCLENBQWdDLEtBQWhDLENBbkNBLENBQUE7QUFBQSxNQW9DQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQWIsQ0FBdUIsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQWhDLENBQXVDLENBQXZDLENBcENBLENBQUE7QUFBQSxNQXFDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQUUsQ0FBQyxJQUExQixDQUErQixDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBdEMsQ0FBNkMsR0FBN0MsQ0FyQ0EsQ0FBQTtBQUFBLE1Bc0NBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBYixDQUF3QixDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBakMsQ0FBd0MsQ0FBeEMsQ0F0Q0EsQ0FBQTtBQUFBLE1BdUNBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFVBQVUsQ0FBQyxJQUF0QyxDQUEyQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBbEQsQ0FBeUQsR0FBekQsQ0F2Q0EsQ0FBQTtBQUFBLE1Bd0NBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFFBQTNCLENBQW9DLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUEzQyxDQUFpRCxLQUFLLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBakUsQ0F4Q0EsQ0FBQTtBQUFBLE1BMENBLEtBQUEsR0FBUSxZQUFZLENBQUMsTUFBTyxDQUFBLENBQUEsQ0ExQzVCLENBQUE7QUFBQSxNQTJDQSxNQUFBLENBQU8sS0FBSyxDQUFDLElBQWIsQ0FBa0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQXpCLENBQWdDLE9BQWhDLENBM0NBLENBQUE7QUFBQSxNQTRDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQWIsQ0FBdUIsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQWhDLENBQXVDLENBQXZDLENBNUNBLENBQUE7QUFBQSxNQTZDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQWIsQ0FBd0IsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQWpDLENBQXdDLENBQXhDLENBN0NBLENBQUE7QUFBQSxNQThDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxVQUFVLENBQUMsSUFBdEMsQ0FBMkMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQWxELENBQXlELFNBQXpELENBOUNBLENBQUE7QUFBQSxNQStDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxRQUEzQixDQUFvQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBM0MsQ0FBaUQsSUFBakQsQ0EvQ0EsQ0FBQTtBQUFBLE1BZ0RBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFVBQVUsQ0FBQyxJQUF0QyxDQUEyQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBbEQsQ0FBeUQsR0FBekQsQ0FoREEsQ0FBQTthQWlEQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxRQUEzQixDQUFvQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBM0MsQ0FBaUQsU0FBUyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQXJFLEVBbER1RDtJQUFBLENBQTNELENBQUEsQ0FBQTtBQUFBLElBb0RBLEVBQUEsQ0FBSSxzREFBSixFQUEyRCxTQUFBLEdBQUE7QUFDdkQsVUFBQSxtQ0FBQTtBQUFBLE1BQUEsR0FBQSxHQUFNLE9BQU8sQ0FBQyxLQUFSLENBQWlCLDBHQUFqQixDQUFOLENBQUE7QUFBQSxNQVNBLFlBQUEsR0FBZSxNQUFNLENBQUMsT0FBUCxDQUFlLEdBQWYsRUFBb0I7QUFBQSxRQUFBLFdBQUEsRUFBYSxDQUFiO09BQXBCLENBVGYsQ0FBQTtBQUFBLE1BVUEsTUFBQSxDQUFPLFlBQVksQ0FBQyxNQUFwQixDQUEyQixDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBcEMsQ0FBMkMsQ0FBM0MsQ0FWQSxDQUFBO0FBQUEsTUFZQSxLQUFBLEdBQVEsWUFBWSxDQUFDLE1BQU8sQ0FBQSxDQUFBLENBWjVCLENBQUE7QUFBQSxNQWFBLE1BQUEsQ0FBTyxLQUFLLENBQUMsSUFBYixDQUFrQixDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBekIsQ0FBZ0MsUUFBaEMsQ0FiQSxDQUFBO0FBQUEsTUFjQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQWIsQ0FBdUIsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQWhDLENBQXVDLENBQXZDLENBZEEsQ0FBQTtBQUFBLE1BZ0JBLEtBQUEsR0FBUSxZQUFZLENBQUMsTUFBTyxDQUFBLENBQUEsQ0FoQjVCLENBQUE7QUFBQSxNQWlCQSxNQUFBLENBQU8sS0FBSyxDQUFDLElBQWIsQ0FBa0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQXpCLENBQWdDLFVBQWhDLENBakJBLENBQUE7QUFBQSxNQWtCQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQWIsQ0FBdUIsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQWhDLENBQXVDLENBQXZDLENBbEJBLENBQUE7QUFBQSxNQW1CQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQUUsQ0FBQyxJQUExQixDQUErQixDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBdEMsQ0FBNkMsV0FBN0MsQ0FuQkEsQ0FBQTtBQUFBLE1Bb0JBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBRSxDQUFDLElBQTFCLENBQStCLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUF0QyxDQUE2QyxHQUE3QyxDQXBCQSxDQUFBO0FBQUEsTUFxQkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxVQUFiLENBQXdCLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFqQyxDQUF3QyxDQUF4QyxDQXJCQSxDQUFBO0FBQUEsTUFzQkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxVQUFXLENBQUEsQ0FBQSxDQUFFLENBQUMsVUFBVSxDQUFDLElBQXRDLENBQTJDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUFsRCxDQUF5RCxHQUF6RCxDQXRCQSxDQUFBO0FBQUEsTUF1QkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxVQUFXLENBQUEsQ0FBQSxDQUFFLENBQUMsUUFBM0IsQ0FBb0MsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQTNDLENBQWlELEtBQUssQ0FBQyxTQUFVLENBQUEsQ0FBQSxDQUFqRSxDQXZCQSxDQUFBO0FBQUEsTUF5QkEsU0FBQSxHQUFZLEtBQUEsR0FBUSxZQUFZLENBQUMsTUFBTyxDQUFBLENBQUEsQ0F6QnhDLENBQUE7QUFBQSxNQTBCQSxNQUFBLENBQU8sS0FBSyxDQUFDLElBQWIsQ0FBa0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQXpCLENBQWdDLEtBQWhDLENBMUJBLENBQUE7QUFBQSxNQTJCQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQWIsQ0FBdUIsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQWhDLENBQXVDLENBQXZDLENBM0JBLENBQUE7QUFBQSxNQTRCQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQUUsQ0FBQyxJQUExQixDQUErQixDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBdEMsQ0FBNkMsR0FBN0MsQ0E1QkEsQ0FBQTtBQUFBLE1BNkJBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBRSxDQUFDLElBQUssQ0FBQSxDQUFBLENBQUUsQ0FBQyxJQUFsQyxDQUF1QyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBOUMsQ0FBcUQsS0FBckQsQ0E3QkEsQ0FBQTtBQUFBLE1BOEJBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBRSxDQUFDLElBQTFCLENBQStCLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUF0QyxDQUE2QyxHQUE3QyxDQTlCQSxDQUFBO0FBQUEsTUErQkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxTQUFVLENBQUEsQ0FBQSxDQUFFLENBQUMsSUFBSyxDQUFBLENBQUEsQ0FBRSxDQUFDLElBQWxDLENBQXVDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUE5QyxDQUFxRCxLQUFyRCxDQS9CQSxDQUFBO0FBQUEsTUFnQ0EsTUFBQSxDQUFPLEtBQUssQ0FBQyxTQUFVLENBQUEsQ0FBQSxDQUFFLENBQUMsSUFBMUIsQ0FBK0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQXRDLENBQTZDLEdBQTdDLENBaENBLENBQUE7QUFBQSxNQWlDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQUUsQ0FBQyxJQUFLLENBQUEsQ0FBQSxDQUFFLENBQUMsSUFBbEMsQ0FBdUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQTlDLENBQXFELEtBQXJELENBakNBLENBQUE7QUFBQSxNQWtDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQWIsQ0FBd0IsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQWpDLENBQXdDLENBQXhDLENBbENBLENBQUE7QUFBQSxNQW1DQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxVQUFVLENBQUMsSUFBdEMsQ0FBMkMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQWxELENBQXlELEdBQXpELENBbkNBLENBQUE7QUFBQSxNQW9DQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxRQUEzQixDQUFvQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBM0MsQ0FBaUQsS0FBSyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQWpFLENBcENBLENBQUE7QUFBQSxNQXNDQSxTQUFBLEdBQVksS0FBQSxHQUFRLFlBQVksQ0FBQyxNQUFPLENBQUEsQ0FBQSxDQXRDeEMsQ0FBQTtBQUFBLE1BdUNBLE1BQUEsQ0FBTyxLQUFLLENBQUMsSUFBYixDQUFrQixDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBekIsQ0FBZ0MsS0FBaEMsQ0F2Q0EsQ0FBQTtBQUFBLE1Bd0NBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBYixDQUF1QixDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBaEMsQ0FBdUMsQ0FBdkMsQ0F4Q0EsQ0FBQTtBQUFBLE1BeUNBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBRSxDQUFDLElBQTFCLENBQStCLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUF0QyxDQUE2QyxHQUE3QyxDQXpDQSxDQUFBO0FBQUEsTUEwQ0EsTUFBQSxDQUFPLEtBQUssQ0FBQyxTQUFVLENBQUEsQ0FBQSxDQUFFLENBQUMsSUFBMUIsQ0FBK0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQXRDLENBQTZDLEdBQTdDLENBMUNBLENBQUE7QUFBQSxNQTJDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQUUsQ0FBQyxJQUExQixDQUErQixDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBdEMsQ0FBNkMsR0FBN0MsQ0EzQ0EsQ0FBQTtBQUFBLE1BNENBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBYixDQUF3QixDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBakMsQ0FBd0MsQ0FBeEMsQ0E1Q0EsQ0FBQTtBQUFBLE1BNkNBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFVBQVUsQ0FBQyxJQUF0QyxDQUEyQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBbEQsQ0FBeUQsR0FBekQsQ0E3Q0EsQ0FBQTtBQUFBLE1BOENBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFFBQTNCLENBQW9DLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUEzQyxDQUFpRCxLQUFLLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBakUsQ0E5Q0EsQ0FBQTtBQUFBLE1BK0NBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFVBQVUsQ0FBQyxJQUF0QyxDQUEyQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBbEQsQ0FBeUQsR0FBekQsQ0EvQ0EsQ0FBQTtBQUFBLE1BZ0RBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFFBQTNCLENBQW9DLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUEzQyxDQUFpRCxLQUFLLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBakUsQ0FoREEsQ0FBQTtBQUFBLE1BaURBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFVBQVUsQ0FBQyxJQUF0QyxDQUEyQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBbEQsQ0FBeUQsR0FBekQsQ0FqREEsQ0FBQTtBQUFBLE1Ba0RBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFFBQTNCLENBQW9DLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUEzQyxDQUFpRCxLQUFLLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBakUsQ0FsREEsQ0FBQTtBQUFBLE1Bb0RBLEtBQUEsR0FBUSxZQUFZLENBQUMsTUFBTyxDQUFBLENBQUEsQ0FwRDVCLENBQUE7QUFBQSxNQXFEQSxNQUFBLENBQU8sS0FBSyxDQUFDLElBQWIsQ0FBa0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQXpCLENBQWdDLE9BQWhDLENBckRBLENBQUE7QUFBQSxNQXNEQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQWIsQ0FBdUIsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQWhDLENBQXVDLENBQXZDLENBdERBLENBQUE7QUFBQSxNQXVEQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQWIsQ0FBd0IsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQWpDLENBQXdDLENBQXhDLENBdkRBLENBQUE7QUFBQSxNQXdEQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxVQUFVLENBQUMsSUFBdEMsQ0FBMkMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQWxELENBQXlELFNBQXpELENBeERBLENBQUE7QUFBQSxNQXlEQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxRQUEzQixDQUFvQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBM0MsQ0FBaUQsSUFBakQsQ0F6REEsQ0FBQTtBQUFBLE1BMERBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFVBQVUsQ0FBQyxJQUF0QyxDQUEyQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBbEQsQ0FBeUQsR0FBekQsQ0ExREEsQ0FBQTthQTJEQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxRQUEzQixDQUFvQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBM0MsQ0FBaUQsU0FBUyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQXJFLEVBNUR1RDtJQUFBLENBQTNELENBcERBLENBQUE7V0FrSEEsRUFBQSxDQUFJLG9EQUFKLEVBQXlELFNBQUEsR0FBQTtBQUNyRCxVQUFBLGtEQUFBO0FBQUEsTUFBQSxHQUFBLEdBQU0sT0FBTyxDQUFDLEtBQVIsQ0FBaUIsbUpBQWpCLENBQU4sQ0FBQTtBQUFBLE1BVUEsWUFBQSxHQUFlLE1BQU0sQ0FBQyxPQUFQLENBQWUsR0FBZixFQUFvQjtBQUFBLFFBQUEsV0FBQSxFQUFhLENBQWI7T0FBcEIsQ0FWZixDQUFBO0FBQUEsTUFXQSxNQUFBLENBQU8sWUFBWSxDQUFDLE1BQXBCLENBQTJCLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFwQyxDQUEyQyxDQUEzQyxDQVhBLENBQUE7QUFBQSxNQWFBLEtBQUEsR0FBUSxZQUFZLENBQUMsTUFBTyxDQUFBLENBQUEsQ0FiNUIsQ0FBQTtBQUFBLE1BY0EsTUFBQSxDQUFPLEtBQUssQ0FBQyxJQUFiLENBQWtCLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUF6QixDQUFnQyxRQUFoQyxDQWRBLENBQUE7QUFBQSxNQWVBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBYixDQUF1QixDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBaEMsQ0FBdUMsQ0FBdkMsQ0FmQSxDQUFBO0FBQUEsTUFpQkEsYUFBQSxHQUFnQixLQUFBLEdBQVEsWUFBWSxDQUFDLE1BQU8sQ0FBQSxDQUFBLENBakI1QyxDQUFBO0FBQUEsTUFrQkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxJQUFiLENBQWtCLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUF6QixDQUFnQyxVQUFoQyxDQWxCQSxDQUFBO0FBQUEsTUFtQkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxTQUFiLENBQXVCLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFoQyxDQUF1QyxDQUF2QyxDQW5CQSxDQUFBO0FBQUEsTUFvQkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxTQUFVLENBQUEsQ0FBQSxDQUFFLENBQUMsSUFBMUIsQ0FBK0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQXRDLENBQTZDLFdBQTdDLENBcEJBLENBQUE7QUFBQSxNQXFCQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQUUsQ0FBQyxJQUExQixDQUErQixDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBdEMsQ0FBNkMsR0FBN0MsQ0FyQkEsQ0FBQTtBQUFBLE1Bc0JBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBRSxDQUFDLElBQTFCLENBQStCLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUF0QyxDQUE2QyxLQUE3QyxDQXRCQSxDQUFBO0FBQUEsTUF1QkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxVQUFiLENBQXdCLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFqQyxDQUF3QyxDQUF4QyxDQXZCQSxDQUFBO0FBQUEsTUF3QkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxVQUFXLENBQUEsQ0FBQSxDQUFFLENBQUMsVUFBVSxDQUFDLElBQXRDLENBQTJDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUFsRCxDQUF5RCxHQUF6RCxDQXhCQSxDQUFBO0FBQUEsTUF5QkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxVQUFXLENBQUEsQ0FBQSxDQUFFLENBQUMsUUFBM0IsQ0FBb0MsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQTNDLENBQWlELEtBQUssQ0FBQyxTQUFVLENBQUEsQ0FBQSxDQUFqRSxDQXpCQSxDQUFBO0FBQUEsTUEwQkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxVQUFXLENBQUEsQ0FBQSxDQUFFLENBQUMsVUFBVSxDQUFDLElBQXRDLENBQTJDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUFsRCxDQUF5RCxLQUF6RCxDQTFCQSxDQUFBO0FBQUEsTUEyQkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxVQUFXLENBQUEsQ0FBQSxDQUFFLENBQUMsUUFBM0IsQ0FBb0MsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQTNDLENBQWlELEtBQUssQ0FBQyxTQUFVLENBQUEsQ0FBQSxDQUFqRSxDQTNCQSxDQUFBO0FBQUEsTUE2QkEsU0FBQSxHQUFZLEtBQUEsR0FBUSxZQUFZLENBQUMsTUFBTyxDQUFBLENBQUEsQ0E3QnhDLENBQUE7QUFBQSxNQThCQSxNQUFBLENBQU8sS0FBSyxDQUFDLElBQWIsQ0FBa0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQXpCLENBQWdDLEtBQWhDLENBOUJBLENBQUE7QUFBQSxNQStCQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQWIsQ0FBdUIsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQWhDLENBQXVDLENBQXZDLENBL0JBLENBQUE7QUFBQSxNQWdDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQUUsQ0FBQyxJQUExQixDQUErQixDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBdEMsQ0FBNkMsR0FBN0MsQ0FoQ0EsQ0FBQTtBQUFBLE1BaUNBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBRSxDQUFDLElBQUssQ0FBQSxDQUFBLENBQUUsQ0FBQyxJQUFsQyxDQUF1QyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBOUMsQ0FBcUQsVUFBckQsQ0FqQ0EsQ0FBQTtBQUFBLE1Ba0NBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBRSxDQUFDLElBQTFCLENBQStCLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUF0QyxDQUE2QyxHQUE3QyxDQWxDQSxDQUFBO0FBQUEsTUFtQ0EsTUFBQSxDQUFPLEtBQUssQ0FBQyxTQUFVLENBQUEsQ0FBQSxDQUFFLENBQUMsSUFBSyxDQUFBLENBQUEsQ0FBRSxDQUFDLElBQWxDLENBQXVDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUE5QyxDQUFxRCxVQUFyRCxDQW5DQSxDQUFBO0FBQUEsTUFvQ0EsTUFBQSxDQUFPLEtBQUssQ0FBQyxTQUFVLENBQUEsQ0FBQSxDQUFFLENBQUMsSUFBMUIsQ0FBK0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQXRDLENBQTZDLEdBQTdDLENBcENBLENBQUE7QUFBQSxNQXFDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQUUsQ0FBQyxJQUFLLENBQUEsQ0FBQSxDQUFFLENBQUMsSUFBbEMsQ0FBdUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQTlDLENBQXFELFVBQXJELENBckNBLENBQUE7QUFBQSxNQXNDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQWIsQ0FBd0IsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQWpDLENBQXdDLENBQXhDLENBdENBLENBQUE7QUFBQSxNQXVDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxVQUFVLENBQUMsSUFBdEMsQ0FBMkMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQWxELENBQXlELEdBQXpELENBdkNBLENBQUE7QUFBQSxNQXdDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxRQUEzQixDQUFvQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBM0MsQ0FBaUQsS0FBSyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQWpFLENBeENBLENBQUE7QUFBQSxNQXlDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxVQUFVLENBQUMsSUFBdEMsQ0FBMkMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQWxELENBQXlELEdBQXpELENBekNBLENBQUE7QUFBQSxNQTBDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxRQUEzQixDQUFvQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBM0MsQ0FBaUQsS0FBSyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQWpFLENBMUNBLENBQUE7QUFBQSxNQTJDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxVQUFVLENBQUMsSUFBdEMsQ0FBMkMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQWxELENBQXlELEdBQXpELENBM0NBLENBQUE7QUFBQSxNQTRDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxRQUEzQixDQUFvQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBM0MsQ0FBaUQsS0FBSyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQWpFLENBNUNBLENBQUE7QUFBQSxNQTZDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxVQUFVLENBQUMsSUFBdEMsQ0FBMkMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQWxELENBQXlELEtBQXpELENBN0NBLENBQUE7QUFBQSxNQThDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxRQUEzQixDQUFvQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBM0MsQ0FBaUQsYUFBYSxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQXpFLENBOUNBLENBQUE7QUFBQSxNQStDQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxVQUFVLENBQUMsSUFBdEMsQ0FBMkMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQWxELENBQXlELEdBQXpELENBL0NBLENBQUE7QUFBQSxNQWdEQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxRQUEzQixDQUFvQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBM0MsQ0FBaUQsS0FBSyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQWpFLENBaERBLENBQUE7QUFBQSxNQWlEQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxVQUFVLENBQUMsSUFBdEMsQ0FBMkMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQWxELENBQXlELE1BQXpELENBakRBLENBQUE7QUFBQSxNQWtEQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxRQUEzQixDQUFvQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsTUFBRCxDQWxEMUMsQ0FBQTtBQUFBLE1BbURBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFVBQVUsQ0FBQyxJQUF0QyxDQUEyQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBbEQsQ0FBeUQsR0FBekQsQ0FuREEsQ0FBQTtBQUFBLE1Bb0RBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFFBQTNCLENBQW9DLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUEzQyxDQUFpRCxLQUFLLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBakUsQ0FwREEsQ0FBQTtBQUFBLE1Bc0RBLEtBQUEsR0FBUSxZQUFZLENBQUMsTUFBTyxDQUFBLENBQUEsQ0F0RDVCLENBQUE7QUFBQSxNQXVEQSxNQUFBLENBQU8sS0FBSyxDQUFDLElBQWIsQ0FBa0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQXpCLENBQWdDLE9BQWhDLENBdkRBLENBQUE7QUFBQSxNQXdEQSxNQUFBLENBQU8sS0FBSyxDQUFDLFNBQWIsQ0FBdUIsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQWhDLENBQXVDLENBQXZDLENBeERBLENBQUE7QUFBQSxNQXlEQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQWIsQ0FBd0IsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQWpDLENBQXdDLENBQXhDLENBekRBLENBQUE7QUFBQSxNQTBEQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxVQUFVLENBQUMsSUFBdEMsQ0FBMkMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQWxELENBQXlELFNBQXpELENBMURBLENBQUE7QUFBQSxNQTJEQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxRQUEzQixDQUFvQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsTUFBRCxDQTNEMUMsQ0FBQTtBQUFBLE1BNERBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFVBQVUsQ0FBQyxJQUF0QyxDQUEyQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBbEQsQ0FBeUQsR0FBekQsQ0E1REEsQ0FBQTtBQUFBLE1BNkRBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFFBQTNCLENBQW9DLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUEzQyxDQUFpRCxTQUFTLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBckUsQ0E3REEsQ0FBQTtBQUFBLE1BOERBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFVBQVUsQ0FBQyxJQUF0QyxDQUEyQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBbEQsQ0FBeUQsR0FBekQsQ0E5REEsQ0FBQTtBQUFBLE1BK0RBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFFBQTNCLENBQW9DLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUEzQyxDQUFpRCxTQUFTLENBQUMsU0FBVSxDQUFBLENBQUEsQ0FBckUsQ0EvREEsQ0FBQTtBQUFBLE1BZ0VBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBVyxDQUFBLENBQUEsQ0FBRSxDQUFDLFVBQVUsQ0FBQyxJQUF0QyxDQUEyQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBbEQsQ0FBeUQsR0FBekQsQ0FoRUEsQ0FBQTthQWlFQSxNQUFBLENBQU8sS0FBSyxDQUFDLFVBQVcsQ0FBQSxDQUFBLENBQUUsQ0FBQyxRQUEzQixDQUFvQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBM0MsQ0FBaUQsU0FBUyxDQUFDLFNBQVUsQ0FBQSxDQUFBLENBQXJFLEVBbEVxRDtJQUFBLENBQXpELEVBbkg0QjtFQUFBLENBQWhDLENBSkEsQ0FBQTtBQUFBIiwiZmlsZSI6ImVzNi1pdGVyYXRpb24tc2NvcGUuanMiLCJzb3VyY2VSb290IjoiL3NvdXJjZS8iLCJzb3VyY2VzQ29udGVudCI6WyIjIC0qLSBjb2Rpbmc6IHV0Zi04IC0qLVxuIyAgQ29weXJpZ2h0IChDKSAyMDE0IFl1c3VrZSBTdXp1a2kgPHV0YXRhbmUudGVhQGdtYWlsLmNvbT5cbiNcbiMgIFJlZGlzdHJpYnV0aW9uIGFuZCB1c2UgaW4gc291cmNlIGFuZCBiaW5hcnkgZm9ybXMsIHdpdGggb3Igd2l0aG91dFxuIyAgbW9kaWZpY2F0aW9uLCBhcmUgcGVybWl0dGVkIHByb3ZpZGVkIHRoYXQgdGhlIGZvbGxvd2luZyBjb25kaXRpb25zIGFyZSBtZXQ6XG4jXG4jICAgICogUmVkaXN0cmlidXRpb25zIG9mIHNvdXJjZSBjb2RlIG11c3QgcmV0YWluIHRoZSBhYm92ZSBjb3B5cmlnaHRcbiMgICAgICBub3RpY2UsIHRoaXMgbGlzdCBvZiBjb25kaXRpb25zIGFuZCB0aGUgZm9sbG93aW5nIGRpc2NsYWltZXIuXG4jICAgICogUmVkaXN0cmlidXRpb25zIGluIGJpbmFyeSBmb3JtIG11c3QgcmVwcm9kdWNlIHRoZSBhYm92ZSBjb3B5cmlnaHRcbiMgICAgICBub3RpY2UsIHRoaXMgbGlzdCBvZiBjb25kaXRpb25zIGFuZCB0aGUgZm9sbG93aW5nIGRpc2NsYWltZXIgaW4gdGhlXG4jICAgICAgZG9jdW1lbnRhdGlvbiBhbmQvb3Igb3RoZXIgbWF0ZXJpYWxzIHByb3ZpZGVkIHdpdGggdGhlIGRpc3RyaWJ1dGlvbi5cbiNcbiMgIFRISVMgU09GVFdBUkUgSVMgUFJPVklERUQgQlkgVEhFIENPUFlSSUdIVCBIT0xERVJTIEFORCBDT05UUklCVVRPUlMgXCJBUyBJU1wiXG4jICBBTkQgQU5ZIEVYUFJFU1MgT1IgSU1QTElFRCBXQVJSQU5USUVTLCBJTkNMVURJTkcsIEJVVCBOT1QgTElNSVRFRCBUTywgVEhFXG4jICBJTVBMSUVEIFdBUlJBTlRJRVMgT0YgTUVSQ0hBTlRBQklMSVRZIEFORCBGSVRORVNTIEZPUiBBIFBBUlRJQ1VMQVIgUFVSUE9TRVxuIyAgQVJFIERJU0NMQUlNRUQuIElOIE5PIEVWRU5UIFNIQUxMIDxDT1BZUklHSFQgSE9MREVSPiBCRSBMSUFCTEUgRk9SIEFOWVxuIyAgRElSRUNULCBJTkRJUkVDVCwgSU5DSURFTlRBTCwgU1BFQ0lBTCwgRVhFTVBMQVJZLCBPUiBDT05TRVFVRU5USUFMIERBTUFHRVNcbiMgIChJTkNMVURJTkcsIEJVVCBOT1QgTElNSVRFRCBUTywgUFJPQ1VSRU1FTlQgT0YgU1VCU1RJVFVURSBHT09EUyBPUiBTRVJWSUNFUztcbiMgIExPU1MgT0YgVVNFLCBEQVRBLCBPUiBQUk9GSVRTOyBPUiBCVVNJTkVTUyBJTlRFUlJVUFRJT04pIEhPV0VWRVIgQ0FVU0VEIEFORFxuIyAgT04gQU5ZIFRIRU9SWSBPRiBMSUFCSUxJVFksIFdIRVRIRVIgSU4gQ09OVFJBQ1QsIFNUUklDVCBMSUFCSUxJVFksIE9SIFRPUlRcbiMgIChJTkNMVURJTkcgTkVHTElHRU5DRSBPUiBPVEhFUldJU0UpIEFSSVNJTkcgSU4gQU5ZIFdBWSBPVVQgT0YgVEhFIFVTRSBPRlxuIyAgVEhJUyBTT0ZUV0FSRSwgRVZFTiBJRiBBRFZJU0VEIE9GIFRIRSBQT1NTSUJJTElUWSBPRiBTVUNIIERBTUFHRS5cblxuZXhwZWN0ID0gcmVxdWlyZSgnY2hhaScpLmV4cGVjdFxuaGFybW9ueSA9IHJlcXVpcmUgJy4uL3RoaXJkX3BhcnR5L2VzcHJpbWEnXG5lc2NvcGUgPSByZXF1aXJlICcuLidcblxuZGVzY3JpYmUgJ0VTNiBpdGVyYXRpb24gc2NvcGUnLCAtPlxuICAgIGl0ICdsZXQgbWF0ZXJpYWxpemUgaXRlcmF0aW9uIHNjb3BlIGZvciBGb3JJblN0YXRlbWVudCMxJywgLT5cbiAgICAgICAgYXN0ID0gaGFybW9ueS5wYXJzZSBcIlwiXCJcbiAgICAgICAgKGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAgIGxldCBpID0gMjA7XG4gICAgICAgICAgICBmb3IgKGxldCBpIGluIGkpIHtcbiAgICAgICAgICAgICAgICBjb25zb2xlLmxvZyhpKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSgpKTtcbiAgICAgICAgXCJcIlwiXG5cbiAgICAgICAgc2NvcGVNYW5hZ2VyID0gZXNjb3BlLmFuYWx5emUgYXN0LCBlY21hVmVyc2lvbjogNlxuICAgICAgICBleHBlY3Qoc2NvcGVNYW5hZ2VyLnNjb3BlcykudG8uaGF2ZS5sZW5ndGggNVxuXG4gICAgICAgIHNjb3BlID0gc2NvcGVNYW5hZ2VyLnNjb3Blc1swXVxuICAgICAgICBleHBlY3Qoc2NvcGUudHlwZSkudG8uYmUuZXF1YWwgJ2dsb2JhbCdcbiAgICAgICAgZXhwZWN0KHNjb3BlLnZhcmlhYmxlcykudG8uaGF2ZS5sZW5ndGggMFxuXG4gICAgICAgIHNjb3BlID0gc2NvcGVNYW5hZ2VyLnNjb3Blc1sxXVxuICAgICAgICBleHBlY3Qoc2NvcGUudHlwZSkudG8uYmUuZXF1YWwgJ2Z1bmN0aW9uJ1xuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzKS50by5oYXZlLmxlbmd0aCAyXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXNbMF0ubmFtZSkudG8uYmUuZXF1YWwgJ2FyZ3VtZW50cydcbiAgICAgICAgZXhwZWN0KHNjb3BlLnZhcmlhYmxlc1sxXS5uYW1lKS50by5iZS5lcXVhbCAnaSdcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXMpLnRvLmhhdmUubGVuZ3RoIDFcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMF0uaWRlbnRpZmllci5uYW1lKS50by5iZS5lcXVhbCAnaSdcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMF0ucmVzb2x2ZWQpLnRvLmJlLmVxdWFsIHNjb3BlLnZhcmlhYmxlc1sxXVxuXG4gICAgICAgIGl0ZXJTY29wZSA9IHNjb3BlID0gc2NvcGVNYW5hZ2VyLnNjb3Blc1syXVxuICAgICAgICBleHBlY3Qoc2NvcGUudHlwZSkudG8uYmUuZXF1YWwgJ1REWidcbiAgICAgICAgZXhwZWN0KHNjb3BlLnZhcmlhYmxlcykudG8uaGF2ZS5sZW5ndGggMVxuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzWzBdLm5hbWUpLnRvLmJlLmVxdWFsICdpJ1xuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzWzBdLmRlZnNbMF0udHlwZSkudG8uYmUuZXF1YWwgJ1REWidcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXMpLnRvLmhhdmUubGVuZ3RoIDFcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMF0uaWRlbnRpZmllci5uYW1lKS50by5iZS5lcXVhbCAnaSdcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMF0ucmVzb2x2ZWQpLnRvLmJlLmVxdWFsIHNjb3BlLnZhcmlhYmxlc1swXVxuXG4gICAgICAgIGl0ZXJTY29wZSA9IHNjb3BlID0gc2NvcGVNYW5hZ2VyLnNjb3Blc1szXVxuICAgICAgICBleHBlY3Qoc2NvcGUudHlwZSkudG8uYmUuZXF1YWwgJ2ZvcidcbiAgICAgICAgZXhwZWN0KHNjb3BlLnZhcmlhYmxlcykudG8uaGF2ZS5sZW5ndGggMVxuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzWzBdLm5hbWUpLnRvLmJlLmVxdWFsICdpJ1xuICAgICAgICBleHBlY3Qoc2NvcGUucmVmZXJlbmNlcykudG8uaGF2ZS5sZW5ndGggMVxuICAgICAgICBleHBlY3Qoc2NvcGUucmVmZXJlbmNlc1swXS5pZGVudGlmaWVyLm5hbWUpLnRvLmJlLmVxdWFsICdpJ1xuICAgICAgICBleHBlY3Qoc2NvcGUucmVmZXJlbmNlc1swXS5yZXNvbHZlZCkudG8uYmUuZXF1YWwgc2NvcGUudmFyaWFibGVzWzBdXG5cbiAgICAgICAgc2NvcGUgPSBzY29wZU1hbmFnZXIuc2NvcGVzWzRdXG4gICAgICAgIGV4cGVjdChzY29wZS50eXBlKS50by5iZS5lcXVhbCAnYmxvY2snXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXMpLnRvLmhhdmUubGVuZ3RoIDBcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXMpLnRvLmhhdmUubGVuZ3RoIDJcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMF0uaWRlbnRpZmllci5uYW1lKS50by5iZS5lcXVhbCAnY29uc29sZSdcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMF0ucmVzb2x2ZWQpLnRvLmJlLmVxdWFsIG51bGxcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMV0uaWRlbnRpZmllci5uYW1lKS50by5iZS5lcXVhbCAnaSdcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMV0ucmVzb2x2ZWQpLnRvLmJlLmVxdWFsIGl0ZXJTY29wZS52YXJpYWJsZXNbMF1cblxuICAgIGl0ICdsZXQgbWF0ZXJpYWxpemUgaXRlcmF0aW9uIHNjb3BlIGZvciBGb3JJblN0YXRlbWVudCMyJywgLT5cbiAgICAgICAgYXN0ID0gaGFybW9ueS5wYXJzZSBcIlwiXCJcbiAgICAgICAgKGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAgIGxldCBpID0gMjA7XG4gICAgICAgICAgICBmb3IgKGxldCB7IGksIGosIGsgfSBpbiBpKSB7XG4gICAgICAgICAgICAgICAgY29uc29sZS5sb2coaSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0oKSk7XG4gICAgICAgIFwiXCJcIlxuXG4gICAgICAgIHNjb3BlTWFuYWdlciA9IGVzY29wZS5hbmFseXplIGFzdCwgZWNtYVZlcnNpb246IDZcbiAgICAgICAgZXhwZWN0KHNjb3BlTWFuYWdlci5zY29wZXMpLnRvLmhhdmUubGVuZ3RoIDVcblxuICAgICAgICBzY29wZSA9IHNjb3BlTWFuYWdlci5zY29wZXNbMF1cbiAgICAgICAgZXhwZWN0KHNjb3BlLnR5cGUpLnRvLmJlLmVxdWFsICdnbG9iYWwnXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXMpLnRvLmhhdmUubGVuZ3RoIDBcblxuICAgICAgICBzY29wZSA9IHNjb3BlTWFuYWdlci5zY29wZXNbMV1cbiAgICAgICAgZXhwZWN0KHNjb3BlLnR5cGUpLnRvLmJlLmVxdWFsICdmdW5jdGlvbidcbiAgICAgICAgZXhwZWN0KHNjb3BlLnZhcmlhYmxlcykudG8uaGF2ZS5sZW5ndGggMlxuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzWzBdLm5hbWUpLnRvLmJlLmVxdWFsICdhcmd1bWVudHMnXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXNbMV0ubmFtZSkudG8uYmUuZXF1YWwgJ2knXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzKS50by5oYXZlLmxlbmd0aCAxXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzBdLmlkZW50aWZpZXIubmFtZSkudG8uYmUuZXF1YWwgJ2knXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzBdLnJlc29sdmVkKS50by5iZS5lcXVhbCBzY29wZS52YXJpYWJsZXNbMV1cblxuICAgICAgICBpdGVyU2NvcGUgPSBzY29wZSA9IHNjb3BlTWFuYWdlci5zY29wZXNbMl1cbiAgICAgICAgZXhwZWN0KHNjb3BlLnR5cGUpLnRvLmJlLmVxdWFsICdURFonXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXMpLnRvLmhhdmUubGVuZ3RoIDNcbiAgICAgICAgZXhwZWN0KHNjb3BlLnZhcmlhYmxlc1swXS5uYW1lKS50by5iZS5lcXVhbCAnaSdcbiAgICAgICAgZXhwZWN0KHNjb3BlLnZhcmlhYmxlc1swXS5kZWZzWzBdLnR5cGUpLnRvLmJlLmVxdWFsICdURFonXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXNbMV0ubmFtZSkudG8uYmUuZXF1YWwgJ2onXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXNbMV0uZGVmc1swXS50eXBlKS50by5iZS5lcXVhbCAnVERaJ1xuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzWzJdLm5hbWUpLnRvLmJlLmVxdWFsICdrJ1xuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzWzJdLmRlZnNbMF0udHlwZSkudG8uYmUuZXF1YWwgJ1REWidcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXMpLnRvLmhhdmUubGVuZ3RoIDFcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMF0uaWRlbnRpZmllci5uYW1lKS50by5iZS5lcXVhbCAnaSdcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMF0ucmVzb2x2ZWQpLnRvLmJlLmVxdWFsIHNjb3BlLnZhcmlhYmxlc1swXVxuXG4gICAgICAgIGl0ZXJTY29wZSA9IHNjb3BlID0gc2NvcGVNYW5hZ2VyLnNjb3Blc1szXVxuICAgICAgICBleHBlY3Qoc2NvcGUudHlwZSkudG8uYmUuZXF1YWwgJ2ZvcidcbiAgICAgICAgZXhwZWN0KHNjb3BlLnZhcmlhYmxlcykudG8uaGF2ZS5sZW5ndGggM1xuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzWzBdLm5hbWUpLnRvLmJlLmVxdWFsICdpJ1xuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzWzFdLm5hbWUpLnRvLmJlLmVxdWFsICdqJ1xuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzWzJdLm5hbWUpLnRvLmJlLmVxdWFsICdrJ1xuICAgICAgICBleHBlY3Qoc2NvcGUucmVmZXJlbmNlcykudG8uaGF2ZS5sZW5ndGggM1xuICAgICAgICBleHBlY3Qoc2NvcGUucmVmZXJlbmNlc1swXS5pZGVudGlmaWVyLm5hbWUpLnRvLmJlLmVxdWFsICdpJ1xuICAgICAgICBleHBlY3Qoc2NvcGUucmVmZXJlbmNlc1swXS5yZXNvbHZlZCkudG8uYmUuZXF1YWwgc2NvcGUudmFyaWFibGVzWzBdXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzFdLmlkZW50aWZpZXIubmFtZSkudG8uYmUuZXF1YWwgJ2onXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzFdLnJlc29sdmVkKS50by5iZS5lcXVhbCBzY29wZS52YXJpYWJsZXNbMV1cbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMl0uaWRlbnRpZmllci5uYW1lKS50by5iZS5lcXVhbCAnaydcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMl0ucmVzb2x2ZWQpLnRvLmJlLmVxdWFsIHNjb3BlLnZhcmlhYmxlc1syXVxuXG4gICAgICAgIHNjb3BlID0gc2NvcGVNYW5hZ2VyLnNjb3Blc1s0XVxuICAgICAgICBleHBlY3Qoc2NvcGUudHlwZSkudG8uYmUuZXF1YWwgJ2Jsb2NrJ1xuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzKS50by5oYXZlLmxlbmd0aCAwXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzKS50by5oYXZlLmxlbmd0aCAyXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzBdLmlkZW50aWZpZXIubmFtZSkudG8uYmUuZXF1YWwgJ2NvbnNvbGUnXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzBdLnJlc29sdmVkKS50by5iZS5lcXVhbCBudWxsXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzFdLmlkZW50aWZpZXIubmFtZSkudG8uYmUuZXF1YWwgJ2knXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzFdLnJlc29sdmVkKS50by5iZS5lcXVhbCBpdGVyU2NvcGUudmFyaWFibGVzWzBdXG5cbiAgICBpdCAnbGV0IG1hdGVyaWFsaXplIGl0ZXJhdGlvbiBzY29wZSBmb3IgRm9yU3RhdGVtZW50IzInLCAtPlxuICAgICAgICBhc3QgPSBoYXJtb255LnBhcnNlIFwiXCJcIlxuICAgICAgICAoZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgbGV0IGkgPSAyMDtcbiAgICAgICAgICAgIGxldCBvYmogPSB7fTtcbiAgICAgICAgICAgIGZvciAobGV0IHsgaSwgaiwgayB9ID0gb2JqOyBpIDwgb2tvazsgKytpKSB7XG4gICAgICAgICAgICAgICAgY29uc29sZS5sb2coaSwgaiwgayk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0oKSk7XG4gICAgICAgIFwiXCJcIlxuXG4gICAgICAgIHNjb3BlTWFuYWdlciA9IGVzY29wZS5hbmFseXplIGFzdCwgZWNtYVZlcnNpb246IDZcbiAgICAgICAgZXhwZWN0KHNjb3BlTWFuYWdlci5zY29wZXMpLnRvLmhhdmUubGVuZ3RoIDRcblxuICAgICAgICBzY29wZSA9IHNjb3BlTWFuYWdlci5zY29wZXNbMF1cbiAgICAgICAgZXhwZWN0KHNjb3BlLnR5cGUpLnRvLmJlLmVxdWFsICdnbG9iYWwnXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXMpLnRvLmhhdmUubGVuZ3RoIDBcblxuICAgICAgICBmdW5jdGlvblNjb3BlID0gc2NvcGUgPSBzY29wZU1hbmFnZXIuc2NvcGVzWzFdXG4gICAgICAgIGV4cGVjdChzY29wZS50eXBlKS50by5iZS5lcXVhbCAnZnVuY3Rpb24nXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXMpLnRvLmhhdmUubGVuZ3RoIDNcbiAgICAgICAgZXhwZWN0KHNjb3BlLnZhcmlhYmxlc1swXS5uYW1lKS50by5iZS5lcXVhbCAnYXJndW1lbnRzJ1xuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzWzFdLm5hbWUpLnRvLmJlLmVxdWFsICdpJ1xuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzWzJdLm5hbWUpLnRvLmJlLmVxdWFsICdvYmonXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzKS50by5oYXZlLmxlbmd0aCAyXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzBdLmlkZW50aWZpZXIubmFtZSkudG8uYmUuZXF1YWwgJ2knXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzBdLnJlc29sdmVkKS50by5iZS5lcXVhbCBzY29wZS52YXJpYWJsZXNbMV1cbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMV0uaWRlbnRpZmllci5uYW1lKS50by5iZS5lcXVhbCAnb2JqJ1xuICAgICAgICBleHBlY3Qoc2NvcGUucmVmZXJlbmNlc1sxXS5yZXNvbHZlZCkudG8uYmUuZXF1YWwgc2NvcGUudmFyaWFibGVzWzJdXG5cbiAgICAgICAgaXRlclNjb3BlID0gc2NvcGUgPSBzY29wZU1hbmFnZXIuc2NvcGVzWzJdXG4gICAgICAgIGV4cGVjdChzY29wZS50eXBlKS50by5iZS5lcXVhbCAnZm9yJ1xuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzKS50by5oYXZlLmxlbmd0aCAzXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXNbMF0ubmFtZSkudG8uYmUuZXF1YWwgJ2knXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXNbMF0uZGVmc1swXS50eXBlKS50by5iZS5lcXVhbCAnVmFyaWFibGUnXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXNbMV0ubmFtZSkudG8uYmUuZXF1YWwgJ2onXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXNbMV0uZGVmc1swXS50eXBlKS50by5iZS5lcXVhbCAnVmFyaWFibGUnXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXNbMl0ubmFtZSkudG8uYmUuZXF1YWwgJ2snXG4gICAgICAgIGV4cGVjdChzY29wZS52YXJpYWJsZXNbMl0uZGVmc1swXS50eXBlKS50by5iZS5lcXVhbCAnVmFyaWFibGUnXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzKS50by5oYXZlLmxlbmd0aCA3XG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzBdLmlkZW50aWZpZXIubmFtZSkudG8uYmUuZXF1YWwgJ2knXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzBdLnJlc29sdmVkKS50by5iZS5lcXVhbCBzY29wZS52YXJpYWJsZXNbMF1cbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMV0uaWRlbnRpZmllci5uYW1lKS50by5iZS5lcXVhbCAnaidcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbMV0ucmVzb2x2ZWQpLnRvLmJlLmVxdWFsIHNjb3BlLnZhcmlhYmxlc1sxXVxuICAgICAgICBleHBlY3Qoc2NvcGUucmVmZXJlbmNlc1syXS5pZGVudGlmaWVyLm5hbWUpLnRvLmJlLmVxdWFsICdrJ1xuICAgICAgICBleHBlY3Qoc2NvcGUucmVmZXJlbmNlc1syXS5yZXNvbHZlZCkudG8uYmUuZXF1YWwgc2NvcGUudmFyaWFibGVzWzJdXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzNdLmlkZW50aWZpZXIubmFtZSkudG8uYmUuZXF1YWwgJ29iaidcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbM10ucmVzb2x2ZWQpLnRvLmJlLmVxdWFsIGZ1bmN0aW9uU2NvcGUudmFyaWFibGVzWzJdXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzRdLmlkZW50aWZpZXIubmFtZSkudG8uYmUuZXF1YWwgJ2knXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzRdLnJlc29sdmVkKS50by5iZS5lcXVhbCBzY29wZS52YXJpYWJsZXNbMF1cbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbNV0uaWRlbnRpZmllci5uYW1lKS50by5iZS5lcXVhbCAnb2tvaydcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbNV0ucmVzb2x2ZWQpLnRvLmJlLm51bGxcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbNl0uaWRlbnRpZmllci5uYW1lKS50by5iZS5lcXVhbCAnaSdcbiAgICAgICAgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXNbNl0ucmVzb2x2ZWQpLnRvLmJlLmVxdWFsIHNjb3BlLnZhcmlhYmxlc1swXVxuXG4gICAgICAgIHNjb3BlID0gc2NvcGVNYW5hZ2VyLnNjb3Blc1szXVxuICAgICAgICBleHBlY3Qoc2NvcGUudHlwZSkudG8uYmUuZXF1YWwgJ2Jsb2NrJ1xuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzKS50by5oYXZlLmxlbmd0aCAwXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzKS50by5oYXZlLmxlbmd0aCA0XG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzBdLmlkZW50aWZpZXIubmFtZSkudG8uYmUuZXF1YWwgJ2NvbnNvbGUnXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzBdLnJlc29sdmVkKS50by5iZS5udWxsXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzFdLmlkZW50aWZpZXIubmFtZSkudG8uYmUuZXF1YWwgJ2knXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzFdLnJlc29sdmVkKS50by5iZS5lcXVhbCBpdGVyU2NvcGUudmFyaWFibGVzWzBdXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzJdLmlkZW50aWZpZXIubmFtZSkudG8uYmUuZXF1YWwgJ2onXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzJdLnJlc29sdmVkKS50by5iZS5lcXVhbCBpdGVyU2NvcGUudmFyaWFibGVzWzFdXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzNdLmlkZW50aWZpZXIubmFtZSkudG8uYmUuZXF1YWwgJ2snXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzWzNdLnJlc29sdmVkKS50by5iZS5lcXVhbCBpdGVyU2NvcGUudmFyaWFibGVzWzJdXG5cbiMgdmltOiBzZXQgc3c9NCB0cz00IGV0IHR3PTgwIDpcbiJdfQ==