# -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

$(eval $(call gb_Executable_Executable,icontest))

$(eval $(call gb_Executable_use_externals,icontest,\
    boost_headers \
	glm_headers \
))
ifeq ($(DISABLE_GUI),)
$(eval $(call gb_Executable_use_externals,icontest,\
    epoxy \
))
endif

ifeq ($(SYSTEM_GLM),TRUE)
$(eval $(call gb_Executable_add_defs,icontest,\
    -DGLM_ENABLE_EXPERIMENTAL \
))
endif

$(eval $(call gb_Executable_add_defs,icontest,\
    -DVCL_INTERNALS \
))

$(eval $(call gb_Executable_use_api,icontest,\
    offapi \
    udkapi \
))

$(eval $(call gb_Executable_use_libraries,icontest,\
    comphelper \
    cppu \
    cppuhelper \
    sal \
    tl \
    ucbhelper \
))

$(eval $(call gb_Executable_use_vclmain,icontest))

$(eval $(call gb_Executable_add_exception_objects,icontest,\
    vcl/workben/icontest \
))

# vim: set noet sw=4 ts=4:
