#ifndef _TEGRA_POWERGATE_H_
#define _TEGRA_POWERGATE_H_

#include <asm/arch/clock.h>

enum tegra_powergate {
	TEGRA_POWERGATE_CPU,
	TEGRA_POWERGATE_3D,
	TEGRA_POWERGATE_VENC,
	TEGRA_POWERGATE_PCIE,
	TEGRA_POWERGATE_VDEC,
	TEGRA_POWERGATE_L2,
	TEGRA_POWERGATE_MPE,
	TEGRA_POWERGATE_HEG,
	TEGRA_POWERGATE_SATA,
	TEGRA_POWERGATE_CPU1,
	TEGRA_POWERGATE_CPU2,
	TEGRA_POWERGATE_CPU3,
	TEGRA_POWERGATE_CELP,
	TEGRA_POWERGATE_3D1,
	TEGRA_POWERGATE_CPU0,
	TEGRA_POWERGATE_C0NC,
	TEGRA_POWERGATE_C1NC,
	TEGRA_POWERGATE_SOR,
	TEGRA_POWERGATE_DIS,
	TEGRA_POWERGATE_DISB,
	TEGRA_POWERGATE_XUSBA,
	TEGRA_POWERGATE_XUSBB,
	TEGRA_POWERGATE_XUSBC,
	TEGRA_POWERGATE_VIC,
	TEGRA_POWERGATE_IRAM,
};

int tegra_powergate_sequence_power_up(enum tegra_powergate id,
				      enum periph_id periph);
int tegra_powergate_power_off(enum tegra_powergate id);

#endif
