/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (C) 2015 Freescale Semiconductor, Inc. All Rights Reserved.
 */

#ifndef __ASM_ARCH_MX7_IMX_REGS_H__
#define __ASM_ARCH_MX7_IMX_REGS_H__

#define ARCH_MXC

#define ROM_SW_INFO_ADDR                0x000001E8
#define ROMCP_ARB_BASE_ADDR             0x00000000
#define ROMCP_ARB_END_ADDR              0x00017FFF
#define BOOT_ROM_BASE_ADDR              ROMCP_ARB_BASE_ADDR
#define CAAM_ARB_BASE_ADDR              0x00100000
#define CAAM_ARB_END_ADDR               0x00107FFF
#define GIC400_ARB_BASE_ADDR            0x31000000
#define GIC400_ARB_END_ADDR             0x31007FFF
#define APBH_DMA_ARB_BASE_ADDR          0x33000000
#define APBH_DMA_ARB_END_ADDR           0x33007FFF
#define M4_BOOTROM_BASE_ADDR            0x00180000

#define MXS_APBH_BASE			APBH_DMA_ARB_BASE_ADDR
#define MXS_GPMI_BASE			(APBH_DMA_ARB_BASE_ADDR + 0x02000)
#define MXS_BCH_BASE			(APBH_DMA_ARB_BASE_ADDR + 0x04000)

/* GPV - PL301 configuration ports */
#define GPV0_BASE_ADDR                  0x32000000
#define GPV1_BASE_ADDR                  0x32100000
#define GPV2_BASE_ADDR                  0x32200000
#define GPV3_BASE_ADDR                  0x32300000
#define GPV4_BASE_ADDR                  0x32400000
#define GPV5_BASE_ADDR                  0x32500000
#define GPV6_BASE_ADDR                  0x32600000
#define GPV7_BASE_ADDR                  0x32700000

#define OCRAM_ARB_BASE_ADDR             0x00900000
#define OCRAM_ARB_END_ADDR              0x0091FFFF
#define OCRAM_EPDC_BASE_ADDR            0x00920000
#define OCRAM_EPDC_END_ADDR             0x0093FFFF
#define OCRAM_PXP_BASE_ADDR             0x00940000
#define OCRAM_PXP_END_ADDR              0x00947FFF
#define IRAM_BASE_ADDR                  OCRAM_ARB_BASE_ADDR
#define IRAM_SIZE			0x00020000

#define AIPS1_ARB_BASE_ADDR             0x30000000
#define AIPS1_ARB_END_ADDR              0x303FFFFF
#define AIPS2_ARB_BASE_ADDR             0x30400000
#define AIPS2_ARB_END_ADDR              0x307FFFFF
#define AIPS3_ARB_BASE_ADDR             0x30800000
#define AIPS3_ARB_END_ADDR              0x30BFFFFF

#define WEIM_ARB_BASE_ADDR              0x28000000
#define WEIM_ARB_END_ADDR               0x2FFFFFFF

#define QSPI0_ARB_BASE_ADDR             0x60000000
#define QSPI0_ARB_END_ADDR              0x6FFFFFFF
#define PCIE_ARB_BASE_ADDR              0x40000000
#define PCIE_ARB_END_ADDR               0x4FFFFFFF
#define PCIE_REG_BASE_ADDR              0x33800000
#define PCIE_REG_END_ADDR               0x33803FFF

#define MMDC0_ARB_BASE_ADDR             0x80000000
#define MMDC0_ARB_END_ADDR              0xBFFFFFFF
#define MMDC1_ARB_BASE_ADDR             0xC0000000
#define MMDC1_ARB_END_ADDR              0xFFFFFFFF

/* Cortex-A9 MPCore private memory region */
#define ARM_PERIPHBASE                  0x31000000
#define SCU_BASE_ADDR                   ARM_PERIPHBASE
#define GLOBAL_TIMER_BASE_ADDR          (ARM_PERIPHBASE + 0x0200)
#define PRIVATE_TIMERS_WD_BASE_ADDR     (ARM_PERIPHBASE + 0x0600)


/* Defines for Blocks connected via AIPS (SkyBlue) */
#define AIPS_TZ1_BASE_ADDR              AIPS1_ARB_BASE_ADDR
#define AIPS_TZ2_BASE_ADDR              AIPS2_ARB_BASE_ADDR
#define AIPS_TZ3_BASE_ADDR              AIPS3_ARB_BASE_ADDR

/* DAP base-address */
#define ARM_IPS_BASE_ADDR               AIPS1_ARB_BASE_ADDR

/* AIPS_TZ#1- On Platform */
#define AIPS1_ON_BASE_ADDR              (AIPS_TZ1_BASE_ADDR+0x1F0000)
/* AIPS_TZ#1- Off Platform */
#define AIPS1_OFF_BASE_ADDR             (AIPS_TZ1_BASE_ADDR+0x200000)

#define GPIO1_BASE_ADDR                 AIPS1_OFF_BASE_ADDR
#define GPIO2_BASE_ADDR                 (AIPS1_OFF_BASE_ADDR+0x10000)
#define GPIO3_BASE_ADDR                 (AIPS1_OFF_BASE_ADDR+0x20000)
#define GPIO4_BASE_ADDR                 (AIPS1_OFF_BASE_ADDR+0x30000)
#define GPIO5_BASE_ADDR                 (AIPS1_OFF_BASE_ADDR+0x40000)
#define GPIO6_BASE_ADDR                 (AIPS1_OFF_BASE_ADDR+0x50000)
#define GPIO7_BASE_ADDR                 (AIPS1_OFF_BASE_ADDR+0x60000)
#define IOMUXC_LPSR_GPR_BASE_ADDR      (AIPS1_OFF_BASE_ADDR+0x70000)
#define WDOG1_BASE_ADDR                (AIPS1_OFF_BASE_ADDR+0x80000)
#define WDOG2_BASE_ADDR                (AIPS1_OFF_BASE_ADDR+0x90000)
#define WDOG3_BASE_ADDR                (AIPS1_OFF_BASE_ADDR+0xA0000)
#define WDOG4_BASE_ADDR                (AIPS1_OFF_BASE_ADDR+0xB0000)
#define IOMUXC_LPSR_BASE_ADDR          (AIPS1_OFF_BASE_ADDR+0xC0000)
#define GPT_IPS_BASE_ADDR              (AIPS1_OFF_BASE_ADDR+0xD0000)
#define GPT1_BASE_ADDR GPT_IPS_BASE_ADDR
#define GPT2_IPS_BASE_ADDR             (AIPS1_OFF_BASE_ADDR+0xE0000)
#define GPT3_IPS_BASE_ADDR             (AIPS1_OFF_BASE_ADDR+0xF0000)
#define GPT4_IPS_BASE_ADDR             (AIPS1_OFF_BASE_ADDR+0x100000)
#define ROMCP_IPS_BASE_ADDR            (AIPS1_OFF_BASE_ADDR+0x110000)
#define KPP_IPS_BASE_ADDR              (AIPS1_OFF_BASE_ADDR+0x120000)
#define IOMUXC_IPS_BASE_ADDR           (AIPS1_OFF_BASE_ADDR+0x130000)
#define IOMUXC_BASE_ADDR               IOMUXC_IPS_BASE_ADDR
#define IOMUXC_GPR_BASE_ADDR           (AIPS1_OFF_BASE_ADDR+0x140000)
#define OCOTP_BASE_ADDR                (AIPS1_OFF_BASE_ADDR+0x150000)
#define ANATOP_BASE_ADDR               (AIPS1_OFF_BASE_ADDR+0x160000)
#define SNVS_BASE_ADDR                 (AIPS1_OFF_BASE_ADDR+0x170000)
#define CCM_BASE_ADDR                  (AIPS1_OFF_BASE_ADDR+0x180000)
#define SRC_BASE_ADDR                  (AIPS1_OFF_BASE_ADDR+0x190000)
#define GPC_IPS_BASE_ADDR              (AIPS1_OFF_BASE_ADDR+0x1A0000)
#define SEMA41_IPS_BASE_ADDR           (AIPS1_OFF_BASE_ADDR+0x1B0000)
#define SEMA42_IPS_BASE_ADDR           (AIPS1_OFF_BASE_ADDR+0x1C0000)
#define RDC_IPS_BASE_ADDR              (AIPS1_OFF_BASE_ADDR+0x1D0000)
#define CSU_IPS_BASE_ADDR              (AIPS1_OFF_BASE_ADDR+0x1E0000)

/* AIPS_TZ#2- On Platform */
#define AIPS2_ON_BASE_ADDR              (AIPS_TZ2_BASE_ADDR+0x1F0000)
/* AIPS_TZ#2- Off Platform */
#define AIPS2_OFF_BASE_ADDR             (AIPS_TZ2_BASE_ADDR+0x200000)
#define ADC1_IPS_BASE_ADDR              (AIPS2_OFF_BASE_ADDR+0x10000)
#define ADC2_IPS_BASE_ADDR              (AIPS2_OFF_BASE_ADDR+0x20000)
#define ECSPI4_BASE_ADDR                (AIPS2_OFF_BASE_ADDR+0x30000)
#define FTM1_IPS_BASE_ADDR              (AIPS2_OFF_BASE_ADDR+0x40000)
#define FTM2_IPS_BASE_ADDR              (AIPS2_OFF_BASE_ADDR+0x50000)
#define PWM1_IPS_BASE_ADDR              (AIPS2_OFF_BASE_ADDR+0x60000)
#define PWM2_IPS_BASE_ADDR              (AIPS2_OFF_BASE_ADDR+0x70000)
#define PWM3_IPS_BASE_ADDR              (AIPS2_OFF_BASE_ADDR+0x80000)
#define PWM4_IPS_BASE_ADDR              (AIPS2_OFF_BASE_ADDR+0x90000)
#define SYSCNT_RD_IPS_BASE_ADDR         (AIPS2_OFF_BASE_ADDR+0xA0000)
#define SYSCNT_CMP_IPS_BASE_ADDR        (AIPS2_OFF_BASE_ADDR+0xB0000)
#define SYSCNT_CTRL_IPS_BASE_ADDR       (AIPS2_OFF_BASE_ADDR+0xC0000)
#define PCIE_PHY_IPS_BASE_ADDR          (AIPS2_OFF_BASE_ADDR+0xD0000)
#define EPDC_IPS_BASE_ADDR              (AIPS2_OFF_BASE_ADDR+0xF0000)
#define EPDC_BASE_ADDR                  EPDC_IPS_BASE_ADDR
#define EPXP_IPS_BASE_ADDR              (AIPS2_OFF_BASE_ADDR+0x100000)
#define CSI1_IPS_BASE_ADDR              (AIPS2_OFF_BASE_ADDR+0x110000)
#define ELCDIF1_IPS_BASE_ADDR           (AIPS2_OFF_BASE_ADDR+0x130000)
#define MIPI_CSI2_IPS_BASE_ADDR         (AIPS2_OFF_BASE_ADDR+0x150000)
#define MIPI_DSI_IPS_BASE_ADDR          (AIPS2_OFF_BASE_ADDR+0x160000)
#define IP2APB_TZASC1_IPS_BASE_ADDR     (AIPS2_OFF_BASE_ADDR+0x180000)
#define DDRPHY_IPS_BASE_ADDR            (AIPS2_OFF_BASE_ADDR+0x190000)
#define DDRC_IPS_BASE_ADDR              (AIPS2_OFF_BASE_ADDR+0x1A0000)
#define IP2APB_PERFMON1_IPS_BASE_ADDR   (AIPS2_OFF_BASE_ADDR+0x1C0000)
#define IP2APB_PERFMON2_IPS_BASE_ADDR   (AIPS2_OFF_BASE_ADDR+0x1D0000)
#define IP2APB_AXIMON_IPS_BASE_ADDR     (AIPS2_OFF_BASE_ADDR+0x1E0000)
#define QOSC_IPS_BASE_ADDR              (AIPS2_OFF_BASE_ADDR+0x1F0000)

/* AIPS_TZ#3  - Global enable (0) */
#define ECSPI1_BASE_ADDR                (AIPS_TZ3_BASE_ADDR+0x20000)
#define ECSPI2_BASE_ADDR                (AIPS_TZ3_BASE_ADDR+0x30000)
#define ECSPI3_BASE_ADDR                (AIPS_TZ3_BASE_ADDR+0x40000)
#define UART1_IPS_BASE_ADDR             (AIPS_TZ3_BASE_ADDR+0x60000)
#define UART3_IPS_BASE_ADDR             (AIPS_TZ3_BASE_ADDR+0x80000)
#define UART2_IPS_BASE_ADDR             (AIPS_TZ3_BASE_ADDR+0x90000)
#define SAI1_IPS_BASE_ADDR              (AIPS_TZ3_BASE_ADDR+0xA0000)
#define SAI2_IPS_BASE_ADDR              (AIPS_TZ3_BASE_ADDR+0xB0000)
#define SAI3_IPS_BASE_ADDR              (AIPS_TZ3_BASE_ADDR+0xC0000)
#define SPBA_IPS_BASE_ADDR              (AIPS_TZ3_BASE_ADDR+0xF0000)
#define CAAM_IPS_BASE_ADDR              (AIPS_TZ3_BASE_ADDR+0x100000)

/* AIPS_TZ#3- On Platform */
#define AIPS3_ON_BASE_ADDR              (AIPS_TZ3_BASE_ADDR+0x1F0000)
/* AIPS_TZ#3- Off Platform */
#define AIPS3_OFF_BASE_ADDR             (AIPS_TZ3_BASE_ADDR+0x200000)
#define CAN1_IPS_BASE_ADDR              AIPS3_OFF_BASE_ADDR
#define CAN2_IPS_BASE_ADDR              (AIPS3_OFF_BASE_ADDR+0x10000)
#define I2C1_BASE_ADDR                  (AIPS3_OFF_BASE_ADDR+0x20000)
#define I2C2_BASE_ADDR                  (AIPS3_OFF_BASE_ADDR+0x30000)
#define I2C3_BASE_ADDR                  (AIPS3_OFF_BASE_ADDR+0x40000)
#define I2C4_BASE_ADDR                  (AIPS3_OFF_BASE_ADDR+0x50000)
#define UART4_IPS_BASE_ADDR             (AIPS3_OFF_BASE_ADDR+0x60000)
#define UART5_IPS_BASE_ADDR             (AIPS3_OFF_BASE_ADDR+0x70000)
#define UART6_IPS_BASE_ADDR             (AIPS3_OFF_BASE_ADDR+0x80000)
#define UART7_IPS_BASE_ADDR             (AIPS3_OFF_BASE_ADDR+0x90000)
#define MUCPU_IPS_BASE_ADDR             (AIPS3_OFF_BASE_ADDR+0xA0000)
#define MUDSP_IPS_BASE_ADDR             (AIPS3_OFF_BASE_ADDR+0xB0000)
#define HS_IPS_BASE_ADDR                (AIPS3_OFF_BASE_ADDR+0xC0000)
#define USBOH2_PL301_IPS_BASE_ADDR      (AIPS3_OFF_BASE_ADDR+0xD0000)
#define USBOTG1_IPS_BASE_ADDR		(AIPS3_OFF_BASE_ADDR+0x110000)
#define USBOTG2_IPS_BASE_ADDR		(AIPS3_OFF_BASE_ADDR+0x120000)
#define USBHSIC_IPS_BASE_ADDR		(AIPS3_OFF_BASE_ADDR+0x130000)
#define USDHC1_BASE_ADDR                (AIPS3_OFF_BASE_ADDR+0x140000)
#define USDHC2_BASE_ADDR                (AIPS3_OFF_BASE_ADDR+0x150000)
#define USDHC3_BASE_ADDR                (AIPS3_OFF_BASE_ADDR+0x160000)
#define EMVSIM1_IPS_BASE_ADDR           (AIPS3_OFF_BASE_ADDR+0x190000)
#define EMVSIM2_IPS_BASE_ADDR           (AIPS3_OFF_BASE_ADDR+0x1A0000)
#define SIM1_IPS_BASE_ADDR              (AIPS3_OFF_BASE_ADDR+0x190000)
#define SIM2_IPS_BASE_ADDR              (AIPS3_OFF_BASE_ADDR+0x1A0000)
#define QSPI1_IPS_BASE_ADDR             (AIPS3_OFF_BASE_ADDR+0x1B0000)
#define WEIM_IPS_BASE_ADDR              (AIPS3_OFF_BASE_ADDR+0x1C0000)
#define SDMA_PORT_IPS_HOST_BASE_ADDR    (AIPS3_OFF_BASE_ADDR+0x1D0000)
#define ENET_IPS_BASE_ADDR              (AIPS3_OFF_BASE_ADDR+0x1E0000)
#define ENET2_IPS_BASE_ADDR             (AIPS3_OFF_BASE_ADDR+0x1F0000)

#define AIPS1_BASE_ADDR			AIPS1_ON_BASE_ADDR
#define AIPS2_BASE_ADDR			AIPS2_ON_BASE_ADDR
#define AIPS3_BASE_ADDR			AIPS3_ON_BASE_ADDR

#define SDMA_IPS_HOST_BASE_ADDR         SDMA_PORT_IPS_HOST_BASE_ADDR
#define SDMA_IPS_HOST_IPS_BASE_ADDR     SDMA_PORT_IPS_HOST_BASE_ADDR

#define SCTR_BASE_ADDR SYSCNT_CTRL_IPS_BASE_ADDR
#define DEBUG_MONITOR_BASE_ADDR IP2APB_AXIMON_IPS_BASE_ADDR

#define USB_BASE_ADDR USBOTG1_IPS_BASE_ADDR
#define SEMAPHORE1_BASE_ADDR SEMA41_IPS_BASE_ADDR
#define SEMAPHORE2_BASE_ADDR SEMA42_IPS_BASE_ADDR
#define RDC_BASE_ADDR RDC_IPS_BASE_ADDR

#define FEC_QUIRK_ENET_MAC
#define SNVS_LPGPR	0x68
#define CONFIG_SYS_FSL_SEC_OFFSET       0
#define CONFIG_SYS_FSL_SEC_ADDR         (CAAM_IPS_BASE_ADDR + \
					 CONFIG_SYS_FSL_SEC_OFFSET)
#define CONFIG_SYS_FSL_JR0_OFFSET       0x1000
#define CONFIG_SYS_FSL_JR0_ADDR         (CONFIG_SYS_FSL_SEC_ADDR + \
					 CONFIG_SYS_FSL_JR0_OFFSET)
#if !(defined(__KERNEL_STRICT_NAMES) || defined(__ASSEMBLY__))
#include <asm/mach-imx/regs-lcdif.h>
#include <asm/types.h>
#include <linux/bitops.h>

extern void imx_get_mac_from_fuse(int dev_id, unsigned char *mac);

/* System Reset Controller (SRC) */
struct src {
	u32	scr;
	u32 a7rcr0;
	u32 a7rcr1;
	u32 m4rcr;
	u32 reserved1;
	u32 ercr;
	u32 reserved2;
	u32 hsicphy_rcr;
	u32 usbophy1_rcr;
	u32 usbophy2_rcr;
	u32 mipiphy_rcr;
	u32 pciephy_rcr;
	u32 reserved3[10];
	u32	sbmr1;
	u32	srsr;
	u32	reserved4[2];
	u32	sisr;
	u32	simr;
	u32 sbmr2;
	u32 gpr1;
	u32 gpr2;
	u32 gpr3;
	u32 gpr4;
	u32 gpr5;
	u32 gpr6;
	u32 gpr7;
	u32 gpr8;
	u32 gpr9;
	u32 gpr10;
	u32 reserved5[985];
	u32 ddrc_rcr;
};

#define src_base ((struct src *)SRC_BASE_ADDR)

#define SRC_M4_REG_OFFSET		0xC
#define SRC_M4C_NON_SCLR_RST_OFFSET	0
#define SRC_M4C_NON_SCLR_RST_MASK	BIT(0)
#define SRC_M4_ENABLE_OFFSET		3
#define SRC_M4_ENABLE_MASK		BIT(3)

#define SRC_DDRC_RCR_DDRC_CORE_RST_OFFSET	1
#define SRC_DDRC_RCR_DDRC_CORE_RST_MASK		(1 << 1)
#define SRC_DDRC_RCR_DDRC_PRST_MASK		(1 << 0)

/* GPR0 Bit Fields */
#define IOMUXC_GPR_GPR0_DMAREQ_MUX_SEL0_MASK     0x1u
#define IOMUXC_GPR_GPR0_DMAREQ_MUX_SEL0_SHIFT    0
#define IOMUXC_GPR_GPR0_DMAREQ_MUX_SEL1_MASK     0x2u
#define IOMUXC_GPR_GPR0_DMAREQ_MUX_SEL1_SHIFT    1
#define IOMUXC_GPR_GPR0_DMAREQ_MUX_SEL2_MASK     0x4u
#define IOMUXC_GPR_GPR0_DMAREQ_MUX_SEL2_SHIFT    2
#define IOMUXC_GPR_GPR0_DMAREQ_MUX_SEL3_MASK     0x8u
#define IOMUXC_GPR_GPR0_DMAREQ_MUX_SEL3_SHIFT    3
#define IOMUXC_GPR_GPR0_DMAREQ_MUX_SEL4_MASK     0x10u
#define IOMUXC_GPR_GPR0_DMAREQ_MUX_SEL4_SHIFT    4
#define IOMUXC_GPR_GPR0_DMAREQ_MUX_SEL5_MASK     0x20u
#define IOMUXC_GPR_GPR0_DMAREQ_MUX_SEL5_SHIFT    5
#define IOMUXC_GPR_GPR0_DMAREQ_MUX_SEL6_MASK     0x40u
#define IOMUXC_GPR_GPR0_DMAREQ_MUX_SEL6_SHIFT    6
#define IOMUXC_GPR_GPR0_ENET_MDIO_OPEN_DRAIN_MASK (3 << 7)
#define IOMUXC_GPR_GPR0_ENET_MDIO_OPEN_DRAIN_SHIFT 7
/* GPR1 Bit Fields */
#define IOMUXC_GPR_GPR1_GPR_WEIM_ACT_CS0_MASK    0x1u
#define IOMUXC_GPR_GPR1_GPR_WEIM_ACT_CS0_SHIFT   0
#define IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS0_MASK     0x6u
#define IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS0_SHIFT    1
#define IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS0(x)       (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS0_SHIFT))&IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS0_MASK)
#define IOMUXC_GPR_GPR1_GPR_WEIM_ACT_CS1_MASK    0x8u
#define IOMUXC_GPR_GPR1_GPR_WEIM_ACT_CS1_SHIFT   3
#define IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS1_MASK     0x30u
#define IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS1_SHIFT    4
#define IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS1(x)       (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS1_SHIFT))&IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS1_MASK)
#define IOMUXC_GPR_GPR1_GPR_WEIM_ACT_CS2_MASK    0x40u
#define IOMUXC_GPR_GPR1_GPR_WEIM_ACT_CS2_SHIFT   6
#define IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS2_MASK     0x180u
#define IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS2_SHIFT    7
#define IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS2(x)       (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS2_SHIFT))&IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS2_MASK)
#define IOMUXC_GPR_GPR1_GPR_WEIM_ACT_CS3_MASK    0x200u
#define IOMUXC_GPR_GPR1_GPR_WEIM_ACT_CS3_SHIFT   9
#define IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS3_MASK     0xC00u
#define IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS3_SHIFT    10
#define IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS3(x)       (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS3_SHIFT))&IOMUXC_GPR_GPR1_GPR_WEIM_ADDRS3_MASK)
#define IOMUXC_GPR_GPR1_GPR_IRQ_MASK             0x1000u
#define IOMUXC_GPR_GPR1_GPR_IRQ_SHIFT            12
#define IOMUXC_GPR_GPR1_GPR_ENET1_TX_CLK_SEL_MASK 0x2000u
#define IOMUXC_GPR_GPR1_GPR_ENET1_TX_CLK_SEL_SHIFT 13
#define IOMUXC_GPR_GPR1_GPR_ENET2_TX_CLK_SEL_MASK 0x4000u
#define IOMUXC_GPR_GPR1_GPR_ENET2_TX_CLK_SEL_SHIFT 14
#define IOMUXC_GPR_GPR1_GPR_ANATOP_TESTMODE_MASK 0x8000u
#define IOMUXC_GPR_GPR1_GPR_ANATOP_TESTMODE_SHIFT 15
#define IOMUXC_GPR_GPR1_GPR_PAD_ADD_DS_MASK      0x10000u
#define IOMUXC_GPR_GPR1_GPR_PAD_ADD_DS_SHIFT     16
#define IOMUXC_GPR_GPR1_GPR_ENET1_CLK_DIR_MASK   0x20000u
#define IOMUXC_GPR_GPR1_GPR_ENET1_CLK_DIR_SHIFT  17
#define IOMUXC_GPR_GPR1_GPR_ENET2_CLK_DIR_MASK   0x40000u
#define IOMUXC_GPR_GPR1_GPR_ENET2_CLK_DIR_SHIFT  18
#define IOMUXC_GPR_GPR1_GPR_EXC_ERR_RESP_EN_MASK 0x400000u
#define IOMUXC_GPR_GPR1_GPR_EXC_ERR_RESP_EN_SHIFT 22
#define IOMUXC_GPR_GPR1_GPR_TZASC1_SECURE_BOOT_LOCK_MASK 0x800000u
#define IOMUXC_GPR_GPR1_GPR_TZASC1_SECURE_BOOT_LOCK_SHIFT 23
#define IOMUXC_GPR_GPR1_GPR_DBG_ACK_MASK         0x30000000u
#define IOMUXC_GPR_GPR1_GPR_DBG_ACK_SHIFT        28
#define IOMUXC_GPR_GPR1_GPR_DBG_ACK(x)           (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR1_GPR_DBG_ACK_SHIFT))&IOMUXC_GPR_GPR1_GPR_DBG_ACK_MASK)
#define IOMUXC_GPR_GPR1_GPR_ENABLE_OCRAM_EPDC_MASK 0x40000000u
#define IOMUXC_GPR_GPR1_GPR_ENABLE_OCRAM_EPDC_SHIFT 30
/* GPR2 Bit Fields */
#define IOMUXC_GPR_GPR2_GPR_MEM_PXP_LOWPOWER_MASK 0x1u
#define IOMUXC_GPR_GPR2_GPR_MEM_PXP_LOWPOWER_SHIFT 0
#define IOMUXC_GPR_GPR2_GPR_MEM_PXP_SD_MASK      0x2u
#define IOMUXC_GPR_GPR2_GPR_MEM_PXP_SD_SHIFT     1
#define IOMUXC_GPR_GPR2_GPR_MEM_PXP_DS_MASK      0x4u
#define IOMUXC_GPR_GPR2_GPR_MEM_PXP_DS_SHIFT     2
#define IOMUXC_GPR_GPR2_GPR_MEM_PXP_LS_MASK      0x8u
#define IOMUXC_GPR_GPR2_GPR_MEM_PXP_LS_SHIFT     3
#define IOMUXC_GPR_GPR2_GPR_MEM_LCDIF_LOWPOWER_MASK 0x10u
#define IOMUXC_GPR_GPR2_GPR_MEM_LCDIF_LOWPOWER_SHIFT 4
#define IOMUXC_GPR_GPR2_GPR_MEM_LCDIF_SD_MASK    0x20u
#define IOMUXC_GPR_GPR2_GPR_MEM_LCDIF_SD_SHIFT   5
#define IOMUXC_GPR_GPR2_GPR_MEM_LCDIF_DS_MASK    0x40u
#define IOMUXC_GPR_GPR2_GPR_MEM_LCDIF_DS_SHIFT   6
#define IOMUXC_GPR_GPR2_GPR_MEM_LCDIF_LS_MASK    0x80u
#define IOMUXC_GPR_GPR2_GPR_MEM_LCDIF_LS_SHIFT   7
#define IOMUXC_GPR_GPR2_GPR_MEM_EPDC_LOWPOWER_MASK 0x100u
#define IOMUXC_GPR_GPR2_GPR_MEM_EPDC_LOWPOWER_SHIFT 8
#define IOMUXC_GPR_GPR2_GPR_MEM_EPDC_SD_MASK     0x200u
#define IOMUXC_GPR_GPR2_GPR_MEM_EPDC_SD_SHIFT    9
#define IOMUXC_GPR_GPR2_GPR_MEM_EPDC_DS_MASK     0x400u
#define IOMUXC_GPR_GPR2_GPR_MEM_EPDC_DS_SHIFT    10
#define IOMUXC_GPR_GPR2_GPR_MEM_EPDC_LS_MASK     0x800u
#define IOMUXC_GPR_GPR2_GPR_MEM_EPDC_LS_SHIFT    11
#define IOMUXC_GPR_GPR2_GPR_MEM_CPU_LOWPOWER_MASK 0x1000u
#define IOMUXC_GPR_GPR2_GPR_MEM_CPU_LOWPOWER_SHIFT 12
#define IOMUXC_GPR_GPR2_GPR_MEM_CPU_SD_MASK      0x2000u
#define IOMUXC_GPR_GPR2_GPR_MEM_CPU_SD_SHIFT     13
#define IOMUXC_GPR_GPR2_GPR_MEM_CPU_DS_MASK      0x4000u
#define IOMUXC_GPR_GPR2_GPR_MEM_CPU_DS_SHIFT     14
#define IOMUXC_GPR_GPR2_GPR_MEM_CPU_LS_MASK      0x8000u
#define IOMUXC_GPR_GPR2_GPR_MEM_CPU_LS_SHIFT     15
#define IOMUXC_GPR_GPR2_GPR_MQS_CLK_DIV_MASK     0xFF0000u
#define IOMUXC_GPR_GPR2_GPR_MQS_CLK_DIV_SHIFT    16
#define IOMUXC_GPR_GPR2_GPR_MQS_CLK_DIV(x)       (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR2_GPR_MQS_CLK_DIV_SHIFT))&IOMUXC_GPR_GPR2_GPR_MQS_CLK_DIV_MASK)
#define IOMUXC_GPR_GPR2_GPR_MQS_SW_RST_MASK      0x1000000u
#define IOMUXC_GPR_GPR2_GPR_MQS_SW_RST_SHIFT     24
#define IOMUXC_GPR_GPR2_GPR_MQS_EN_MASK          0x2000000u
#define IOMUXC_GPR_GPR2_GPR_MQS_EN_SHIFT         25
#define IOMUXC_GPR_GPR2_GPR_MQS_OVERSAMPLE_MASK  0x4000000u
#define IOMUXC_GPR_GPR2_GPR_MQS_OVERSAMPLE_SHIFT 26
#define IOMUXC_GPR_GPR2_GPR_DRAM_RESET_BYPASS_MASK 0x8000000u
#define IOMUXC_GPR_GPR2_GPR_DRAM_RESET_BYPASS_SHIFT 27
#define IOMUXC_GPR_GPR2_GPR_DRAM_RESET_MASK      0x10000000u
#define IOMUXC_GPR_GPR2_GPR_DRAM_RESET_SHIFT     28
#define IOMUXC_GPR_GPR2_GPR_DRAM_CKE0_MASK       0x20000000u
#define IOMUXC_GPR_GPR2_GPR_DRAM_CKE0_SHIFT      29
#define IOMUXC_GPR_GPR2_GPR_DRAM_CKE1_MASK       0x40000000u
#define IOMUXC_GPR_GPR2_GPR_DRAM_CKE1_SHIFT      30
#define IOMUXC_GPR_GPR2_GPR_DRAM_CKE_BYPASS_MASK 0x80000000u
#define IOMUXC_GPR_GPR2_GPR_DRAM_CKE_BYPASS_SHIFT 31
/* GPR3 Bit Fields */
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_READ_DATA_WAIT_EN_MASK 0x1u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_READ_DATA_WAIT_EN_SHIFT 0
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_READ_ADDR_PIPELINE_EN_MASK 0x2u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_READ_ADDR_PIPELINE_EN_SHIFT 1
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_WRITE_DATA_PIPELINE_EN_MASK 0x4u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_WRITE_DATA_PIPELINE_EN_SHIFT 2
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_WRITE_ADDR_PIPELINE_EN_MASK 0x8u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_WRITE_ADDR_PIPELINE_EN_SHIFT 3
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_S_READ_DATA_WAIT_EN_MASK 0x10u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_S_READ_DATA_WAIT_EN_SHIFT 4
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_S_READ_ADDR_PIPELINE_EN_MASK 0x20u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_S_READ_ADDR_PIPELINE_EN_SHIFT 5
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_S_WRITE_DATA_PIPELINE_EN_MASK 0x40u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_S_WRITE_DATA_PIPELINE_EN_SHIFT 6
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_S_WRITE_ADDR_PIPELINE_EN_MASK 0x80u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_S_WRITE_ADDR_PIPELINE_EN_SHIFT 7
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_EPDC_READ_DATA_WAIT_EN_MASK 0x100u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_EPDC_READ_DATA_WAIT_EN_SHIFT 8
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_EPDC_READ_ADDR_PIPELINE_EN_MASK 0x200u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_EPDC_READ_ADDR_PIPELINE_EN_SHIFT 9
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_EPDC_WRITE_DATA_PIPELINE_EN_MASK 0x400u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_EPDC_WRITE_DATA_PIPELINE_EN_SHIFT 10
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_EPDC_WRITE_ADDR_PIPELINE_EN_MASK 0x800u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_EPDC_WRITE_ADDR_PIPELINE_EN_SHIFT 11
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_PXP_READ_DATA_WAIT_EN_MASK 0x1000u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_PXP_READ_DATA_WAIT_EN_SHIFT 12
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_PXP_READ_ADDR_PIPELINE_EN_MASK 0x2000u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_PXP_READ_ADDR_PIPELINE_EN_SHIFT 13
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_PXP_WRITE_DATA_PIPELINE_EN_MASK 0x4000u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_PXP_WRITE_DATA_PIPELINE_EN_SHIFT 14
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_PXP_WRITE_ADDR_PIPELINE_EN_MASK 0x8000u
#define IOMUXC_GPR_GPR3_GPR_OCRAM_CTRL_PXP_WRITE_ADDR_PIPELINE_EN_SHIFT 15
#define IOMUXC_GPR_GPR3_ocram_ctrl_read_data_wait_en_update_pending_MASK 0x10000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_read_data_wait_en_update_pending_SHIFT 16
#define IOMUXC_GPR_GPR3_ocram_ctrl_read_addr_pipeline_en_update_pending_MASK 0x20000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_read_addr_pipeline_en_update_pending_SHIFT 17
#define IOMUXC_GPR_GPR3_ocram_ctrl_write_data_pipeline_en_update_pending_MASK 0x40000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_write_data_pipeline_en_update_pending_SHIFT 18
#define IOMUXC_GPR_GPR3_ocram_ctrl_write_addr_pipeline_en_update_pending_MASK 0x80000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_write_addr_pipeline_en_update_pending_SHIFT 19
#define IOMUXC_GPR_GPR3_ocram_ctrl_s_read_data_wait_en_update_pending_MASK 0x100000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_s_read_data_wait_en_update_pending_SHIFT 20
#define IOMUXC_GPR_GPR3_ocram_ctrl_s_read_addr_pipeline_en_update_pending_MASK 0x200000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_s_read_addr_pipeline_en_update_pending_SHIFT 21
#define IOMUXC_GPR_GPR3_ocram_ctrl_s_write_data_pipeline_en_update_pending_MASK 0x400000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_s_write_data_pipeline_en_update_pending_SHIFT 22
#define IOMUXC_GPR_GPR3_ocram_ctrl_s_write_addr_pipeline_en_update_pending_MASK 0x800000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_s_write_addr_pipeline_en_update_pending_SHIFT 23
#define IOMUXC_GPR_GPR3_ocram_ctrl_epdc_read_data_wait_en_update_pending_MASK 0x1000000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_epdc_read_data_wait_en_update_pending_SHIFT 24
#define IOMUXC_GPR_GPR3_ocram_ctrl_epdc_read_addr_pipeline_en_update_pending_MASK 0x2000000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_epdc_read_addr_pipeline_en_update_pending_SHIFT 25
#define IOMUXC_GPR_GPR3_ocram_ctrl_epdc_write_data_pipeline_en_update_pending_MASK 0x4000000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_epdc_write_data_pipeline_en_update_pending_SHIFT 26
#define IOMUXC_GPR_GPR3_ocram_ctrl_epdc_write_addr_pipeline_en_update_pending_MASK 0x8000000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_epdc_write_addr_pipeline_en_update_pending_SHIFT 27
#define IOMUXC_GPR_GPR3_ocram_ctrl_pxp_read_data_wait_en_update_pending_MASK 0x10000000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_pxp_read_data_wait_en_update_pending_SHIFT 28
#define IOMUXC_GPR_GPR3_ocram_ctrl_pxp_read_addr_pipeline_en_update_pending_MASK 0x20000000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_pxp_read_addr_pipeline_en_update_pending_SHIFT 29
#define IOMUXC_GPR_GPR3_ocram_ctrl_pxp_write_data_pipeline_en_update_pending_MASK 0x40000000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_pxp_write_data_pipeline_en_update_pending_SHIFT 30
#define IOMUXC_GPR_GPR3_ocram_ctrl_pxp_write_addr_pipeline_en_update_pending_MASK 0x80000000u
#define IOMUXC_GPR_GPR3_ocram_ctrl_pxp_write_addr_pipeline_en_update_pending_SHIFT 31
/* GPR4 Bit Fields */
#define IOMUXC_GPR_GPR4_GPR_SDMA_IPG_STOP_MASK   0x1u
#define IOMUXC_GPR_GPR4_GPR_SDMA_IPG_STOP_SHIFT  0
#define IOMUXC_GPR_GPR4_GPR_CAN1_IPG_STOP_MASK   0x2u
#define IOMUXC_GPR_GPR4_GPR_CAN1_IPG_STOP_SHIFT  1
#define IOMUXC_GPR_GPR4_GPR_CAN2_IPG_STOP_MASK   0x4u
#define IOMUXC_GPR_GPR4_GPR_CAN2_IPG_STOP_SHIFT  2
#define IOMUXC_GPR_GPR4_GPR_ENET1_IPG_STOP_MASK  0x8u
#define IOMUXC_GPR_GPR4_GPR_ENET1_IPG_STOP_SHIFT 3
#define IOMUXC_GPR_GPR4_GPR_ENET2_IPG_STOP_MASK  0x10u
#define IOMUXC_GPR_GPR4_GPR_ENET2_IPG_STOP_SHIFT 4
#define IOMUXC_GPR_GPR4_GPR_SAI1_IPG_STOP_MASK   0x20u
#define IOMUXC_GPR_GPR4_GPR_SAI1_IPG_STOP_SHIFT  5
#define IOMUXC_GPR_GPR4_GPR_SAI2_IPG_STOP_MASK   0x40u
#define IOMUXC_GPR_GPR4_GPR_SAI2_IPG_STOP_SHIFT  6
#define IOMUXC_GPR_GPR4_GPR_SAI3_IPG_STOP_MASK   0x80u
#define IOMUXC_GPR_GPR4_GPR_SAI3_IPG_STOP_SHIFT  7
#define IOMUXC_GPR_GPR4_sdma_ipg_stop_ack_MASK   0x10000u
#define IOMUXC_GPR_GPR4_sdma_ipg_stop_ack_SHIFT  16
#define IOMUXC_GPR_GPR4_can1_ipg_stop_ack_MASK   0x20000u
#define IOMUXC_GPR_GPR4_can1_ipg_stop_ack_SHIFT  17
#define IOMUXC_GPR_GPR4_can2_ipg_stop_ack_MASK   0x40000u
#define IOMUXC_GPR_GPR4_can2_ipg_stop_ack_SHIFT  18
#define IOMUXC_GPR_GPR4_enet1_ipg_stop_ack_MASK  0x80000u
#define IOMUXC_GPR_GPR4_enet1_ipg_stop_ack_SHIFT 19
#define IOMUXC_GPR_GPR4_enet2_ipg_stop_ack_MASK  0x100000u
#define IOMUXC_GPR_GPR4_enet2_ipg_stop_ack_SHIFT 20
#define IOMUXC_GPR_GPR4_sai1_ipg_stop_ack_MASK   0x200000u
#define IOMUXC_GPR_GPR4_sai1_ipg_stop_ack_SHIFT  21
#define IOMUXC_GPR_GPR4_sai2_ipg_stop_ack_MASK   0x400000u
#define IOMUXC_GPR_GPR4_sai2_ipg_stop_ack_SHIFT  22
#define IOMUXC_GPR_GPR4_sai3_ipg_stop_ack_MASK   0x800000u
#define IOMUXC_GPR_GPR4_sai3_ipg_stop_ack_SHIFT  23
#define IOMUXC_GPR_GPR4_cpu_STANDBYWFI_MASK      0x6000000u
#define IOMUXC_GPR_GPR4_cpu_STANDBYWFI_SHIFT     25
#define IOMUXC_GPR_GPR4_cpu_STANDBYWFI(x)        (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR4_cpu_STANDBYWFI_SHIFT))&IOMUXC_GPR_GPR4_cpu_STANDBYWFI_MASK)
#define IOMUXC_GPR_GPR4_cpu_STANDBYWFE_MASK      0x18000000u
#define IOMUXC_GPR_GPR4_cpu_STANDBYWFE_SHIFT     27
#define IOMUXC_GPR_GPR4_cpu_STANDBYWFE(x)        (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR4_cpu_STANDBYWFE_SHIFT))&IOMUXC_GPR_GPR4_cpu_STANDBYWFE_MASK)
/* GPR5 Bit Fields */
#define IOMUXC_GPR_GPR5_GPR_CSI_MUX_CONTROL_MASK 0x10u
#define IOMUXC_GPR_GPR5_GPR_CSI_MUX_CONTROL_SHIFT 4
#define IOMUXC_GPR_GPR5_GPR_LVDS_MUX_CONTROL_MASK 0x20u
#define IOMUXC_GPR_GPR5_GPR_LVDS_MUX_CONTROL_SHIFT 5
#define IOMUXC_GPR_GPR5_GPR_WDOG1_MASK_MASK      0x40u
#define IOMUXC_GPR_GPR5_GPR_WDOG1_MASK_SHIFT     6
#define IOMUXC_GPR_GPR5_GPR_WDOG2_MASK_MASK      0x80u
#define IOMUXC_GPR_GPR5_GPR_WDOG2_MASK_SHIFT     7
#define IOMUXC_GPR_GPR5_GPR_LCDIF_HANDSHAKE_MASK 0x1000u
#define IOMUXC_GPR_GPR5_GPR_LCDIF_HANDSHAKE_SHIFT 12
#define IOMUXC_GPR_GPR5_GPR_PCIE_BTNRST_MASK     0x80000u
#define IOMUXC_GPR_GPR5_GPR_PCIE_BTNRST_SHIFT    19
#define IOMUXC_GPR_GPR5_GPR_WDOG3_MASK_MASK      0x100000u
#define IOMUXC_GPR_GPR5_GPR_WDOG3_MASK_SHIFT     20
#define IOMUXC_GPR_GPR5_GPR_LCDIF_CSI_VSYNC_SEL_MASK 0x200000u
#define IOMUXC_GPR_GPR5_GPR_LCDIF_CSI_VSYNC_SEL_SHIFT 21
#define IOMUXC_GPR_GPR5_GPR_WDOG4_MASK_MASK      0x400000u
#define IOMUXC_GPR_GPR5_GPR_WDOG4_MASK_SHIFT     22
#define IOMUXC_GPR_GPR5_GPR_GPT4_CAPIN1_SEL_MASK 0x1000000u
#define IOMUXC_GPR_GPR5_GPR_GPT4_CAPIN1_SEL_SHIFT 24
#define IOMUXC_GPR_GPR5_GPR_GPT4_CAPIN2_SEL_MASK 0x2000000u
#define IOMUXC_GPR_GPR5_GPR_GPT4_CAPIN2_SEL_SHIFT 25
#define IOMUXC_GPR_GPR5_GPR_ENET1_EVENT3IN_SEL_MASK 0x4000000u
#define IOMUXC_GPR_GPR5_GPR_ENET1_EVENT3IN_SEL_SHIFT 26
#define IOMUXC_GPR_GPR5_GPR_ENET2_EVENT3IN_SEL_MASK 0x8000000u
#define IOMUXC_GPR_GPR5_GPR_ENET2_EVENT3IN_SEL_SHIFT 27
#define IOMUXC_GPR_GPR5_GPR_REF_1M_CLK_GPT1_MASK 0x10000000u
#define IOMUXC_GPR_GPR5_GPR_REF_1M_CLK_GPT1_SHIFT 28
#define IOMUXC_GPR_GPR5_GPR_REF_1M_CLK_GPT2_MASK 0x20000000u
#define IOMUXC_GPR_GPR5_GPR_REF_1M_CLK_GPT2_SHIFT 29
#define IOMUXC_GPR_GPR5_GPR_REF_1M_CLK_GPT3_MASK 0x40000000u
#define IOMUXC_GPR_GPR5_GPR_REF_1M_CLK_GPT3_SHIFT 30
#define IOMUXC_GPR_GPR5_GPR_REF_1M_CLK_GPT4_MASK 0x80000000u
#define IOMUXC_GPR_GPR5_GPR_REF_1M_CLK_GPT4_SHIFT 31
/* GPR6 Bit Fields */
#define IOMUXC_GPR_GPR6_GPR_ARCACHE_PXP6_MASK    0x1u
#define IOMUXC_GPR_GPR6_GPR_ARCACHE_PXP6_SHIFT   0
#define IOMUXC_GPR_GPR6_GPR_AWCACHE_PXP6_MASK    0x2u
#define IOMUXC_GPR_GPR6_GPR_AWCACHE_PXP6_SHIFT   1
#define IOMUXC_GPR_GPR6_GPR_ARCACHE_PXP6_EN_MASK 0x4u
#define IOMUXC_GPR_GPR6_GPR_ARCACHE_PXP6_EN_SHIFT 2
#define IOMUXC_GPR_GPR6_GPR_AWCACHE_PXP6_EN_MASK 0x8u
#define IOMUXC_GPR_GPR6_GPR_AWCACHE_PXP6_EN_SHIFT 3
/* GPR7 Bit Fields */
#define IOMUXC_GPR_GPR7_GPR_chd1_pwd_ldo_usb_1p0_MASK 0x1u
#define IOMUXC_GPR_GPR7_GPR_chd1_pwd_ldo_usb_1p0_SHIFT 0
#define IOMUXC_GPR_GPR7_GPR_chd1_lowpwr_ldo_usb_1p0_MASK 0x2u
#define IOMUXC_GPR_GPR7_GPR_chd1_lowpwr_ldo_usb_1p0_SHIFT 1
#define IOMUXC_GPR_GPR7_GPR_chd1_en_ilimit_ldo_usb_1p0_MASK 0x4u
#define IOMUXC_GPR_GPR7_GPR_chd1_en_ilimit_ldo_usb_1p0_SHIFT 2
#define IOMUXC_GPR_GPR7_GPR_chd1_en_pwrupload_ldo_usb_1p0_MASK 0x8u
#define IOMUXC_GPR_GPR7_GPR_chd1_en_pwrupload_ldo_usb_1p0_SHIFT 3
#define IOMUXC_GPR_GPR7_GPR_chd1_chrg_det_test_MASK 0x30u
#define IOMUXC_GPR_GPR7_GPR_chd1_chrg_det_test_SHIFT 4
#define IOMUXC_GPR_GPR7_GPR_chd1_chrg_det_test(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR7_GPR_chd1_chrg_det_test_SHIFT))&IOMUXC_GPR_GPR7_GPR_chd1_chrg_det_test_MASK)
#define IOMUXC_GPR_GPR7_GPR_chd2_pwd_ldo_usb_1p0_MASK 0x40u
#define IOMUXC_GPR_GPR7_GPR_chd2_pwd_ldo_usb_1p0_SHIFT 6
#define IOMUXC_GPR_GPR7_GPR_chd2_lowpwr_ldo_usb_1p0_MASK 0x80u
#define IOMUXC_GPR_GPR7_GPR_chd2_lowpwr_ldo_usb_1p0_SHIFT 7
#define IOMUXC_GPR_GPR7_GPR_chd2_en_ilimit_ldo_usb_1p0_MASK 0x100u
#define IOMUXC_GPR_GPR7_GPR_chd2_en_ilimit_ldo_usb_1p0_SHIFT 8
#define IOMUXC_GPR_GPR7_GPR_chd2_en_pwrupload_ldo_usb_1p0_MASK 0x200u
#define IOMUXC_GPR_GPR7_GPR_chd2_en_pwrupload_ldo_usb_1p0_SHIFT 9
#define IOMUXC_GPR_GPR7_GPR_chd2_chrg_det_test_MASK 0xC00u
#define IOMUXC_GPR_GPR7_GPR_chd2_chrg_det_test_SHIFT 10
#define IOMUXC_GPR_GPR7_GPR_chd2_chrg_det_test(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR7_GPR_chd2_chrg_det_test_SHIFT))&IOMUXC_GPR_GPR7_GPR_chd2_chrg_det_test_MASK)
#define IOMUXC_GPR_GPR7_GPR_pcie_clk_rst_fix_lnkrst_disable_MASK 0x1000u
#define IOMUXC_GPR_GPR7_GPR_pcie_clk_rst_fix_lnkrst_disable_SHIFT 12
#define IOMUXC_GPR_GPR7_GPR_pcie_clk_rst_fix_perst_disable_MASK 0x2000u
#define IOMUXC_GPR_GPR7_GPR_pcie_clk_rst_fix_perst_disable_SHIFT 13
/* GPR8 Bit Fields */
#define IOMUXC_GPR_GPR8_ddr_phy_ctrl_wake_up_MASK 0xF8u
#define IOMUXC_GPR_GPR8_ddr_phy_ctrl_wake_up_SHIFT 3
#define IOMUXC_GPR_GPR8_ddr_phy_ctrl_wake_up(x)  (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR8_ddr_phy_ctrl_wake_up_SHIFT))&IOMUXC_GPR_GPR8_ddr_phy_ctrl_wake_up_MASK)
#define IOMUXC_GPR_GPR8_ddr_phy_dfi_init_start_MASK 0x100u
#define IOMUXC_GPR_GPR8_ddr_phy_dfi_init_start_SHIFT 8
/* GPR9 Bit Fields */
#define IOMUXC_GPR_GPR9_GPR_TZASC1_MUX_CONTROL_MASK 0x1u
#define IOMUXC_GPR_GPR9_GPR_TZASC1_MUX_CONTROL_SHIFT 0
#define IOMUXC_GPR_GPR9_ddr_phy_ctrl_pd_MASK     0x3Eu
#define IOMUXC_GPR_GPR9_ddr_phy_ctrl_pd_SHIFT    1
#define IOMUXC_GPR_GPR9_ddr_phy_ctrl_pd(x)       (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR9_ddr_phy_ctrl_pd_SHIFT))&IOMUXC_GPR_GPR9_ddr_phy_ctrl_pd_MASK)
/* GPR10 Bit Fields */
#define IOMUXC_GPR_GPR10_GPR0_BF0_MASK           0x1u
#define IOMUXC_GPR_GPR10_GPR0_BF0_SHIFT          0
#define IOMUXC_GPR_GPR10_GPR_DBG_EN_MASK         0x2u
#define IOMUXC_GPR_GPR10_GPR_DBG_EN_SHIFT        1
#define IOMUXC_GPR_GPR10_GPR_SEC_ERR_RESP_EN_MASK 0x4u
#define IOMUXC_GPR_GPR10_GPR_SEC_ERR_RESP_EN_SHIFT 2
#define IOMUXC_GPR_GPR10_GPR_OCRAM_CTRL_EPDC_OCRAM_TZ_SECURE_REGION0_MASK 0x8u
#define IOMUXC_GPR_GPR10_GPR_OCRAM_CTRL_EPDC_OCRAM_TZ_SECURE_REGION0_SHIFT 3
#define IOMUXC_GPR_GPR10_GPR_OCRAM_CTRL_EPDC_OCRAM_TZ_SECURE_REGION1_MASK 0x3F0u
#define IOMUXC_GPR_GPR10_GPR_OCRAM_CTRL_EPDC_OCRAM_TZ_SECURE_REGION1_SHIFT 4
#define IOMUXC_GPR_GPR10_GPR_OCRAM_CTRL_EPDC_OCRAM_TZ_SECURE_REGION1(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR10_GPR_OCRAM_CTRL_EPDC_OCRAM_TZ_SECURE_REGION1_SHIFT))&IOMUXC_GPR_GPR10_GPR_OCRAM_CTRL_EPDC_OCRAM_TZ_SECURE_REGION1_MASK)
/* GPR11 Bit Fields */
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_OCRAM_TZ_SECURE_REGION0_MASK 0x1u
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_OCRAM_TZ_SECURE_REGION0_SHIFT 0
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_OCRAM_TZ_SECURE_REGION1_MASK 0x3Eu
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_OCRAM_TZ_SECURE_REGION1_SHIFT 1
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_OCRAM_TZ_SECURE_REGION1(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_OCRAM_TZ_SECURE_REGION1_SHIFT))&IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_OCRAM_TZ_SECURE_REGION1_MASK)
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_PXP_OCRAM_TZ_SECURE_REGION0_MASK 0x40u
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_PXP_OCRAM_TZ_SECURE_REGION0_SHIFT 6
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_PXP_OCRAM_TZ_SECURE_REGION1_MASK 0x380u
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_PXP_OCRAM_TZ_SECURE_REGION1_SHIFT 7
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_PXP_OCRAM_TZ_SECURE_REGION1(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_PXP_OCRAM_TZ_SECURE_REGION1_SHIFT))&IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_PXP_OCRAM_TZ_SECURE_REGION1_MASK)
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_S_OCRAM_TZ_SECURE_REGION0_MASK 0x400u
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_S_OCRAM_TZ_SECURE_REGION0_SHIFT 10
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_S_OCRAM_TZ_SECURE_REGION1_MASK 0x3800u
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_S_OCRAM_TZ_SECURE_REGION1_SHIFT 11
#define IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_S_OCRAM_TZ_SECURE_REGION1(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_S_OCRAM_TZ_SECURE_REGION1_SHIFT))&IOMUXC_GPR_GPR11_GPR_OCRAM_CTRL_S_OCRAM_TZ_SECURE_REGION1_MASK)
/* GPR12 Bit Fields */
#define IOMUXC_GPR_GPR12_GPR_PCIE_PHY_TRSV_REG_RST_CH0_MASK 0x1u
#define IOMUXC_GPR_GPR12_GPR_PCIE_PHY_TRSV_REG_RST_CH0_SHIFT 0
#define IOMUXC_GPR_GPR12_GPR_PCIE_PHY_TRSV_RST_CH0_MASK 0x2u
#define IOMUXC_GPR_GPR12_GPR_PCIE_PHY_TRSV_RST_CH0_SHIFT 1
#define IOMUXC_GPR_GPR12_GPR_PCIE_PHY_SSC_EN_MASK 0x8u
#define IOMUXC_GPR_GPR12_GPR_PCIE_PHY_SSC_EN_SHIFT 3
#define IOMUXC_GPR_GPR12_GPR_PCIE_PHY_CMN_REG_RST_MASK 0x10u
#define IOMUXC_GPR_GPR12_GPR_PCIE_PHY_CMN_REG_RST_SHIFT 4
#define IOMUXC_GPR_GPR12_GPR_PCIE_PHY_REFCLK_SEL_MASK 0x20u
#define IOMUXC_GPR_GPR12_GPR_PCIE_PHY_REFCLK_SEL_SHIFT 5
#define IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DEVICE_TYPE_MASK 0xF000u
#define IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DEVICE_TYPE_SHIFT 12
#define IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DEVICE_TYPE(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DEVICE_TYPE_SHIFT))&IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DEVICE_TYPE_MASK)
#define IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DIAG_STATUS_BUS_SELECT_MASK 0x1E0000u
#define IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DIAG_STATUS_BUS_SELECT_SHIFT 17
#define IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DIAG_STATUS_BUS_SELECT(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DIAG_STATUS_BUS_SELECT_SHIFT))&IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DIAG_STATUS_BUS_SELECT_MASK)
#define IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DIAG_CTRL_BUS_MASK 0xE00000u
#define IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DIAG_CTRL_BUS_SHIFT 21
#define IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DIAG_CTRL_BUS(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DIAG_CTRL_BUS_SHIFT))&IOMUXC_GPR_GPR12_GPR_PCIE_CTRL_DIAG_CTRL_BUS_MASK)
/* GPR13 Bit Fields */
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_USDHC_MASK  0x1u
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_USDHC_SHIFT 0
#define IOMUXC_GPR_GPR13_GPR_AWCACHE_USDHC_MASK  0x2u
#define IOMUXC_GPR_GPR13_GPR_AWCACHE_USDHC_SHIFT 1
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_PXP_MASK    0x4u
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_PXP_SHIFT   2
#define IOMUXC_GPR_GPR13_GPR_AWCACHE_PXP_MASK    0x8u
#define IOMUXC_GPR_GPR13_GPR_AWCACHE_PXP_SHIFT   3
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_PCIE_MASK   0x10u
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_PCIE_SHIFT  4
#define IOMUXC_GPR_GPR13_GPR_AWCACHE_PCIE_MASK   0x20u
#define IOMUXC_GPR_GPR13_GPR_AWCACHE_PCIE_SHIFT  5
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_LCDIF_MASK  0x40u
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_LCDIF_SHIFT 6
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_EPDC_MASK   0x80u
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_EPDC_SHIFT  7
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_PXP_EN_MASK 0x100u
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_PXP_EN_SHIFT 8
#define IOMUXC_GPR_GPR13_GPR_AWCACHE_PXP_EN_MASK 0x200u
#define IOMUXC_GPR_GPR13_GPR_AWCACHE_PXP_EN_SHIFT 9
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_PCIE_EN_MASK 0x400u
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_PCIE_EN_SHIFT 10
#define IOMUXC_GPR_GPR13_GPR_AWCACHE_PCIE_EN_MASK 0x800u
#define IOMUXC_GPR_GPR13_GPR_AWCACHE_PCIE_EN_SHIFT 11
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_LCDIF_EN_MASK 0x1000u
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_LCDIF_EN_SHIFT 12
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_EPDC_EN_MASK 0x2000u
#define IOMUXC_GPR_GPR13_GPR_ARCACHE_EPDC_EN_SHIFT 13
#define IOMUXC_GPR_GPR13_GPR_AWCACHE_EPDC_MASK   0x4000u
#define IOMUXC_GPR_GPR13_GPR_AWCACHE_EPDC_SHIFT  14
#define IOMUXC_GPR_GPR13_GPR_AWCACHE_EPDC_EN_MASK 0x8000u
#define IOMUXC_GPR_GPR13_GPR_AWCACHE_EPDC_EN_SHIFT 15
#define IOMUXC_GPR_GPR13_GPR_PCIE_PHY_AFC_CODE_OUT_CH0_MASK 0xFF0000u
#define IOMUXC_GPR_GPR13_GPR_PCIE_PHY_AFC_CODE_OUT_CH0_SHIFT 16
#define IOMUXC_GPR_GPR13_GPR_PCIE_PHY_AFC_CODE_OUT_CH0(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR13_GPR_PCIE_PHY_AFC_CODE_OUT_CH0_SHIFT))&IOMUXC_GPR_GPR13_GPR_PCIE_PHY_AFC_CODE_OUT_CH0_MASK)
#define IOMUXC_GPR_GPR13_GPR_PCIE_PHY_VCO_BAND_MASK 0xF000000u
#define IOMUXC_GPR_GPR13_GPR_PCIE_PHY_VCO_BAND_SHIFT 24
#define IOMUXC_GPR_GPR13_GPR_PCIE_PHY_VCO_BAND(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR13_GPR_PCIE_PHY_VCO_BAND_SHIFT))&IOMUXC_GPR_GPR13_GPR_PCIE_PHY_VCO_BAND_MASK)
#define IOMUXC_GPR_GPR13_GPR_PCIE_PHY_PMA_CDR_LOCKED_CH0_MASK 0x10000000u
#define IOMUXC_GPR_GPR13_GPR_PCIE_PHY_PMA_CDR_LOCKED_CH0_SHIFT 28
#define IOMUXC_GPR_GPR13_GPR_PCIE_PHY_PMA_RX_PRESENT_CH0_MASK 0x20000000u
#define IOMUXC_GPR_GPR13_GPR_PCIE_PHY_PMA_RX_PRESENT_CH0_SHIFT 29
#define IOMUXC_GPR_GPR13_GPR_PCIE_PHY_CDR_VCO_MON_CH0_MASK 0x40000000u
#define IOMUXC_GPR_GPR13_GPR_PCIE_PHY_CDR_VCO_MON_CH0_SHIFT 30
#define IOMUXC_GPR_GPR13_GPR_PCIE_PHY_PCS_REFCLK_DISABLE_MASK 0x80000000u
#define IOMUXC_GPR_GPR13_GPR_PCIE_PHY_PCS_REFCLK_DISABLE_SHIFT 31
/* GPR14 Bit Fields */
#define IOMUXC_GPR_GPR14_GPR_SIM1_SIMV2_EMV_SEL_MASK 0x1u
#define IOMUXC_GPR_GPR14_GPR_SIM1_SIMV2_EMV_SEL_SHIFT 0
#define IOMUXC_GPR_GPR14_GPR_SIM2_SIMV2_EMV_SEL_MASK 0x2u
#define IOMUXC_GPR_GPR14_GPR_SIM2_SIMV2_EMV_SEL_SHIFT 1
/* GPR15 Bit Fields */
#define IOMUXC_GPR_GPR15_GPR_LVDS_I_VBLK_FLAG_MASK 0x1u
#define IOMUXC_GPR_GPR15_GPR_LVDS_I_VBLK_FLAG_SHIFT 0
#define IOMUXC_GPR_GPR15_GPR_LVDS_I_AUTO_SEL_MASK 0x2u
#define IOMUXC_GPR_GPR15_GPR_LVDS_I_AUTO_SEL_SHIFT 1
#define IOMUXC_GPR_GPR15_GPR_LVDS_I_DESKEW_CNT_SET_MASK 0x3FFCu
#define IOMUXC_GPR_GPR15_GPR_LVDS_I_DESKEW_CNT_SET_SHIFT 2
#define IOMUXC_GPR_GPR15_GPR_LVDS_I_DESKEW_CNT_SET(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR15_GPR_LVDS_I_DESKEW_CNT_SET_SHIFT))&IOMUXC_GPR_GPR15_GPR_LVDS_I_DESKEW_CNT_SET_MASK)
#define IOMUXC_GPR_GPR15_GPR_LVDS_I_LOCK_PPM_SET_MASK 0x3F0000u
#define IOMUXC_GPR_GPR15_GPR_LVDS_I_LOCK_PPM_SET_SHIFT 16
#define IOMUXC_GPR_GPR15_GPR_LVDS_I_LOCK_PPM_SET(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR15_GPR_LVDS_I_LOCK_PPM_SET_SHIFT))&IOMUXC_GPR_GPR15_GPR_LVDS_I_LOCK_PPM_SET_MASK)
/* GPR16 Bit Fields */
#define IOMUXC_GPR_GPR16_GPR_LVDS_SKEW_REG_CUR_MASK 0x3u
#define IOMUXC_GPR_GPR16_GPR_LVDS_SKEW_REG_CUR_SHIFT 0
#define IOMUXC_GPR_GPR16_GPR_LVDS_SKEW_REG_CUR(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR16_GPR_LVDS_SKEW_REG_CUR_SHIFT))&IOMUXC_GPR_GPR16_GPR_LVDS_SKEW_REG_CUR_MASK)
#define IOMUXC_GPR_GPR16_GPR_LVDS_SEL_DATABF_MASK 0x4u
#define IOMUXC_GPR_GPR16_GPR_LVDS_SEL_DATABF_SHIFT 2
#define IOMUXC_GPR_GPR16_GPR_LVDS_CNTB_TDLY_MASK 0x8u
#define IOMUXC_GPR_GPR16_GPR_LVDS_CNTB_TDLY_SHIFT 3
#define IOMUXC_GPR_GPR16_GPR_LVDS_SKEW_EN_H_MASK 0x10u
#define IOMUXC_GPR_GPR16_GPR_LVDS_SKEW_EN_H_SHIFT 4
#define IOMUXC_GPR_GPR16_GPR_LVDS_SKEWINI_MASK   0x20u
#define IOMUXC_GPR_GPR16_GPR_LVDS_SKEWINI_SHIFT  5
#define IOMUXC_GPR_GPR16_GPR_LVDS_SK_BIAS_MASK   0x3C0u
#define IOMUXC_GPR_GPR16_GPR_LVDS_SK_BIAS_SHIFT  6
#define IOMUXC_GPR_GPR16_GPR_LVDS_SK_BIAS(x)     (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR16_GPR_LVDS_SK_BIAS_SHIFT))&IOMUXC_GPR_GPR16_GPR_LVDS_SK_BIAS_MASK)
#define IOMUXC_GPR_GPR16_GPR_LVDS_AUTO_DSK_SEL_MASK 0x400u
#define IOMUXC_GPR_GPR16_GPR_LVDS_AUTO_DSK_SEL_SHIFT 10
#define IOMUXC_GPR_GPR16_GPR_LVDS_LOCK_CNT_MASK  0x800u
#define IOMUXC_GPR_GPR16_GPR_LVDS_LOCK_CNT_SHIFT 11
#define IOMUXC_GPR_GPR16_GPR_LVDS_OUTCON_MASK    0x1000u
#define IOMUXC_GPR_GPR16_GPR_LVDS_OUTCON_SHIFT   12
#define IOMUXC_GPR_GPR16_GPR_LVDS_FC_CODE_MASK   0xE000u
#define IOMUXC_GPR_GPR16_GPR_LVDS_FC_CODE_SHIFT  13
#define IOMUXC_GPR_GPR16_GPR_LVDS_FC_CODE(x)     (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR16_GPR_LVDS_FC_CODE_SHIFT))&IOMUXC_GPR_GPR16_GPR_LVDS_FC_CODE_MASK)
#define IOMUXC_GPR_GPR16_GPR_LVDS_SRC_TRH_MASK   0x10000u
#define IOMUXC_GPR_GPR16_GPR_LVDS_SRC_TRH_SHIFT  16
#define IOMUXC_GPR_GPR16_GPR_LVDS_VOD_HIGH_S_MASK 0x20000u
#define IOMUXC_GPR_GPR16_GPR_LVDS_VOD_HIGH_S_SHIFT 17
#define IOMUXC_GPR_GPR16_GPR_LVDS_CNNCT_CNT_MASK 0x180000u
#define IOMUXC_GPR_GPR16_GPR_LVDS_CNNCT_CNT_SHIFT 19
#define IOMUXC_GPR_GPR16_GPR_LVDS_CNNCT_CNT(x)   (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR16_GPR_LVDS_CNNCT_CNT_SHIFT))&IOMUXC_GPR_GPR16_GPR_LVDS_CNNCT_CNT_MASK)
#define IOMUXC_GPR_GPR16_GPR_LVDS_CNNCT_MODE_SEL_MASK 0x200000u
#define IOMUXC_GPR_GPR16_GPR_LVDS_CNNCT_MODE_SEL_SHIFT 21
#define IOMUXC_GPR_GPR16_GPR_LVDS_FLT_CNT_MASK   0x400000u
#define IOMUXC_GPR_GPR16_GPR_LVDS_FLT_CNT_SHIFT  22
#define IOMUXC_GPR_GPR16_GPR_LVDS_VOD_ONLY_CNT_MASK 0x800000u
#define IOMUXC_GPR_GPR16_GPR_LVDS_VOD_ONLY_CNT_SHIFT 23
/* GPR17 Bit Fields */
#define IOMUXC_GPR_GPR17_GPR_LVDS_CNT_PEN_H_MASK 0xFFu
#define IOMUXC_GPR_GPR17_GPR_LVDS_CNT_PEN_H_SHIFT 0
#define IOMUXC_GPR_GPR17_GPR_LVDS_CNT_PEN_H(x)   (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR17_GPR_LVDS_CNT_PEN_H_SHIFT))&IOMUXC_GPR_GPR17_GPR_LVDS_CNT_PEN_H_MASK)
#define IOMUXC_GPR_GPR17_GPR_LVDS_CNT_VOD_H_MASK 0xFF00u
#define IOMUXC_GPR_GPR17_GPR_LVDS_CNT_VOD_H_SHIFT 8
#define IOMUXC_GPR_GPR17_GPR_LVDS_CNT_VOD_H(x)   (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR17_GPR_LVDS_CNT_VOD_H_SHIFT))&IOMUXC_GPR_GPR17_GPR_LVDS_CNT_VOD_H_MASK)
/* GPR18 Bit Fields */
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_CH_SEL_MASK 0x7u
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_CH_SEL_SHIFT 0
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_CH_SEL(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_CH_SEL_SHIFT))&IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_CH_SEL_MASK)
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_DATA_INV_MASK 0x18u
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_DATA_INV_SHIFT 3
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_DATA_INV(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_DATA_INV_SHIFT))&IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_DATA_INV_MASK)
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_CLK_INV_MASK 0x60u
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_CLK_INV_SHIFT 5
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_CLK_INV(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_CLK_INV_SHIFT))&IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_CLK_INV_MASK)
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_SKEW_CTRL_MASK 0x3F00u
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_SKEW_CTRL_SHIFT 8
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_SKEW_CTRL(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_SKEW_CTRL_SHIFT))&IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_SKEW_CTRL_MASK)
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_FORCE_ERROR_MASK 0x4000u
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_FORCE_ERROR_SHIFT 14
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_USER_PATTERN_MASK 0x7F0000u
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_USER_PATTERN_SHIFT 16
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_USER_PATTERN(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_USER_PATTERN_SHIFT))&IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_USER_PATTERN_MASK)
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_PAT_SEL_MASK 0x3000000u
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_PAT_SEL_SHIFT 24
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_PAT_SEL(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_PAT_SEL_SHIFT))&IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_PAT_SEL_MASK)
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_EN_MASK 0x4000000u
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_EN_SHIFT 26
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_RESETB_MASK 0x8000000u
#define IOMUXC_GPR_GPR18_GPR_LVDS_I_BIST_RESETB_SHIFT 27
#define IOMUXC_GPR_GPR18_GPR_LVDS_DLYS_BST_MASK  0x10000000u
#define IOMUXC_GPR_GPR18_GPR_LVDS_DLYS_BST_SHIFT 28
#define IOMUXC_GPR_GPR18_GPR_LVDS_SKINI_BST_MASK 0x20000000u
#define IOMUXC_GPR_GPR18_GPR_LVDS_SKINI_BST_SHIFT 29
/* GPR19 Bit Fields */
#define IOMUXC_GPR_GPR19_GPR_LVDS_O_BIST_STATUS_MASK 0x1u
#define IOMUXC_GPR_GPR19_GPR_LVDS_O_BIST_STATUS_SHIFT 0
#define IOMUXC_GPR_GPR19_GPR_LVDS_O_BIST_ERR_COUNT_MASK 0xFF00u
#define IOMUXC_GPR_GPR19_GPR_LVDS_O_BIST_ERR_COUNT_SHIFT 8
#define IOMUXC_GPR_GPR19_GPR_LVDS_O_BIST_ERR_COUNT(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR19_GPR_LVDS_O_BIST_ERR_COUNT_SHIFT))&IOMUXC_GPR_GPR19_GPR_LVDS_O_BIST_ERR_COUNT_MASK)
#define IOMUXC_GPR_GPR19_GPR_LVDS_O_BIST_SYNC_MASK 0x10000u
#define IOMUXC_GPR_GPR19_GPR_LVDS_O_BIST_SYNC_SHIFT 16
#define IOMUXC_GPR_GPR19_GPR_LVDS_MON_FOR_CNNCT_MASK 0x20000u
#define IOMUXC_GPR_GPR19_GPR_LVDS_MON_FOR_CNNCT_SHIFT 17
/* GPR20 Bit Fields */
#define IOMUXC_GPR_GPR20_GPR_LVDS_P_MASK         0x3Fu
#define IOMUXC_GPR_GPR20_GPR_LVDS_P_SHIFT        0
#define IOMUXC_GPR_GPR20_GPR_LVDS_P(x)           (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR20_GPR_LVDS_P_SHIFT))&IOMUXC_GPR_GPR20_GPR_LVDS_P_MASK)
#define IOMUXC_GPR_GPR20_GPR_LVDS_M_MASK         0x3F00u
#define IOMUXC_GPR_GPR20_GPR_LVDS_M_SHIFT        8
#define IOMUXC_GPR_GPR20_GPR_LVDS_M(x)           (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR20_GPR_LVDS_M_SHIFT))&IOMUXC_GPR_GPR20_GPR_LVDS_M_MASK)
#define IOMUXC_GPR_GPR20_GPR_LVDS_S_MASK         0x30000u
#define IOMUXC_GPR_GPR20_GPR_LVDS_S_SHIFT        16
#define IOMUXC_GPR_GPR20_GPR_LVDS_S(x)           (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR20_GPR_LVDS_S_SHIFT))&IOMUXC_GPR_GPR20_GPR_LVDS_S_MASK)
#define IOMUXC_GPR_GPR20_GPR_LVDS_VSEL_MASK      0x1000000u
#define IOMUXC_GPR_GPR20_GPR_LVDS_VSEL_SHIFT     24
#define IOMUXC_GPR_GPR20_GPR_LVDS_CK_POL_SEL_MASK 0x2000000u
#define IOMUXC_GPR_GPR20_GPR_LVDS_CK_POL_SEL_SHIFT 25
#define IOMUXC_GPR_GPR20_GPR_LVDS_I_TX2801X_DUMMY_MASK 0x38000000u
#define IOMUXC_GPR_GPR20_GPR_LVDS_I_TX2801X_DUMMY_SHIFT 27
#define IOMUXC_GPR_GPR20_GPR_LVDS_I_TX2801X_DUMMY(x) (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR20_GPR_LVDS_I_TX2801X_DUMMY_SHIFT))&IOMUXC_GPR_GPR20_GPR_LVDS_I_TX2801X_DUMMY_MASK)
/* GPR21 Bit Fields */
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC0_MASK      0x7u
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC0_SHIFT     0
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC0(x)        (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR21_GPR_LVDS_SKC0_SHIFT))&IOMUXC_GPR_GPR21_GPR_LVDS_SKC0_MASK)
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC1_MASK      0x38u
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC1_SHIFT     3
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC1(x)        (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR21_GPR_LVDS_SKC1_SHIFT))&IOMUXC_GPR_GPR21_GPR_LVDS_SKC1_MASK)
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC2_MASK      0x1C0u
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC2_SHIFT     6
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC2(x)        (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR21_GPR_LVDS_SKC2_SHIFT))&IOMUXC_GPR_GPR21_GPR_LVDS_SKC2_MASK)
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKCCK_MASK     0xE00u
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKCCK_SHIFT    9
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKCCK(x)       (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR21_GPR_LVDS_SKCCK_SHIFT))&IOMUXC_GPR_GPR21_GPR_LVDS_SKCCK_MASK)
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC3_MASK      0x7000u
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC3_SHIFT     12
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC3(x)        (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR21_GPR_LVDS_SKC3_SHIFT))&IOMUXC_GPR_GPR21_GPR_LVDS_SKC3_MASK)
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC4_MASK      0x38000u
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC4_SHIFT     15
#define IOMUXC_GPR_GPR21_GPR_LVDS_SKC4(x)        (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR21_GPR_LVDS_SKC4_SHIFT))&IOMUXC_GPR_GPR21_GPR_LVDS_SKC4_MASK)
#define IOMUXC_GPR_GPR21_SJC_BYPASS_CJTAGC_MASK  0x40000u
#define IOMUXC_GPR_GPR21_SJC_BYPASS_CJTAGC_SHIFT 18
#define IOMUXC_GPR_GPR21_DAP_BYPASS_CJTAGC_MASK  0x80000u
#define IOMUXC_GPR_GPR21_DAP_BYPASS_CJTAGC_SHIFT 19
/* GPR22 Bit Fields */
#define IOMUXC_GPR_GPR22_ddrc_mrr_data_out_MASK  0xFF0000u
#define IOMUXC_GPR_GPR22_ddrc_mrr_data_out_SHIFT 16
#define IOMUXC_GPR_GPR22_ddrc_mrr_data_out(x)    (((uint32_t)(((uint32_t)(x))<<IOMUXC_GPR_GPR22_ddrc_mrr_data_out_SHIFT))&IOMUXC_GPR_GPR22_ddrc_mrr_data_out_MASK)
#define IOMUXC_GPR_GPR22_ddrc_mrr_valid_out_MASK 0x1000000u
#define IOMUXC_GPR_GPR22_ddrc_mrr_valid_out_SHIFT 24
#define IOMUXC_GPR_GPR22_ddr_phy_dfi_init_complete_MASK 0x2000000u
#define IOMUXC_GPR_GPR22_ddr_phy_dfi_init_complete_SHIFT 25
#define IOMUXC_GPR_GPR22_GPR_chd2_dvdd_usb_stable_MASK 0x4000000u
#define IOMUXC_GPR_GPR22_GPR_chd2_dvdd_usb_stable_SHIFT 26
#define IOMUXC_GPR_GPR22_aux_chrg_det_2_usb_iso_enable_1_MASK 0x8000000u
#define IOMUXC_GPR_GPR22_aux_chrg_det_2_usb_iso_enable_1_SHIFT 27
#define IOMUXC_GPR_GPR22_GPR_chd1_dvdd_usb_stable_MASK 0x10000000u
#define IOMUXC_GPR_GPR22_GPR_chd1_dvdd_usb_stable_SHIFT 28
#define IOMUXC_GPR_GPR22_aux_chrg_det_1_usb_iso_enable_1_MASK 0x20000000u
#define IOMUXC_GPR_GPR22_aux_chrg_det_1_usb_iso_enable_1_SHIFT 29
#define IOMUXC_GPR_GPR22_GPR_PCIE_PHY_PLL_LOCKED_MASK 0x80000000u
#define IOMUXC_GPR_GPR22_GPR_PCIE_PHY_PLL_LOCKED_SHIFT 31

#define IMX7D_GPR5_CSI1_MUX_CTRL_MASK			(0x1 << 4)
#define IMX7D_GPR5_CSI1_MUX_CTRL_PARALLEL_CSI		(0x0 << 4)
#define IMX7D_GPR5_CSI1_MUX_CTRL_MIPI_CSI		(0x1 << 4)

struct iomuxc {
	u32 gpr[23];
	/* mux and pad registers */
};

struct iomuxc_gpr_base_regs {
	u32 gpr[23];        /* 0x000 */
};

/*
 * CSPI register definitions
 */
#define MXC_SPI_BASE_ADDRESSES \
	ECSPI1_BASE_ADDR, \
	ECSPI2_BASE_ADDR, \
	ECSPI3_BASE_ADDR, \
	ECSPI4_BASE_ADDR

#define CSU_INIT_SEC_LEVEL0	0x00FF00FF
#define CSU_NUM_REGS		64

struct ocotp_regs {
	u32 ctrl;
	u32 ctrl_set;
	u32 ctrl_clr;
	u32 ctrl_tog;
	u32 timing;
	u32 rsvd0[3];
	u32 data0;
	u32 rsvd1[3];
	u32 data1;
	u32 rsvd2[3];
	u32 data2;
	u32 rsvd3[3];
	u32 data3;
	u32 rsvd4[3];
	u32 read_ctrl;
	u32 rsvd5[3];
	u32 read_fuse_data0;
	u32 rsvd6[3];
	u32 read_fuse_data1;
	u32 rsvd7[3];
	u32 read_fuse_data2;
	u32 rsvd8[3];
	u32 read_fuse_data3;
	u32 rsvd9[3];
	u32 sw_sticky;
	u32 rsvd10[3];
	u32 scs;
	u32 scs_set;
	u32 scs_clr;
	u32 scs_tog;
	u32 crc_addr;
	u32 rsvd11[3];
	u32 crc_value;
	u32 rsvd12[3];
	u32 version;
	u32 rsvd13[0xc3];

	struct fuse_bank {	/* offset 0x400 */
		u32 fuse_regs[0x10];
	} bank[16];
};

struct fuse_bank0_regs {
	u32 lock;
	u32 rsvd0[3];
	u32 tester0;
	u32 rsvd1[3];
	u32 tester1;
	u32 rsvd2[3];
	u32 tester2;
	u32 rsvd3[3];
};

struct fuse_bank1_regs {
	u32 tester3;
	u32 rsvd0[3];
	u32 tester4;
	u32 rsvd1[3];
	u32 tester5;
	u32 rsvd2[3];
	u32 cfg0;
	u32 rsvd3[3];
};

struct fuse_bank2_regs {
	u32 cfg1;
	u32 rsvd0[3];
	u32 cfg2;
	u32 rsvd1[3];
	u32 cfg3;
	u32 rsvd2[3];
	u32 cfg4;
	u32 rsvd3[3];
};

struct fuse_bank3_regs {
	u32 mem_trim0;
	u32 rsvd0[3];
	u32 mem_trim1;
	u32 rsvd1[3];
	u32 ana0;
	u32 rsvd2[3];
	u32 ana1;
	u32 rsvd3[3];
};

struct fuse_bank8_regs {
	u32 sjc_resp_low;
	u32 rsvd0[3];
	u32 sjc_resp_high;
	u32 rsvd1[3];
	u32 usb_id;
	u32 rsvd2[3];
	u32 field_return;
	u32 rsvd3[3];
};

struct fuse_bank9_regs {
	u32 mac_addr0;
	u32 rsvd0[3];
	u32 mac_addr1;
	u32 rsvd1[3];
	u32 mac_addr2;
	u32 rsvd2[7];
};

struct aipstz_regs {
	u32	mprot0;
	u32	mprot1;
	u32	rsvd[0xe];
	u32	opacr0;
	u32	opacr1;
	u32	opacr2;
	u32	opacr3;
	u32	opacr4;
};

struct wdog_regs {
	u16	wcr;	/* Control */
	u16	wsr;	/* Service */
	u16	wrsr;	/* Reset Status */
	u16	wicr;	/* Interrupt Control */
	u16	wmcr;	/* Miscellaneous Control */
};

struct dbg_monitor_regs {
	u32	ctrl[4];		/* Control */
	u32	master_en[4];		/* Master enable */
	u32	irq[4];			/* IRQ */
	u32	trap_addr_low[4];	/* Trap address low */
	u32	trap_addr_high[4];	/* Trap address high */
	u32	trap_id[4];		/* Trap ID */
	u32	snvs_addr[4];		/* SNVS address */
	u32	snvs_data[4];		/* SNVS data */
	u32	snvs_info[4];		/* SNVS info */
	u32	version[4];		/* Version */
};

struct rdc_regs {
	u32	vir;		/* Version information */
	u32	reserved1[8];
	u32	stat;		/* Status */
	u32	intctrl;	/* Interrupt and Control */
	u32	intstat;	/* Interrupt Status */
	u32	reserved2[116];
	u32	mda[27];		/* Master Domain Assignment */
	u32	reserved3[101];
	u32	pdap[118];		/* Peripheral Domain Access Permissions */
	u32	reserved4[138];
	struct {
		u32 mrsa;		/* Memory Region Start Address */
		u32 mrea;		/* Memory Region End Address */
		u32 mrc;		/* Memory Region Control */
		u32 mrvs;		/* Memory Region Violation Status */
	} mem_region[52];
};

struct rdc_sema_regs {
	u8	gate[64];	/* Gate */
	u16	rstgt;		/* Reset Gate */
};

#define MXS_LCDIF_BASE ELCDIF1_IPS_BASE_ADDR

#define	LCDIF_CTRL_SFTRST					(1 << 31)
#define	LCDIF_CTRL_CLKGATE					(1 << 30)
#define	LCDIF_CTRL_YCBCR422_INPUT				(1 << 29)
#define	LCDIF_CTRL_READ_WRITEB					(1 << 28)
#define	LCDIF_CTRL_WAIT_FOR_VSYNC_EDGE				(1 << 27)
#define	LCDIF_CTRL_DATA_SHIFT_DIR				(1 << 26)
#define	LCDIF_CTRL_SHIFT_NUM_BITS_MASK				(0x1f << 21)
#define	LCDIF_CTRL_SHIFT_NUM_BITS_OFFSET			21
#define	LCDIF_CTRL_DVI_MODE					(1 << 20)
#define	LCDIF_CTRL_BYPASS_COUNT					(1 << 19)
#define	LCDIF_CTRL_VSYNC_MODE					(1 << 18)
#define	LCDIF_CTRL_DOTCLK_MODE					(1 << 17)
#define	LCDIF_CTRL_DATA_SELECT					(1 << 16)
#define	LCDIF_CTRL_INPUT_DATA_SWIZZLE_MASK			(0x3 << 14)
#define	LCDIF_CTRL_INPUT_DATA_SWIZZLE_OFFSET			14
#define	LCDIF_CTRL_CSC_DATA_SWIZZLE_MASK			(0x3 << 12)
#define	LCDIF_CTRL_CSC_DATA_SWIZZLE_OFFSET			12
#define	LCDIF_CTRL_LCD_DATABUS_WIDTH_MASK			(0x3 << 10)
#define	LCDIF_CTRL_LCD_DATABUS_WIDTH_OFFSET			10
#define	LCDIF_CTRL_LCD_DATABUS_WIDTH_16BIT			(0 << 10)
#define	LCDIF_CTRL_LCD_DATABUS_WIDTH_8BIT			(1 << 10)
#define	LCDIF_CTRL_LCD_DATABUS_WIDTH_18BIT			(2 << 10)
#define	LCDIF_CTRL_LCD_DATABUS_WIDTH_24BIT			(3 << 10)
#define	LCDIF_CTRL_WORD_LENGTH_MASK				(0x3 << 8)
#define	LCDIF_CTRL_WORD_LENGTH_OFFSET				8
#define	LCDIF_CTRL_WORD_LENGTH_16BIT				(0 << 8)
#define	LCDIF_CTRL_WORD_LENGTH_8BIT				(1 << 8)
#define	LCDIF_CTRL_WORD_LENGTH_18BIT				(2 << 8)
#define	LCDIF_CTRL_WORD_LENGTH_24BIT				(3 << 8)
#define	LCDIF_CTRL_RGB_TO_YCBCR422_CSC				(1 << 7)
#define	LCDIF_CTRL_LCDIF_MASTER					(1 << 5)
#define	LCDIF_CTRL_DATA_FORMAT_16_BIT				(1 << 3)
#define	LCDIF_CTRL_DATA_FORMAT_18_BIT				(1 << 2)
#define	LCDIF_CTRL_DATA_FORMAT_24_BIT				(1 << 1)
#define	LCDIF_CTRL_RUN						(1 << 0)

#define	LCDIF_CTRL1_COMBINE_MPU_WR_STRB				(1 << 27)
#define	LCDIF_CTRL1_BM_ERROR_IRQ_EN				(1 << 26)
#define	LCDIF_CTRL1_BM_ERROR_IRQ				(1 << 25)
#define	LCDIF_CTRL1_RECOVER_ON_UNDERFLOW			(1 << 24)
#define	LCDIF_CTRL1_INTERLACE_FIELDS				(1 << 23)
#define	LCDIF_CTRL1_START_INTERLACE_FROM_SECOND_FIELD		(1 << 22)
#define	LCDIF_CTRL1_FIFO_CLEAR					(1 << 21)
#define	LCDIF_CTRL1_IRQ_ON_ALTERNATE_FIELDS			(1 << 20)
#define	LCDIF_CTRL1_BYTE_PACKING_FORMAT_MASK			(0xf << 16)
#define	LCDIF_CTRL1_BYTE_PACKING_FORMAT_OFFSET			16
#define	LCDIF_CTRL1_OVERFLOW_IRQ_EN				(1 << 15)
#define	LCDIF_CTRL1_UNDERFLOW_IRQ_EN				(1 << 14)
#define	LCDIF_CTRL1_CUR_FRAME_DONE_IRQ_EN			(1 << 13)
#define	LCDIF_CTRL1_VSYNC_EDGE_IRQ_EN				(1 << 12)
#define	LCDIF_CTRL1_OVERFLOW_IRQ				(1 << 11)
#define	LCDIF_CTRL1_UNDERFLOW_IRQ				(1 << 10)
#define	LCDIF_CTRL1_CUR_FRAME_DONE_IRQ				(1 << 9)
#define	LCDIF_CTRL1_VSYNC_EDGE_IRQ				(1 << 8)
#define	LCDIF_CTRL1_BUSY_ENABLE					(1 << 2)
#define	LCDIF_CTRL1_MODE86					(1 << 1)
#define	LCDIF_CTRL1_RESET					(1 << 0)

#define	LCDIF_CTRL2_OUTSTANDING_REQS_MASK			(0x7 << 21)
#define	LCDIF_CTRL2_OUTSTANDING_REQS_OFFSET			21
#define	LCDIF_CTRL2_OUTSTANDING_REQS_REQ_1			(0x0 << 21)
#define	LCDIF_CTRL2_OUTSTANDING_REQS_REQ_2			(0x1 << 21)
#define	LCDIF_CTRL2_OUTSTANDING_REQS_REQ_4			(0x2 << 21)
#define	LCDIF_CTRL2_OUTSTANDING_REQS_REQ_8			(0x3 << 21)
#define	LCDIF_CTRL2_OUTSTANDING_REQS_REQ_16			(0x4 << 21)
#define	LCDIF_CTRL2_BURST_LEN_8					(1 << 20)
#define	LCDIF_CTRL2_ODD_LINE_PATTERN_MASK			(0x7 << 16)
#define	LCDIF_CTRL2_ODD_LINE_PATTERN_OFFSET			16
#define	LCDIF_CTRL2_ODD_LINE_PATTERN_RGB			(0x0 << 16)
#define	LCDIF_CTRL2_ODD_LINE_PATTERN_RBG			(0x1 << 16)
#define	LCDIF_CTRL2_ODD_LINE_PATTERN_GBR			(0x2 << 16)
#define	LCDIF_CTRL2_ODD_LINE_PATTERN_GRB			(0x3 << 16)
#define	LCDIF_CTRL2_ODD_LINE_PATTERN_BRG			(0x4 << 16)
#define	LCDIF_CTRL2_ODD_LINE_PATTERN_BGR			(0x5 << 16)
#define	LCDIF_CTRL2_EVEN_LINE_PATTERN_MASK			(0x7 << 12)
#define	LCDIF_CTRL2_EVEN_LINE_PATTERN_OFFSET			12
#define	LCDIF_CTRL2_EVEN_LINE_PATTERN_RGB			(0x0 << 12)
#define	LCDIF_CTRL2_EVEN_LINE_PATTERN_RBG			(0x1 << 12)
#define	LCDIF_CTRL2_EVEN_LINE_PATTERN_GBR			(0x2 << 12)
#define	LCDIF_CTRL2_EVEN_LINE_PATTERN_GRB			(0x3 << 12)
#define	LCDIF_CTRL2_EVEN_LINE_PATTERN_BRG			(0x4 << 12)
#define	LCDIF_CTRL2_EVEN_LINE_PATTERN_BGR			(0x5 << 12)
#define	LCDIF_CTRL2_READ_PACK_DIR				(1 << 10)
#define	LCDIF_CTRL2_READ_MODE_OUTPUT_IN_RGB_FORMAT		(1 << 9)
#define	LCDIF_CTRL2_READ_MODE_6_BIT_INPUT			(1 << 8)
#define	LCDIF_CTRL2_READ_MODE_NUM_PACKED_SUBWORDS_MASK		(0x7 << 4)
#define	LCDIF_CTRL2_READ_MODE_NUM_PACKED_SUBWORDS_OFFSET	4
#define	LCDIF_CTRL2_INITIAL_DUMMY_READ_MASK			(0x7 << 1)
#define	LCDIF_CTRL2_INITIAL_DUMMY_READ_OFFSET			1

#define	LCDIF_TRANSFER_COUNT_V_COUNT_MASK			(0xffff << 16)
#define	LCDIF_TRANSFER_COUNT_V_COUNT_OFFSET			16
#define	LCDIF_TRANSFER_COUNT_H_COUNT_MASK			(0xffff << 0)
#define	LCDIF_TRANSFER_COUNT_H_COUNT_OFFSET			0

#define	LCDIF_CUR_BUF_ADDR_MASK					0xffffffff
#define	LCDIF_CUR_BUF_ADDR_OFFSET				0

#define	LCDIF_NEXT_BUF_ADDR_MASK				0xffffffff
#define	LCDIF_NEXT_BUF_ADDR_OFFSET				0

#define	LCDIF_TIMING_CMD_HOLD_MASK				(0xff << 24)
#define	LCDIF_TIMING_CMD_HOLD_OFFSET				24
#define	LCDIF_TIMING_CMD_SETUP_MASK				(0xff << 16)
#define	LCDIF_TIMING_CMD_SETUP_OFFSET				16
#define	LCDIF_TIMING_DATA_HOLD_MASK				(0xff << 8)
#define	LCDIF_TIMING_DATA_HOLD_OFFSET				8
#define	LCDIF_TIMING_DATA_SETUP_MASK				(0xff << 0)
#define	LCDIF_TIMING_DATA_SETUP_OFFSET				0

#define	LCDIF_VDCTRL0_VSYNC_OEB					(1 << 29)
#define	LCDIF_VDCTRL0_ENABLE_PRESENT				(1 << 28)
#define	LCDIF_VDCTRL0_VSYNC_POL					(1 << 27)
#define	LCDIF_VDCTRL0_HSYNC_POL					(1 << 26)
#define	LCDIF_VDCTRL0_DOTCLK_POL				(1 << 25)
#define	LCDIF_VDCTRL0_ENABLE_POL				(1 << 24)
#define	LCDIF_VDCTRL0_VSYNC_PERIOD_UNIT				(1 << 21)
#define	LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH_UNIT			(1 << 20)
#define	LCDIF_VDCTRL0_HALF_LINE					(1 << 19)
#define	LCDIF_VDCTRL0_HALF_LINE_MODE				(1 << 18)
#define	LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH_MASK			0x3ffff
#define	LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH_OFFSET			0

#define	LCDIF_VDCTRL1_VSYNC_PERIOD_MASK				0xffffffff
#define	LCDIF_VDCTRL1_VSYNC_PERIOD_OFFSET			0

#define	LCDIF_VDCTRL2_HSYNC_PULSE_WIDTH_MASK			(0x3fff << 18)
#define	LCDIF_VDCTRL2_HSYNC_PULSE_WIDTH_OFFSET			18
#define	LCDIF_VDCTRL2_HSYNC_PERIOD_MASK				0x3ffff
#define	LCDIF_VDCTRL2_HSYNC_PERIOD_OFFSET			0

#define	LCDIF_VDCTRL3_MUX_SYNC_SIGNALS				(1 << 29)
#define	LCDIF_VDCTRL3_VSYNC_ONLY				(1 << 28)
#define	LCDIF_VDCTRL3_HORIZONTAL_WAIT_CNT_MASK			(0xfff << 16)
#define	LCDIF_VDCTRL3_HORIZONTAL_WAIT_CNT_OFFSET		16
#define	LCDIF_VDCTRL3_VERTICAL_WAIT_CNT_MASK			(0xffff << 0)
#define	LCDIF_VDCTRL3_VERTICAL_WAIT_CNT_OFFSET			0

#define	LCDIF_VDCTRL4_DOTCLK_DLY_SEL_MASK			(0x7 << 29)
#define	LCDIF_VDCTRL4_DOTCLK_DLY_SEL_OFFSET			29
#define	LCDIF_VDCTRL4_SYNC_SIGNALS_ON				(1 << 18)
#define	LCDIF_VDCTRL4_DOTCLK_H_VALID_DATA_CNT_MASK		0x3ffff
#define	LCDIF_VDCTRL4_DOTCLK_H_VALID_DATA_CNT_OFFSET		0


extern void check_cpu_temperature(void);

extern void pcie_power_up(void);
extern void pcie_power_off(void);

/* If ROM fail back to USB recover mode, USBPH0_PWD will be clear to use USB
 * If boot from the other mode, USB0_PWD will keep reset value
 */
#define	is_boot_from_usb(void) (readl(USBOTG1_IPS_BASE_ADDR + 0x158) || \
	readl(USBOTG2_IPS_BASE_ADDR + 0x158))
#define	disconnect_from_pc(void) writel(0x0, USBOTG1_IPS_BASE_ADDR + 0x140)

struct bootrom_sw_info {
	u8 reserved_1;
	u8 boot_dev_instance;
	u8 boot_dev_type;
	u8 reserved_2;
	u32 arm_core_freq;
	u32 axi_freq;
	u32 ddr_freq;
	u32 gpt1_freq;
	u32 reserved_3[3];
};

#endif /* __ASSEMBLY__ */
#endif /* __ASM_ARCH_MX7_IMX_REGS_H__ */
