// SPDX-License-Identifier: BSD-3-Clause
/*
 * Cadence DDR Driver
 *
 * Copyright (C) 2012-2022 Cadence Design Systems, Inc.
 * Copyright (C) 2018-2022 Texas Instruments Incorporated - https://www.ti.com/
 */

#include <linux/types.h>
#include <lpddr4_j721e_ctl_regs_rw_masks.h>

u32 g_lpddr4_ddr_controller_rw_mask[] = {
	0x00000F01U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x01FFFFFFU,
	0x01010100U,
	0x03013F01U,
	0x1F1F1F03U,
	0x00030303U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFF01U,
	0x0001FFFFU,
	0xFF0F7FFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x7F7F0000U,
	0x7F7F7F7FU,
	0x00FF1F07U,
	0x3FFF01FFU,
	0xFF01FFFFU,
	0x3FFF01FFU,
	0xFF01FFFFU,
	0x3FFF01FFU,
	0x3F01FFFFU,
	0x00FFFFFFU,
	0x1F01FFFFU,
	0xFFFFFFFFU,
	0x1F01FFFFU,
	0xFFFFFFFFU,
	0x1F01FFFFU,
	0x070707FFU,
	0xFFFFFF01U,
	0x0FFFFFFFU,
	0x3F03FF1FU,
	0x1F1F1F1FU,
	0x0101011FU,
	0x1FFFFFFFU,
	0xFFFFFFFFU,
	0x0301FFFFU,
	0x0101017FU,
	0x07010000U,
	0x0003FF3FU,
	0x000FFFFFU,
	0x000003FFU,
	0x000FFFFFU,
	0x000003FFU,
	0x000FFFFFU,
	0x000FFFFFU,
	0x03FF0101U,
	0x03FFFFFFU,
	0x03FFFFFFU,
	0xFFFFFFFFU,
	0x1F1F010FU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x1F1F1FFFU,
	0x1F010F1FU,
	0x0F1F1F1FU,
	0x1F1F1F01U,
	0x00010F1FU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFF1F1F1FU,
	0x1F1F1F07U,
	0xFF1F1F1FU,
	0x1F1F1F07U,
	0xFF1F1F1FU,
	0x1F1F1F07U,
	0x07010101U,
	0x01010000U,
	0x00010101U,
	0xFFFFFFFFU,
	0x0700FFFFU,
	0xFFFFFF07U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0000FFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0000FFFFU,
	0x000FFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0000FFFFU,
	0x000FFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0000FFFFU,
	0x010FFFFFU,
	0x00010100U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0001FFFFU,
	0x01FFFFFFU,
	0x01000107U,
	0xFFFFFF03U,
	0x00FFFFFFU,
	0x0F0F0F0FU,
	0x0F0F0F0FU,
	0x0F0F0F0FU,
	0x0F0F0F0FU,
	0x0F0F0F0FU,
	0x0F0F0F0FU,
	0x3F0F0F0FU,
	0x070FFF01U,
	0x0F0F0000U,
	0x000FFF07U,
	0xFFFF0FFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x01010101U,
	0x3F3F0101U,
	0x01FF03FFU,
	0xFFFF03FFU,
	0xFFFF03FFU,
	0xFFFF03FFU,
	0x00000100U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x00FFFF0FU,
	0x07FFFFFFU,
	0x01FFFF00U,
	0x00000000U,
	0x00000000U,
	0x00010000U,
	0x03FF0003U,
	0x03FF03FFU,
	0xFFFF1F1FU,
	0x03FF03FFU,
	0x1F1F03FFU,
	0x03FFFFFFU,
	0x03FF03FFU,
	0xFFFF1F1FU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFF00FFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFF00FFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x00FFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFF00U,
	0x010101FFU,
	0x01000000U,
	0x01010101U,
	0x03030101U,
	0x013F0000U,
	0x00000001U,
	0xFFFFFFFFU,
	0x00000007U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x00000007U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0FFF0000U,
	0x07030000U,
	0x010F0101U,
	0x01FFFF01U,
	0x00000001U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x7FFF0000U,
	0x7FFF7FFFU,
	0x7FFF7FFFU,
	0x00077FFFU,
	0x010FFF00U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x00000007U,
	0xFFFFFFFFU,
	0x1F1F1F07U,
	0x000F1F1FU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0007FFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0000FF00U,
	0x00000000U,
	0x0FFF0FFFU,
	0x0FFF0FFFU,
	0x000FFF7FU,
	0x0FFF0FFFU,
	0x007F0FFFU,
	0x0FFF0FFFU,
	0x0FFF0FFFU,
	0x0000037FU,
	0x0FFF0FFFU,
	0x01010FFFU,
	0x03030303U,
	0x07070303U,
	0xFFFF0F0FU,
	0x0007FFFFU,
	0xFFFFFFFFU,
	0xFFFF0307U,
	0x1F01FFFFU,
	0xFFFF1F01U,
	0x01010101U,
	0x01010101U,
	0x011F0301U,
	0x01030301U,
	0x0003FFFFU,
	0x00000000U,
	0x0103FFFFU,
	0x01010103U,
	0x01010101U,
	0x01010101U,
	0x01010101U,
	0x0F0F0F07U,
	0x0F0F070FU,
	0x011F0F0FU,
	0x01000003U,
	0x03030301U,
	0x00010101U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0xFFFFFFFFU,
	0x00001FFFU,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x03000000U,
	0xFF030303U,
	0x0FFF0F0FU,
	0x0F0FFF0FU,
	0x01010101U,
	0x3F3F3F3FU,
	0x1F1F3F3FU,
	0x1F1F1F1FU,
	0x1F1F1F1FU,
	0x1F1F1F1FU,
	0x1F1F1F1FU,
	0x0F1F1F1FU,
	0x0F070F07U,
	0x00000707U,
	0x00000000U,
	0x00010000U,
	0x013F3F01U,
	0x0F010101U,
	0x00030101U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0000FFFFU,
	0x010F0F01U,
	0x01010101U,
	0x01010101U,
	0x03030101U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x00000100U,
	0x000FFFFFU,
	0x000FFFFFU,
	0x000FFFFFU,
	0x000FFFFFU,
	0x000FFFFFU,
	0x000FFFFFU,
	0x000FFFFFU,
	0x010FFFFFU,
	0x0101030FU,
	0x03010101U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0101FFFFU,
	0x00000707U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00FFFFFFU,
	0x7F7F7F00U,
	0x00FF0300U,
	0x001FFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x007FFFFFU,
	0xFFFFFFFFU,
	0x00007F7FU,
	0x001FFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x007FFFFFU,
	0xFFFFFFFFU,
	0x00007F7FU,
	0x001FFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x007FFFFFU,
	0xFFFFFFFFU,
	0x0F0F7F7FU,
	0xFF0F0F0FU,
	0x000003FFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0003FFFFU,
	0xFFFFFFFFU,
	0x000101FFU,
	0xFFFFFFFFU,
	0x00FF0000U,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x07000101U,
	0x7F7F0707U,
	0x7F7F7F7FU,
	0x010101FFU,
	0x07070701U,
	0x0F070707U,
	0x0F0F0F0FU,
	0x0F0F0F0FU,
	0x0F0F0F0FU,
	0x0F0F0F0FU,
	0xFF0F0F0FU,
	0xFFFF00FFU,
	0x000001FFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x01010101U,
	0x01010101U,
	0x00010101U,
	0x00000000U,
	0x00000000U,
	0x00000100U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x00000007U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0000000FU
};

u32 g_lpddr4_pi_rw_mask[] = {
	0x00000F01U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00010101U,
	0x00FFFFFFU,
	0x01010301U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0xFFFFFFFFU,
	0x0101011FU,
	0x0F011F0FU,
	0x00010103U,
	0x000FFFFFU,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000007U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x01000000U,
	0x00010101U,
	0x003F3F03U,
	0x0101FFFFU,
	0x0F010F01U,
	0x0000FF00U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0F0F0F1FU,
	0x00030000U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0101010FU,
	0x01010101U,
	0x000F0F01U,
	0x000003FFU,
	0xFFFFFFFFU,
	0x0000FF0FU,
	0xFFFFFFFFU,
	0x00FFFF00U,
	0x0F0FFFFFU,
	0x01011F1FU,
	0x03000000U,
	0x01030F01U,
	0x0F010101U,
	0x000000FFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFF0001U,
	0x1F1F3F1FU,
	0xFF0F0F01U,
	0x7F1F0FFFU,
	0x0101FFFFU,
	0x00FFFF01U,
	0x00000000U,
	0x010F0701U,
	0x011F1F0FU,
	0x00FF0300U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0101FFFFU,
	0x01010100U,
	0x0F1F0703U,
	0x0F0F0F0FU,
	0x0F0F0F0FU,
	0x0F0F0F0FU,
	0x0F0F0F0FU,
	0x000F0F0FU,
	0x00000000U,
	0x00000000U,
	0x0FFFFFFFU,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x011F1F00U,
	0x03030301U,
	0x00FF0103U,
	0x013F0001U,
	0x00000001U,
	0xFFFFFFFFU,
	0x0000FF07U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0FFF0000U,
	0xFFFFFFFFU,
	0x0000000FU,
	0xFFFFFFFFU,
	0x0000000FU,
	0xFFFFFFFFU,
	0x0000000FU,
	0xFFFFFFFFU,
	0x0000000FU,
	0xFFFFFFFFU,
	0x0000000FU,
	0xFFFFFFFFU,
	0x0000000FU,
	0xFFFFFFFFU,
	0x0000000FU,
	0xFFFFFFFFU,
	0x0000000FU,
	0xFFFFFFFFU,
	0x0000000FU,
	0xFFFFFFFFU,
	0x0303070FU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0000000FU,
	0x3FFFFFFFU,
	0x3FFFFFFFU,
	0x3FFFFFFFU,
	0x3FFFFFFFU,
	0x3FFFFFFFU,
	0x3FFFFFFFU,
	0x3FFFFFFFU,
	0x3FFFFFFFU,
	0x0101010FU,
	0x01010100U,
	0x00000001U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFF0101U,
	0x000000FFU,
	0x03FFFFFFU,
	0x01FFFF00U,
	0x01000000U,
	0x0100000FU,
	0x00010F07U,
	0x0F00010FU,
	0x010F0001U,
	0x00010F00U,
	0x0F00010FU,
	0x010F0001U,
	0x00000000U,
	0x00000000U,
	0x011F0000U,
	0x01010103U,
	0x01010101U,
	0x01010101U,
	0x01010101U,
	0x01010101U,
	0x0001FFFFU,
	0x0000001FU,
	0x0F011F01U,
	0x01010101U,
	0xFFFFFF01U,
	0x000000FFU,
	0x000000FFU,
	0x000FFFFFU,
	0x0FFF0FFFU,
	0x7F7F7F7FU,
	0x03FF7F7FU,
	0x000FFFFFU,
	0x000003FFU,
	0x000FFFFFU,
	0x000003FFU,
	0x0F0FFFFFU,
	0x03030F0FU,
	0x0003FF03U,
	0x03FF03FFU,
	0x01FF01FFU,
	0x0F0F01FFU,
	0x0F0F0F0FU,
	0x03030303U,
	0x03030303U,
	0x03030303U,
	0x03030303U,
	0x7F7F0303U,
	0x7F7F7F7FU,
	0x00070707U,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x1F030303U,
	0x001F3FFFU,
	0x001F3FFFU,
	0x1F1F3FFFU,
	0x03FF03FFU,
	0x03FF1F1FU,
	0x1F1F03FFU,
	0x03FF03FFU,
	0x7F7F7F7FU,
	0x0F0F7F7FU,
	0xFF1F0F0FU,
	0xFF1F0F1FU,
	0xFF1F0F1FU,
	0x0003FF1FU,
	0x03FFFFFFU,
	0x03FFFFFFU,
	0x003FFFFFU,
	0x003F03FFU,
	0x003F03FFU,
	0x03FF03FFU,
	0x7F7F03FFU,
	0x0003030FU,
	0x03FF03FFU,
	0x030F7F7FU,
	0x0003FF03U,
	0x7F7F03FFU,
	0xFF03030FU,
	0xFF3FFFFFU,
	0xFF01FFFFU,
	0xFFFF3F0FU,
	0xFFFFFFFFU,
	0x0000FF3FU,
	0xFF01FFFFU,
	0xFFFF3F0FU,
	0xFFFFFFFFU,
	0x0000FF3FU,
	0xFF01FFFFU,
	0xFFFF3F0FU,
	0x1FFFFFFFU,
	0xFFFFFFFFU,
	0x001FFFFFU,
	0xFFFFFFFFU,
	0x001FFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x3F3FFFFFU,
	0xFFFFFF3FU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x0000FFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x0000FFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x00FFFFFFU,
	0x0FFFFFFFU,
	0x0FFF0FFFU,
	0x000FFF7FU,
	0x0FFF0FFFU,
	0x000FFF7FU,
	0x0FFF0FFFU,
	0x000FFF7FU,
	0x0FFF0FFFU,
	0xFF0F0F0FU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0FFFFFFFU,
	0x0F0F0F0FU,
	0x0F0F0F0FU,
	0xFF0F0F0FU,
	0x0FFFFFFFU,
	0x0F0F0F0FU,
	0x000F0F0FU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x000007FFU
};

u32 g_lpddr4_data_slice_0_rw_mask[] = {
	0x000F07FFU,
	0x000703FFU,
	0x010303FFU,
	0x3F3F3F3FU,
	0x3F3F3F3FU,
	0x01030F3FU,
	0x1F1F0301U,
	0x1F030F0FU,
	0x0101FF03U,
	0xFFFFFFFFU,
	0x00000000U,
	0x0101FF7FU,
	0x00003F01U,
	0x000F03FFU,
	0x070101FFU,
	0x000301FFU,
	0x00000000U,
	0x00000301U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x070F0107U,
	0x0F0F0F0FU,
	0xFF030001U,
	0x00FF0F3FU,
	0x0F3F03FFU,
	0x1F030F3FU,
	0x3FFFFFFFU,
	0x0F07FF07U,
	0x0000FF0FU,
	0x000001FFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0001FFFFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x00000001U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x7FFFFFFFU,
	0x0000003FU,
	0x00000000U,
	0x00000000U,
	0x010001FFU,
	0x01FF01FFU,
	0x01FF01FFU,
	0x01FF01FFU,
	0x01FF01FFU,
	0x000001FFU,
	0x0003FFFFU,
	0x01FF01FFU,
	0x00000000U,
	0x017F7F01U,
	0x07FF0FFFU,
	0x03FFFF1FU,
	0x01FFFF3FU,
	0x07030101U,
	0x01010101U,
	0x000007FFU,
	0x00003FFFU,
	0x00001F00U,
	0x07FFFF07U,
	0x7F03FFFFU,
	0xFF01037FU,
	0x07FF07FFU,
	0x0103FFFFU,
	0x1F1F0F3FU,
	0x1F1F1F1FU,
	0x1F1F1F1FU,
	0x003F1F1FU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x000703FFU,
	0xFFFFFFFFU,
	0xFFFFFF0FU,
	0x0FFFFFFFU,
	0x03FFFF01U,
	0x1F1F0103U,
	0x3F07FF0FU,
	0xFF0FFFFFU,
	0x1F0F3F0FU,
	0x03FF03FFU,
	0x0F010FFFU,
	0x000003FFU,
	0x3F0103FFU,
	0x00030703U,
	0x07FF03FFU,
	0xFFFF0101U,
	0x001F3F7FU,
	0xFFFFFFFFU,
	0x0000000FU,
	0x07FF07FFU,
	0x07FF07FFU,
	0x07FF07FFU,
	0x07FF07FFU,
	0x03FF07FFU,
	0x0003FF03U,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF070FU,
	0x000103FFU,
	0x000F03FFU,
	0x010F07FFU,
	0x000003FFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0003033FU
};

u32 g_lpddr4_data_slice_1_rw_mask[] = {
	0x000F07FFU,
	0x000703FFU,
	0x010303FFU,
	0x3F3F3F3FU,
	0x3F3F3F3FU,
	0x01030F3FU,
	0x1F1F0301U,
	0x1F030F0FU,
	0x0101FF03U,
	0xFFFFFFFFU,
	0x00000000U,
	0x0101FF7FU,
	0x00003F01U,
	0x000F03FFU,
	0x070101FFU,
	0x000301FFU,
	0x00000000U,
	0x00000301U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x070F0107U,
	0x0F0F0F0FU,
	0xFF030001U,
	0x00FF0F3FU,
	0x0F3F03FFU,
	0x1F030F3FU,
	0x3FFFFFFFU,
	0x0F07FF07U,
	0x0000FF0FU,
	0x000001FFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0001FFFFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x00000001U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x7FFFFFFFU,
	0x0000003FU,
	0x00000000U,
	0x00000000U,
	0x010001FFU,
	0x01FF01FFU,
	0x01FF01FFU,
	0x01FF01FFU,
	0x01FF01FFU,
	0x000001FFU,
	0x0003FFFFU,
	0x01FF01FFU,
	0x00000000U,
	0x017F7F01U,
	0x07FF0FFFU,
	0x03FFFF1FU,
	0x01FFFF3FU,
	0x07030101U,
	0x01010101U,
	0x000007FFU,
	0x00003FFFU,
	0x00001F00U,
	0x07FFFF07U,
	0x7F03FFFFU,
	0xFF01037FU,
	0x07FF07FFU,
	0x0103FFFFU,
	0x1F1F0F3FU,
	0x1F1F1F1FU,
	0x1F1F1F1FU,
	0x003F1F1FU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x000703FFU,
	0xFFFFFFFFU,
	0xFFFFFF0FU,
	0x0FFFFFFFU,
	0x03FFFF01U,
	0x1F1F0103U,
	0x3F07FF0FU,
	0xFF0FFFFFU,
	0x1F0F3F0FU,
	0x03FF03FFU,
	0x0F010FFFU,
	0x000003FFU,
	0x3F0103FFU,
	0x00030703U,
	0x07FF03FFU,
	0xFFFF0101U,
	0x001F3F7FU,
	0xFFFFFFFFU,
	0x0000000FU,
	0x07FF07FFU,
	0x07FF07FFU,
	0x07FF07FFU,
	0x07FF07FFU,
	0x03FF07FFU,
	0x0003FF03U,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF070FU,
	0x000103FFU,
	0x000F03FFU,
	0x010F07FFU,
	0x000003FFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0003033FU
};

u32 g_lpddr4_data_slice_2_rw_mask[] = {
	0x000F07FFU,
	0x000703FFU,
	0x010303FFU,
	0x3F3F3F3FU,
	0x3F3F3F3FU,
	0x01030F3FU,
	0x1F1F0301U,
	0x1F030F0FU,
	0x0101FF03U,
	0xFFFFFFFFU,
	0x00000000U,
	0x0101FF7FU,
	0x00003F01U,
	0x000F03FFU,
	0x070101FFU,
	0x000301FFU,
	0x00000000U,
	0x00000301U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x070F0107U,
	0x0F0F0F0FU,
	0xFF030001U,
	0x00FF0F3FU,
	0x0F3F03FFU,
	0x1F030F3FU,
	0x3FFFFFFFU,
	0x0F07FF07U,
	0x0000FF0FU,
	0x000001FFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0001FFFFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x00000001U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x7FFFFFFFU,
	0x0000003FU,
	0x00000000U,
	0x00000000U,
	0x010001FFU,
	0x01FF01FFU,
	0x01FF01FFU,
	0x01FF01FFU,
	0x01FF01FFU,
	0x000001FFU,
	0x0003FFFFU,
	0x01FF01FFU,
	0x00000000U,
	0x017F7F01U,
	0x07FF0FFFU,
	0x03FFFF1FU,
	0x01FFFF3FU,
	0x07030101U,
	0x01010101U,
	0x000007FFU,
	0x00003FFFU,
	0x00001F00U,
	0x07FFFF07U,
	0x7F03FFFFU,
	0xFF01037FU,
	0x07FF07FFU,
	0x0103FFFFU,
	0x1F1F0F3FU,
	0x1F1F1F1FU,
	0x1F1F1F1FU,
	0x003F1F1FU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x000703FFU,
	0xFFFFFFFFU,
	0xFFFFFF0FU,
	0x0FFFFFFFU,
	0x03FFFF01U,
	0x1F1F0103U,
	0x3F07FF0FU,
	0xFF0FFFFFU,
	0x1F0F3F0FU,
	0x03FF03FFU,
	0x0F010FFFU,
	0x000003FFU,
	0x3F0103FFU,
	0x00030703U,
	0x07FF03FFU,
	0xFFFF0101U,
	0x001F3F7FU,
	0xFFFFFFFFU,
	0x0000000FU,
	0x07FF07FFU,
	0x07FF07FFU,
	0x07FF07FFU,
	0x07FF07FFU,
	0x03FF07FFU,
	0x0003FF03U,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF070FU,
	0x000103FFU,
	0x000F03FFU,
	0x010F07FFU,
	0x000003FFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0003033FU
};

u32 g_lpddr4_data_slice_3_rw_mask[] = {
	0x000F07FFU,
	0x000703FFU,
	0x010303FFU,
	0x3F3F3F3FU,
	0x3F3F3F3FU,
	0x01030F3FU,
	0x1F1F0301U,
	0x1F030F0FU,
	0x0101FF03U,
	0xFFFFFFFFU,
	0x00000000U,
	0x0101FF7FU,
	0x00003F01U,
	0x000F03FFU,
	0x070101FFU,
	0x000301FFU,
	0x00000000U,
	0x00000301U,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x070F0107U,
	0x0F0F0F0FU,
	0xFF030001U,
	0x00FF0F3FU,
	0x0F3F03FFU,
	0x1F030F3FU,
	0x3FFFFFFFU,
	0x0F07FF07U,
	0x0000FF0FU,
	0x000001FFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0001FFFFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x00000001U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x7FFFFFFFU,
	0x0000003FU,
	0x00000000U,
	0x00000000U,
	0x010001FFU,
	0x01FF01FFU,
	0x01FF01FFU,
	0x01FF01FFU,
	0x01FF01FFU,
	0x000001FFU,
	0x0003FFFFU,
	0x01FF01FFU,
	0x00000000U,
	0x017F7F01U,
	0x07FF0FFFU,
	0x03FFFF1FU,
	0x01FFFF3FU,
	0x07030101U,
	0x01010101U,
	0x000007FFU,
	0x00003FFFU,
	0x00001F00U,
	0x07FFFF07U,
	0x7F03FFFFU,
	0xFF01037FU,
	0x07FF07FFU,
	0x0103FFFFU,
	0x1F1F0F3FU,
	0x1F1F1F1FU,
	0x1F1F1F1FU,
	0x003F1F1FU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x000703FFU,
	0xFFFFFFFFU,
	0xFFFFFF0FU,
	0x0FFFFFFFU,
	0x03FFFF01U,
	0x1F1F0103U,
	0x3F07FF0FU,
	0xFF0FFFFFU,
	0x1F0F3F0FU,
	0x03FF03FFU,
	0x0F010FFFU,
	0x000003FFU,
	0x3F0103FFU,
	0x00030703U,
	0x07FF03FFU,
	0xFFFF0101U,
	0x001F3F7FU,
	0xFFFFFFFFU,
	0x0000000FU,
	0x07FF07FFU,
	0x07FF07FFU,
	0x07FF07FFU,
	0x07FF07FFU,
	0x03FF07FFU,
	0x0003FF03U,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF03FFU,
	0x03FF070FU,
	0x000103FFU,
	0x000F03FFU,
	0x010F07FFU,
	0x000003FFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0xFFFFFFFFU,
	0x0003033FU
};

u32 g_lpddr4_address_slice_0_rw_mask[] = {
	0x000107FFU,
	0x00000000U,
	0x0F000000U,
	0x00000000U,
	0x01000707U,
	0x011F7F7FU,
	0x01000301U,
	0x07FFFFFFU,
	0x0000003FU,
	0x00000000U,
	0x00000000U,
	0x07FF07FFU,
	0x000007FFU,
	0x00FFFFFFU,
	0x03FFFFFFU,
	0x01FF0F03U,
	0x07000001U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x000FFFFFU,
	0x000FFFFFU,
	0x000FFFFFU,
	0x000FFFFFU,
	0x000FFFFFU,
	0x000FFFFFU,
	0x000FFFFFU,
	0x000FFFFFU,
	0x00FFFFFFU,
	0x3F3F03FFU,
	0x3F0F3F3FU,
	0xFFFFFF03U,
	0x01FFFFFFU,
	0x3F03FFFFU,
	0x0101FFFFU,
	0x07FF3F01U,
	0x01FF0000U,
	0x01000000U,
	0x00000000U,
	0x07FF07FFU,
	0x1F07FF1FU,
	0x001F07FFU,
	0x001F07FFU,
	0x001F07FFU,
	0x001F07FFU,
	0x000F07FFU,
	0xFF3F07FFU,
	0x0103FFFFU,
	0x0000000FU,
	0x03FF010FU,
	0x0000FF01U
};

u32 g_lpddr4_phy_core_rw_mask[] = {
	0x00000003U,
	0x1F030101U,
	0x1F1F1F1FU,
	0x001F1F1FU,
	0x011F07FFU,
	0x07FF0100U,
	0x000107FFU,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x0101FF01U,
	0x0007FF0FU,
	0xFF0F07FFU,
	0x01030007U,
	0xFFFF0101U,
	0xFF3F0103U,
	0x010101FFU,
	0x0F0F0100U,
	0x010F0F01U,
	0xFFFF0101U,
	0x0001010FU,
	0x00000000U,
	0x0000FFFFU,
	0x00000001U,
	0x0F0F0F0FU,
	0x0F0F0F0FU,
	0x01FF0F0FU,
	0x001FFFFFU,
	0x0001FFFFU,
	0x0007FFFFU,
	0x000003FFU,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x01000000U,
	0x0001FF0FU,
	0x000103FFU,
	0x0003FFFFU,
	0x0001FFFFU,
	0x0001FFFFU,
	0x0003FFFFU,
	0x0003FFFFU,
	0x0003FFFFU,
	0x0003FFFFU,
	0x0003FFFFU,
	0x0003FFFFU,
	0x1FFF03FFU,
	0x00001FFFU,
	0xFFFFFFFFU,
	0x000007FFU,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x7F000000U,
	0x01FFFFFFU,
	0x00000000U,
	0x00000000U,
	0x0FFFFF7FU,
	0x000FFFFFU,
	0x01FFFFFFU,
	0x3F7FFFFFU,
	0x3F3F1F3FU,
	0x1F3F3F1FU,
	0x001F3F3FU,
	0x07FFFFFFU,
	0x03010000U,
	0x0F7F01FFU,
	0x00000000U,
	0x003F0101U,
	0x01010000U,
	0x00000001U,
	0xFFFFFFFFU,
	0x031F01FFU,
	0x00000003U,
	0xFFFFFFFFU,
	0x03FFFFFFU,
	0x07FF073FU,
	0x00000007U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000000U,
	0x00000003U,
	0x070F0101U,
	0x00000000U,
	0x0707FF01U,
	0x00007F00U,
	0x3FFF0000U,
	0x3F000000U,
	0x000FFF00U,
	0x03000FFFU,
	0x00000000U,
	0x000001FFU,
	0x03FF0000U,
	0x03000000U,
	0x007F0000U,
	0x00003F00U,
	0x000FFFFFU,
	0x000FFFFFU,
	0x0000FFFFU,
	0xFFFFFFFFU,
	0x1F0FFFFFU,
	0x0FFFFFFFU,
	0x0000FFFFU,
	0x00003FFFU,
	0x3FFF0000U,
	0x00000000U,
	0x00003FFFU,
	0x0003FFFFU,
	0x00003FFFU,
	0x00000001U,
	0x00011FFFU,
	0x0F0F0FFFU,
	0x010101FFU,
	0x07FF07FFU,
	0x07FF07FFU,
	0x000007FFU,
	0x000007FFU,
	0x000007FFU,
	0x000007FFU,
	0x00000007U,
	0x3FFFFFFFU,
	0x0003FFFFU,
	0x7FFFFFFFU,
	0xFFFFFFFFU,
	0x3FFFFFFFU,
	0x07FFFFFFU,
	0xFFFFFFFFU,
	0x0003FFFFU,
	0x3FFFFFFFU,
	0x07FFFFFFU,
	0x3FFFFFFFU,
	0x07FFFFFFU,
	0x3FFFFFFFU,
	0x07FFFFFFU,
	0x3FFFFFFFU,
	0x07FFFFFFU,
	0x7FFFFF07U
};
