/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (c) 2020 Aspeed Technology Inc.
 */

#ifndef _ASM_ARCH_WDT_AST2600_H
#define _ASM_ARCH_WDT_AST2600_H

#define WDT_BASE			0x1e785000

/*
 * Special value that needs to be written to counter_restart register to
 * (re)start the timer
 */
#define WDT_COUNTER_RESTART_VAL		0x4755

/* reset mode */
#define WDT_RESET_MODE_SOC		0
#define WDT_RESET_MODE_CHIP		1
#define WDT_RESET_MODE_CPU		2

/* bit-fields of WDT control register */
#define WDT_CTRL_2ND_BOOT		BIT(7)
#define WDT_CTRL_RESET_MODE_MASK	GENMASK(6, 5)
#define WDT_CTRL_RESET_MODE_SHIFT	5
#define WDT_CTRL_CLK1MHZ		BIT(4)
#define WDT_CTRL_RESET			BIT(1)
#define WDT_CTRL_EN			BIT(0)

/* bit-fields of WDT reset mask1 register */
#define WDT_RESET_MASK1_RVAS		BIT(25)
#define WDT_RESET_MASK1_GPIO1		BIT(24)
#define WDT_RESET_MASK1_XDMA2		BIT(23)
#define WDT_RESET_MASK1_XDMA1		BIT(22)
#define WDT_RESET_MASK1_MCTP2		BIT(21)
#define WDT_RESET_MASK1_MCTP1		BIT(20)
#define WDT_RESET_MASK1_JTAG1		BIT(19)
#define WDT_RESET_MASK1_SD_SDIO1	BIT(18)
#define WDT_RESET_MASK1_MAC2		BIT(17)
#define WDT_RESET_MASK1_MAC1		BIT(16)
#define WDT_RESET_MASK1_GPMCU		BIT(15)
#define WDT_RESET_MASK1_DPMCU		BIT(14)
#define WDT_RESET_MASK1_DP		BIT(13)
#define WDT_RESET_MASK1_HAC		BIT(12)
#define WDT_RESET_MASK1_VIDEO		BIT(11)
#define WDT_RESET_MASK1_CRT		BIT(10)
#define WDT_RESET_MASK1_GCRT		BIT(9)
#define WDT_RESET_MASK1_USB11_UHCI	BIT(8)
#define WDT_RESET_MASK1_USB_PORTA	BIT(7)
#define WDT_RESET_MASK1_USB_PORTB	BIT(6)
#define WDT_RESET_MASK1_COPROC		BIT(5)
#define WDT_RESET_MASK1_SOC		BIT(4)
#define WDT_RESET_MASK1_SLI		BIT(3)
#define WDT_RESET_MASK1_AHB		BIT(2)
#define WDT_RESET_MASK1_SDRAM		BIT(1)
#define WDT_RESET_MASK1_ARM		BIT(0)

/* bit-fields of WDT reset mask2 register */
#define WDT_RESET_MASK2_ESPI		BIT(26)
#define WDT_RESET_MASK2_I3C_BUS8	BIT(25)
#define WDT_RESET_MASK2_I3C_BUS7	BIT(24)
#define WDT_RESET_MASK2_I3C_BUS6	BIT(23)
#define WDT_RESET_MASK2_I3C_BUS5	BIT(22)
#define WDT_RESET_MASK2_I3C_BUS4	BIT(21)
#define WDT_RESET_MASK2_I3C_BUS3	BIT(20)
#define WDT_RESET_MASK2_I3C_BUS2	BIT(19)
#define WDT_RESET_MASK2_I3C_BUS1	BIT(18)
#define WDT_RESET_MASK2_I3C_GLOBAL	BIT(17)
#define WDT_RESET_MASK2_I2C		BIT(16)
#define WDT_RESET_MASK2_FSI		BIT(15)
#define WDT_RESET_MASK2_ADC		BIT(14)
#define WDT_RESET_MASK2_PWM		BIT(13)
#define WDT_RESET_MASK2_PECI		BIT(12)
#define WDT_RESET_MASK2_LPC		BIT(11)
#define WDT_RESET_MASK2_MDC_MDIO	BIT(10)
#define WDT_RESET_MASK2_GPIO2		BIT(9)
#define WDT_RESET_MASK2_JTAG2		BIT(8)
#define WDT_RESET_MASK2_SD_SDIO2	BIT(7)
#define WDT_RESET_MASK2_MAC4		BIT(6)
#define WDT_RESET_MASK2_MAC3		BIT(5)
#define WDT_RESET_MASK2_SOC		BIT(4)
#define WDT_RESET_MASK2_SLI2		BIT(3)
#define WDT_RESET_MASK2_AHB2		BIT(2)
#define WDT_RESET_MASK2_SPI1_SPI2	BIT(1)
#define WDT_RESET_MASK2_ARM		BIT(0)

#define WDT_RESET_MASK1_DEFAULT						\
	(WDT_RESET_MASK1_RVAS | WDT_RESET_MASK1_GPIO1 |			\
	 WDT_RESET_MASK1_JTAG1 | WDT_RESET_MASK1_SD_SDIO1 |		\
	 WDT_RESET_MASK1_MAC2 | WDT_RESET_MASK1_MAC1 |			\
	 WDT_RESET_MASK1_HAC | WDT_RESET_MASK1_VIDEO |			\
	 WDT_RESET_MASK1_CRT | WDT_RESET_MASK1_GCRT |			\
	 WDT_RESET_MASK1_USB11_UHCI | WDT_RESET_MASK1_USB_PORTA	|	\
	 WDT_RESET_MASK1_USB_PORTB | WDT_RESET_MASK1_COPROC |		\
	 WDT_RESET_MASK1_SOC | WDT_RESET_MASK1_ARM)

#define WDT_RESET_MASK2_DEFAULT						\
	(WDT_RESET_MASK2_I3C_BUS8 | WDT_RESET_MASK2_I3C_BUS7 |		\
	 WDT_RESET_MASK2_I3C_BUS6 | WDT_RESET_MASK2_I3C_BUS5 |		\
	 WDT_RESET_MASK2_I3C_BUS4 | WDT_RESET_MASK2_I3C_BUS3 |		\
	 WDT_RESET_MASK2_I3C_BUS2 | WDT_RESET_MASK2_I3C_BUS1 |		\
	 WDT_RESET_MASK2_I3C_GLOBAL | WDT_RESET_MASK2_I2C |		\
	 WDT_RESET_MASK2_FSI | WDT_RESET_MASK2_ADC |			\
	 WDT_RESET_MASK2_PWM | WDT_RESET_MASK2_PECI |			\
	 WDT_RESET_MASK2_LPC | WDT_RESET_MASK2_MDC_MDIO |		\
	 WDT_RESET_MASK2_GPIO2 | WDT_RESET_MASK2_JTAG2 |		\
	 WDT_RESET_MASK2_SD_SDIO2 | WDT_RESET_MASK2_MAC4 |		\
	 WDT_RESET_MASK2_MAC3 | WDT_RESET_MASK2_SOC |			\
	 WDT_RESET_MASK2_ARM)

#ifndef __ASSEMBLY__
struct ast2600_wdt {
	u32 counter_status;
	u32 counter_reload_val;
	u32 counter_restart;
	u32 ctrl;
	u32 timeout_status;
	u32 clr_timeout_status;
	u32 reset_width;
	u32 reset_mask1;
	u32 reset_mask2;
	u32 sw_reset_ctrl;
	u32 sw_reset_mask1;
	u32 sw_reset_mask2;
	u32 sw_reset_disable;
};
#endif  /* __ASSEMBLY__ */

#endif /* _ASM_ARCH_WDT_AST2600_H */
