/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (c) 2010-2014, NVIDIA CORPORATION. All rights reserved.
 */

#ifndef _TEGRA30_PINMUX_H_
#define _TEGRA30_PINMUX_H_

enum pmux_pingrp {
	PMUX_PINGRP_ULPI_DATA0_PO1,
	PMUX_PINGRP_ULPI_DATA1_PO2,
	PMUX_PINGRP_ULPI_DATA2_PO3,
	PMUX_PINGRP_ULPI_DATA3_PO4,
	PMUX_PINGRP_ULPI_DATA4_PO5,
	PMUX_PINGRP_ULPI_DATA5_PO6,
	PMUX_PINGRP_ULPI_DATA6_PO7,
	PMUX_PINGRP_ULPI_DATA7_PO0,
	PMUX_PINGRP_ULPI_CLK_PY0,
	PMUX_PINGRP_ULPI_DIR_PY1,
	PMUX_PINGRP_ULPI_NXT_PY2,
	PMUX_PINGRP_ULPI_STP_PY3,
	PMUX_PINGRP_DAP3_FS_PP0,
	PMUX_PINGRP_DAP3_DIN_PP1,
	PMUX_PINGRP_DAP3_DOUT_PP2,
	PMUX_PINGRP_DAP3_SCLK_PP3,
	PMUX_PINGRP_PV0,
	PMUX_PINGRP_PV1,
	PMUX_PINGRP_SDMMC1_CLK_PZ0,
	PMUX_PINGRP_SDMMC1_CMD_PZ1,
	PMUX_PINGRP_SDMMC1_DAT3_PY4,
	PMUX_PINGRP_SDMMC1_DAT2_PY5,
	PMUX_PINGRP_SDMMC1_DAT1_PY6,
	PMUX_PINGRP_SDMMC1_DAT0_PY7,
	PMUX_PINGRP_PV2,
	PMUX_PINGRP_PV3,
	PMUX_PINGRP_CLK2_OUT_PW5,
	PMUX_PINGRP_CLK2_REQ_PCC5,
	PMUX_PINGRP_LCD_PWR1_PC1,
	PMUX_PINGRP_LCD_PWR2_PC6,
	PMUX_PINGRP_LCD_SDIN_PZ2,
	PMUX_PINGRP_LCD_SDOUT_PN5,
	PMUX_PINGRP_LCD_WR_N_PZ3,
	PMUX_PINGRP_LCD_CS0_N_PN4,
	PMUX_PINGRP_LCD_DC0_PN6,
	PMUX_PINGRP_LCD_SCK_PZ4,
	PMUX_PINGRP_LCD_PWR0_PB2,
	PMUX_PINGRP_LCD_PCLK_PB3,
	PMUX_PINGRP_LCD_DE_PJ1,
	PMUX_PINGRP_LCD_HSYNC_PJ3,
	PMUX_PINGRP_LCD_VSYNC_PJ4,
	PMUX_PINGRP_LCD_D0_PE0,
	PMUX_PINGRP_LCD_D1_PE1,
	PMUX_PINGRP_LCD_D2_PE2,
	PMUX_PINGRP_LCD_D3_PE3,
	PMUX_PINGRP_LCD_D4_PE4,
	PMUX_PINGRP_LCD_D5_PE5,
	PMUX_PINGRP_LCD_D6_PE6,
	PMUX_PINGRP_LCD_D7_PE7,
	PMUX_PINGRP_LCD_D8_PF0,
	PMUX_PINGRP_LCD_D9_PF1,
	PMUX_PINGRP_LCD_D10_PF2,
	PMUX_PINGRP_LCD_D11_PF3,
	PMUX_PINGRP_LCD_D12_PF4,
	PMUX_PINGRP_LCD_D13_PF5,
	PMUX_PINGRP_LCD_D14_PF6,
	PMUX_PINGRP_LCD_D15_PF7,
	PMUX_PINGRP_LCD_D16_PM0,
	PMUX_PINGRP_LCD_D17_PM1,
	PMUX_PINGRP_LCD_D18_PM2,
	PMUX_PINGRP_LCD_D19_PM3,
	PMUX_PINGRP_LCD_D20_PM4,
	PMUX_PINGRP_LCD_D21_PM5,
	PMUX_PINGRP_LCD_D22_PM6,
	PMUX_PINGRP_LCD_D23_PM7,
	PMUX_PINGRP_LCD_CS1_N_PW0,
	PMUX_PINGRP_LCD_M1_PW1,
	PMUX_PINGRP_LCD_DC1_PD2,
	PMUX_PINGRP_HDMI_INT_PN7,
	PMUX_PINGRP_DDC_SCL_PV4,
	PMUX_PINGRP_DDC_SDA_PV5,
	PMUX_PINGRP_CRT_HSYNC_PV6,
	PMUX_PINGRP_CRT_VSYNC_PV7,
	PMUX_PINGRP_VI_D0_PT4,
	PMUX_PINGRP_VI_D1_PD5,
	PMUX_PINGRP_VI_D2_PL0,
	PMUX_PINGRP_VI_D3_PL1,
	PMUX_PINGRP_VI_D4_PL2,
	PMUX_PINGRP_VI_D5_PL3,
	PMUX_PINGRP_VI_D6_PL4,
	PMUX_PINGRP_VI_D7_PL5,
	PMUX_PINGRP_VI_D8_PL6,
	PMUX_PINGRP_VI_D9_PL7,
	PMUX_PINGRP_VI_D10_PT2,
	PMUX_PINGRP_VI_D11_PT3,
	PMUX_PINGRP_VI_PCLK_PT0,
	PMUX_PINGRP_VI_MCLK_PT1,
	PMUX_PINGRP_VI_VSYNC_PD6,
	PMUX_PINGRP_VI_HSYNC_PD7,
	PMUX_PINGRP_UART2_RXD_PC3,
	PMUX_PINGRP_UART2_TXD_PC2,
	PMUX_PINGRP_UART2_RTS_N_PJ6,
	PMUX_PINGRP_UART2_CTS_N_PJ5,
	PMUX_PINGRP_UART3_TXD_PW6,
	PMUX_PINGRP_UART3_RXD_PW7,
	PMUX_PINGRP_UART3_CTS_N_PA1,
	PMUX_PINGRP_UART3_RTS_N_PC0,
	PMUX_PINGRP_PU0,
	PMUX_PINGRP_PU1,
	PMUX_PINGRP_PU2,
	PMUX_PINGRP_PU3,
	PMUX_PINGRP_PU4,
	PMUX_PINGRP_PU5,
	PMUX_PINGRP_PU6,
	PMUX_PINGRP_GEN1_I2C_SDA_PC5,
	PMUX_PINGRP_GEN1_I2C_SCL_PC4,
	PMUX_PINGRP_DAP4_FS_PP4,
	PMUX_PINGRP_DAP4_DIN_PP5,
	PMUX_PINGRP_DAP4_DOUT_PP6,
	PMUX_PINGRP_DAP4_SCLK_PP7,
	PMUX_PINGRP_CLK3_OUT_PEE0,
	PMUX_PINGRP_CLK3_REQ_PEE1,
	PMUX_PINGRP_GMI_WP_N_PC7,
	PMUX_PINGRP_GMI_IORDY_PI5,
	PMUX_PINGRP_GMI_WAIT_PI7,
	PMUX_PINGRP_GMI_ADV_N_PK0,
	PMUX_PINGRP_GMI_CLK_PK1,
	PMUX_PINGRP_GMI_CS0_N_PJ0,
	PMUX_PINGRP_GMI_CS1_N_PJ2,
	PMUX_PINGRP_GMI_CS2_N_PK3,
	PMUX_PINGRP_GMI_CS3_N_PK4,
	PMUX_PINGRP_GMI_CS4_N_PK2,
	PMUX_PINGRP_GMI_CS6_N_PI3,
	PMUX_PINGRP_GMI_CS7_N_PI6,
	PMUX_PINGRP_GMI_AD0_PG0,
	PMUX_PINGRP_GMI_AD1_PG1,
	PMUX_PINGRP_GMI_AD2_PG2,
	PMUX_PINGRP_GMI_AD3_PG3,
	PMUX_PINGRP_GMI_AD4_PG4,
	PMUX_PINGRP_GMI_AD5_PG5,
	PMUX_PINGRP_GMI_AD6_PG6,
	PMUX_PINGRP_GMI_AD7_PG7,
	PMUX_PINGRP_GMI_AD8_PH0,
	PMUX_PINGRP_GMI_AD9_PH1,
	PMUX_PINGRP_GMI_AD10_PH2,
	PMUX_PINGRP_GMI_AD11_PH3,
	PMUX_PINGRP_GMI_AD12_PH4,
	PMUX_PINGRP_GMI_AD13_PH5,
	PMUX_PINGRP_GMI_AD14_PH6,
	PMUX_PINGRP_GMI_AD15_PH7,
	PMUX_PINGRP_GMI_A16_PJ7,
	PMUX_PINGRP_GMI_A17_PB0,
	PMUX_PINGRP_GMI_A18_PB1,
	PMUX_PINGRP_GMI_A19_PK7,
	PMUX_PINGRP_GMI_WR_N_PI0,
	PMUX_PINGRP_GMI_OE_N_PI1,
	PMUX_PINGRP_GMI_DQS_PI2,
	PMUX_PINGRP_GMI_RST_N_PI4,
	PMUX_PINGRP_GEN2_I2C_SCL_PT5,
	PMUX_PINGRP_GEN2_I2C_SDA_PT6,
	PMUX_PINGRP_SDMMC4_CLK_PCC4,
	PMUX_PINGRP_SDMMC4_CMD_PT7,
	PMUX_PINGRP_SDMMC4_DAT0_PAA0,
	PMUX_PINGRP_SDMMC4_DAT1_PAA1,
	PMUX_PINGRP_SDMMC4_DAT2_PAA2,
	PMUX_PINGRP_SDMMC4_DAT3_PAA3,
	PMUX_PINGRP_SDMMC4_DAT4_PAA4,
	PMUX_PINGRP_SDMMC4_DAT5_PAA5,
	PMUX_PINGRP_SDMMC4_DAT6_PAA6,
	PMUX_PINGRP_SDMMC4_DAT7_PAA7,
	PMUX_PINGRP_SDMMC4_RST_N_PCC3,
	PMUX_PINGRP_CAM_MCLK_PCC0,
	PMUX_PINGRP_PCC1,
	PMUX_PINGRP_PBB0,
	PMUX_PINGRP_CAM_I2C_SCL_PBB1,
	PMUX_PINGRP_CAM_I2C_SDA_PBB2,
	PMUX_PINGRP_PBB3,
	PMUX_PINGRP_PBB4,
	PMUX_PINGRP_PBB5,
	PMUX_PINGRP_PBB6,
	PMUX_PINGRP_PBB7,
	PMUX_PINGRP_PCC2,
	PMUX_PINGRP_JTAG_RTCK_PU7,
	PMUX_PINGRP_PWR_I2C_SCL_PZ6,
	PMUX_PINGRP_PWR_I2C_SDA_PZ7,
	PMUX_PINGRP_KB_ROW0_PR0,
	PMUX_PINGRP_KB_ROW1_PR1,
	PMUX_PINGRP_KB_ROW2_PR2,
	PMUX_PINGRP_KB_ROW3_PR3,
	PMUX_PINGRP_KB_ROW4_PR4,
	PMUX_PINGRP_KB_ROW5_PR5,
	PMUX_PINGRP_KB_ROW6_PR6,
	PMUX_PINGRP_KB_ROW7_PR7,
	PMUX_PINGRP_KB_ROW8_PS0,
	PMUX_PINGRP_KB_ROW9_PS1,
	PMUX_PINGRP_KB_ROW10_PS2,
	PMUX_PINGRP_KB_ROW11_PS3,
	PMUX_PINGRP_KB_ROW12_PS4,
	PMUX_PINGRP_KB_ROW13_PS5,
	PMUX_PINGRP_KB_ROW14_PS6,
	PMUX_PINGRP_KB_ROW15_PS7,
	PMUX_PINGRP_KB_COL0_PQ0,
	PMUX_PINGRP_KB_COL1_PQ1,
	PMUX_PINGRP_KB_COL2_PQ2,
	PMUX_PINGRP_KB_COL3_PQ3,
	PMUX_PINGRP_KB_COL4_PQ4,
	PMUX_PINGRP_KB_COL5_PQ5,
	PMUX_PINGRP_KB_COL6_PQ6,
	PMUX_PINGRP_KB_COL7_PQ7,
	PMUX_PINGRP_CLK_32K_OUT_PA0,
	PMUX_PINGRP_SYS_CLK_REQ_PZ5,
	PMUX_PINGRP_CORE_PWR_REQ,
	PMUX_PINGRP_CPU_PWR_REQ,
	PMUX_PINGRP_PWR_INT_N,
	PMUX_PINGRP_CLK_32K_IN,
	PMUX_PINGRP_OWR,
	PMUX_PINGRP_DAP1_FS_PN0,
	PMUX_PINGRP_DAP1_DIN_PN1,
	PMUX_PINGRP_DAP1_DOUT_PN2,
	PMUX_PINGRP_DAP1_SCLK_PN3,
	PMUX_PINGRP_CLK1_REQ_PEE2,
	PMUX_PINGRP_CLK1_OUT_PW4,
	PMUX_PINGRP_SPDIF_IN_PK6,
	PMUX_PINGRP_SPDIF_OUT_PK5,
	PMUX_PINGRP_DAP2_FS_PA2,
	PMUX_PINGRP_DAP2_DIN_PA4,
	PMUX_PINGRP_DAP2_DOUT_PA5,
	PMUX_PINGRP_DAP2_SCLK_PA3,
	PMUX_PINGRP_SPI2_MOSI_PX0,
	PMUX_PINGRP_SPI2_MISO_PX1,
	PMUX_PINGRP_SPI2_CS0_N_PX3,
	PMUX_PINGRP_SPI2_SCK_PX2,
	PMUX_PINGRP_SPI1_MOSI_PX4,
	PMUX_PINGRP_SPI1_SCK_PX5,
	PMUX_PINGRP_SPI1_CS0_N_PX6,
	PMUX_PINGRP_SPI1_MISO_PX7,
	PMUX_PINGRP_SPI2_CS1_N_PW2,
	PMUX_PINGRP_SPI2_CS2_N_PW3,
	PMUX_PINGRP_SDMMC3_CLK_PA6,
	PMUX_PINGRP_SDMMC3_CMD_PA7,
	PMUX_PINGRP_SDMMC3_DAT0_PB7,
	PMUX_PINGRP_SDMMC3_DAT1_PB6,
	PMUX_PINGRP_SDMMC3_DAT2_PB5,
	PMUX_PINGRP_SDMMC3_DAT3_PB4,
	PMUX_PINGRP_SDMMC3_DAT4_PD1,
	PMUX_PINGRP_SDMMC3_DAT5_PD0,
	PMUX_PINGRP_SDMMC3_DAT6_PD3,
	PMUX_PINGRP_SDMMC3_DAT7_PD4,
	PMUX_PINGRP_PEX_L0_PRSNT_N_PDD0,
	PMUX_PINGRP_PEX_L0_RST_N_PDD1,
	PMUX_PINGRP_PEX_L0_CLKREQ_N_PDD2,
	PMUX_PINGRP_PEX_WAKE_N_PDD3,
	PMUX_PINGRP_PEX_L1_PRSNT_N_PDD4,
	PMUX_PINGRP_PEX_L1_RST_N_PDD5,
	PMUX_PINGRP_PEX_L1_CLKREQ_N_PDD6,
	PMUX_PINGRP_PEX_L2_PRSNT_N_PDD7,
	PMUX_PINGRP_PEX_L2_RST_N_PCC6,
	PMUX_PINGRP_PEX_L2_CLKREQ_N_PCC7,
	PMUX_PINGRP_HDMI_CEC_PEE3,
	PMUX_PINGRP_COUNT,
};

enum pmux_drvgrp {
	PMUX_DRVGRP_AO1,
	PMUX_DRVGRP_AO2,
	PMUX_DRVGRP_AT1,
	PMUX_DRVGRP_AT2,
	PMUX_DRVGRP_AT3,
	PMUX_DRVGRP_AT4,
	PMUX_DRVGRP_AT5,
	PMUX_DRVGRP_CDEV1,
	PMUX_DRVGRP_CDEV2,
	PMUX_DRVGRP_CSUS,
	PMUX_DRVGRP_DAP1,
	PMUX_DRVGRP_DAP2,
	PMUX_DRVGRP_DAP3,
	PMUX_DRVGRP_DAP4,
	PMUX_DRVGRP_DBG,
	PMUX_DRVGRP_LCD1,
	PMUX_DRVGRP_LCD2,
	PMUX_DRVGRP_SDIO2,
	PMUX_DRVGRP_SDIO3,
	PMUX_DRVGRP_SPI,
	PMUX_DRVGRP_UAA,
	PMUX_DRVGRP_UAB,
	PMUX_DRVGRP_UART2,
	PMUX_DRVGRP_UART3,
	PMUX_DRVGRP_VI1,
	PMUX_DRVGRP_SDIO1 = (0x84 / 4),
	PMUX_DRVGRP_CRT = (0x90 / 4),
	PMUX_DRVGRP_DDC,
	PMUX_DRVGRP_GMA,
	PMUX_DRVGRP_GMB,
	PMUX_DRVGRP_GMC,
	PMUX_DRVGRP_GMD,
	PMUX_DRVGRP_GME,
	PMUX_DRVGRP_GMF,
	PMUX_DRVGRP_GMG,
	PMUX_DRVGRP_GMH,
	PMUX_DRVGRP_OWR,
	PMUX_DRVGRP_UDA,
	PMUX_DRVGRP_GPV,
	PMUX_DRVGRP_DEV3,
	PMUX_DRVGRP_CEC = (0xd0 / 4),
	PMUX_DRVGRP_COUNT,
};

enum pmux_func {
	PMUX_FUNC_DEFAULT,
	PMUX_FUNC_BLINK,
	PMUX_FUNC_CEC,
	PMUX_FUNC_CLK_12M_OUT,
	PMUX_FUNC_CLK_32K_IN,
	PMUX_FUNC_CORE_PWR_REQ,
	PMUX_FUNC_CPU_PWR_REQ,
	PMUX_FUNC_CRT,
	PMUX_FUNC_DAP,
	PMUX_FUNC_DDR,
	PMUX_FUNC_DEV3,
	PMUX_FUNC_DISPLAYA,
	PMUX_FUNC_DISPLAYB,
	PMUX_FUNC_DTV,
	PMUX_FUNC_EXTPERIPH1,
	PMUX_FUNC_EXTPERIPH2,
	PMUX_FUNC_EXTPERIPH3,
	PMUX_FUNC_GMI,
	PMUX_FUNC_GMI_ALT,
	PMUX_FUNC_HDA,
	PMUX_FUNC_HDCP,
	PMUX_FUNC_HDMI,
	PMUX_FUNC_HSI,
	PMUX_FUNC_I2C1,
	PMUX_FUNC_I2C2,
	PMUX_FUNC_I2C3,
	PMUX_FUNC_I2C4,
	PMUX_FUNC_I2CPWR,
	PMUX_FUNC_I2S0,
	PMUX_FUNC_I2S1,
	PMUX_FUNC_I2S2,
	PMUX_FUNC_I2S3,
	PMUX_FUNC_I2S4,
	PMUX_FUNC_INVALID,
	PMUX_FUNC_KBC,
	PMUX_FUNC_MIO,
	PMUX_FUNC_NAND,
	PMUX_FUNC_NAND_ALT,
	PMUX_FUNC_OWR,
	PMUX_FUNC_PCIE,
	PMUX_FUNC_PWM0,
	PMUX_FUNC_PWM1,
	PMUX_FUNC_PWM2,
	PMUX_FUNC_PWM3,
	PMUX_FUNC_PWR_INT_N,
	PMUX_FUNC_RTCK,
	PMUX_FUNC_SATA,
	PMUX_FUNC_SDMMC1,
	PMUX_FUNC_SDMMC2,
	PMUX_FUNC_SDMMC3,
	PMUX_FUNC_SDMMC4,
	PMUX_FUNC_SPDIF,
	PMUX_FUNC_SPI1,
	PMUX_FUNC_SPI2,
	PMUX_FUNC_SPI2_ALT,
	PMUX_FUNC_SPI3,
	PMUX_FUNC_SPI4,
	PMUX_FUNC_SPI5,
	PMUX_FUNC_SPI6,
	PMUX_FUNC_SYSCLK,
	PMUX_FUNC_TEST,
	PMUX_FUNC_TRACE,
	PMUX_FUNC_UARTA,
	PMUX_FUNC_UARTB,
	PMUX_FUNC_UARTC,
	PMUX_FUNC_UARTD,
	PMUX_FUNC_UARTE,
	PMUX_FUNC_ULPI,
	PMUX_FUNC_VGP1,
	PMUX_FUNC_VGP2,
	PMUX_FUNC_VGP3,
	PMUX_FUNC_VGP4,
	PMUX_FUNC_VGP5,
	PMUX_FUNC_VGP6,
	PMUX_FUNC_VI,
	PMUX_FUNC_VI_ALT1,
	PMUX_FUNC_VI_ALT2,
	PMUX_FUNC_VI_ALT3,
	PMUX_FUNC_RSVD1,
	PMUX_FUNC_RSVD2,
	PMUX_FUNC_RSVD3,
	PMUX_FUNC_RSVD4,
	PMUX_FUNC_COUNT,
};

static const char * const tegra_pinctrl_to_pingrp[] = {
	[PMUX_PINGRP_ULPI_DATA0_PO1] = "ulpi_data0_po1",
	[PMUX_PINGRP_ULPI_DATA1_PO2] = "ulpi_data1_po2",
	[PMUX_PINGRP_ULPI_DATA2_PO3] = "ulpi_data2_po3",
	[PMUX_PINGRP_ULPI_DATA3_PO4] = "ulpi_data3_po4",
	[PMUX_PINGRP_ULPI_DATA4_PO5] = "ulpi_data4_po5",
	[PMUX_PINGRP_ULPI_DATA5_PO6] = "ulpi_data5_po6",
	[PMUX_PINGRP_ULPI_DATA6_PO7] = "ulpi_data6_po7",
	[PMUX_PINGRP_ULPI_DATA7_PO0] = "ulpi_data7_po0",
	[PMUX_PINGRP_ULPI_CLK_PY0] = "ulpi_clk_py0",
	[PMUX_PINGRP_ULPI_DIR_PY1] = "ulpi_dir_py1",
	[PMUX_PINGRP_ULPI_NXT_PY2] = "ulpi_nxt_py2",
	[PMUX_PINGRP_ULPI_STP_PY3] = "ulpi_stp_py3",
	[PMUX_PINGRP_DAP3_FS_PP0] = "dap3_fs_pp0",
	[PMUX_PINGRP_DAP3_DIN_PP1] = "dap3_din_pp1",
	[PMUX_PINGRP_DAP3_DOUT_PP2] = "dap3_dout_pp2",
	[PMUX_PINGRP_DAP3_SCLK_PP3] = "dap3_sclk_pp3",
	[PMUX_PINGRP_PV0] = "pv0",
	[PMUX_PINGRP_PV1] = "pv1",
	[PMUX_PINGRP_SDMMC1_CLK_PZ0] = "sdmmc1_clk_pz0",
	[PMUX_PINGRP_SDMMC1_CMD_PZ1] = "sdmmc1_cmd_pz1",
	[PMUX_PINGRP_SDMMC1_DAT3_PY4] = "sdmmc1_dat3_py4",
	[PMUX_PINGRP_SDMMC1_DAT2_PY5] = "sdmmc1_dat2_py5",
	[PMUX_PINGRP_SDMMC1_DAT1_PY6] = "sdmmc1_dat1_py6",
	[PMUX_PINGRP_SDMMC1_DAT0_PY7] = "sdmmc1_dat0_py7",
	[PMUX_PINGRP_PV2] = "pv2",
	[PMUX_PINGRP_PV3] = "pv3",
	[PMUX_PINGRP_CLK2_OUT_PW5] = "clk2_out_pw5",
	[PMUX_PINGRP_CLK2_REQ_PCC5] = "clk2_req_pcc5",
	[PMUX_PINGRP_LCD_PWR1_PC1] = "lcd_pwr1_pc1",
	[PMUX_PINGRP_LCD_PWR2_PC6] = "lcd_pwr2_pc6",
	[PMUX_PINGRP_LCD_SDIN_PZ2] = "lcd_sdin_pz2",
	[PMUX_PINGRP_LCD_SDOUT_PN5] = "lcd_sdout_pn5",
	[PMUX_PINGRP_LCD_WR_N_PZ3] = "lcd_wr_n_pz3",
	[PMUX_PINGRP_LCD_CS0_N_PN4] = "lcd_cs0_n_pn4",
	[PMUX_PINGRP_LCD_DC0_PN6] = "lcd_dc0_pn6",
	[PMUX_PINGRP_LCD_SCK_PZ4] = "lcd_sck_pz4",
	[PMUX_PINGRP_LCD_PWR0_PB2] = "lcd_pwr0_pb2",
	[PMUX_PINGRP_LCD_PCLK_PB3] = "lcd_pclk_pb3",
	[PMUX_PINGRP_LCD_DE_PJ1] = "lcd_de_pj1",
	[PMUX_PINGRP_LCD_HSYNC_PJ3] = "lcd_hsync_pj3",
	[PMUX_PINGRP_LCD_VSYNC_PJ4] = "lcd_vsync_pj4",
	[PMUX_PINGRP_LCD_D0_PE0] = "lcd_d0_pe0",
	[PMUX_PINGRP_LCD_D1_PE1] = "lcd_d1_pe1",
	[PMUX_PINGRP_LCD_D2_PE2] = "lcd_d2_pe2",
	[PMUX_PINGRP_LCD_D3_PE3] = "lcd_d3_pe3",
	[PMUX_PINGRP_LCD_D4_PE4] = "lcd_d4_pe4",
	[PMUX_PINGRP_LCD_D5_PE5] = "lcd_d5_pe5",
	[PMUX_PINGRP_LCD_D6_PE6] = "lcd_d6_pe6",
	[PMUX_PINGRP_LCD_D7_PE7] = "lcd_d7_pe7",
	[PMUX_PINGRP_LCD_D8_PF0] = "lcd_d8_pf0",
	[PMUX_PINGRP_LCD_D9_PF1] = "lcd_d9_pf1",
	[PMUX_PINGRP_LCD_D10_PF2] = "lcd_d10_pf2",
	[PMUX_PINGRP_LCD_D11_PF3] = "lcd_d11_pf3",
	[PMUX_PINGRP_LCD_D12_PF4] = "lcd_d12_pf4",
	[PMUX_PINGRP_LCD_D13_PF5] = "lcd_d13_pf5",
	[PMUX_PINGRP_LCD_D14_PF6] = "lcd_d14_pf6",
	[PMUX_PINGRP_LCD_D15_PF7] = "lcd_d15_pf7",
	[PMUX_PINGRP_LCD_D16_PM0] = "lcd_d16_pm0",
	[PMUX_PINGRP_LCD_D17_PM1] = "lcd_d17_pm1",
	[PMUX_PINGRP_LCD_D18_PM2] = "lcd_d18_pm2",
	[PMUX_PINGRP_LCD_D19_PM3] = "lcd_d19_pm3",
	[PMUX_PINGRP_LCD_D20_PM4] = "lcd_d20_pm4",
	[PMUX_PINGRP_LCD_D21_PM5] = "lcd_d21_pm5",
	[PMUX_PINGRP_LCD_D22_PM6] = "lcd_d22_pm6",
	[PMUX_PINGRP_LCD_D23_PM7] = "lcd_d23_pm7",
	[PMUX_PINGRP_LCD_CS1_N_PW0] = "lcd_cs1_n_pw0",
	[PMUX_PINGRP_LCD_M1_PW1] = "lcd_m1_pw1",
	[PMUX_PINGRP_LCD_DC1_PD2] = "lcd_dc1_pd2",
	[PMUX_PINGRP_HDMI_INT_PN7] = "hdmi_int_pn7",
	[PMUX_PINGRP_DDC_SCL_PV4] = "ddc_scl_pv4",
	[PMUX_PINGRP_DDC_SDA_PV5] = "ddc_sda_pv5",
	[PMUX_PINGRP_CRT_HSYNC_PV6] = "crt_hsync_pv6",
	[PMUX_PINGRP_CRT_VSYNC_PV7] = "crt_vsync_pv7",
	[PMUX_PINGRP_VI_D0_PT4] = "vi_d0_pt4",
	[PMUX_PINGRP_VI_D1_PD5] = "vi_d1_pd5",
	[PMUX_PINGRP_VI_D2_PL0] = "vi_d2_pl0",
	[PMUX_PINGRP_VI_D3_PL1] = "vi_d3_pl1",
	[PMUX_PINGRP_VI_D4_PL2] = "vi_d4_pl2",
	[PMUX_PINGRP_VI_D5_PL3] = "vi_d5_pl3",
	[PMUX_PINGRP_VI_D6_PL4] = "vi_d6_pl4",
	[PMUX_PINGRP_VI_D7_PL5] = "vi_d7_pl5",
	[PMUX_PINGRP_VI_D8_PL6] = "vi_d8_pl6",
	[PMUX_PINGRP_VI_D9_PL7] = "vi_d9_pl7",
	[PMUX_PINGRP_VI_D10_PT2] = "vi_d10_pt2",
	[PMUX_PINGRP_VI_D11_PT3] = "vi_d11_pt3",
	[PMUX_PINGRP_VI_PCLK_PT0] = "vi_pclk_pt0",
	[PMUX_PINGRP_VI_MCLK_PT1] = "vi_mclk_pt1",
	[PMUX_PINGRP_VI_VSYNC_PD6] = "vi_vsync_pd6",
	[PMUX_PINGRP_VI_HSYNC_PD7] = "vi_hsync_pd7",
	[PMUX_PINGRP_UART2_RXD_PC3] = "uart2_rxd_pc3",
	[PMUX_PINGRP_UART2_TXD_PC2] = "uart2_txd_pc2",
	[PMUX_PINGRP_UART2_RTS_N_PJ6] = "uart2_rts_n_pj6",
	[PMUX_PINGRP_UART2_CTS_N_PJ5] = "uart2_cts_n_pj5",
	[PMUX_PINGRP_UART3_TXD_PW6] = "uart3_txd_pw6",
	[PMUX_PINGRP_UART3_RXD_PW7] = "uart3_rxd_pw7",
	[PMUX_PINGRP_UART3_CTS_N_PA1] = "uart3_cts_n_pa1",
	[PMUX_PINGRP_UART3_RTS_N_PC0] = "uart3_rts_n_pc0",
	[PMUX_PINGRP_PU0] = "pu0",
	[PMUX_PINGRP_PU1] = "pu1",
	[PMUX_PINGRP_PU2] = "pu2",
	[PMUX_PINGRP_PU3] = "pu3",
	[PMUX_PINGRP_PU4] = "pu4",
	[PMUX_PINGRP_PU5] = "pu5",
	[PMUX_PINGRP_PU6] = "pu6",
	[PMUX_PINGRP_GEN1_I2C_SDA_PC5] = "gen1_i2c_sda_pc5",
	[PMUX_PINGRP_GEN1_I2C_SCL_PC4] = "gen1_i2c_scl_pc4",
	[PMUX_PINGRP_DAP4_FS_PP4] = "dap4_fs_pp4",
	[PMUX_PINGRP_DAP4_DIN_PP5] = "dap4_din_pp5",
	[PMUX_PINGRP_DAP4_DOUT_PP6] = "dap4_dout_pp6",
	[PMUX_PINGRP_DAP4_SCLK_PP7] = "dap4_sclk_pp7",
	[PMUX_PINGRP_CLK3_OUT_PEE0] = "clk3_out_pee0",
	[PMUX_PINGRP_CLK3_REQ_PEE1] = "clk3_req_pee1",
	[PMUX_PINGRP_GMI_WP_N_PC7] = "gmi_wp_n_pc7",
	[PMUX_PINGRP_GMI_IORDY_PI5] = "gmi_iordy_pi5",
	[PMUX_PINGRP_GMI_WAIT_PI7] = "gmi_wait_pi7",
	[PMUX_PINGRP_GMI_ADV_N_PK0] = "gmi_adv_n_pk0",
	[PMUX_PINGRP_GMI_CLK_PK1] = "gmi_clk_pk1",
	[PMUX_PINGRP_GMI_CS0_N_PJ0] = "gmi_cs0_n_pj0",
	[PMUX_PINGRP_GMI_CS1_N_PJ2] = "gmi_cs1_n_pj2",
	[PMUX_PINGRP_GMI_CS2_N_PK3] = "gmi_cs2_n_pk3",
	[PMUX_PINGRP_GMI_CS3_N_PK4] = "gmi_cs3_n_pk4",
	[PMUX_PINGRP_GMI_CS4_N_PK2] = "gmi_cs4_n_pk2",
	[PMUX_PINGRP_GMI_CS6_N_PI3] = "gmi_cs6_n_pi3",
	[PMUX_PINGRP_GMI_CS7_N_PI6] = "gmi_cs7_n_pi6",
	[PMUX_PINGRP_GMI_AD0_PG0] = "gmi_ad0_pg0",
	[PMUX_PINGRP_GMI_AD1_PG1] = "gmi_ad1_pg1",
	[PMUX_PINGRP_GMI_AD2_PG2] = "gmi_ad2_pg2",
	[PMUX_PINGRP_GMI_AD3_PG3] = "gmi_ad3_pg3",
	[PMUX_PINGRP_GMI_AD4_PG4] = "gmi_ad4_pg4",
	[PMUX_PINGRP_GMI_AD5_PG5] = "gmi_ad5_pg5",
	[PMUX_PINGRP_GMI_AD6_PG6] = "gmi_ad6_pg6",
	[PMUX_PINGRP_GMI_AD7_PG7] = "gmi_ad7_pg7",
	[PMUX_PINGRP_GMI_AD8_PH0] = "gmi_ad8_ph0",
	[PMUX_PINGRP_GMI_AD9_PH1] = "gmi_ad9_ph1",
	[PMUX_PINGRP_GMI_AD10_PH2] = "gmi_ad10_ph2",
	[PMUX_PINGRP_GMI_AD11_PH3] = "gmi_ad11_ph3",
	[PMUX_PINGRP_GMI_AD12_PH4] = "gmi_ad12_ph4",
	[PMUX_PINGRP_GMI_AD13_PH5] = "gmi_ad13_ph5",
	[PMUX_PINGRP_GMI_AD14_PH6] = "gmi_ad14_ph6",
	[PMUX_PINGRP_GMI_AD15_PH7] = "gmi_ad15_ph7",
	[PMUX_PINGRP_GMI_A16_PJ7] = "gmi_a16_pj7",
	[PMUX_PINGRP_GMI_A17_PB0] = "gmi_a17_pb0",
	[PMUX_PINGRP_GMI_A18_PB1] = "gmi_a18_pb1",
	[PMUX_PINGRP_GMI_A19_PK7] = "gmi_a19_pk7",
	[PMUX_PINGRP_GMI_WR_N_PI0] = "gmi_wr_n_pi0",
	[PMUX_PINGRP_GMI_OE_N_PI1] = "gmi_oe_n_pi1",
	[PMUX_PINGRP_GMI_DQS_PI2] = "gmi_dqs_pi2",
	[PMUX_PINGRP_GMI_RST_N_PI4] = "gmi_rst_n_pi4",
	[PMUX_PINGRP_GEN2_I2C_SCL_PT5] = "gen2_i2c_scl_pt5",
	[PMUX_PINGRP_GEN2_I2C_SDA_PT6] = "gen2_i2c_sda_pt6",
	[PMUX_PINGRP_SDMMC4_CLK_PCC4] = "sdmmc4_clk_pcc4",
	[PMUX_PINGRP_SDMMC4_CMD_PT7] = "sdmmc4_cmd_pt7",
	[PMUX_PINGRP_SDMMC4_DAT0_PAA0] = "sdmmc4_dat0_paa0",
	[PMUX_PINGRP_SDMMC4_DAT1_PAA1] = "sdmmc4_dat1_paa1",
	[PMUX_PINGRP_SDMMC4_DAT2_PAA2] = "sdmmc4_dat2_paa2",
	[PMUX_PINGRP_SDMMC4_DAT3_PAA3] = "sdmmc4_dat3_paa3",
	[PMUX_PINGRP_SDMMC4_DAT4_PAA4] = "sdmmc4_dat4_paa4",
	[PMUX_PINGRP_SDMMC4_DAT5_PAA5] = "sdmmc4_dat5_paa5",
	[PMUX_PINGRP_SDMMC4_DAT6_PAA6] = "sdmmc4_dat6_paa6",
	[PMUX_PINGRP_SDMMC4_DAT7_PAA7] = "sdmmc4_dat7_paa7",
	[PMUX_PINGRP_SDMMC4_RST_N_PCC3] = "sdmmc4_rst_n_pcc3",
	[PMUX_PINGRP_CAM_MCLK_PCC0] = "cam_mclk_pcc0",
	[PMUX_PINGRP_PCC1] = "pcc1",
	[PMUX_PINGRP_PBB0] = "pbb0",
	[PMUX_PINGRP_CAM_I2C_SCL_PBB1] = "cam_i2c_scl_pbb1",
	[PMUX_PINGRP_CAM_I2C_SDA_PBB2] = "cam_i2c_sda_pbb2",
	[PMUX_PINGRP_PBB3] = "pbb3",
	[PMUX_PINGRP_PBB4] = "pbb4",
	[PMUX_PINGRP_PBB5] = "pbb5",
	[PMUX_PINGRP_PBB6] = "pbb6",
	[PMUX_PINGRP_PBB7] = "pbb7",
	[PMUX_PINGRP_PCC2] = "pcc2",
	[PMUX_PINGRP_JTAG_RTCK_PU7] = "jtag_rtck_pu7",
	[PMUX_PINGRP_PWR_I2C_SCL_PZ6] = "pwr_i2c_scl_pz6",
	[PMUX_PINGRP_PWR_I2C_SDA_PZ7] = "pwr_i2c_sda_pz7",
	[PMUX_PINGRP_KB_ROW0_PR0] = "kb_row0_pr0",
	[PMUX_PINGRP_KB_ROW1_PR1] = "kb_row1_pr1",
	[PMUX_PINGRP_KB_ROW2_PR2] = "kb_row2_pr2",
	[PMUX_PINGRP_KB_ROW3_PR3] = "kb_row3_pr3",
	[PMUX_PINGRP_KB_ROW4_PR4] = "kb_row4_pr4",
	[PMUX_PINGRP_KB_ROW5_PR5] = "kb_row5_pr5",
	[PMUX_PINGRP_KB_ROW6_PR6] = "kb_row6_pr6",
	[PMUX_PINGRP_KB_ROW7_PR7] = "kb_row7_pr7",
	[PMUX_PINGRP_KB_ROW8_PS0] = "kb_row8_ps0",
	[PMUX_PINGRP_KB_ROW9_PS1] = "kb_row9_ps1",
	[PMUX_PINGRP_KB_ROW10_PS2] = "kb_row10_ps2",
	[PMUX_PINGRP_KB_ROW11_PS3] = "kb_row11_ps3",
	[PMUX_PINGRP_KB_ROW12_PS4] = "kb_row12_ps4",
	[PMUX_PINGRP_KB_ROW13_PS5] = "kb_row13_ps5",
	[PMUX_PINGRP_KB_ROW14_PS6] = "kb_row14_ps6",
	[PMUX_PINGRP_KB_ROW15_PS7] = "kb_row15_ps7",
	[PMUX_PINGRP_KB_COL0_PQ0] = "kb_col0_pq0",
	[PMUX_PINGRP_KB_COL1_PQ1] = "kb_col1_pq1",
	[PMUX_PINGRP_KB_COL2_PQ2] = "kb_col2_pq2",
	[PMUX_PINGRP_KB_COL3_PQ3] = "kb_col3_pq3",
	[PMUX_PINGRP_KB_COL4_PQ4] = "kb_col4_pq4",
	[PMUX_PINGRP_KB_COL5_PQ5] = "kb_col5_pq5",
	[PMUX_PINGRP_KB_COL6_PQ6] = "kb_col6_pq6",
	[PMUX_PINGRP_KB_COL7_PQ7] = "kb_col7_pq7",
	[PMUX_PINGRP_CLK_32K_OUT_PA0] = "clk_32k_out_pa0",
	[PMUX_PINGRP_SYS_CLK_REQ_PZ5] = "sys_clk_req_pz5",
	[PMUX_PINGRP_CORE_PWR_REQ] = "core_pwr_req",
	[PMUX_PINGRP_CPU_PWR_REQ] = "cpu_pwr_req",
	[PMUX_PINGRP_PWR_INT_N] = "pwr_int_n",
	[PMUX_PINGRP_CLK_32K_IN] = "clk_32k_in",
	[PMUX_PINGRP_OWR] = "owr",
	[PMUX_PINGRP_DAP1_FS_PN0] = "dap1_fs_pn0",
	[PMUX_PINGRP_DAP1_DIN_PN1] = "dap1_din_pn1",
	[PMUX_PINGRP_DAP1_DOUT_PN2] = "dap1_dout_pn2",
	[PMUX_PINGRP_DAP1_SCLK_PN3] = "dap1_sclk_pn3",
	[PMUX_PINGRP_CLK1_REQ_PEE2] = "clk1_req_pee2",
	[PMUX_PINGRP_CLK1_OUT_PW4] = "clk1_out_pw4",
	[PMUX_PINGRP_SPDIF_IN_PK6] = "spdif_in_pk6",
	[PMUX_PINGRP_SPDIF_OUT_PK5] = "spdif_out_pk5",
	[PMUX_PINGRP_DAP2_FS_PA2] = "dap2_fs_pa2",
	[PMUX_PINGRP_DAP2_DIN_PA4] = "dap2_din_pa4",
	[PMUX_PINGRP_DAP2_DOUT_PA5] = "dap2_dout_pa5",
	[PMUX_PINGRP_DAP2_SCLK_PA3] = "dap2_sclk_pa3",
	[PMUX_PINGRP_SPI2_MOSI_PX0] = "spi2_mosi_px0",
	[PMUX_PINGRP_SPI2_MISO_PX1] = "spi2_miso_px1",
	[PMUX_PINGRP_SPI2_CS0_N_PX3] = "spi2_cs0_n_px3",
	[PMUX_PINGRP_SPI2_SCK_PX2] = "spi2_sck_px2",
	[PMUX_PINGRP_SPI1_MOSI_PX4] = "spi1_mosi_px4",
	[PMUX_PINGRP_SPI1_SCK_PX5] = "spi1_sck_px5",
	[PMUX_PINGRP_SPI1_CS0_N_PX6] = "spi1_cs0_n_px6",
	[PMUX_PINGRP_SPI1_MISO_PX7] = "spi1_miso_px7",
	[PMUX_PINGRP_SPI2_CS1_N_PW2] = "spi2_cs1_n_pw2",
	[PMUX_PINGRP_SPI2_CS2_N_PW3] = "spi2_cs2_n_pw3",
	[PMUX_PINGRP_SDMMC3_CLK_PA6] = "sdmmc3_clk_pa6",
	[PMUX_PINGRP_SDMMC3_CMD_PA7] = "sdmmc3_cmd_pa7",
	[PMUX_PINGRP_SDMMC3_DAT0_PB7] = "sdmmc3_dat0_pb7",
	[PMUX_PINGRP_SDMMC3_DAT1_PB6] = "sdmmc3_dat1_pb6",
	[PMUX_PINGRP_SDMMC3_DAT2_PB5] = "sdmmc3_dat2_pb5",
	[PMUX_PINGRP_SDMMC3_DAT3_PB4] = "sdmmc3_dat3_pb4",
	[PMUX_PINGRP_SDMMC3_DAT4_PD1] = "sdmmc3_dat4_pd1",
	[PMUX_PINGRP_SDMMC3_DAT5_PD0] = "sdmmc3_dat5_pd0",
	[PMUX_PINGRP_SDMMC3_DAT6_PD3] = "sdmmc3_dat6_pd3",
	[PMUX_PINGRP_SDMMC3_DAT7_PD4] = "sdmmc3_dat7_pd4",
	[PMUX_PINGRP_PEX_L0_PRSNT_N_PDD0] = "pex_l0_prsnt_n_pdd0",
	[PMUX_PINGRP_PEX_L0_RST_N_PDD1] = "pex_l0_rst_n_pdd1",
	[PMUX_PINGRP_PEX_L0_CLKREQ_N_PDD2] = "pex_l0_clkreq_n_pdd2",
	[PMUX_PINGRP_PEX_WAKE_N_PDD3] = "pex_wake_n_pdd3",
	[PMUX_PINGRP_PEX_L1_PRSNT_N_PDD4] = "pex_l1_prsnt_n_pdd4",
	[PMUX_PINGRP_PEX_L1_RST_N_PDD5] = "pex_l1_rst_n_pdd5",
	[PMUX_PINGRP_PEX_L1_CLKREQ_N_PDD6] = "pex_l1_clkreq_n_pdd6",
	[PMUX_PINGRP_PEX_L2_PRSNT_N_PDD7] = "pex_l2_prsnt_n_pdd7",
	[PMUX_PINGRP_PEX_L2_RST_N_PCC6] = "pex_l2_rst_n_pcc6",
	[PMUX_PINGRP_PEX_L2_CLKREQ_N_PCC7] = "pex_l2_clkreq_n_pcc7",
	[PMUX_PINGRP_HDMI_CEC_PEE3] = "hdmi_cec_pee3",
};

static const char * const tegra_pinctrl_to_drvgrp[] = {
	[PMUX_DRVGRP_AO1] = "drive_ao1",
	[PMUX_DRVGRP_AO2] = "drive_ao2",
	[PMUX_DRVGRP_AT1] = "drive_at1",
	[PMUX_DRVGRP_AT2] = "drive_at2",
	[PMUX_DRVGRP_AT3] = "drive_at3",
	[PMUX_DRVGRP_AT4] = "drive_at4",
	[PMUX_DRVGRP_AT5] = "drive_at5",
	[PMUX_DRVGRP_CDEV1] = "drive_cdev1",
	[PMUX_DRVGRP_CDEV2] = "drive_cdev2",
	[PMUX_DRVGRP_CSUS] = "drive_csus",
	[PMUX_DRVGRP_DAP1] = "drive_dap1",
	[PMUX_DRVGRP_DAP2] = "drive_dap2",
	[PMUX_DRVGRP_DAP3] = "drive_dap3",
	[PMUX_DRVGRP_DAP4] = "drive_dap4",
	[PMUX_DRVGRP_DBG] = "drive_dbg",
	[PMUX_DRVGRP_LCD1] = "drive_lcd1",
	[PMUX_DRVGRP_LCD2] = "drive_lcd2",
	[PMUX_DRVGRP_SDIO2] = "drive_sdio2",
	[PMUX_DRVGRP_SDIO3] = "drive_sdio3",
	[PMUX_DRVGRP_SPI] = "drive_spi",
	[PMUX_DRVGRP_UAA] = "drive_uaa",
	[PMUX_DRVGRP_UAB] = "drive_uab",
	[PMUX_DRVGRP_UART2] = "drive_uart2",
	[PMUX_DRVGRP_UART3] = "drive_uart3",
	[PMUX_DRVGRP_VI1] = "drive_vi1",
	[PMUX_DRVGRP_SDIO1] = "drive_sdio1",
	[PMUX_DRVGRP_CRT] = "drive_crt",
	[PMUX_DRVGRP_DDC] = "drive_ddc",
	[PMUX_DRVGRP_GMA] = "drive_gma",
	[PMUX_DRVGRP_GMB] = "drive_gmb",
	[PMUX_DRVGRP_GMC] = "drive_gmc",
	[PMUX_DRVGRP_GMD] = "drive_gmd",
	[PMUX_DRVGRP_GME] = "drive_gme",
	[PMUX_DRVGRP_GMF] = "drive_gmf",
	[PMUX_DRVGRP_GMG] = "drive_gmg",
	[PMUX_DRVGRP_GMH] = "drive_gmh",
	[PMUX_DRVGRP_OWR] = "drive_owr",
	[PMUX_DRVGRP_UDA] = "drive_uda",
	[PMUX_DRVGRP_GPV] = "drive_gpv",
	[PMUX_DRVGRP_DEV3] = "drive_dev3",
	[PMUX_DRVGRP_CEC] = "drive_cec",
};

static const char * const tegra_pinctrl_to_func[] = {
	[PMUX_FUNC_DEFAULT] = "default",
	[PMUX_FUNC_BLINK] = "blink",
	[PMUX_FUNC_CEC] = "cec",
	[PMUX_FUNC_CLK_12M_OUT] = "clk_12m_out",
	[PMUX_FUNC_CLK_32K_IN] = "clk_32k_in",
	[PMUX_FUNC_CORE_PWR_REQ] = "core_pwr_req",
	[PMUX_FUNC_CPU_PWR_REQ] = "cpu_pwr_req",
	[PMUX_FUNC_CRT] = "crt",
	[PMUX_FUNC_DAP] = "dap",
	[PMUX_FUNC_DDR] = "ddr",
	[PMUX_FUNC_DEV3] = "dev3",
	[PMUX_FUNC_DISPLAYA] = "displaya",
	[PMUX_FUNC_DISPLAYB] = "displayb",
	[PMUX_FUNC_DTV] = "dtv",
	[PMUX_FUNC_EXTPERIPH1] = "extperiph1",
	[PMUX_FUNC_EXTPERIPH2] = "extperiph2",
	[PMUX_FUNC_EXTPERIPH3] = "extperiph3",
	[PMUX_FUNC_GMI] = "gmi",
	[PMUX_FUNC_GMI_ALT] = "gmi_alt",
	[PMUX_FUNC_HDA] = "hda",
	[PMUX_FUNC_HDCP] = "hdcp",
	[PMUX_FUNC_HDMI] = "hdmi",
	[PMUX_FUNC_HSI] = "hsi",
	[PMUX_FUNC_I2C1] = "i2c1",
	[PMUX_FUNC_I2C2] = "i2c2",
	[PMUX_FUNC_I2C3] = "i2c3",
	[PMUX_FUNC_I2C4] = "i2c4",
	[PMUX_FUNC_I2CPWR] = "i2cpwr",
	[PMUX_FUNC_I2S0] = "i2s0",
	[PMUX_FUNC_I2S1] = "i2s1",
	[PMUX_FUNC_I2S2] = "i2s2",
	[PMUX_FUNC_I2S3] = "i2s3",
	[PMUX_FUNC_I2S4] = "i2s4",
	[PMUX_FUNC_INVALID] = "invalid",
	[PMUX_FUNC_KBC] = "kbc",
	[PMUX_FUNC_MIO] = "mio",
	[PMUX_FUNC_NAND] = "nand",
	[PMUX_FUNC_NAND_ALT] = "nand_alt",
	[PMUX_FUNC_OWR] = "owr",
	[PMUX_FUNC_PCIE] = "pcie",
	[PMUX_FUNC_PWM0] = "pwm0",
	[PMUX_FUNC_PWM1] = "pwm1",
	[PMUX_FUNC_PWM2] = "pwm2",
	[PMUX_FUNC_PWM3] = "pwm3",
	[PMUX_FUNC_PWR_INT_N] = "pwr_int_n",
	[PMUX_FUNC_RTCK] = "rtck",
	[PMUX_FUNC_SATA] = "sata",
	[PMUX_FUNC_SDMMC1] = "sdmmc1",
	[PMUX_FUNC_SDMMC2] = "sdmmc2",
	[PMUX_FUNC_SDMMC3] = "sdmmc3",
	[PMUX_FUNC_SDMMC4] = "sdmmc4",
	[PMUX_FUNC_SPDIF] = "spdif",
	[PMUX_FUNC_SPI1] = "spi1",
	[PMUX_FUNC_SPI2] = "spi2",
	[PMUX_FUNC_SPI2_ALT] = "spi2_alt",
	[PMUX_FUNC_SPI3] = "spi3",
	[PMUX_FUNC_SPI4] = "spi4",
	[PMUX_FUNC_SPI5] = "spi5",
	[PMUX_FUNC_SPI6] = "spi6",
	[PMUX_FUNC_SYSCLK] = "sysclk",
	[PMUX_FUNC_TEST] = "test",
	[PMUX_FUNC_TRACE] = "trace",
	[PMUX_FUNC_UARTA] = "uarta",
	[PMUX_FUNC_UARTB] = "uartb",
	[PMUX_FUNC_UARTC] = "uartc",
	[PMUX_FUNC_UARTD] = "uartd",
	[PMUX_FUNC_UARTE] = "uarte",
	[PMUX_FUNC_ULPI] = "ulpi",
	[PMUX_FUNC_VGP1] = "vgp1",
	[PMUX_FUNC_VGP2] = "vgp2",
	[PMUX_FUNC_VGP3] = "vgp3",
	[PMUX_FUNC_VGP4] = "vgp4",
	[PMUX_FUNC_VGP5] = "vgp5",
	[PMUX_FUNC_VGP6] = "vgp6",
	[PMUX_FUNC_VI] = "vi",
	[PMUX_FUNC_VI_ALT1] = "vi_alt1",
	[PMUX_FUNC_VI_ALT2] = "vi_alt2",
	[PMUX_FUNC_VI_ALT3] = "vi_alt3",
	[PMUX_FUNC_RSVD1] = "rsvd1",
	[PMUX_FUNC_RSVD2] = "rsvd2",
	[PMUX_FUNC_RSVD3] = "rsvd3",
	[PMUX_FUNC_RSVD4] = "rsvd4",
};

#define TEGRA_PMX_SOC_DRV_GROUP_BASE_REG 0x868
#define TEGRA_PMX_SOC_HAS_DRVGRPS
#define TEGRA_PMX_GRPS_HAVE_LPMD
#define TEGRA_PMX_GRPS_HAVE_SCHMT
#define TEGRA_PMX_GRPS_HAVE_HSM
#define TEGRA_PMX_PINS_HAVE_E_INPUT
#define TEGRA_PMX_PINS_HAVE_LOCK
#define TEGRA_PMX_PINS_HAVE_OD
#define TEGRA_PMX_PINS_HAVE_IO_RESET
#include <asm/arch-tegra/pinmux.h>

#endif /* _TEGRA30_PINMUX_H_ */
