/****************************************************************************
** libmatroska : parse Matroska files, see http://www.matroska.org/
**
** <file/class description>
**
** Copyright (C) 2002-2003 Steve Lhomme.  All rights reserved.
**
** This file is part of libmatroska.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding an other license may use this file in accordance with 
** the Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.matroska.org/license/qpl/ for QPL licensing information.
** See http://www.matroska.org/license/gpl/ for GPL licensing information.
**
** Contact license@matroska.org if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

/*!
	\file
	\version \$Id: KaxContentEncoding.h,v 1.3 2003/10/21 18:21:44 mosu Exp $
	\author Moritz Bunkus <moritz @ bunkus.org>
*/
#ifndef LIBMATROSKA_CONTENT_ENCODING_H
#define LIBMATROSKA_CONTENT_ENCODING_H

#include "matroska/KaxTypes.h"
#include "ebml/EbmlMaster.h"
#include "ebml/EbmlUInteger.h"
#include "ebml/EbmlBinary.h"

using namespace LIBEBML_NAMESPACE;

START_LIBMATROSKA_NAMESPACE

class KaxContentEncodings: public EbmlMaster {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentEncodings();
  KaxContentEncodings(const KaxContentEncodings &ElementToClone):
    EbmlMaster(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentEncodings); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const { return new KaxContentEncodings(*this); }
};

class KaxContentEncoding: public EbmlMaster {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentEncoding();
  KaxContentEncoding(const KaxContentEncoding &ElementToClone):
    EbmlMaster(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentEncoding); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const { return new KaxContentEncoding(*this); }
};

class KaxContentEncodingOrder: public EbmlUInteger {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentEncodingOrder(): EbmlUInteger(0) {}
  KaxContentEncodingOrder(const KaxContentEncodingOrder &ElementToClone):
    EbmlUInteger(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentEncodingOrder); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const { return new KaxContentEncodingOrder(*this); }
};

class KaxContentEncodingScope: public EbmlUInteger {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentEncodingScope(): EbmlUInteger(1) {}
  KaxContentEncodingScope(const KaxContentEncodingScope &ElementToClone):
    EbmlUInteger(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentEncodingScope); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const { return new KaxContentEncodingScope(*this); }
};

class KaxContentEncodingType: public EbmlUInteger {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentEncodingType(): EbmlUInteger(0) {}
  KaxContentEncodingType(const KaxContentEncodingType &ElementToClone):
    EbmlUInteger(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentEncodingType); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const { return new KaxContentEncodingType(*this); }
};

class KaxContentCompression: public EbmlMaster {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentCompression();
  KaxContentCompression(const KaxContentCompression &ElementToClone):
    EbmlMaster(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentCompression); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const { return new KaxContentCompression(*this); }
};

class KaxContentCompAlgo: public EbmlUInteger {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentCompAlgo(): EbmlUInteger(0) {}
  KaxContentCompAlgo(const KaxContentCompAlgo &ElementToClone):
    EbmlUInteger(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentCompAlgo); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const { return new KaxContentCompAlgo(*this); }
};

class KaxContentCompSettings: public EbmlBinary {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentCompSettings() {}
  KaxContentCompSettings(const KaxContentCompSettings &ElementToClone):
    EbmlBinary(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentCompSettings); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const {
    return new KaxContentCompSettings(*this);
  }
  bool ValidateSize(void) const { return true; }
};

class KaxContentEncryption: public EbmlMaster {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentEncryption();
  KaxContentEncryption(const KaxContentEncryption &ElementToClone):
    EbmlMaster(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentEncryption); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const { return new KaxContentEncryption(*this); }
};

class KaxContentEncAlgo: public EbmlUInteger {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentEncAlgo(): EbmlUInteger(0) {}
  KaxContentEncAlgo(const KaxContentEncAlgo &ElementToClone):
    EbmlUInteger(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentEncAlgo); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const { return new KaxContentEncAlgo(*this); }
};

class KaxContentEncKeyID: public EbmlBinary {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentEncKeyID() {}
  KaxContentEncKeyID(const KaxContentEncKeyID &ElementToClone):
    EbmlBinary(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentEncKeyID); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const { return new KaxContentEncKeyID(*this); }
  bool ValidateSize(void) const { return true; }
};

class KaxContentSignature: public EbmlBinary {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentSignature() {}
  KaxContentSignature(const KaxContentSignature &ElementToClone):
    EbmlBinary(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentSignature); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const { return new KaxContentSignature(*this); }
  bool ValidateSize(void) const { return true; }
};

class KaxContentSigKeyID: public EbmlBinary {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentSigKeyID() {}
  KaxContentSigKeyID(const KaxContentSigKeyID &ElementToClone):
    EbmlBinary(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentSigKeyID); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const { return new KaxContentSigKeyID(*this); }
  bool ValidateSize(void) const { return true; }
};

class KaxContentSigAlgo: public EbmlUInteger {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentSigAlgo() {}
  KaxContentSigAlgo(const KaxContentSigAlgo &ElementToClone):
    EbmlUInteger(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentSigAlgo); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const { return new KaxContentSigAlgo(*this); }
};

class KaxContentSigHashAlgo: public EbmlUInteger {
public:
  static const EbmlCallbacks ClassInfos;

  KaxContentSigHashAlgo() {}
  KaxContentSigHashAlgo(const KaxContentSigHashAlgo &ElementToClone):
    EbmlUInteger(ElementToClone) {}
  static EbmlElement &Create() { return *(new KaxContentSigHashAlgo); }
  const EbmlCallbacks &Generic() const { return ClassInfos; }
  operator const EbmlId &() const { return ClassInfos.GlobalId; }
  EbmlElement *Clone() const { return new KaxContentSigHashAlgo(*this); }
};

END_LIBMATROSKA_NAMESPACE

#endif // LIBMATROSKA_CONTENT_ENCODING_H
