/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.BDGraphics;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.videolan.Logger;

public class BDFontMetrics
extends FontMetrics {
    static final long serialVersionUID = -4956160226949100590L;
    private static long ftLib = 0L;
    private static Map fontNameMap;
    private static Map fontMetricsMap;
    private long ftFace;
    private int ascent;
    private int descent;
    private int leading;
    private int maxAdvance;
    private int[] widths;

    private static native long initN();

    private static native void destroyN(long var0);

    public static synchronized void init() {
        if (ftLib != 0L) {
            return;
        }
        ftLib = BDFontMetrics.initN();
        if (ftLib == 0L) {
            System.err.println("freetype library not loaded");
            throw new AWTError("freetype lib not loaded");
        }
        String javaHome = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.home");
            }
        });
        File f = new File(javaHome, "lib" + File.separator + "fonts");
        String dir = f.getAbsolutePath() + File.separator;
        fontNameMap = new HashMap(24);
        fontNameMap.put("serif.0", dir + "LucidaBrightRegular.ttf");
        fontNameMap.put("serif.1", dir + "LucidaBrightDemiBold.ttf");
        fontNameMap.put("serif.2", dir + "LucidaBrightItalic.ttf");
        fontNameMap.put("serif.3", dir + "LucidaBrightDemiItalic.ttf");
        fontNameMap.put("sansserif.0", dir + "LucidaSansRegular.ttf");
        fontNameMap.put("sansserif.1", dir + "LucidaSansDemiBold.ttf");
        fontNameMap.put("sansserif.2", dir + "LucidaSansOblique.ttf");
        fontNameMap.put("sansserif.3", dir + "LucidaSansDemiOblique.ttf");
        fontNameMap.put("monospaced.0", dir + "LucidaTypewriterRegular.ttf");
        fontNameMap.put("monospaced.1", dir + "LucidaTypewriterBold.ttf");
        fontNameMap.put("monospaced.2", dir + "LucidaTypewriterOblique.ttf");
        fontNameMap.put("monospaced.3", dir + "LucidaTypewriterBoldOblique.ttf");
        fontNameMap.put("dialog.0", dir + "LucidaSansRegular.ttf");
        fontNameMap.put("dialog.1", dir + "LucidaSansDemiBold.ttf");
        fontNameMap.put("dialog.2", dir + "LucidaSansOblique.ttf");
        fontNameMap.put("dialog.3", dir + "LucidaSansDemiOblique.ttf");
        fontNameMap.put("dialoginput.0", dir + "LucidaTypewriterRegular.ttf");
        fontNameMap.put("dialoginput.1", dir + "LucidaTypewriterBold.ttf");
        fontNameMap.put("dialoginput.2", dir + "LucidaTypewriterOblique.ttf");
        fontNameMap.put("dialoginput.3", dir + "LucidaTypewriterBoldOblique.ttf");
        fontNameMap.put("default.0", dir + "LucidaSansRegular.ttf");
        fontNameMap.put("default.1", dir + "LucidaSansDemiBold.ttf");
        fontNameMap.put("default.2", dir + "LucidaSansOblique.ttf");
        fontNameMap.put("default.3", dir + "LucidaSansDemiOblique.ttf");
    }

    public static synchronized void shutdown() {
        Iterator it = fontMetricsMap.values().iterator();
        while (it.hasNext()) {
            try {
                BDFontMetrics fm = (BDFontMetrics)it.next();
                it.remove();
                fm.destroy();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        BDFontMetrics.destroyN(ftLib);
        ftLib = 0L;
    }

    static synchronized BDFontMetrics getFontMetrics(Font font) {
        String key;
        BDFontMetrics fm = null;
        String nativeName = (String)fontNameMap.get(font.getName().toLowerCase() + "." + font.getStyle());
        if (nativeName == null) {
            nativeName = (String)fontNameMap.get("default." + font.getStyle());
        }
        if ((fm = (BDFontMetrics)fontMetricsMap.get(key = nativeName + "." + font.getSize())) == null) {
            fm = new BDFontMetrics(font, nativeName);
            fontMetricsMap.put(key, fm);
        }
        return fm;
    }

    static synchronized String[] getFontList() {
        BDFontMetrics.init();
        ArrayList<String> fontNames = new ArrayList<String>();
        Iterator fonts = fontNameMap.keySet().iterator();
        while (fonts.hasNext()) {
            String fontname = (String)fonts.next();
            int dotidx = fontname.indexOf(46);
            if (dotidx == -1) {
                dotidx = fontname.length();
            }
            if (fontNames.contains(fontname = fontname.substring(0, dotidx))) continue;
            fontNames.add(fontname);
        }
        return fontNames.toArray(new String[fontNames.size()]);
    }

    public static void registerFont(String name, int style, String path) {
        File f = new File(path);
        if ((path = f.getAbsolutePath()) != null) {
            name = name.toLowerCase() + "." + style;
            fontNameMap.put(name, path);
        }
    }

    public static synchronized boolean registerFont(File f) {
        Logger.unimplemented("BDFontMetrics", "registerFont");
        return false;
    }

    public static synchronized void unregisterFont(String name, int style) {
        name = name.toLowerCase() + "." + style;
        fontNameMap.remove(name);
    }

    private BDFontMetrics(Font font, String nativeName) {
        super(font);
        this.ftFace = this.loadFontN(ftLib, nativeName, font.getSize());
        if (this.ftFace == 0L) {
            throw new AWTError("font face:" + nativeName + " not loaded");
        }
        this.widths = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.widths[i] = this.charWidthN(this.ftFace, (char)i);
        }
    }

    private native long loadFontN(long var1, String var3, int var4);

    private native void destroyFontN(long var1);

    private native int charWidthN(long var1, char var3);

    private native int stringWidthN(long var1, String var3);

    private native int charsWidthN(long var1, char[] var3, int var4, int var5);

    protected synchronized void drawString(BDGraphics g, String string, int x, int y, int rgb) {
        g.drawStringN(this.ftFace, string, x, y, rgb);
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLeading() {
        return this.leading;
    }

    public int getMaxAdvance() {
        return this.maxAdvance;
    }

    public synchronized int charWidth(char c) {
        if (c < '\u0100') {
            return this.widths[c];
        }
        return this.charWidthN(this.ftFace, c);
    }

    public synchronized int stringWidth(String string) {
        return this.stringWidthN(this.ftFace, string);
    }

    public synchronized int charsWidth(char[] chars, int offset, int length) {
        return this.charsWidthN(this.ftFace, chars, offset, length);
    }

    public int[] getWidths() {
        int[] newWidths = new int[256];
        System.arraycopy(this.widths, 0, newWidths, 0, 256);
        return newWidths;
    }

    private void destroy() {
        if (this.ftFace != 0L) {
            this.destroyFontN(this.ftFace);
            this.ftFace = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            super.finalize();
        }
    }

    static {
        fontMetricsMap = new HashMap();
    }
}

