/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import com.ice.tar.TarEntry;
import com.ice.tar.TarGzOutputStream;
import com.ice.tar.TarInputStream;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import vlcskineditor.CustomFileFilter;
import vlcskineditor.FrameUpdater;
import vlcskineditor.Item;
import vlcskineditor.Layout;
import vlcskineditor.PreviewWindow;
import vlcskineditor.ProgressWindow;
import vlcskineditor.Resource;
import vlcskineditor.Skin;
import vlcskineditor.TreeRenderer;
import vlcskineditor.Window;
import vlcskineditor.history.History;
import vlcskineditor.history.ItemDeletionEvent;
import vlcskineditor.history.LayoutDeletionEvent;
import vlcskineditor.history.ResourceDeletionEvent;
import vlcskineditor.history.WindowDeletionEvent;
import vlcskineditor.items.Anchor;
import vlcskineditor.items.Button;
import vlcskineditor.items.Checkbox;
import vlcskineditor.items.Group;
import vlcskineditor.items.Image;
import vlcskineditor.items.Panel;
import vlcskineditor.items.Playtree;
import vlcskineditor.items.RadialSlider;
import vlcskineditor.items.Slider;
import vlcskineditor.items.SliderBackground;
import vlcskineditor.items.Text;
import vlcskineditor.items.Video;
import vlcskineditor.resources.Bitmap;
import vlcskineditor.resources.Font;
import vlcskineditor.resources.SubBitmap;

public class Main
extends JFrame
implements ActionListener,
TreeSelectionListener,
WindowListener,
MouseListener {
    private static final long serialVersionUID = 70L;
    private final String updateURL_s = "http://www.videolan.org/vlc/skineditor_update.php";
    public final String VERSION = "0.7";
    String vlc_dir = "";
    String vlc_skins_dir = "";
    JMenuBar mbar;
    JMenu m_file;
    JMenu m_edit;
    JMenu m_help;
    JMenuItem m_file_new;
    JMenuItem m_file_open;
    JMenuItem m_file_save;
    JMenuItem m_file_test;
    JMenuItem m_file_vlt;
    JMenuItem m_file_png;
    JMenuItem m_file_quit;
    JMenuItem m_edit_undo;
    JMenuItem m_edit_redo;
    JMenuItem m_edit_theme;
    JMenuItem m_edit_global;
    JMenuItem m_edit_up;
    JMenuItem m_edit_down;
    JMenuItem m_edit_right;
    JMenuItem m_edit_left;
    JMenuItem m_help_doc;
    JMenuItem m_help_about;
    JDesktopPane jdesk;
    JInternalFrame resources;
    JInternalFrame windows;
    JInternalFrame items;
    JInternalFrame current_window;
    JTree res_tree;
    JTree win_tree;
    JTree items_tree;
    DefaultTreeModel res_tree_model;
    DefaultTreeModel win_tree_model;
    DefaultTreeModel items_tree_model;
    JButton res_add_bitmap;
    JButton res_add_font;
    JButton res_duplicate;
    JButton res_edit;
    JButton res_del;
    JPopupMenu res_add_bitmap_pu;
    JMenuItem res_add_bitmap_pu_b;
    JMenuItem res_add_bitmap_pu_s;
    JButton win_add_window;
    JButton win_add_layout;
    JButton win_layout_up;
    JButton win_layout_down;
    JButton win_duplicate;
    JButton win_edit;
    JButton win_del;
    JButton items_add;
    JButton items_up;
    JButton items_down;
    JButton items_duplicate;
    JButton items_edit;
    JButton items_del;
    JPopupMenu items_add_pu;
    JMenu items_add_pu_tp;
    JMenuItem items_add_pu_tp_anchor;
    JMenuItem items_add_pu_tp_button;
    JMenuItem items_add_pu_tp_checkbox;
    JMenuItem items_add_pu_tp_image;
    JMenuItem items_add_pu_tp_panel;
    JMenuItem items_add_pu_tp_playtree;
    JMenuItem items_add_pu_tp_slider;
    JMenuItem items_add_pu_tp_text;
    JMenuItem items_add_pu_tp_video;
    JMenuItem items_add_pu_anchor;
    JMenuItem items_add_pu_button;
    JMenuItem items_add_pu_checkbox;
    JMenuItem items_add_pu_image;
    JMenuItem items_add_pu_panel;
    JMenuItem items_add_pu_playtree;
    JMenuItem items_add_pu_slider;
    JMenuItem items_add_pu_text;
    JMenuItem items_add_pu_video;
    Skin s;
    public ImageIcon add_bitmap_icon = this.createIcon("icons/add_bitmap.png");
    public ImageIcon add_font_icon = this.createIcon("icons/add_font.png");
    public ImageIcon copy_icon = this.createIcon("icons/copy.png");
    public ImageIcon edit_icon = this.createIcon("icons/edit.png");
    public ImageIcon edit_undo_icon = this.createIcon("icons/edit-undo.png");
    public ImageIcon edit_redo_icon = this.createIcon("icons/edit-redo.png");
    public ImageIcon editor_icon = this.createIcon("icons/editor.png");
    public ImageIcon delete_icon = this.createIcon("icons/delete.png");
    public ImageIcon add_window_icon = this.createIcon("icons/add_window.png");
    public ImageIcon add_layout_icon = this.createIcon("icons/add_layout.png");
    public ImageIcon add_icon = this.createIcon("icons/add.png");
    public ImageIcon up_icon = this.createIcon("icons/move_up.png");
    public ImageIcon down_icon = this.createIcon("icons/move_down.png");
    public ImageIcon help_icon = this.createIcon("icons/help.png");
    public ImageIcon icon = this.createIcon("icons/icon.png");
    public ImageIcon open_icon = this.createIcon("icons/open.png");
    public ImageIcon save_icon = this.createIcon("icons/save.png");
    public ImageIcon new_icon = this.createIcon("icons/new.png");
    public ImageIcon exit_icon = this.createIcon("icons/exit.png");
    public ImageIcon resources_icon = this.createIcon("icons/resources.png");
    public ImageIcon windows_icon = this.createIcon("icons/windows.png");
    public ImageIcon items_icon = this.createIcon("icons/items.png");
    DefaultTreeCellRenderer tree_renderer = new TreeRenderer();
    String selected_resource;
    String selected_in_windows;
    String selected_window;
    String selected_layout;
    String selected_item;
    JFileChooser base_fc;
    JFileChooser bitmap_adder;
    JFileChooser font_adder;
    JFileChooser vlt_saver;
    PreviewWindow pvwin;
    public boolean saved = false;
    boolean opening = false;
    boolean opened = false;
    public History hist;

    public Main(String[] stringArray) {
        this.setTitle("New skin - VLC Skin Editor 0.7");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.setSize(800, 700);
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("icons/icon16.png")));
        this.mbar = new JMenuBar();
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.m_file = new JMenu("File");
        this.m_file.setMnemonic("F".charAt(0));
        this.m_file_new = new JMenuItem("New");
        this.m_file_new.setIcon(this.new_icon);
        this.m_file_new.setMnemonic("N".charAt(0));
        this.m_file_new.setAccelerator(KeyStroke.getKeyStroke(78, n));
        this.m_file_new.addActionListener(this);
        this.m_file_open = new JMenuItem("Open");
        this.m_file_open.setIcon(this.open_icon);
        this.m_file_open.setMnemonic('O');
        this.m_file_open.setAccelerator(KeyStroke.getKeyStroke(79, n));
        this.m_file_open.addActionListener(this);
        this.m_file_save = new JMenuItem("Save");
        this.m_file_save.setIcon(this.save_icon);
        this.m_file_save.setMnemonic('S');
        this.m_file_save.setAccelerator(KeyStroke.getKeyStroke(83, n));
        this.m_file_save.addActionListener(this);
        this.m_file_test = new JMenuItem("Test skin in VLC...");
        this.m_file_test.setMnemonic('T');
        this.m_file_test.setAccelerator(KeyStroke.getKeyStroke(84, n + 64));
        this.m_file_test.addActionListener(this);
        this.m_file_vlt = new JMenuItem("Export as VLT...");
        this.m_file_vlt.setMnemonic('V');
        this.m_file_vlt.setAccelerator(KeyStroke.getKeyStroke(86, n + 64));
        this.m_file_vlt.addActionListener(this);
        this.m_file_png = new JMenuItem("Save current preview as image");
        this.m_file_png.setMnemonic('p');
        this.m_file_png.addActionListener(this);
        this.m_file_png.setEnabled(false);
        if (System.getProperty("os.name").indexOf("Mac") == -1) {
            this.m_file_quit = new JMenuItem("Exit");
            this.m_file_quit.setIcon(this.exit_icon);
            this.m_file_quit.setMnemonic('x');
            this.m_file_quit.setAccelerator(KeyStroke.getKeyStroke("alt F4"));
            this.m_file_quit.addActionListener(this);
        }
        this.m_file.add(this.m_file_new);
        this.m_file.addSeparator();
        this.m_file.add(this.m_file_open);
        this.m_file.add(this.m_file_save);
        this.m_file.addSeparator();
        this.m_file.add(this.m_file_test);
        this.m_file.add(this.m_file_vlt);
        this.m_file.add(this.m_file_png);
        this.m_file.addSeparator();
        this.m_file.add(this.m_file_quit);
        this.m_edit = new JMenu("Edit");
        this.m_edit.setMnemonic("E".charAt(0));
        this.m_edit_undo = new JMenuItem("Undo");
        this.m_edit_undo.setIcon(this.edit_undo_icon);
        this.m_edit_undo.setMnemonic('U');
        this.m_edit_undo.setAccelerator(KeyStroke.getKeyStroke(90, n));
        this.m_edit_undo.addActionListener(this);
        this.m_edit_redo = new JMenuItem("Redo");
        this.m_edit_redo.setIcon(this.edit_redo_icon);
        this.m_edit_redo.setMnemonic('R');
        this.m_edit_redo.setAccelerator(KeyStroke.getKeyStroke(89, n));
        this.m_edit_redo.addActionListener(this);
        this.m_edit_theme = new JMenuItem("Theme settings");
        this.m_edit_theme.setIcon(this.edit_icon);
        this.m_edit_theme.setMnemonic('I');
        this.m_edit_theme.setAccelerator(KeyStroke.getKeyStroke(73, n));
        this.m_edit_theme.addActionListener(this);
        this.m_edit_global = new JMenuItem("Global variables");
        this.m_edit_global.setMnemonic('G');
        this.m_edit_global.setAccelerator(KeyStroke.getKeyStroke(71, n));
        this.m_edit_global.addActionListener(this);
        this.m_edit_up = new JMenuItem("Move selected item up");
        this.m_edit_up.setAccelerator(KeyStroke.getKeyStroke(38, n));
        this.m_edit_up.addActionListener(this);
        this.m_edit_down = new JMenuItem("Move selected item down");
        this.m_edit_down.setAccelerator(KeyStroke.getKeyStroke(40, n));
        this.m_edit_down.addActionListener(this);
        this.m_edit_left = new JMenuItem("Move selected item left");
        this.m_edit_left.setAccelerator(KeyStroke.getKeyStroke(37, n));
        this.m_edit_left.addActionListener(this);
        this.m_edit_right = new JMenuItem("Move selected item right");
        this.m_edit_right.setAccelerator(KeyStroke.getKeyStroke(39, n));
        this.m_edit_right.addActionListener(this);
        this.m_edit.add(this.m_edit_undo);
        this.m_edit.add(this.m_edit_redo);
        this.m_edit.addSeparator();
        this.m_edit.add(this.m_edit_theme);
        this.m_edit.addSeparator();
        this.m_edit.add(this.m_edit_global);
        this.m_edit.addSeparator();
        this.m_edit.add(this.m_edit_up);
        this.m_edit.add(this.m_edit_down);
        this.m_edit.add(this.m_edit_left);
        this.m_edit.add(this.m_edit_right);
        this.m_help = new JMenu("Help");
        this.m_help.setMnemonic('H');
        this.m_help_doc = new JMenuItem("Online Help");
        this.m_help_doc.setIcon(this.help_icon);
        this.m_help_doc.setMnemonic('D');
        this.m_help_doc.addActionListener(this);
        this.m_help_doc.setAccelerator(KeyStroke.getKeyStroke("F1"));
        this.m_help_about = new JMenuItem("About");
        this.m_help_about.setMnemonic('A');
        this.m_help_about.addActionListener(this);
        this.m_help.add(this.m_help_doc);
        this.m_help.add(this.m_help_about);
        this.mbar.add(this.m_file);
        this.mbar.add(this.m_edit);
        this.mbar.add(this.m_help);
        this.setJMenuBar(this.mbar);
        this.jdesk = new JDesktopPane();
        this.s = new Skin(this);
        this.resources = new JInternalFrame("Resources", true, false);
        this.resources.setFrameIcon(this.resources_icon);
        this.resources.setMinimumSize(new Dimension(190, 200));
        SpringLayout springLayout = new SpringLayout();
        this.resources.setLayout(springLayout);
        this.res_tree_model = new DefaultTreeModel(this.s.getResourcesTree());
        this.res_tree = new JTree(this.res_tree_model);
        ToolTipManager.sharedInstance().registerComponent(this.res_tree);
        this.res_tree.setCellRenderer(this.tree_renderer);
        this.res_tree.setRootVisible(false);
        this.res_tree.setShowsRootHandles(true);
        this.res_tree.getSelectionModel().setSelectionMode(1);
        this.res_tree.addTreeSelectionListener(this);
        this.res_tree.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.res_tree);
        this.resources.add(jScrollPane);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(1));
        this.res_add_bitmap = new JButton("", this.add_bitmap_icon);
        this.res_add_bitmap.setToolTipText("Add a new Bitmap or SubBitmap");
        this.res_add_bitmap.setMaximumSize(new Dimension(24, 24));
        this.res_add_bitmap.setPreferredSize(new Dimension(24, 24));
        this.res_add_bitmap.addActionListener(this);
        this.res_add_font = new JButton("", this.add_font_icon);
        this.res_add_font.setToolTipText("Add a new font");
        this.res_add_font.setMaximumSize(new Dimension(24, 24));
        this.res_add_font.setPreferredSize(new Dimension(24, 24));
        this.res_add_font.addActionListener(this);
        this.res_duplicate = new JButton("", this.copy_icon);
        this.res_duplicate.setToolTipText("Create a copy of the selected resource");
        this.res_duplicate.setPreferredSize(new Dimension(24, 24));
        this.res_duplicate.addActionListener(this);
        this.res_edit = new JButton("", this.edit_icon);
        this.res_edit.setToolTipText("Edit the selected item");
        this.res_edit.setMaximumSize(new Dimension(24, 24));
        this.res_edit.setPreferredSize(new Dimension(24, 24));
        this.res_edit.addActionListener(this);
        this.res_del = new JButton("", this.delete_icon);
        this.res_del.setToolTipText("Delete the selected item");
        this.res_del.setMaximumSize(new Dimension(24, 24));
        this.res_del.setPreferredSize(new Dimension(24, 24));
        this.res_del.addActionListener(this);
        this.resources.add(this.res_add_bitmap);
        this.resources.add(this.res_add_font);
        this.resources.add(this.res_duplicate);
        this.resources.add(this.res_edit);
        this.resources.add(this.res_del);
        springLayout.putConstraint("West", (Component)jScrollPane, 5, "West", (Component)this.resources.getContentPane());
        springLayout.putConstraint("North", (Component)jScrollPane, 5, "North", (Component)this.resources.getContentPane());
        springLayout.putConstraint("North", (Component)this.res_add_bitmap, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_add_font, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_duplicate, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_edit, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_del, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_add_bitmap, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_add_font, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_edit, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_del, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("West", (Component)this.res_add_bitmap, 5, "West", (Component)this.resources.getContentPane());
        springLayout.putConstraint("West", (Component)this.res_add_font, 5, "East", (Component)this.res_add_bitmap);
        springLayout.putConstraint("West", (Component)this.res_duplicate, 5, "East", (Component)this.res_add_font);
        springLayout.putConstraint("West", (Component)this.res_edit, 5, "East", (Component)this.res_duplicate);
        springLayout.putConstraint("West", (Component)this.res_del, 5, "East", (Component)this.res_edit);
        springLayout.putConstraint("South", (Component)this.resources.getContentPane(), 34, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.resources.getContentPane(), 5, "North", (Component)jScrollPane);
        springLayout.putConstraint("East", (Component)this.resources.getContentPane(), 5, "East", (Component)jScrollPane);
        this.resources.pack();
        this.resources.setSize(190, 200);
        this.resources.setVisible(true);
        this.windows = new JInternalFrame("Windows", true, false);
        this.windows.setFrameIcon(this.windows_icon);
        this.windows.setMinimumSize(new Dimension(190, 150));
        SpringLayout springLayout2 = new SpringLayout();
        this.windows.setLayout(springLayout2);
        this.win_tree_model = new DefaultTreeModel(this.s.getWindowsTree());
        this.win_tree = new JTree(this.win_tree_model);
        ToolTipManager.sharedInstance().registerComponent(this.win_tree);
        this.win_tree.setCellRenderer(this.tree_renderer);
        this.win_tree.setRootVisible(false);
        this.win_tree.setShowsRootHandles(true);
        this.win_tree.getSelectionModel().setSelectionMode(1);
        this.win_tree.addTreeSelectionListener(this);
        this.win_tree.addMouseListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.win_tree);
        this.windows.add(jScrollPane2);
        jScrollPane2.setBorder(BorderFactory.createEtchedBorder(1));
        this.win_add_window = new JButton("", this.add_window_icon);
        this.win_add_window.setToolTipText("Add a new window");
        this.win_add_window.setMaximumSize(new Dimension(24, 24));
        this.win_add_window.setPreferredSize(new Dimension(24, 24));
        this.win_add_window.addActionListener(this);
        this.win_add_layout = new JButton("", this.add_layout_icon);
        this.win_add_layout.setToolTipText("Add a new layout to the selected window");
        this.win_add_layout.setMaximumSize(new Dimension(24, 24));
        this.win_add_layout.setPreferredSize(new Dimension(24, 24));
        this.win_add_layout.addActionListener(this);
        this.win_layout_up = new JButton("", this.up_icon);
        this.win_layout_up.setToolTipText("Move selected layout up in hierarchy (last layout is the default layout for the window)");
        this.win_layout_up.setMaximumSize(new Dimension(24, 12));
        this.win_layout_up.setPreferredSize(new Dimension(24, 12));
        this.win_layout_up.addActionListener(this);
        this.win_layout_down = new JButton("", this.down_icon);
        this.win_layout_down.setToolTipText("Move selected layout down in hierarchy (last layout is the default layout for the window)");
        this.win_layout_down.setMaximumSize(new Dimension(24, 12));
        this.win_layout_down.setPreferredSize(new Dimension(24, 12));
        this.win_layout_down.addActionListener(this);
        this.win_duplicate = new JButton("", this.copy_icon);
        this.win_duplicate.setToolTipText("Create a copy of the selected window or layout");
        this.win_duplicate.setMaximumSize(new Dimension(24, 24));
        this.win_duplicate.setPreferredSize(new Dimension(24, 24));
        this.win_duplicate.addActionListener(this);
        this.win_edit = new JButton("", this.edit_icon);
        this.win_edit.setToolTipText("Edit the selected resource");
        this.win_edit.setMaximumSize(new Dimension(24, 24));
        this.win_edit.setPreferredSize(new Dimension(24, 24));
        this.win_edit.addActionListener(this);
        this.win_del = new JButton("", this.delete_icon);
        this.win_del.setToolTipText("Delete the selected resource");
        this.win_del.setMaximumSize(new Dimension(24, 24));
        this.win_del.setPreferredSize(new Dimension(24, 24));
        this.win_del.addActionListener(this);
        this.windows.add(this.win_add_window);
        this.windows.add(this.win_add_layout);
        this.windows.add(this.win_duplicate);
        this.windows.add(this.win_edit);
        this.windows.add(this.win_layout_up);
        this.windows.add(this.win_layout_down);
        this.windows.add(this.win_del);
        springLayout2.putConstraint("West", (Component)jScrollPane2, 5, "West", (Component)this.windows.getContentPane());
        springLayout2.putConstraint("North", (Component)jScrollPane2, 5, "North", (Component)this.windows.getContentPane());
        springLayout2.putConstraint("North", (Component)this.win_add_window, 5, "South", (Component)jScrollPane2);
        springLayout2.putConstraint("North", (Component)this.win_add_layout, 5, "South", (Component)jScrollPane2);
        springLayout2.putConstraint("North", (Component)this.win_layout_up, 5, "South", (Component)jScrollPane2);
        springLayout2.putConstraint("North", (Component)this.win_layout_down, 0, "South", (Component)this.win_layout_up);
        springLayout2.putConstraint("North", (Component)this.win_duplicate, 5, "South", (Component)jScrollPane2);
        springLayout2.putConstraint("North", (Component)this.win_edit, 5, "South", (Component)jScrollPane2);
        springLayout2.putConstraint("North", (Component)this.win_del, 5, "South", (Component)jScrollPane2);
        springLayout2.putConstraint("West", (Component)this.win_add_window, 5, "West", (Component)this.windows.getContentPane());
        springLayout2.putConstraint("West", (Component)this.win_add_layout, 5, "East", (Component)this.win_add_window);
        springLayout2.putConstraint("West", (Component)this.win_layout_up, 5, "East", (Component)this.win_add_layout);
        springLayout2.putConstraint("West", (Component)this.win_layout_down, 5, "East", (Component)this.win_add_layout);
        springLayout2.putConstraint("West", (Component)this.win_duplicate, 5, "East", (Component)this.win_layout_up);
        springLayout2.putConstraint("West", (Component)this.win_edit, 5, "East", (Component)this.win_duplicate);
        springLayout2.putConstraint("West", (Component)this.win_del, 5, "East", (Component)this.win_edit);
        springLayout2.putConstraint("South", (Component)this.windows.getContentPane(), 34, "South", (Component)jScrollPane2);
        springLayout2.putConstraint("North", (Component)this.windows.getContentPane(), 5, "North", (Component)jScrollPane2);
        springLayout2.putConstraint("East", (Component)this.windows.getContentPane(), 5, "East", (Component)jScrollPane2);
        this.windows.pack();
        this.windows.setSize(190, 150);
        this.windows.setVisible(true);
        this.items = new JInternalFrame("Items", true, false);
        this.items.setFrameIcon(this.items_icon);
        this.items.setMinimumSize(new Dimension(190, 150));
        SpringLayout springLayout3 = new SpringLayout();
        this.items.setLayout(springLayout3);
        this.items_tree_model = new DefaultTreeModel(this.s.getItemsTree());
        this.items_tree = new JTree(this.items_tree_model);
        ToolTipManager.sharedInstance().registerComponent(this.items_tree);
        this.items_tree.setCellRenderer(this.tree_renderer);
        this.items_tree.setRootVisible(false);
        this.items_tree.getSelectionModel().setSelectionMode(1);
        this.items_tree.addTreeSelectionListener(this);
        this.items_tree.setShowsRootHandles(true);
        this.items_tree.addMouseListener(this);
        JScrollPane jScrollPane3 = new JScrollPane(this.items_tree);
        this.items.add(jScrollPane3);
        jScrollPane3.setBorder(BorderFactory.createEtchedBorder(1));
        this.items_add = new JButton("", this.add_icon);
        this.items_add.setToolTipText("Add a new item");
        this.items_add.setMaximumSize(new Dimension(24, 24));
        this.items_add.setPreferredSize(new Dimension(24, 24));
        this.items_add.addActionListener(this);
        this.items_up = new JButton("", this.up_icon);
        this.items_up.setToolTipText("Move selected item up in hierarchy");
        this.items_up.setMaximumSize(new Dimension(24, 12));
        this.items_up.setPreferredSize(new Dimension(24, 12));
        this.items_up.addActionListener(this);
        this.items_down = new JButton("", this.down_icon);
        this.items_down.setToolTipText("Move selected item down in hierarchy");
        this.items_down.setMaximumSize(new Dimension(24, 12));
        this.items_down.setPreferredSize(new Dimension(24, 12));
        this.items_down.addActionListener(this);
        this.items_duplicate = new JButton("", this.copy_icon);
        this.items_duplicate.setToolTipText("Create a copy of the selected resource");
        this.items_duplicate.setMaximumSize(new Dimension(24, 24));
        this.items_duplicate.setPreferredSize(new Dimension(24, 24));
        this.items_duplicate.addActionListener(this);
        this.items_edit = new JButton("", this.edit_icon);
        this.items_edit.setToolTipText("Edit the selected item");
        this.items_edit.setMaximumSize(new Dimension(24, 24));
        this.items_edit.setPreferredSize(new Dimension(24, 24));
        this.items_edit.addActionListener(this);
        this.items_del = new JButton("", this.delete_icon);
        this.items_del.setToolTipText("Delete the selected item");
        this.items_del.setMaximumSize(new Dimension(24, 24));
        this.items_del.setPreferredSize(new Dimension(24, 24));
        this.items_del.addActionListener(this);
        this.items.add(this.items_add);
        this.items.add(this.items_up);
        this.items.add(this.items_down);
        this.items.add(this.items_duplicate);
        this.items.add(this.items_edit);
        this.items.add(this.items_del);
        springLayout3.putConstraint("West", (Component)jScrollPane3, 5, "West", (Component)this.items.getContentPane());
        springLayout3.putConstraint("North", (Component)jScrollPane3, 5, "North", (Component)this.items.getContentPane());
        springLayout3.putConstraint("North", (Component)this.items_add, 5, "South", (Component)jScrollPane3);
        springLayout3.putConstraint("North", (Component)this.items_up, 5, "South", (Component)jScrollPane3);
        springLayout3.putConstraint("North", (Component)this.items_down, 0, "South", (Component)this.items_up);
        springLayout3.putConstraint("North", (Component)this.items_duplicate, 5, "South", (Component)jScrollPane3);
        springLayout3.putConstraint("North", (Component)this.items_edit, 5, "South", (Component)jScrollPane3);
        springLayout3.putConstraint("North", (Component)this.items_del, 5, "South", (Component)jScrollPane3);
        springLayout3.putConstraint("West", (Component)this.items_add, 5, "West", (Component)this.items.getContentPane());
        springLayout3.putConstraint("West", (Component)this.items_up, 5, "East", (Component)this.items_add);
        springLayout3.putConstraint("West", (Component)this.items_down, 5, "East", (Component)this.items_add);
        springLayout3.putConstraint("West", (Component)this.items_duplicate, 5, "East", (Component)this.items_up);
        springLayout3.putConstraint("West", (Component)this.items_edit, 5, "East", (Component)this.items_duplicate);
        springLayout3.putConstraint("West", (Component)this.items_del, 5, "East", (Component)this.items_edit);
        springLayout3.putConstraint("South", (Component)this.items.getContentPane(), 34, "South", (Component)jScrollPane3);
        springLayout3.putConstraint("North", (Component)this.items.getContentPane(), 5, "North", (Component)jScrollPane3);
        springLayout3.putConstraint("East", (Component)this.items.getContentPane(), 5, "East", (Component)jScrollPane3);
        this.items.pack();
        this.items.setSize(190, 200);
        this.items.setVisible(true);
        this.pvwin = new PreviewWindow(this);
        this.jdesk.add(this.resources);
        this.jdesk.add(this.windows);
        this.jdesk.add(this.items);
        this.jdesk.add(this.pvwin.frame);
        this.resources.setLocation(0, 0);
        this.windows.setLocation(0, 200);
        this.items.setLocation(0, 350);
        this.pvwin.frame.setLocation(250, 0);
        this.res_add_bitmap_pu = new JPopupMenu();
        this.res_add_bitmap_pu_b = new JMenuItem("Add Bitmap/s");
        this.res_add_bitmap_pu_b.addActionListener(this);
        this.res_add_bitmap_pu.add(this.res_add_bitmap_pu_b);
        this.res_add_bitmap_pu_s = new JMenuItem("Add SubBitmap");
        this.res_add_bitmap_pu_s.addActionListener(this);
        this.res_add_bitmap_pu.add(this.res_add_bitmap_pu_s);
        this.jdesk.add(this.res_add_bitmap_pu);
        this.items_add_pu = new JPopupMenu();
        this.items_add_pu_tp = new JMenu("Add to selected Panel");
        this.items_add_pu_tp_anchor = new JMenuItem("Anchor");
        this.items_add_pu_tp_anchor.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_anchor);
        this.items_add_pu_tp_button = new JMenuItem("Button");
        this.items_add_pu_tp_button.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_button);
        this.items_add_pu_tp_checkbox = new JMenuItem("Checkbox");
        this.items_add_pu_tp_checkbox.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_checkbox);
        this.items_add_pu_tp_image = new JMenuItem("Image");
        this.items_add_pu_tp_image.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_image);
        this.items_add_pu_tp_panel = new JMenuItem("Panel");
        this.items_add_pu_tp_panel.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_panel);
        this.items_add_pu_tp_playtree = new JMenuItem("Playtree");
        this.items_add_pu_tp_playtree.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_playtree);
        this.items_add_pu_tp_slider = new JMenuItem("Slider");
        this.items_add_pu_tp_slider.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_slider);
        this.items_add_pu_tp_text = new JMenuItem("Text");
        this.items_add_pu_tp_text.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_text);
        this.items_add_pu_tp_video = new JMenuItem("Video");
        this.items_add_pu_tp_video.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_video);
        this.items_add_pu.add(this.items_add_pu_tp);
        this.items_add_pu.addSeparator();
        this.items_add_pu_anchor = new JMenuItem("Anchor");
        this.items_add_pu_anchor.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_anchor);
        this.items_add_pu_button = new JMenuItem("Button");
        this.items_add_pu_button.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_button);
        this.items_add_pu_checkbox = new JMenuItem("Checkbox");
        this.items_add_pu_checkbox.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_checkbox);
        this.items_add_pu_image = new JMenuItem("Image");
        this.items_add_pu_image.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_image);
        this.items_add_pu_panel = new JMenuItem("Panel");
        this.items_add_pu_panel.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_panel);
        this.items_add_pu_playtree = new JMenuItem("Playtree");
        this.items_add_pu_playtree.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_playtree);
        this.items_add_pu_slider = new JMenuItem("Slider");
        this.items_add_pu_slider.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_slider);
        this.items_add_pu_text = new JMenuItem("Text");
        this.items_add_pu_text.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_text);
        this.items_add_pu_video = new JMenuItem("Video");
        this.items_add_pu_video.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_video);
        this.jdesk.add(this.items_add_pu);
        this.jdesk.setMinimumSize(new Dimension(800, 600));
        this.add(this.jdesk);
        this.setVisible(true);
        this.setSize(800, 600);
        this.update();
        this.getVLCdirectory();
        if (stringArray.length > 0) {
            File file = new File(stringArray[0]);
            if (file.exists()) {
                this.openFile(file);
            }
        } else {
            this.showWelcomeDialog();
        }
    }

    private void getVLCdirectory() {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            try {
                RegistryKey registryKey = Registry.openSubkey(Registry.HKEY_LOCAL_MACHINE, "Software\\VideoLAN\\VLC", 1);
                String string = registryKey.getStringValue("InstallDir");
                this.vlc_dir = string + File.separator;
                this.vlc_skins_dir = this.vlc_dir + "skins";
            }
            catch (Exception exception) {
                System.err.println("Could not read VLC installation directory from Registry. VLC might not be properly installed.");
                exception.printStackTrace();
            }
        } else if (System.getProperty("os.name").indexOf("Linux") != -1) {
            this.vlc_skins_dir = "~/.vlc/skins2/";
        }
        if (this.base_fc == null) {
            this.base_fc = new JFileChooser();
        }
        this.base_fc.setCurrentDirectory(new File(this.vlc_skins_dir));
    }

    private void showWelcomeDialog() {
        Object[] objectArray = new Object[]{"Create a new skin", "Open an exisiting skin", "Quit"};
        int n = JOptionPane.showOptionDialog(this, "What would you like to do?", "Welcome to the VLC Skin Editor", 1, 3, null, objectArray, objectArray[1]);
        if (n == 0) {
            this.createNew();
        } else if (n == 1) {
            this.openFile();
        } else {
            System.exit(0);
        }
    }

    private void openFile() {
        this.opening = true;
        String[] stringArray = new String[]{"xml", "vlt"};
        if (System.getProperty("os.name").indexOf("Mac") == -1) {
            this.base_fc.setFileFilter(new CustomFileFilter(this.base_fc, stringArray, "*.xml (VLC XML-Skin Files), *.vlt (Packed XML-Skins)", false, this.vlc_dir));
            int n = this.base_fc.showOpenDialog(this);
            if (n == 0) {
                this.openFile(this.base_fc.getSelectedFile());
                this.opening = false;
            } else {
                this.opening = false;
                if (!this.opened) {
                    this.showWelcomeDialog();
                }
            }
        } else {
            FileDialog fileDialog = new FileDialog(this);
            fileDialog.setMode(0);
            fileDialog.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return file.getName().toUpperCase().matches("*.XML");
                }
            });
            fileDialog.setVisible(true);
            String string = fileDialog.getFile();
            if (string != null) {
                this.openFile(new File(fileDialog.getDirectory(), fileDialog.getFile()));
                this.opening = false;
            } else {
                this.opening = false;
                if (!this.opened) {
                    this.showWelcomeDialog();
                }
            }
        }
    }

    private void openFile(File object) {
        if (!((File)object).exists()) {
            JOptionPane.showMessageDialog(this, "The file \"" + ((File)object).getPath() + "\" does not exist and thus could not be opened!", "Error while opening file", 0);
            if (!this.opened) {
                this.showWelcomeDialog();
            }
            return;
        }
        this.opening = true;
        ProgressWindow progressWindow = new ProgressWindow(this, "");
        if (((File)object).toString().toLowerCase().endsWith(".vlt")) {
            int n;
            BufferedOutputStream bufferedOutputStream;
            FileOutputStream fileOutputStream;
            BufferedInputStream bufferedInputStream;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Closeable closeable;
            String string = ((File)object).getName().replaceAll(".vlt", "");
            Object[] objectArray = new Object[]{"Yes, unpack", "No, cancel"};
            int n2 = JOptionPane.showOptionDialog(this, "The VLT file will be unpacked to a subfolder called \"" + string + "_unpacked\".\nDo you want to continue?", "Importing a VLT file", 1, 3, null, objectArray, objectArray[1]);
            if (n2 != 0) {
                this.showWelcomeDialog();
            }
            File file = new File(((File)object).getParent(), string + "_unpacked");
            file.mkdirs();
            boolean bl = false;
            progressWindow.setText("Unpacking VLT file...");
            progressWindow.setVisible(true);
            try {
                closeable = new ZipFile((File)object);
                object5 = ((ZipFile)closeable).entries();
                while (object5.hasMoreElements()) {
                    object4 = object5.nextElement();
                    object3 = new File(file, ((ZipEntry)object4).getName());
                    if (((ZipEntry)object4).getName().endsWith("theme.xml")) {
                        object = object3;
                    }
                    if (((ZipEntry)object4).isDirectory()) {
                        ((File)object3).mkdirs();
                        continue;
                    }
                    object2 = ((ZipFile)closeable).getInputStream((ZipEntry)object4);
                    bufferedInputStream = new BufferedInputStream((InputStream)object2);
                    ((File)object3).getParentFile().mkdirs();
                    fileOutputStream = new FileOutputStream((File)object3);
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    n = 0;
                    while ((n = bufferedInputStream.read()) != -1) {
                        bufferedOutputStream.write((byte)n);
                    }
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    bufferedInputStream.close();
                    ((InputStream)object2).close();
                }
                bl = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (!bl) {
                try {
                    closeable = new FileInputStream((File)object);
                    object5 = new GZIPInputStream((InputStream)closeable);
                    object4 = new TarInputStream((InputStream)object5);
                    object3 = null;
                    while ((object3 = ((TarInputStream)object4).getNextEntry()) != null) {
                        object2 = new File(file, ((TarEntry)object3).getName());
                        if (((TarEntry)object3).getName().endsWith("theme.xml")) {
                            object = object2;
                        }
                        if (((TarEntry)object3).isDirectory()) {
                            ((File)object2).mkdirs();
                            continue;
                        }
                        bufferedInputStream = new BufferedInputStream((InputStream)object4);
                        ((File)object2).getParentFile().mkdirs();
                        fileOutputStream = new FileOutputStream((File)object2);
                        bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                        n = 0;
                        while ((n = bufferedInputStream.read()) != -1) {
                            bufferedOutputStream.write((byte)n);
                        }
                        bufferedOutputStream.close();
                        fileOutputStream.close();
                    }
                    ((TarInputStream)object4).close();
                    ((GZIPInputStream)object5).close();
                    ((FileInputStream)closeable).close();
                    bl = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (!bl) {
                progressWindow.setVisible(false);
                JOptionPane.showMessageDialog(this, "VLT file could not be unpacked!", "Could not unpack VLT file", 0);
                this.opening = false;
                return;
            }
            if (object == this.base_fc.getSelectedFile()) {
                progressWindow.setVisible(false);
                JOptionPane.showMessageDialog(this, "Could not find \"theme.xml\" inside the unpacked contents of the VLT file\ntry opening it manually.", "Could not find theme.xml", 0);
                this.opening = false;
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        progressWindow.setText("Parsing XML...");
        progressWindow.setVisible(true);
        this.setTitle(((File)object).toString() + " - VLC Skin Editor " + "0.7");
        this.pvwin.clearLayout();
        this.m_file_png.setEnabled(false);
        this.s.open((File)object);
        this.selected_resource = null;
        this.selected_in_windows = null;
        this.selected_window = null;
        this.selected_item = null;
        this.saved = true;
        this.opening = false;
        this.opened = true;
        progressWindow.setVisible(false);
        this.hist = new History(this);
    }

    private void createNew() {
        this.base_fc.setFileFilter(new CustomFileFilter(this.base_fc, "xml", "*.xml (VLC XML-Skin Files)", false, this.vlc_dir));
        int n = this.base_fc.showSaveDialog(this);
        if (n != 0) {
            if (!this.opened) {
                this.showWelcomeDialog();
            }
        } else {
            File file = this.base_fc.getSelectedFile();
            if (!file.getPath().toLowerCase().endsWith(".xml")) {
                file = new File(file.getPath() + ".xml");
            }
            this.setTitle(file.getPath() + " - VLC Skin Editor " + "0.7");
            this.s.createNew(file);
            this.selected_resource = null;
            this.selected_in_windows = null;
            this.selected_window = null;
            this.selected_item = null;
            this.saved = false;
            this.opened = true;
            this.hist = new History(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.m_file_new)) {
            this.createNew();
        } else if (actionEvent.getSource().equals(this.m_file_open)) {
            this.openFile();
        } else if (actionEvent.getSource().equals(this.m_file_save)) {
            this.s.save();
            this.saved = true;
        } else if (actionEvent.getSource().equals(this.m_file_test)) {
            this.s.save();
            this.saved = true;
            String[] stringArray = new String[]{this.vlc_dir + "vlc", "-I", "skins2", "--skins2-last=" + this.s.skinfile.toString(), "--skins2-systray"};
            try {
                Runtime.getRuntime().exec(stringArray);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "VLC Media Player could not be launched", "Error", 0);
            }
        } else if (actionEvent.getSource().equals(this.m_file_vlt)) {
            if (this.vlt_saver == null) {
                this.vlt_saver = new JFileChooser();
                this.vlt_saver.setCurrentDirectory(new File(this.vlc_skins_dir));
                this.vlt_saver.setFileFilter(new CustomFileFilter(this.vlt_saver, "vlt", ".vlt  (VideoLAN Theme)", false, ""));
                this.vlt_saver.setAcceptAllFileFilterUsed(false);
            }
            int n = this.vlt_saver.showSaveDialog(this);
            File file = null;
            if (n == 0) {
                file = this.vlt_saver.getSelectedFile();
                if (!file.getPath().toLowerCase().endsWith(".vlt")) {
                    file = new File(file.getPath() + ".vlt");
                }
            } else {
                return;
            }
            ProgressWindow progressWindow = new ProgressWindow(this, "");
            progressWindow.setText("Creating VLT archive...");
            progressWindow.setVisible(true);
            try {
                int n2;
                TarGzOutputStream tarGzOutputStream = new TarGzOutputStream(new FileOutputStream(file));
                TarEntry tarEntry = new TarEntry(this.s.skinfile);
                tarEntry.setName("theme.xml");
                tarGzOutputStream.putNextEntry(tarEntry);
                FileInputStream fileInputStream = new FileInputStream(this.s.skinfile);
                while ((n2 = fileInputStream.read()) != -1) {
                    tarGzOutputStream.write(n2);
                }
                fileInputStream.close();
                tarGzOutputStream.closeEntry();
                LinkedList<String> linkedList = new LinkedList<String>();
                for (int i = 0; i < this.s.resources.size(); ++i) {
                    int n3;
                    FileInputStream fileInputStream2;
                    String string;
                    Resource resource;
                    if (this.s.resources.get((int)i).type.equals("Bitmap")) {
                        try {
                            resource = (Bitmap)this.s.resources.get(i);
                            string = this.s.skinfolder + resource.file;
                            if (linkedList.contains(string)) continue;
                            tarGzOutputStream.putNextEntry(new TarEntry(resource.file));
                            fileInputStream2 = new FileInputStream(string);
                            while ((n3 = fileInputStream2.read()) != -1) {
                                tarGzOutputStream.write(n3);
                            }
                            fileInputStream2.close();
                            tarGzOutputStream.closeEntry();
                            linkedList.add(string);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            progressWindow.setVisible(false);
                            JOptionPane.showMessageDialog(this, "VLT file could not be created!", "Could not create VLT file", 0);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!this.s.resources.get((int)i).type.equals("Font")) continue;
                    try {
                        resource = (Font)this.s.resources.get(i);
                        string = this.s.skinfolder + ((Font)resource).file;
                        if (linkedList.contains(string)) continue;
                        tarGzOutputStream.putNextEntry(new TarEntry(((Font)resource).file));
                        fileInputStream2 = new FileInputStream(string);
                        while ((n3 = fileInputStream2.read()) != -1) {
                            tarGzOutputStream.write(n3);
                        }
                        fileInputStream2.close();
                        tarGzOutputStream.closeEntry();
                        linkedList.add(string);
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        progressWindow.setVisible(false);
                        JOptionPane.showMessageDialog(this, "VLT file could not be created!", "Could not create VLT file", 0);
                    }
                }
                tarGzOutputStream.close();
                progressWindow.setVisible(false);
                JOptionPane.showMessageDialog(this, "VLT file created successfully!", "VLT file created", 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                progressWindow.setVisible(false);
                JOptionPane.showMessageDialog(this, "VLT file could not be created!", "Could not create VLT file", 0);
                return;
            }
        } else if (actionEvent.getSource().equals(this.m_file_png)) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new CustomFileFilter(jFileChooser, "png", "*.PNG (Portable Network Graphic)", false, ""));
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                if (!file.getPath().toLowerCase().endsWith(".png")) {
                    file = new File(file.getPath() + ".png");
                }
                this.pvwin.savePNG(file);
            }
        } else if (actionEvent.getSource().equals(this.m_file_quit)) {
            if (!this.saved) {
                Object[] objectArray = new Object[]{"Yes", "No", "Don't quit"};
                int n = JOptionPane.showOptionDialog(this, "Would you like to save your skin before exiting?", "Your changes were not saved", 1, 3, null, objectArray, objectArray[1]);
                if (n == 0) {
                    this.s.save();
                    System.exit(0);
                } else if (n == 1) {
                    System.exit(0);
                }
            } else {
                System.exit(0);
            }
        } else if (actionEvent.getSource().equals(this.m_edit_theme)) {
            this.s.showThemeOptions();
        } else if (actionEvent.getSource().equals(this.m_edit_global)) {
            this.s.gvars.showOptions();
        } else if (actionEvent.getSource().equals(this.m_help_doc)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/", 2);
            }
        } else if (actionEvent.getSource().equals(this.m_help_about)) {
            JOptionPane.showMessageDialog(this, "Copyright 2007-2008 The VideoLAN Team\nLead programmer: Daniel Dreibrodt (daniel.dreibrodt@googlemail.com)\nhttp://www.videolan.org/vlc/skineditor.php\nReleased under terms of the GPL 2+\n\nCredits:\nTimothy Gerard Endres for registry access and TAR support (Public Domain)\nThe Tango! Desktop Project (http://tango.freedesktop.org/) for some icons (Creative Commons BY-SA 2.5)\nCyril Deguet (asmax@via.ecp.fr) and Olivier Teuliere (ipkiss@via.ecp.fr) for the Boolean Expression Evaluator and Bezier code (GPL 2+)", "About VLC Skin Editor", 1, this.icon);
        } else if (actionEvent.getSource().equals(this.res_add_bitmap)) {
            this.res_add_bitmap_pu.show(this.res_add_bitmap, 0, 0);
        } else if (actionEvent.getSource().equals(this.res_add_bitmap_pu_b)) {
            int n;
            if (this.bitmap_adder == null) {
                this.bitmap_adder = new JFileChooser();
                this.bitmap_adder.setFileFilter(new CustomFileFilter(this.bitmap_adder, "png", "*.png (Portable Network Graphic) inside the XML file's directory", true, this.s.skinfolder));
                this.bitmap_adder.setCurrentDirectory(new File(this.s.skinfolder));
                this.bitmap_adder.setAcceptAllFileFilterUsed(false);
                this.bitmap_adder.setMultiSelectionEnabled(true);
            }
            if ((n = this.bitmap_adder.showOpenDialog(this)) == 0) {
                File[] fileArray = this.bitmap_adder.getSelectedFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.s.resources.add(new Bitmap(this.s, fileArray[i]));
                }
                this.s.updateResources();
            }
        } else if (actionEvent.getSource().equals(this.res_add_bitmap_pu_s)) {
            if (this.selected_resource != null) {
                Resource resource = this.s.getResource(this.selected_resource);
                if (resource != null) {
                    if (resource.getClass() == Bitmap.class) {
                        Bitmap bitmap = (Bitmap)resource;
                        bitmap.SubBitmaps.add(new SubBitmap(this.s, bitmap));
                    } else if (resource.getClass() == SubBitmap.class) {
                        SubBitmap subBitmap = (SubBitmap)resource;
                        Bitmap bitmap = subBitmap.getParentBitmap();
                        bitmap.SubBitmaps.add(new SubBitmap(this.s, bitmap));
                    } else {
                        JOptionPane.showMessageDialog(this, "The selected resource is no bitmap!", "Could not add subbitmap", 1);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "No parent bitmap selected!", "Could not add subbitmap", 1);
                }
            } else {
                JOptionPane.showMessageDialog(this, "No parent bitmap selected!", "Could not add subbitmap", 1);
            }
        } else if (actionEvent.getSource().equals(this.res_add_font)) {
            int n;
            if (this.font_adder == null) {
                this.font_adder = new JFileChooser();
                String[] stringArray = new String[]{"ttf", "otf"};
                this.font_adder.setFileFilter(new CustomFileFilter(this.font_adder, stringArray, "*.otf/*.ttf (Open and true type fonts) inside the XML file's directory", true, this.s.skinfolder));
                this.font_adder.setCurrentDirectory(new File(this.s.skinfolder));
                this.font_adder.setAcceptAllFileFilterUsed(false);
                this.font_adder.setMultiSelectionEnabled(true);
            }
            if ((n = this.font_adder.showOpenDialog(this)) == 0) {
                File[] fileArray = this.font_adder.getSelectedFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.s.resources.add(new Font(this.s, fileArray[i]));
                }
                this.s.updateResources();
            }
        } else if (actionEvent.getSource().equals(this.res_duplicate)) {
            if (this.selected_resource == null) {
                return;
            }
            Resource resource = this.s.getResource(this.selected_resource);
            if (resource == null) {
                return;
            }
            String string = JOptionPane.showInputDialog(this, "Please enter the rename pattern for the duplicated objects.\n%oldid% will be replaced by the old ID of the object.", "%oldid%_copy");
            if (resource.getClass() == Bitmap.class) {
                Bitmap bitmap = (Bitmap)resource;
                Bitmap bitmap2 = new Bitmap(bitmap.returnCode(""), this.s);
                bitmap2.renameForCopy(string);
                this.s.resources.add(bitmap2);
                this.s.updateResources();
                this.s.expandResource(bitmap.id);
            } else if (resource.getClass() == SubBitmap.class) {
                SubBitmap subBitmap = (SubBitmap)resource;
                SubBitmap subBitmap2 = new SubBitmap(subBitmap.returnCode(""), this.s, subBitmap.getParentBitmap());
                subBitmap2.renameForCopy(string);
                subBitmap.getParentBitmap().SubBitmaps.add(subBitmap2);
                this.s.updateResources();
                this.s.expandResource(subBitmap.id);
            } else {
                Font font = (Font)resource;
                Font font2 = new Font(font.returnCode(""), this.s);
                font2.renameForCopy(string);
                this.s.resources.add(font2);
                this.s.updateResources();
                this.s.expandResource(font.id);
            }
        } else if (actionEvent.getSource().equals(this.win_duplicate)) {
            if (this.selected_window == null) {
                return;
            }
            String string = JOptionPane.showInputDialog(this, "Please enter the rename pattern for the duplicated objects.\n%oldid% will be replaced by the old ID of the object.", "%oldid%_copy");
            if (this.selected_layout == null) {
                Window window = this.s.getWindow(this.selected_window);
                if (window == null) {
                    return;
                }
                Window window2 = new Window(window.returnCode(""), this.s);
                window2.renameForCopy(string);
                this.s.windows.add(window2);
                this.s.updateWindows();
            } else {
                Window window = this.s.getWindow(this.selected_window);
                Layout layout = window.getLayout(this.selected_layout);
                Layout layout2 = new Layout(layout.returnCode(""), window, this.s);
                layout2.renameForCopy(string);
                window.layouts.add(layout2);
                this.s.updateWindows();
                this.s.expandLayout(layout2.id);
            }
        } else if (actionEvent.getSource().equals(this.items_duplicate)) {
            if (this.selected_item == null) {
                return;
            }
            String string = JOptionPane.showInputDialog(this, "Please enter the rename pattern for the duplicated objects.\n%oldid% will be replaced by the old ID of the object.", "%oldid%_copy");
            Item item = this.s.getItem(this.selected_item);
            if (item == null) {
                return;
            }
            if (item.getClass() == Anchor.class) {
                Anchor anchor = new Anchor(item.returnCode(""), this.s);
                anchor.id = item.id;
                anchor.renameForCopy(string);
                this.s.getParentListOf(item.id).add(anchor);
                this.s.updateItems();
                this.s.expandItem(anchor.id);
            } else if (item.getClass() == Button.class) {
                Button button = new Button(item.returnCode(""), this.s);
                button.renameForCopy(string);
                this.s.getParentListOf(item.id).add(button);
                this.s.updateItems();
                this.s.expandItem(button.id);
            } else if (item.getClass() == Checkbox.class) {
                Checkbox checkbox = new Checkbox(item.returnCode(""), this.s);
                checkbox.renameForCopy(string);
                this.s.getParentListOf(item.id).add(checkbox);
                this.s.updateItems();
                this.s.expandItem(checkbox.id);
            } else if (item.getClass() == Group.class) {
                Group group = new Group(item.returnCode(""), this.s);
                group.renameForCopy(string);
                this.s.getParentListOf(item.id).add(group);
                this.s.updateItems();
                this.s.expandItem(group.id);
            } else if (item.getClass() == Image.class) {
                Image image = new Image(item.returnCode(""), this.s);
                image.renameForCopy(string);
                this.s.getParentListOf(item.id).add(image);
                this.s.updateItems();
                this.s.expandItem(image.id);
            } else if (item.getClass() == Panel.class) {
                Panel panel = new Panel(item.returnCode(""), this.s);
                panel.renameForCopy(string);
                this.s.getParentListOf(item.id).add(panel);
                this.s.updateItems();
                this.s.expandItem(panel.id);
            } else if (item.getClass() == Playtree.class) {
                Playtree playtree = new Playtree(item.returnCode(""), this.s);
                playtree.renameForCopy(string);
                this.s.getParentListOf(item.id).add(playtree);
                this.s.updateItems();
                this.s.expandItem(playtree.id);
            } else if (item.getClass() == RadialSlider.class) {
                RadialSlider radialSlider = new RadialSlider(item.returnCode(""), this.s);
                radialSlider.renameForCopy(string);
                this.s.getParentListOf(item.id).add(radialSlider);
                this.s.updateItems();
                this.s.expandItem(radialSlider.id);
            } else if (item.getClass() == Slider.class) {
                Slider slider = new Slider(item.returnCode(""), this.s);
                slider.renameForCopy(string);
                List<Item> list = this.s.getParentListOf(item.id);
                if (list != null) {
                    list.add(slider);
                    this.s.updateItems();
                    this.s.expandItem(slider.id);
                } else {
                    JOptionPane.showMessageDialog(this, "A PlayTree cannot contain more than one slider!", "Slider could not be duplicated", 1);
                }
            } else if (item.getClass() == SliderBackground.class) {
                JOptionPane.showMessageDialog(this, "A slider cannot contain more than one background!", "SliderBackgrounds cannot be duplicated", 1);
            } else if (item.getClass() == Text.class) {
                Text text = new Text(item.returnCode(""), this.s);
                text.renameForCopy(string);
                this.s.getParentListOf(item.id).add(text);
                this.s.updateItems();
                this.s.expandItem(text.id);
            } else if (item.getClass() == Video.class) {
                Video video = new Video(item.returnCode(""), this.s);
                video.renameForCopy(string);
                this.s.getParentListOf(item.id).add(video);
                this.s.updateItems();
                this.s.expandItem(video.id);
            }
        } else if (actionEvent.getSource().equals(this.res_edit)) {
            Resource resource;
            if (this.selected_resource != null && (resource = this.s.getResource(this.selected_resource)) != null) {
                resource.showOptions();
            }
        } else if (actionEvent.getSource().equals(this.res_del)) {
            if (this.s.isUsed(this.selected_resource)) {
                JOptionPane.showMessageDialog(this, "Resource is in use by some item/s, thus it cannot be deleted", "Could not delete resource", 1);
            } else {
                Object[] objectArray = new Object[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(this, "Do you really want to delete \"" + this.selected_resource + "\"?", "Confirmation", 0, 3, null, objectArray, objectArray[1]);
                if (n == 0) {
                    Resource resource = this.s.getResource(this.selected_resource);
                    ResourceDeletionEvent resourceDeletionEvent = new ResourceDeletionEvent(this.s, resource, this.s.resources.indexOf(resource));
                    this.hist.addEvent(resourceDeletionEvent);
                    this.s.resources.remove(resource);
                    this.s.updateResources();
                }
            }
        } else if (actionEvent.getSource().equals(this.win_add_window)) {
            this.s.windows.add(new Window(this.s));
        } else if (actionEvent.getSource().equals(this.win_add_layout)) {
            if (this.selected_window != null) {
                Window window = this.s.getWindow(this.selected_window);
                if (window != null) {
                    window.addLayout();
                }
            } else {
                JOptionPane.showMessageDialog(this, "No parent window selected!", "Could not add layout", 1);
            }
        } else if (actionEvent.getSource().equals(this.win_layout_up)) {
            Window window = this.s.getWindow(this.selected_window);
            Layout layout = window.getLayout(this.selected_layout);
            if (layout == null) {
                return;
            }
            int n = window.layouts.indexOf(layout);
            if (n <= 0) {
                return;
            }
            window.layouts.set(n, window.layouts.set(n - 1, layout));
            this.s.updateWindows();
            this.s.expandLayout(layout.id);
        } else if (actionEvent.getSource().equals(this.win_layout_down)) {
            Window window = this.s.getWindow(this.selected_window);
            Layout layout = window.getLayout(this.selected_layout);
            if (layout == null) {
                return;
            }
            int n = window.layouts.indexOf(layout);
            if (n >= window.layouts.size() - 1) {
                return;
            }
            window.layouts.set(n, window.layouts.set(n + 1, layout));
            this.s.updateWindows();
            this.s.expandLayout(layout.id);
        } else if (actionEvent.getSource().equals(this.win_edit)) {
            Window window;
            if (this.selected_layout != null && this.selected_window != null) {
                Layout layout = this.s.getWindow(this.selected_window).getLayout(this.selected_layout);
                if (layout != null) {
                    layout.showOptions();
                }
            } else if (this.selected_window != null && (window = this.s.getWindow(this.selected_window)) != null) {
                window.showOptions();
            }
        } else if (actionEvent.getSource().equals(this.win_del)) {
            Window window;
            if (this.selected_layout != null) {
                Window window3 = this.s.getWindow(this.selected_window);
                Layout layout = window3.getLayout(this.selected_layout);
                if (layout != null) {
                    Object[] objectArray = new Object[]{"Yes", "No"};
                    int n = JOptionPane.showOptionDialog(this, "Do you really want to delete \"" + layout.id + "\"?", "Confirmation", 0, 3, null, objectArray, objectArray[1]);
                    if (n == 0) {
                        LayoutDeletionEvent layoutDeletionEvent = new LayoutDeletionEvent(window3, layout, window3.layouts.indexOf(layout), this.s);
                        this.pvwin.clearLayout();
                        this.m_file_png.setEnabled(false);
                        window3.layouts.remove(layout);
                        this.s.updateWindows();
                        this.s.updateItems();
                        this.hist.addEvent(layoutDeletionEvent);
                    }
                }
            } else if (this.selected_window != null && (window = this.s.getWindow(this.selected_window)) != null) {
                Object[] objectArray = new Object[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(this, "Do you really want to delete \"" + window.id + "\"?", "Confirmation", 0, 3, null, objectArray, objectArray[1]);
                if (n == 0) {
                    WindowDeletionEvent windowDeletionEvent = new WindowDeletionEvent(window, this.s, this.s.windows.indexOf(window));
                    this.s.windows.remove(window);
                    this.s.updateWindows();
                    this.hist.addEvent(windowDeletionEvent);
                }
            }
        } else if (actionEvent.getSource().equals(this.items_add)) {
            Item item;
            if (this.selected_layout == null) {
                return;
            }
            this.items_add_pu_tp.setEnabled(false);
            if (this.selected_item != null && (item = this.s.getItem(this.selected_item)) != null) {
                if (item.type.equals("Group")) {
                    this.items_add_pu_tp.setEnabled(true);
                }
                if (item.type.equals("Panel")) {
                    this.items_add_pu_tp.setEnabled(true);
                }
            }
            this.items_add_pu.setSelected(null);
            this.items_add_pu.show(this.items_add, 0, 0);
        } else if (actionEvent.getSource().equals(this.items_up)) {
            Item item = this.s.getItem(this.selected_item);
            if (item == null) {
                return;
            }
            List<Item> list = this.s.getParentListOf(this.selected_item);
            if (list == null) {
                return;
            }
            int n = list.indexOf(item);
            if (n <= 0) {
                return;
            }
            list.set(n, list.set(n - 1, item));
            this.s.updateItems();
            this.s.expandItem(this.selected_item);
        } else if (actionEvent.getSource().equals(this.items_down)) {
            Item item = this.s.getItem(this.selected_item);
            if (item == null) {
                return;
            }
            List<Item> list = this.s.getParentListOf(this.selected_item);
            int n = list.indexOf(item);
            if (n >= list.size() - 1) {
                return;
            }
            list.set(n, list.set(n + 1, item));
            this.s.updateItems();
            this.s.expandItem(this.selected_item);
        } else if (actionEvent.getSource().equals(this.items_edit)) {
            Item item;
            if (this.selected_item != null && (item = this.s.getItem(this.selected_item)) != null) {
                item.showOptions();
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_anchor)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Anchor(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_button)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Button(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_checkbox)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Checkbox(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_panel)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Panel(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_image)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Image(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_playtree)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Playtree(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_slider)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Slider(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_text)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Text(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_video)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Video(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_anchor)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Anchor(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_button)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Button(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_checkbox)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Checkbox(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_image)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Image(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_panel)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Panel(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_playtree)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Playtree(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_slider)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Slider(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_text)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Text(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_video)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Video(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_del)) {
            List<Item> list;
            if (this.selected_item != null && (list = this.s.getParentListOf(this.selected_item)) != null) {
                Object[] objectArray = new Object[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(this, "Do you really want to delete \"" + this.selected_item + "\"?", "Confirmation", 0, 3, null, objectArray, objectArray[1]);
                if (n == 0) {
                    Item item = this.s.getItem(this.selected_item);
                    ItemDeletionEvent itemDeletionEvent = new ItemDeletionEvent(list, item, list.indexOf(item), this.s);
                    list.remove(this.s.getItem(this.selected_item));
                    this.s.updateItems();
                    this.hist.addEvent(itemDeletionEvent);
                }
            }
        } else if (actionEvent.getSource().equals(this.m_edit_up)) {
            this.pvwin.moveItem(0, -1);
        } else if (actionEvent.getSource().equals(this.m_edit_down)) {
            this.pvwin.moveItem(0, 1);
        } else if (actionEvent.getSource().equals(this.m_edit_right)) {
            this.pvwin.moveItem(1, 0);
        } else if (actionEvent.getSource().equals(this.m_edit_left)) {
            this.pvwin.moveItem(-1, 0);
        } else if (actionEvent.getSource().equals(this.m_edit_undo)) {
            if (this.hist != null) {
                this.hist.undo();
            }
        } else if (actionEvent.getSource().equals(this.m_edit_redo) && this.hist != null) {
            this.hist.redo();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.opening) {
            return;
        }
        if (treeSelectionEvent.getSource().equals(this.res_tree)) {
            String string = treeSelectionEvent.getPath().getLastPathComponent().toString();
            this.selected_resource = string.substring(string.indexOf(": ") + 2);
        } else if (treeSelectionEvent.getSource().equals(this.win_tree)) {
            this.selected_in_windows = treeSelectionEvent.getPath().getLastPathComponent().toString();
            Object[] objectArray = treeSelectionEvent.getPath().getPath();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i].toString().substring(0, objectArray[i].toString().indexOf(": "));
                if (string.equals("Window")) {
                    this.selected_window = objectArray[i].toString().substring(objectArray[i].toString().indexOf(": ") + 2);
                    this.selected_layout = null;
                    this.pvwin.clearLayout();
                    this.m_file_png.setEnabled(false);
                    this.items_tree_model.setRoot(new DefaultMutableTreeNode("Root: Items"));
                    continue;
                }
                if (!string.equals("Layout")) continue;
                this.selected_layout = objectArray[i].toString().substring(objectArray[i].toString().indexOf(": ") + 2);
                this.pvwin.setLayout(this.s.getWindow(this.selected_window), this.s.getWindow(this.selected_window).getLayout(this.selected_layout));
                this.m_file_png.setEnabled(true);
                this.s.updateItems();
            }
        } else if (treeSelectionEvent.getSource().equals(this.items_tree)) {
            String string = treeSelectionEvent.getPath().getLastPathComponent().toString();
            this.selected_item = string.substring(string.indexOf(": ") + 2);
            this.pvwin.selectItem(this.s.getItem(this.selected_item));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (!this.saved) {
            Object[] objectArray = new Object[]{"Yes", "No", "Don't quit"};
            int n = JOptionPane.showOptionDialog(this, "Would you like to save your skin before exiting?", "Your modifications were not saved", 1, 3, null, objectArray, objectArray[1]);
            if (n == 0) {
                this.s.save();
                System.exit(0);
                return;
            } else {
                if (n != 1) return;
                System.exit(0);
            }
            return;
        } else {
            System.exit(0);
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        if (this.pvwin.fu == null) {
            this.pvwin.fu = new FrameUpdater(this.pvwin, 5);
            this.pvwin.fu.start();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        this.pvwin.fu = null;
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        if (this.pvwin.fu == null) {
            this.pvwin.fu = new FrameUpdater(this.pvwin, 5);
            this.pvwin.fu.start();
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        this.pvwin.fu = null;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            if (mouseEvent.getSource().equals(this.res_tree)) {
                this.actionPerformed(new ActionEvent(this.res_edit, 1001, "Doubleclick"));
            } else if (mouseEvent.getSource().equals(this.win_tree)) {
                this.actionPerformed(new ActionEvent(this.win_edit, 1001, "Doubleclick"));
            } else if (mouseEvent.getSource().equals(this.items_tree)) {
                this.actionPerformed(new ActionEvent(this.items_edit, 1001, "Doubleclick"));
            }
        } else if (mouseEvent.getSource().equals(this.res_tree)) {
            TreePath treePath = this.res_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            if (this.res_tree.isExpanded(treePath)) {
                this.res_tree.collapsePath(treePath);
            } else {
                this.res_tree.expandPath(treePath);
            }
        } else if (mouseEvent.getSource().equals(this.win_tree)) {
            TreePath treePath = this.win_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            if (this.win_tree.isExpanded(treePath)) {
                this.win_tree.collapsePath(treePath);
            } else {
                this.win_tree.expandPath(treePath);
            }
        } else if (mouseEvent.getSource().equals(this.items_tree)) {
            TreePath treePath = this.items_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            if (this.items_tree.isExpanded(treePath)) {
                this.items_tree.collapsePath(treePath);
            } else {
                this.items_tree.expandPath(treePath);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setUndoEnabled(boolean bl) {
        this.m_edit_undo.setEnabled(bl);
    }

    public void setRedoEnabled(boolean bl) {
        this.m_edit_redo.setEnabled(bl);
    }

    public void setUndoString(String string) {
        if (string.isEmpty()) {
            this.m_edit_undo.setText("Undo");
        } else {
            this.m_edit_undo.setText("Undo: " + string);
        }
    }

    public void setRedoString(String string) {
        if (string.isEmpty()) {
            this.m_edit_redo.setText("Redo");
        } else {
            this.m_edit_redo.setText("Redo: " + string);
        }
    }

    public ImageIcon createIcon(String string) {
        java.awt.Image image = null;
        try {
            image = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource(string));
            return new ImageIcon(image);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    private void update() {
        if ("0.7".contains("dev")) {
            return;
        }
        try {
            URL uRL = new URL("http://www.videolan.org/vlc/skineditor_update.php");
            InputStream inputStream = uRL.openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            if (string.equals("SKINEDITORUPDATEPAGE")) {
                String string2 = bufferedReader.readLine();
                String string3 = bufferedReader.readLine();
                if (!string2.equals("0.7")) {
                    System.out.println("Update available!");
                    int n = JOptionPane.showConfirmDialog(this, "There is an update available for the Skin Editor.\nYour version: 0.7\nLatest version: " + string2 + "\n" + "Do you want to update the Skin Editor now?", "VLC Skin Editor", 0);
                    if (n == 0) {
                        ZipEntry zipEntry;
                        Object object;
                        int n2;
                        URL uRL2 = new URL(string3);
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL2.openConnection();
                        httpURLConnection.connect();
                        if (httpURLConnection.getResponseCode() / 100 != 2) {
                            throw new Exception("Server error! Response code: " + httpURLConnection.getResponseCode());
                        }
                        int n3 = httpURLConnection.getContentLength();
                        if (n3 < 1) {
                            throw new Exception("Invalid content length!");
                        }
                        int n4 = n3;
                        File file = File.createTempFile("vlcse_update", ".zip");
                        file.deleteOnExit();
                        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                        InputStream inputStream2 = httpURLConnection.getInputStream();
                        boolean bl = true;
                        int n5 = 0;
                        ProgressWindow progressWindow = new ProgressWindow(this, "Downloading");
                        progressWindow.setVisible(true);
                        progressWindow.setProgress(0.0);
                        progressWindow.setText("Connecting...");
                        while (n5 < n4 && (n2 = inputStream2.read((byte[])(object = (Object)(n4 - n5 > 1024 ? new byte[1024] : new byte[n4 - n5])))) != -1) {
                            randomAccessFile.write((byte[])object, 0, n2);
                            progressWindow.setProgress((n5 += n2) / n4);
                        }
                        randomAccessFile.close();
                        System.out.println("Downloaded file to " + file.getAbsolutePath());
                        progressWindow.setVisible(false);
                        progressWindow.dispose();
                        progressWindow = null;
                        object = new ZipInputStream(new FileInputStream(file));
                        while ((zipEntry = object.getNextEntry()) != null) {
                            int n6;
                            File file2 = new File(zipEntry.getName());
                            System.out.println(file2.getAbsoluteFile());
                            if (file2.exists()) {
                                file2.delete();
                            }
                            FileOutputStream fileOutputStream = new FileOutputStream(file2);
                            byte[] byArray = new byte[1024];
                            while ((n6 = object.read(byArray)) > 0) {
                                ((OutputStream)fileOutputStream).write(byArray, 0, n6);
                            }
                            ((OutputStream)fileOutputStream).close();
                        }
                        JOptionPane.showMessageDialog(this, "Update was sucessfully downloaded and installed.\nVLC Skin Editor will restart now", "VLC Skin Editor update", 1);
                        this.setVisible(false);
                        if (System.getProperty("os.name").indexOf("Windows") != -1) {
                            Runtime.getRuntime().exec("VLCSkinEditor.exe");
                        } else {
                            Runtime.getRuntime().exec("java -jar VLCSkinEditor.jar");
                        }
                        System.exit(0);
                    }
                }
            } else {
                bufferedReader.close();
                inputStreamReader.close();
                inputStream.close();
                throw new Exception("Update page had invalid header: " + string);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "Error while updating...", 0);
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame.setDefaultLookAndFeelDecorated(true);
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "VLC Skin Editor");
        new Main(stringArray);
    }
}

