/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.awt.BDJHelper;
import java.awt.Container;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.LinkedList;
import javax.microedition.xlet.UnavailableContainerException;
import javax.tv.xlet.XletContext;
import org.bluray.ui.FrameAccurateAnimation;
import org.dvb.application.AppID;
import org.dvb.application.AppProxy;
import org.dvb.application.AppsDatabase;
import org.dvb.io.ixc.IxcRegistry;
import org.havi.ui.HSceneFactory;
import org.videolan.BDJAction;
import org.videolan.BDJActionQueue;
import org.videolan.BDJAppProxy;
import org.videolan.BDJClassLoader;
import org.videolan.BDJSockets;
import org.videolan.BDJThreadGroup;
import org.videolan.Logger;
import org.videolan.MountManager;
import org.videolan.PortingHelper;
import org.videolan.bdjo.AppCache;
import org.videolan.bdjo.AppEntry;

public class BDJXletContext
implements XletContext,
javax.microedition.xlet.XletContext {
    private final Object cbLock = new Object();
    private boolean released = false;
    private String[] args;
    private AppID appid;
    private String homeMountPoint = null;
    private BDJClassLoader loader;
    private Container container;
    private EventQueue eventQueue = null;
    private HSceneFactory sceneFactory = null;
    private BDJThreadGroup threadGroup = null;
    private LinkedList ixcThreads = new LinkedList();
    private LinkedList faaList = new LinkedList();
    private BDJSockets sockets = new BDJSockets();
    private HashMap defaultLooks = new HashMap();
    private BDJActionQueue callbackQueue;
    private BDJActionQueue userEventQueue;
    private BDJActionQueue mediaQueue;
    private static final Logger logger = Logger.getLogger(BDJXletContext.class.getName());

    public BDJXletContext(AppEntry entry, AppCache[] caches, Container container) {
        this.appid = entry.getIdentifier();
        this.args = entry.getParams();
        this.loader = BDJClassLoader.newInstance(caches, entry.getBasePath(), entry.getClassPathExt(), entry.getInitialClass());
        this.container = container;
        this.threadGroup = new BDJThreadGroup(Integer.toHexString(this.appid.getOID()) + "." + Integer.toHexString(this.appid.getAID()) + "." + entry.getInitialClass(), this);
        this.callbackQueue = new BDJActionQueue(this.threadGroup, "CallbackQueue");
        this.mediaQueue = new BDJActionQueue(this.threadGroup, "MediaQueue");
        this.userEventQueue = new BDJActionQueue(this.threadGroup, "UserEventQueue");
        this.mountHomeDir(entry);
    }

    private void mountHomeDir(AppEntry entry) {
        String home = entry.getBasePath();
        if (home.length() > 5) {
            logger.error("Unhandled home directory: " + home);
        }
        try {
            int homeJarID = Integer.parseInt(home);
            long time = System.currentTimeMillis();
            this.homeMountPoint = MountManager.mount(homeJarID, false);
            if (this.homeMountPoint == null) {
                logger.error("Failed mounting " + home + ".jar");
            } else {
                this.homeMountPoint = this.homeMountPoint + File.separator;
            }
            time = System.currentTimeMillis() - time;
            logger.info("Mounted Xlet home directory from " + home + ".jar " + "to " + this.homeMountPoint + "(" + time + "ms)");
        }
        catch (Exception ex) {
            logger.error("Failed mounting " + home + ".jar:" + ex);
        }
    }

    public String getXletHome() {
        if (this.homeMountPoint == null) {
            logger.error("Home directory not mounted!");
        }
        return this.homeMountPoint;
    }

    public static String getCurrentXletHome() {
        BDJXletContext ctx = BDJXletContext.getCurrentContext();
        if (ctx == null) {
            logger.error("getCurrentXletHome(): no context: " + Logger.dumpStack());
            return null;
        }
        return ctx.getXletHome();
    }

    public Object getXletProperty(String key) {
        if (key.equals("javax.tv.xlet.args") || key.equals("javax.microedition.xlet.args")) {
            return this.args;
        }
        if (key.equals("dvb.org.id")) {
            return Integer.toHexString(this.appid.getOID());
        }
        if (key.equals("dvb.app.id")) {
            return Integer.toHexString(this.appid.getAID());
        }
        if (key.equals("org.dvb.application.appid")) {
            return this.appid;
        }
        logger.error("unhandled getXletProperty(" + key + ")");
        return null;
    }

    public void notifyDestroyed() {
        AppProxy proxy = AppsDatabase.getAppsDatabase().getAppProxy(this.appid);
        if (proxy instanceof BDJAppProxy) {
            ((BDJAppProxy)proxy).notifyDestroyed();
        }
    }

    public void notifyPaused() {
        AppProxy proxy = AppsDatabase.getAppsDatabase().getAppProxy(this.appid);
        if (proxy instanceof BDJAppProxy) {
            ((BDJAppProxy)proxy).notifyPaused();
        }
    }

    public void resumeRequest() {
        AppProxy proxy = AppsDatabase.getAppsDatabase().getAppProxy(this.appid);
        if (proxy instanceof BDJAppProxy) {
            ((BDJAppProxy)proxy).resume();
        }
    }

    public Container getContainer() throws UnavailableContainerException {
        if (this.container == null) {
            logger.error("getContainer(): container is null");
            throw new UnavailableContainerException();
        }
        return this.container;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public static ClassLoader getCurrentClassLoader() {
        BDJXletContext ctx = BDJXletContext.getCurrentContext();
        if (ctx == null) {
            logger.error("getCurrentClassLoader(): no context: " + Logger.dumpStack());
            return null;
        }
        ClassLoader cldr = ctx.getClassLoader();
        if (cldr == null) {
            logger.error("getCurrentClassLoader(): no class loader: " + Logger.dumpStack());
            return null;
        }
        return cldr;
    }

    protected AppProxy getAppProxy() {
        return AppsDatabase.getAppsDatabase().getAppProxy(this.appid);
    }

    public boolean isReleased() {
        return this.released;
    }

    public BDJThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public String toString() {
        BDJThreadGroup localGroup = this.threadGroup;
        String groupName = localGroup == null ? "<destroyed>" : localGroup.getName();
        return super.toString() + "[name=" + groupName + ", released=" + this.released + "]";
    }

    protected void setEventQueue(EventQueue eq) {
        this.eventQueue = eq;
    }

    public EventQueue getEventQueue() {
        return this.eventQueue;
    }

    private boolean putCallbackImpl(BDJAction cb, BDJActionQueue queue) {
        if (this.isReleased()) {
            logger.error("callback ignored (xlet destroyed)");
            return false;
        }
        if (queue == null) {
            logger.error("callback ignored (no queue)");
            return false;
        }
        queue.put(cb);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean putCallback(BDJAction cb) {
        Object object = this.cbLock;
        synchronized (object) {
            return this.putCallbackImpl(cb, this.callbackQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean putMediaCallback(BDJAction cb) {
        Object object = this.cbLock;
        synchronized (object) {
            return this.putCallbackImpl(cb, this.mediaQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putUserEvent(BDJAction cb) {
        Object object = this.cbLock;
        synchronized (object) {
            return this.putCallbackImpl(cb, this.userEventQueue);
        }
    }

    protected int numEventQueueThreads() {
        EventDispatchThread t;
        int cnt = 0;
        if (this.eventQueue != null && (t = BDJHelper.getEventDispatchThread(this.eventQueue)) != null && t.isAlive()) {
            ++cnt;
        }
        if (!this.released) {
            cnt += 3;
        }
        return cnt;
    }

    public void setSceneFactory(HSceneFactory f) {
        this.sceneFactory = f;
    }

    public HSceneFactory getSceneFactory() {
        return this.sceneFactory;
    }

    public static Object getXletDefaultLook(String key, Class defClass) {
        BDJXletContext ctx = BDJXletContext.getCurrentContext();
        if (ctx == null) {
            logger.error("getDefaultLook(): no context: " + Logger.dumpStack());
            return null;
        }
        return ctx.getDefaultLook(key, defClass);
    }

    public static void setXletDefaultLook(String key, Object look) {
        BDJXletContext ctx = BDJXletContext.getCurrentContext();
        if (ctx == null) {
            logger.error("setDefaultLook(): no context: " + Logger.dumpStack());
            return;
        }
        ctx.setDefaultLook(key, look);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getDefaultLook(String key, Class defClass) {
        Object look = null;
        HashMap hashMap = this.defaultLooks;
        synchronized (hashMap) {
            look = this.defaultLooks.get(key);
            if (look == null) {
                try {
                    look = defClass.newInstance();
                    this.setDefaultLook(key, look);
                }
                catch (Exception t) {
                    logger.error("Error creating default look " + defClass.getName() + " for " + key + ": " + t);
                }
            }
        }
        return look;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultLook(String key, Object look) {
        HashMap hashMap = this.defaultLooks;
        synchronized (hashMap) {
            this.defaultLooks.remove(key);
            if (look != null) {
                this.defaultLooks.put(key, look);
            }
        }
    }

    protected void addSocket(Object socket) {
        this.sockets.add(socket);
    }

    protected void closeSockets() {
        this.sockets.closeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addIxcThread(Thread thread) {
        LinkedList linkedList = this.ixcThreads;
        synchronized (linkedList) {
            this.ixcThreads.addLast(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeIxcThread(Thread thread) {
        LinkedList linkedList = this.ixcThreads;
        synchronized (linkedList) {
            this.ixcThreads.remove(thread);
        }
    }

    private static boolean waitThread(Thread thread, int timeout) {
        boolean result;
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)timeout;
        while (thread.isAlive() && System.currentTimeMillis() < endTime) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        boolean bl = result = !thread.isAlive();
        if (!result) {
            logger.error("waitThread timeout: " + thread);
        }
        return result;
    }

    protected static void stopThread(Thread thread, int timeout, String type) {
        if (!BDJXletContext.waitThread(thread, timeout)) {
            thread.interrupt();
            if (!BDJXletContext.waitThread(thread, 200)) {
                PortingHelper.stopThread(thread);
                logger.error("killing " + type + " thread " + thread);
            }
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopIxcThreads() {
        while (true) {
            Thread thread;
            LinkedList linkedList = this.ixcThreads;
            synchronized (linkedList) {
                if (this.ixcThreads.isEmpty()) {
                    break;
                }
                thread = (Thread)this.ixcThreads.removeFirst();
            }
            logger.info("Stopping remote thread " + thread);
            BDJXletContext.stopThread(thread, 1000, "Ixc");
            this.removeIxcThread(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFAA(FrameAccurateAnimation faa) {
        LinkedList linkedList = this.faaList;
        synchronized (linkedList) {
            this.faaList.add(faa);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFAA(FrameAccurateAnimation faa) {
        LinkedList linkedList = this.faaList;
        synchronized (linkedList) {
            this.faaList.remove(faa);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllFAA() {
        Object[] faaArray;
        LinkedList linkedList = this.faaList;
        synchronized (linkedList) {
            faaArray = this.faaList.toArray();
        }
        for (int i = 0; i < faaArray.length; ++i) {
            FrameAccurateAnimation faa = (FrameAccurateAnimation)faaArray[i];
            faa.destroy();
        }
    }

    public static BDJXletContext getCurrentContext() {
        Object obj = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup group;
                for (group = Thread.currentThread().getThreadGroup(); group != null && !(group instanceof BDJThreadGroup); group = group.getParent()) {
                }
                return group;
            }
        });
        if (obj == null) {
            return null;
        }
        return ((BDJThreadGroup)obj).getContext();
    }

    protected void setArgs(String[] args) {
        this.args = args;
    }

    protected void update(AppEntry entry, AppCache[] caches) {
        this.args = entry.getParams();
        this.loader.update(caches, entry.getBasePath(), entry.getClassPathExt(), entry.getInitialClass());
    }

    protected void exitXlet() {
        IxcRegistry.unbindAll(this);
        this.closeSockets();
        this.removeAllFAA();
        this.stopIxcThreads();
        this.defaultLooks.clear();
        if (this.sceneFactory != null) {
            this.sceneFactory.dispose();
            this.sceneFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        this.exitXlet();
        this.callbackQueue.shutdown();
        this.userEventQueue.shutdown();
        this.mediaQueue.shutdown();
        EventQueue eq = this.eventQueue;
        this.eventQueue = null;
        if (eq != null) {
            BDJHelper.stopEventQueue(eq);
        }
        this.threadGroup.stopAll(1000);
        try {
            Method m = this.loader.getClass().getMethod("close", new Class[0]);
            m.invoke((Object)this.loader, new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        Object object = this.cbLock;
        synchronized (object) {
            this.callbackQueue = null;
            this.userEventQueue = null;
            this.mediaQueue = null;
        }
        object = this;
        synchronized (object) {
            this.threadGroup = null;
            this.loader = null;
            this.container = null;
            this.defaultLooks = null;
            this.released = true;
        }
    }
}

