/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.tv.xlet.XletContext;
import org.videolan.BDJXletContext;
import org.videolan.Copy;
import org.videolan.Logger;

public class IxcRegistryImpl {
    private final HashMap remoteObjects = new HashMap();
    private static final boolean DEBUG = true;
    private static final boolean TRACE = true;
    private static final Logger logger = Logger.getLogger(IxcRegistryImpl.class.getName());
    static /* synthetic */ Class class$java$rmi$RemoteException;

    private boolean isProxiedRemoteObj(Object obj) {
        return Proxy.isProxyClass(obj.getClass()) && Proxy.getInvocationHandler(obj) instanceof RemoteObjectInvocationHandler;
    }

    private Object wrapImportedObject(WrappedRemoteObj remoteObj, XletContext toContext) throws RemoteException {
        if (toContext == remoteObj.context) {
            return remoteObj.object;
        }
        if (toContext == null) {
            logger.error("toContext is null");
            return remoteObj.object;
        }
        if (remoteObj.context == null) {
            logger.error("remote context is null");
        }
        RemoteObjectInvocationHandler handler = new RemoteObjectInvocationHandler(remoteObj);
        ClassLoader cl = ((BDJXletContext)toContext).getClassLoader();
        ArrayList list = new ArrayList();
        this.getAllInterfaces(remoteObj.object.getClass(), list);
        ArrayList FilteredList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            try {
                Class<?> cls = cl.loadClass(((Class)list.get(i)).getName());
                if (!cls.isInterface() || !(class$java$rmi$Remote == null ? IxcRegistryImpl.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(cls)) continue;
                FilteredList.add(cls);
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        Class[] ifs = FilteredList.toArray(new Class[0]);
        if (ifs != null && ifs.length != 0) {
            return (Remote)Proxy.newProxyInstance(cl, ifs, (InvocationHandler)handler);
        }
        return null;
    }

    private Object exportRemoteObj(Object proxiedRemoteObj, XletContext toContext) throws RemoteException {
        RemoteObjectInvocationHandler handler = (RemoteObjectInvocationHandler)Proxy.getInvocationHandler(proxiedRemoteObj);
        if (handler.remoteObj.context == toContext) {
            return handler.remoteObj.object;
        }
        return this.wrapImportedObject(handler.remoteObj, toContext);
    }

    private Object wrapOrCopy(Object obj, BDJXletContext fromContext, BDJXletContext toContext) throws RemoteException {
        Object result = null;
        if (null == obj) {
            return null;
        }
        if (this.isProxiedRemoteObj(obj)) {
            return this.exportRemoteObj(obj, toContext);
        }
        if (obj instanceof Remote) {
            return this.wrapImportedObject(new WrappedRemoteObj((Remote)obj, fromContext), toContext);
        }
        if (obj instanceof WrappedRemoteObj) {
            WrappedRemoteObj wrappedObj = (WrappedRemoteObj)obj;
            if (this.isProxiedRemoteObj(wrappedObj.object)) {
                return this.exportRemoteObj(wrappedObj.object, toContext);
            }
            return this.wrapImportedObject(wrappedObj, toContext);
        }
        if (obj.getClass().isPrimitive() || obj.getClass().equals(Void.TYPE)) {
            return obj;
        }
        if (obj instanceof Serializable) {
            try {
                return Copy.deepCopy(toContext.getClassLoader(), (Serializable)obj);
            }
            catch (Exception e) {
                IxcRegistryImpl.Debug("wrapOrCopy: failed in deepCopy: " + e.getStackTrace());
                throw new RemoteException("serialization/deserialization failed", e);
            }
        }
        IxcRegistryImpl.Debug("wrapOrCopy: Object is neither Serializable nor Remote");
        throw new RemoteException("Object is neither Serializable nor Remote");
    }

    private void getAllInterfaces(Class objClass, ArrayList resultList) {
        if (objClass == null) {
            return;
        }
        Class<?>[] ifs = objClass.getInterfaces();
        for (int i = 0; i < ifs.length; ++i) {
            int j;
            for (j = 0; j < resultList.size() && resultList.get(j) != ifs[i]; ++j) {
            }
            if (j != resultList.size()) continue;
            resultList.add(ifs[i]);
        }
        this.getAllInterfaces(objClass.getSuperclass(), resultList);
    }

    private static final void verifyRemoteInterfaces(Class remoteClass) throws RemoteException {
        Class<?>[] remoteInterfaces = remoteClass.getInterfaces();
        for (int i = 0; i < remoteInterfaces.length; ++i) {
            if (!(class$java$rmi$Remote == null ? IxcRegistryImpl.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(remoteInterfaces[i])) continue;
            Method[] remoteMethods = remoteInterfaces[i].getMethods();
            for (int j = 0; j < remoteMethods.length; ++j) {
                IxcRegistryImpl.verifyRemoteMethod(remoteMethods[j]);
            }
        }
    }

    private static final void verifyRemoteMethod(Method remoteMethod) throws RemoteException {
        Class<?>[] expTypes = remoteMethod.getExceptionTypes();
        boolean hasRemoteException = false;
        for (int i = 0; i < expTypes.length; ++i) {
            if (!expTypes[i].isAssignableFrom(class$java$rmi$RemoteException == null ? IxcRegistryImpl.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException)) continue;
            hasRemoteException = true;
            break;
        }
        if (!hasRemoteException) {
            throw new RemoteException("no RemoteException found from remote method");
        }
        Class<?>[] paramTypes = remoteMethod.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            IxcRegistryImpl.verifyRemoteParameters(paramTypes[i]);
        }
        IxcRegistryImpl.verifyRemoteParameters(remoteMethod.getReturnType());
    }

    private static final void verifyRemoteParameters(Class parameter) throws RemoteException {
        if (Remote.class.isAssignableFrom(parameter)) {
            if (!parameter.isInterface()) {
                throw new RemoteException("remote parameter is not an interface");
            }
            Class<?>[] superInterfaces = parameter.getInterfaces();
            for (int j = 0; j < superInterfaces.length; ++j) {
                if ((class$java$rmi$Remote == null ? IxcRegistryImpl.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(superInterfaces[j])) continue;
                throw new RemoteException("remote parameter not assignable");
            }
        } else if (!(parameter.isPrimitive() || parameter.equals(Void.TYPE) || Serializable.class.isAssignableFrom(parameter))) {
            throw new RemoteException("invalid parameter");
        }
    }

    private static void Debug(String s) {
        logger.info(s);
    }

    private static void TRACE(String s) {
        logger.info("Ixc TRACE: " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(XletContext xc, String path, Remote obj) throws AlreadyBoundException {
        IxcRegistryImpl.Debug("IxcRegistry.bind(" + xc + ", " + path + ", " + obj + ")");
        if (!(xc instanceof BDJXletContext) || (BDJXletContext)xc != BDJXletContext.getCurrentContext()) {
            IxcRegistryImpl.Debug("bind(): xc not current BDJXletContext");
            throw new IllegalArgumentException("xc not current BDJXletContext");
        }
        if (((BDJXletContext)xc).isReleased()) {
            IxcRegistryImpl.Debug("bind(): xc is destroyed");
            return;
        }
        HashMap hashMap = this.remoteObjects;
        synchronized (hashMap) {
            if (this.remoteObjects.containsKey(path)) {
                throw new AlreadyBoundException();
            }
            this.remoteObjects.put(path, new WrappedRemoteObj(obj, (BDJXletContext)xc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Remote lookup(XletContext xc, String path) throws NotBoundException, RemoteException {
        IxcRegistryImpl.Debug("IxcRegistry.lookup(" + xc + ", " + path + ")");
        if (!(xc instanceof BDJXletContext) || (BDJXletContext)xc != BDJXletContext.getCurrentContext()) {
            IxcRegistryImpl.Debug("lookup(): xc not current BDJXletContext");
            throw new IllegalArgumentException("xc not current BDJXletContext");
        }
        WrappedRemoteObj wrappedObj = null;
        HashMap hashMap = this.remoteObjects;
        synchronized (hashMap) {
            if (!this.remoteObjects.containsKey(path)) {
                throw new NotBoundException();
            }
            wrappedObj = (WrappedRemoteObj)this.remoteObjects.get(path);
        }
        if (null == wrappedObj) {
            return null;
        }
        Object remoteObj = this.wrapOrCopy(wrappedObj, wrappedObj.context, (BDJXletContext)xc);
        IxcRegistryImpl.Debug("IxcRegistry.lookup(" + path + ") => " + remoteObj);
        return (Remote)remoteObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String path) throws NotBoundException {
        IxcRegistryImpl.Debug("IxcRegistry.unbind(" + path + ")");
        HashMap hashMap = this.remoteObjects;
        synchronized (hashMap) {
            if (!this.remoteObjects.containsKey(path)) {
                throw new NotBoundException();
            }
            WrappedRemoteObj wrappedObj = (WrappedRemoteObj)this.remoteObjects.get(path);
            if (wrappedObj != null && wrappedObj.context != BDJXletContext.getCurrentContext()) {
                throw new IllegalArgumentException("invalid context");
            }
            this.remoteObjects.remove(path);
        }
        IxcRegistryImpl.Debug("IxcRegistry.unbind(" + path + ") OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list() {
        String[] result = null;
        int i = 0;
        HashMap hashMap = this.remoteObjects;
        synchronized (hashMap) {
            result = new String[this.remoteObjects.size()];
            Iterator it = this.remoteObjects.keySet().iterator();
            while (it.hasNext()) {
                result[i++] = (String)it.next();
            }
        }
        IxcRegistryImpl.Debug("IxcRegistry.list():");
        for (i = 0; i < result.length; ++i) {
            IxcRegistryImpl.Debug("\t" + i + " => " + result[i]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAll() {
        if (null != BDJXletContext.getCurrentContext()) {
            logger.error("unbindAll() from wrong thread: " + Logger.dumpStack());
            return;
        }
        HashMap hashMap = this.remoteObjects;
        synchronized (hashMap) {
            this.remoteObjects.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAll(XletContext xc) {
        if (null != BDJXletContext.getCurrentContext()) {
            logger.error("unbindAll(ctx) from wrong thread: " + Logger.dumpStack());
            return;
        }
        IxcRegistryImpl.Debug("IxcRegistry.removeBinding(" + xc + ")");
        String prefix = "/" + (String)xc.getXletProperty("dvb.org.id") + "/" + (String)xc.getXletProperty("dvb.app.id") + "/";
        HashMap hashMap = this.remoteObjects;
        synchronized (hashMap) {
            Iterator it = this.remoteObjects.keySet().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                String path = (String)o;
                if (!path.startsWith(prefix)) continue;
                it.remove();
            }
        }
    }

    private class WrappedRemoteObj {
        final Remote object;
        final BDJXletContext context;

        public WrappedRemoteObj(Remote object, BDJXletContext context) {
            this.object = object;
            this.context = context;
        }
    }

    private class RemoteObjectInvocationHandler
    implements InvocationHandler {
        public WrappedRemoteObj remoteObj = null;

        public RemoteObjectInvocationHandler(WrappedRemoteObj remoteObj) {
            IxcRegistryImpl.TRACE("RemoteInvocationHandler created for " + remoteObj);
            this.remoteObj = remoteObj;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (null == this.remoteObj.context || this.remoteObj.context.isReleased()) {
                IxcRegistryImpl.Debug("invoke(): callee has been destroyed");
                throw new RemoteException("callee has been destroyed");
            }
            IxcRegistryImpl.TRACE("RemoteInvocationHandler called for " + this.remoteObj);
            if (null != args) {
                for (int i = 0; i < args.length; ++i) {
                    if (null == args[i] || !(class$java$rmi$Remote == null ? IxcRegistryImpl.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(args[i].getClass())) continue;
                    IxcRegistryImpl.verifyRemoteInterfaces(args[i].getClass());
                }
            }
            RemoteMethod remoteMethod = new RemoteMethod(method, this.remoteObj.context, args);
            if (remoteMethod.callerContext.isReleased()) {
                IxcRegistryImpl.Debug("invoke(): caller has been destroyed");
                throw new RemoteException("caller has been destroyed");
            }
            Thread remoteThread = new Thread(this.remoteObj.context.getThreadGroup(), remoteMethod, "Ixc Remote thread " + method);
            remoteMethod.callerContext.addIxcThread(remoteThread);
            remoteThread.setDaemon(false);
            remoteThread.start();
            remoteThread.join();
            remoteMethod.callerContext.removeIxcThread(remoteThread);
            if (!remoteMethod.finished) {
                IxcRegistryImpl.Debug("invoke(): calling xlet destroyed during remote execution");
                throw new RemoteException("calling xlet destroyed during remote execution");
            }
            if (remoteMethod.exception != null) {
                IxcRegistryImpl.Debug("Exception in remote thread");
                if (remoteMethod.exception instanceof InvocationTargetException) {
                    throw ((InvocationTargetException)remoteMethod.exception).getTargetException();
                }
                IxcRegistryImpl.Debug("Exception in remote thread is not InvocationTargetException");
                throw remoteMethod.exception;
            }
            Object result = remoteMethod.retInCaller;
            IxcRegistryImpl.TRACE("RPC return " + result);
            return result;
        }

        public class RemoteMethod
        implements Runnable {
            final BDJXletContext calleeContext;
            final BDJXletContext callerContext;
            final Method methodInCallee;
            Object[] argsInCallee = new Object[0];
            Exception exception = null;
            boolean finished = false;
            Object retInCaller = null;

            public RemoteMethod(Method method, BDJXletContext context, Object[] args) throws RemoteException {
                this.callerContext = BDJXletContext.getCurrentContext();
                if (this.callerContext == null) {
                    logger.error("caller context is null");
                }
                if (context == null) {
                    logger.error("callee context is null");
                }
                this.calleeContext = context;
                this.methodInCallee = this.findMethodInCallee(method);
                if (null != args) {
                    this.argsInCallee = new Object[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        this.argsInCallee[i] = IxcRegistryImpl.this.wrapOrCopy(args[i], this.callerContext, this.calleeContext);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IxcRegistryImpl.TRACE("start execution in remote thread");
                Object ret = null;
                try {
                    ret = this.methodInCallee.invoke((Object)RemoteObjectInvocationHandler.this.remoteObj.object, this.argsInCallee);
                    IxcRegistryImpl.TRACE("result: " + ret);
                    if (ret != null) {
                        IxcRegistryImpl.TRACE("  type: " + ret.getClass().getName());
                    }
                    this.retInCaller = IxcRegistryImpl.this.wrapOrCopy(ret, this.calleeContext, this.callerContext);
                }
                catch (IllegalArgumentException e) {
                    this.exception = e;
                }
                catch (IllegalAccessException e) {
                    this.exception = e;
                }
                catch (InvocationTargetException e) {
                    try {
                        this.exception = (Exception)IxcRegistryImpl.this.wrapOrCopy(e, this.calleeContext, this.callerContext);
                    }
                    catch (RemoteException e1) {
                        this.exception = e1;
                    }
                }
                catch (RemoteException e) {
                    this.exception = e;
                }
                finally {
                    this.finished = true;
                }
            }

            private Method findMethodInCallee(Method method) {
                try {
                    Class<?> c = method.getDeclaringClass();
                    Method[] methodsInCaller = this.callerContext.getClassLoader().loadClass(c.getName()).getDeclaredMethods();
                    Method[] methodsInCallee = this.calleeContext.getClassLoader().loadClass(c.getName()).getDeclaredMethods();
                    for (int i = 0; i < methodsInCaller.length; ++i) {
                        if (!methodsInCaller[i].equals(method)) continue;
                        Method result = methodsInCallee[i];
                        IxcRegistryImpl.TRACE("method in callee: " + result);
                        return result;
                    }
                    IxcRegistryImpl.TRACE("can't find method in callee");
                }
                catch (SecurityException e) {
                    IxcRegistryImpl.TRACE("can't find method in callee: SecurityException: " + e.getStackTrace());
                }
                catch (ClassNotFoundException e) {
                    IxcRegistryImpl.TRACE("can't find method in callee: ClassNotFound:" + e.getStackTrace());
                }
                return null;
            }
        }
    }
}

