/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.common.programs;

import java.net.InetAddress;
import java.util.Date;

/**
 * This interface represents a programmation.
 * 
 * @author SylV
 */
public interface IVlProgram {
    /**
     * Gets the programmation start time.
     * 
     * @return the start time
     */
    public Date getLiveStart();

    /**
     * Sets the programmation start time.
     * 
     * @param liveStart
     *            the start time to set
     */
    public void setLiveStart(Date liveStart);

    /**
     * Gets the programmation length.
     * 
     * @return the programmation length
     */
    public int getLiveLength();

    /**
     * Sets the programmation length.
     * 
     * @param liveLength
     *            the programmation length
     */
    public void setLiveLength(int liveLength);

    /**
     * Gets the repetition interval of the programmation.
     * 
     * @return the repetition interval
     */
    public int getLiveInterval();

    /**
     * Sets the repetition interval of the programmation.
     * 
     * @param liveInterval
     *            the repetition interval
     */
    public void setLiveInterval(int liveInterval);

    /**
     * Gets the number of repetitions of the programmation.
     * 
     * @return the number of repetitions
     */
    public int getLiveRepetitions();

    /**
     * Sets the number of repetitions of the programmation.
     * 
     * @param liveRepetitions the number of repetitions
     *            
     */
    public void setLiveRepetitions(int liveRepetitions);

    /**
     * Gets the IP address used to stream the program.
     * 
     * @return the IP address 
     */ 
    public InetAddress getIp();

    /**
     * Sets the IP address used to stream the program.
     * 
     * @param ip
     *            the IP address to set
     */
    public void setIp(InetAddress ip);

    /**
     * Gets the programmation priority.
     * 
     * @return the programmation priority
     */
    public int getPriority();

    /**
     * Sets the programmation priority.
     * 
     * @param priority
     *            the priority to set
     */
    public void setPriority(int priority);

    /**
     * Returns true if diffusion has to take place.
     * 
     * @return true if diffusion has to take place; false otherwise
     */
    public boolean isTimeToPlay();

    /**
     * Gets the IP address of the server which streams on the program IP 
     * address.
     * 
     * @return the server IP address
     */
    public InetAddress getPlayer();

    /**
     * Sets the IP address of the server which streams on the program IP 
     * address.
     * 
     * @param player
     *            the server IP address
     */
    public void setPlayer(InetAddress player);

    /**
     * Gets the SAP name which will be used during the streaming.
     * 
     * @return the SAP name
     */
    public String getSapName();

    /**
     * Sets the SAP name which will be used during the streaming.
     * 
     * @param sapName
     *            the SAP name to set
     */
    public void setSapName(String sapName);

    /**
     * Gets the SAP group which will be used during the streaming.
     * 
     * @return the SAP group
     */
    public String getSapGroup();

    /**
     * Sets the SAP group which will be used during the streaming.
     * 
     * @param sapGroup
     *            the SAP group to set
     */
    public void setSapGroup(String sapGroup);
    
    /**
     * Tells whether the media of the order is really broadcasted.
     * 
     * @param broadcastState
     *            The brocast state :
     *            True if the media is broadcast
     *            False if not
     */
    public void setBroadcastState(boolean broadcastState);
    
    /**
     * Gets broadcast state.
     * 
     * @return The brocast state :
     *         True if the media is broadcast
     *         False if not
     */
     public boolean getBroadcastState();
}
