/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.servers;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.VlServer;
import org.videolan.vlma.common.adapters.IVlAdapter;

public class ServersAdapterRemoveFormController extends SimpleFormController {

    private IVlData data;

    public IVlData getData() {
        return data;
    }

    public void setData(IVlData data) {
        this.data = data;
    }

    public ModelAndView onSubmit(Object command) throws ServletException,
            UnknownHostException {
        int server = ((ServersAdapterAdd) command).getServer();
        String name = ((ServersAdapterAdd) command).getName();
        
        Map<String, Object> params = new HashMap<String, Object>();
        data.removeAdapter(server, name);
        params.put("server", data.getServer(server));
        return new ModelAndView("servers/serversview", params);
    }

    protected Object formBackingObject(HttpServletRequest request)
            throws ServletException {
        ServersAdapterAdd serversAdapterRemove = new ServersAdapterAdd();
        int server = Integer.parseInt(request.getParameter("server"));
        String name = request.getParameter("adapter");
        serversAdapterRemove.setData(data);
        serversAdapterRemove.setServer(server);
        serversAdapterRemove.setName(name);
        return serversAdapterRemove;
    }

    @Override
    protected ModelAndView showForm(HttpServletRequest arg0,
            HttpServletResponse arg1, BindException arg2, Map arg3)
            throws Exception {
        int serverId = Integer.parseInt(arg0.getParameter("server"));
        VlServer server = data.getServer(serverId);
        IVlAdapter adapter = data.getAdapter(serverId, arg0
                .getParameter("adapter"));
        Map<String, Object> m = new HashMap<String, Object>();
        m.put("server", server);
        m.put("adapter", adapter);
        return super.showForm(arg0, arg1, arg2, m);
    }

}
