/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import org.jrobin.core.RrdDataSet;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.Def;
import org.jrobin.graph.Print;
import org.jrobin.graph.Source;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExportData
implements RrdDataSet {
    private int arraySize;
    private long[] timestamps;
    private HashMap sourceByName;
    private HashMap legends;
    private Source[] sources;
    private Print printer;

    ExportData() {
        this.sourceByName = new HashMap();
        this.legends = new HashMap();
    }

    ExportData(long[] lArray, Source[] sourceArray, HashMap hashMap) {
        this.timestamps = lArray;
        this.sources = sourceArray;
        this.legends = hashMap;
        this.arraySize = lArray.length;
        this.sourceByName = new HashMap(sourceArray.length);
        for (int i = 0; i < sourceArray.length; ++i) {
            this.sourceByName.put(sourceArray[i].getName(), sourceArray[i]);
        }
    }

    public ExportData(String string) throws RrdException, IOException {
        this();
        this.importXml(string);
    }

    public ExportData(String string, boolean bl) throws RrdException, IOException {
        this();
        this.importXml(string, bl);
    }

    public ExportData(String string, String string2) throws RrdException, IOException {
        this();
        this.importXml(string, string2);
    }

    public ExportData(File file) throws RrdException, IOException {
        this();
        this.importXml(file);
    }

    public ExportData(File file, boolean bl) throws RrdException, IOException {
        this();
        this.importXml(file, bl);
    }

    public ExportData(File file, String string) throws RrdException, IOException {
        this();
        this.importXml(file, string);
    }

    public int getRowCount() {
        return this.sources.length;
    }

    public int getColumnCount() {
        return this.arraySize;
    }

    public long[] getTimestamps() {
        return this.timestamps;
    }

    public long getStep() {
        return this.timestamps[1] - this.timestamps[0];
    }

    public double[] getValues(int n) {
        return this.sources[n].getValues();
    }

    public double[][] getValues() {
        double[][] dArray = new double[this.sources.length][this.arraySize];
        for (int i = 0; i < this.sources.length; ++i) {
            dArray[i] = this.sources[i].getValues();
        }
        return dArray;
    }

    public double[] getValues(String string) throws RrdException {
        Source source = this.getSource(string);
        return source.getValues();
    }

    public long getFirstTimestamp() {
        return this.timestamps[0];
    }

    public long getLastTimestamp() {
        return this.timestamps[this.arraySize - 1];
    }

    public String[] getDsNames() {
        String[] stringArray = new String[this.sources.length];
        for (int i = 0; i < this.sources.length; ++i) {
            stringArray[i] = this.sources[i].getName();
        }
        return stringArray;
    }

    public int getDsIndex(String string) throws RrdException {
        for (int i = 0; i < this.sources.length; ++i) {
            if (!this.sources[i].getName().equals(string)) continue;
            return i;
        }
        throw new RrdException("No such datasource: " + string);
    }

    public double getAggregate(String string, String string2) throws RrdException {
        Source source = this.getSource(string);
        if (string2.equalsIgnoreCase("MAX")) {
            return source.getAggregate(1);
        }
        if (string2.equalsIgnoreCase("MIN")) {
            return source.getAggregate(0);
        }
        if (string2.equalsIgnoreCase("LAST")) {
            return source.getAggregate(4);
        }
        if (string2.equalsIgnoreCase("FIRST")) {
            return source.getAggregate(3);
        }
        if (string2.equalsIgnoreCase("TOTAL")) {
            return source.getAggregate(5);
        }
        if (string2.equalsIgnoreCase("AVERAGE")) {
            return source.getAggregate(2);
        }
        throw new RrdException("Unsupported consolidation function [" + string2 + "]");
    }

    public String print(String string, String string2, String string3) throws RrdException {
        return this.print(string, string2, string3, 1000.0);
    }

    public String print(String string, String string2, String string3, double d) throws RrdException {
        double d2 = this.getAggregate(string, string2);
        if (this.printer == null) {
            this.printer = new Print(d, -1);
        }
        return this.printer.getFormattedString(d2, string3, d);
    }

    public void importXml(String string) throws RrdException, IOException {
        this.importXml(string, true);
    }

    public void importXml(File file) throws RrdException, IOException {
        this.importXml(file, true);
    }

    public void importXml(File file, boolean bl) throws RrdException, IOException {
        Element element = Util.Xml.getRootElement(file);
        this.importXml(element, bl, "d");
    }

    public void importXml(String string, String string2) throws RrdException, IOException {
        Element element = Util.Xml.getRootElement(string);
        this.importXml(element, false, string2);
    }

    public void importXml(File file, String string) throws RrdException, IOException {
        Element element = Util.Xml.getRootElement(file);
        this.importXml(element, false, string);
    }

    public void importXml(String string, boolean bl) throws RrdException, IOException {
        Element element = Util.Xml.getRootElement(string);
        this.importXml(element, bl, "d");
    }

    public void exportXml(OutputStream outputStream) throws RrdException, IOException {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.write(this.exportXml());
        printWriter.flush();
    }

    public void exportXml(String string) throws RrdException, IOException {
        FileWriter fileWriter = new FileWriter(string);
        fileWriter.write(this.exportXml());
        fileWriter.close();
    }

    public String exportXml() throws RrdException, IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("<xport>\n");
        stringBuffer.append("\t<meta>\n");
        stringBuffer.append("\t\t<start>" + this.timestamps[0] + "</start>\n");
        stringBuffer.append("\t\t<step>" + (this.timestamps[1] - this.timestamps[0]) + "</step>\n");
        stringBuffer.append("\t\t<end>" + this.timestamps[this.arraySize - 1] + "</end>\n");
        stringBuffer.append("\t\t<rows>" + this.arraySize + "</rows>\n");
        stringBuffer.append("\t\t<columns>" + this.sources.length + "</columns>\n");
        stringBuffer.append("\t\t<legend>\n");
        for (n = 0; n < this.sources.length; ++n) {
            stringBuffer.append("\t\t\t<entry>" + this.getExportLegend(this.sources[n].getName()) + "</entry>\n");
        }
        stringBuffer.append("\t\t</legend>\n");
        stringBuffer.append("\t</meta>\n");
        stringBuffer.append("\t<data>\n");
        for (n = 0; n < this.arraySize; ++n) {
            stringBuffer.append("\t\t<row>");
            stringBuffer.append("<t>" + this.timestamps[n] + "</t>");
            for (int i = 0; i < this.sources.length; ++i) {
                stringBuffer.append("<v>" + this.sources[i].get(n) + "</v>");
            }
            stringBuffer.append("</row>\n");
        }
        stringBuffer.append("\t</data>\n");
        stringBuffer.append("</xport>\n");
        return stringBuffer.toString();
    }

    protected Source[] getSources() {
        return this.sources;
    }

    private String getExportLegend(String string) {
        if (!this.legends.containsKey(string)) {
            return "";
        }
        return (String)this.legends.get(string);
    }

    private Source getSource(String string) throws RrdException {
        if (!this.sourceByName.containsKey(string)) {
            throw new RrdException("No such datasource: " + string);
        }
        return (Source)this.sourceByName.get(string);
    }

    private void importXml(Element element, boolean bl, String string) throws RrdException {
        Node[] nodeArray;
        int n;
        Node node = Util.Xml.getFirstChildNode(element, "meta");
        Node[] nodeArray2 = Util.Xml.getChildNodes(Util.Xml.getFirstChildNode(element, "data"), "row");
        this.sourceByName.clear();
        this.legends.clear();
        int n2 = Util.Xml.getChildValueAsInt(node, "columns");
        long l = Util.Xml.getChildValueAsLong(node, "step");
        String[] stringArray = new String[n2];
        Node[] nodeArray3 = Util.Xml.getChildNodes(Util.Xml.getFirstChildNode(node, "legend"), "entry");
        for (n = 0; n < nodeArray3.length; ++n) {
            nodeArray = Util.Xml.getValue(nodeArray3[n]);
            stringArray[n] = bl ? nodeArray : string + (n + 1);
            this.legends.put(stringArray[n], nodeArray);
        }
        this.timestamps = new long[nodeArray2.length];
        this.sources = new Source[n2];
        this.arraySize = this.timestamps.length;
        for (n = 0; n < this.sources.length; ++n) {
            this.sources[n] = new Def(stringArray[n], this.arraySize, this.arraySize);
            this.sources[n].setFetchedStep(l);
        }
        for (n = 0; n < nodeArray2.length; ++n) {
            this.timestamps[n] = Util.Xml.getChildValueAsLong(nodeArray2[n], "t");
            nodeArray = Util.Xml.getChildNodes(nodeArray2[n], "v");
            for (int i = 0; i < nodeArray.length; ++i) {
                this.sources[i].set(n, this.timestamps[n], Util.Xml.getValueAsDouble(nodeArray[i]));
            }
        }
        for (n = 0; n < this.sources.length; ++n) {
            this.sourceByName.put(this.sources[n].getName(), this.sources[n]);
        }
    }
}

