/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspException;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.tags.form.AbstractCheckedElementTag;
import org.springframework.web.servlet.tags.form.TagIdGenerator;
import org.springframework.web.servlet.tags.form.TagWriter;

public abstract class AbstractMultiCheckedElementTag
extends AbstractCheckedElementTag {
    private static final String SPAN_TAG = "span";
    private Object items;
    private String itemValue;
    private String itemLabel;
    private String element = "span";
    private String delimiter;

    public void setItems(Object items) {
        Assert.notNull((Object)items, (String)"'items' must not be null");
        this.items = items;
    }

    protected Object getItems() {
        return this.items;
    }

    public void setItemValue(String itemValue) {
        Assert.hasText((String)itemValue, (String)"'itemValue' must not be empty");
        this.itemValue = itemValue;
    }

    protected String getItemValue() {
        return this.itemValue;
    }

    public void setItemLabel(String itemLabel) {
        Assert.hasText((String)itemLabel, (String)"'itemLabel' must not be empty");
        this.itemLabel = itemLabel;
    }

    protected String getItemLabel() {
        return this.itemLabel;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setElement(String element) {
        Assert.hasText((String)element, (String)"'element' cannot be null or blank");
        this.element = element;
    }

    public String getElement() {
        return this.element;
    }

    protected String resolveId() throws JspException {
        Object id = this.evaluate("id", this.getId());
        id = id != null && StringUtils.hasText((String)id.toString()) ? TagIdGenerator.nextId(id.toString(), this.pageContext) : this.autogenerateId();
        return id.toString();
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        String labelProperty;
        Object items = this.getItems();
        Object itemsObject = items instanceof String ? this.evaluate("items", (String)items) : items;
        String itemValue = this.getItemValue();
        String itemLabel = this.getItemLabel();
        String valueProperty = itemValue != null ? ObjectUtils.getDisplayString((Object)this.evaluate("itemValue", itemValue)) : null;
        String string = labelProperty = itemLabel != null ? ObjectUtils.getDisplayString((Object)this.evaluate("itemLabel", itemLabel)) : null;
        if (itemsObject == null) {
            throw new IllegalArgumentException("Attribute 'items' is required and must be a Collection, an Array or a Map");
        }
        if (itemsObject.getClass().isArray()) {
            Object[] itemsArray = (Object[])itemsObject;
            for (int i = 0; i < itemsArray.length; ++i) {
                Object item = itemsArray[i];
                this.writeObjectEntry(tagWriter, valueProperty, labelProperty, item, i);
            }
        } else if (itemsObject instanceof Collection) {
            Collection optionCollection = (Collection)itemsObject;
            int itemIndex = 0;
            Iterator it = optionCollection.iterator();
            while (it.hasNext()) {
                Object item = it.next();
                this.writeObjectEntry(tagWriter, valueProperty, labelProperty, item, itemIndex);
                ++itemIndex;
            }
        } else if (itemsObject instanceof Map) {
            Map optionMap = (Map)itemsObject;
            int itemIndex = 0;
            Iterator it = optionMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.writeMapEntry(tagWriter, valueProperty, labelProperty, entry, itemIndex);
                ++itemIndex;
            }
        } else {
            throw new IllegalArgumentException("Attribute 'items' must be a Collection, an Array or a Map");
        }
        return 6;
    }

    private void writeObjectEntry(TagWriter tagWriter, String valueProperty, String labelProperty, Object item, int itemIndex) throws JspException {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
        Object renderValue = valueProperty != null ? wrapper.getPropertyValue(valueProperty) : item;
        Object renderLabel = labelProperty != null ? wrapper.getPropertyValue(labelProperty) : item;
        this.writeElementTag(tagWriter, item, renderValue, renderLabel, itemIndex);
    }

    private void writeMapEntry(TagWriter tagWriter, String valueProperty, String labelProperty, Map.Entry entry, int itemIndex) throws JspException {
        Object mapKey = entry.getKey();
        Object mapValue = entry.getValue();
        BeanWrapper mapKeyWrapper = PropertyAccessorFactory.forBeanPropertyAccess(mapKey);
        BeanWrapper mapValueWrapper = PropertyAccessorFactory.forBeanPropertyAccess(mapValue);
        Object renderValue = valueProperty != null ? mapKeyWrapper.getPropertyValue(valueProperty) : mapKey.toString();
        Object renderLabel = labelProperty != null ? mapValueWrapper.getPropertyValue(labelProperty) : mapValue.toString();
        this.writeElementTag(tagWriter, mapKey, renderValue, renderLabel, itemIndex);
    }

    private void writeElementTag(TagWriter tagWriter, Object item, Object value, Object label, int itemIndex) throws JspException {
        Object resolvedDelimiter;
        tagWriter.startTag(this.getElement());
        if (itemIndex > 0 && (resolvedDelimiter = this.evaluate("delimiter", this.getDelimiter())) != null) {
            tagWriter.appendValue(resolvedDelimiter.toString());
        }
        tagWriter.startTag("input");
        String id = this.resolveId();
        this.writeOptionalAttribute(tagWriter, "id", id);
        this.writeOptionalAttribute(tagWriter, "name", this.getName());
        this.writeOptionalAttributes(tagWriter);
        tagWriter.writeAttribute("type", this.getInputType());
        this.renderFromValue(item, value, tagWriter);
        tagWriter.endTag();
        tagWriter.startTag("label");
        tagWriter.writeAttribute("for", id);
        tagWriter.appendValue(label.toString());
        tagWriter.endTag();
        tagWriter.endTag();
    }

    protected abstract String getInputType();
}

