/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.common;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdException;
import org.jrobin.core.Sample;
import org.videolan.vlma.common.Configuration;
import org.videolan.vlma.common.VlServer;
import snmp.SNMPBadValueException;
import snmp.SNMPGetException;
import snmp.SNMPSequence;
import snmp.SNMPVarBindList;
import snmp.SNMPv1CommunicationInterface;

public class VlServerReal
extends VlServer {
    public VlServerReal(String name, InetAddress ip) {
        super(name, ip);
    }

    public void updateSnmpData() {
        String rrdFile = this.createRrdFileIfNecessary();
        try {
            SNMPv1CommunicationInterface comm = new SNMPv1CommunicationInterface(0, this.getIp(), Configuration.getInstance().getSnmpCommunity());
            Map<String, String> configurationOids = Configuration.getInstance().getoids();
            String[] oid = new String[]{configurationOids.get("CPU_LOAD"), configurationOids.get("TRAFFIC_IN"), configurationOids.get("TRAFFIC_OUT"), configurationOids.get("VLC_CPU"), configurationOids.get("VLC_MEM")};
            SNMPVarBindList varList = comm.getMIBEntry(oid);
            SNMPSequence pair = (SNMPSequence)varList.getSNMPObjectAt(0);
            this.currentCpuLoad = Double.parseDouble(pair.getSNMPObjectAt(1).toString().trim());
            pair = (SNMPSequence)varList.getSNMPObjectAt(1);
            this.currentTrafficIn = Long.parseLong(pair.getSNMPObjectAt(1).toString().trim());
            pair = (SNMPSequence)varList.getSNMPObjectAt(2);
            this.currentTrafficOut = Long.parseLong(pair.getSNMPObjectAt(1).toString().trim());
            pair = (SNMPSequence)varList.getSNMPObjectAt(3);
            this.currentVlcCpu = Double.parseDouble(pair.getSNMPObjectAt(1).toString().trim());
            pair = (SNMPSequence)varList.getSNMPObjectAt(4);
            this.currentVlcMem = Double.parseDouble(pair.getSNMPObjectAt(1).toString().trim());
        }
        catch (SNMPGetException e) {
            logger.error((Object)("Error while fetching data from SNMP of " + this.getName()), (Throwable)e);
        }
        catch (SNMPBadValueException e) {
            logger.error((Object)("Error while fetching data from SNMP of " + this.getName()), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("Error while fetching data from SNMP of " + this.getName()), (Throwable)e);
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Error while fetching data from SNMP of " + this.getName()), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("Error while fetching data from SNMP of " + this.getName()), (Throwable)e);
        }
        try {
            RrdDbPool rrdPool = RrdDbPool.getInstance();
            RrdDb rrdDb = rrdPool.requestRrdDb(rrdFile);
            Sample sample = rrdDb.createSample();
            sample.setValue("cpu_load", this.currentCpuLoad);
            sample.setValue("traffic_in", (double)this.currentTrafficIn);
            sample.setValue("traffic_out", (double)this.currentTrafficOut);
            sample.setValue("vlc_cpu", this.currentVlcCpu);
            sample.setValue("vlc_mem", this.currentVlcMem);
            sample.update();
            rrdPool.release(rrdDb);
        }
        catch (RrdException e) {
            logger.error((Object)("Error while writing data from SNMP of " + this.getName()), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("Error while writing data from SNMP of " + this.getName()), (Throwable)e);
        }
    }

    public boolean checkVLC() {
        try {
            Socket socket = new Socket(this.ip, Configuration.getInstance().getVlcTelnetPort());
            socket.close();
            this.setUp(true);
            logger.log((Priority)Level.DEBUG, (Object)("Le VLC de " + this.getName() + " est accessible"));
        }
        catch (IOException e) {
            logger.log((Priority)Level.ERROR, (Object)("Impossible to contact VLC server of " + this.getName() + " through telnet interface."), (Throwable)e);
            this.setUp(false);
        }
        return this.isUp;
    }

    public boolean equals(Object o) {
        if (o.getClass().equals(VlServerReal.class)) {
            return ((VlServerReal)o).name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

