/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.common.medias;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.medias.VlMedia;
import org.videolan.vlma.common.medias.VlMediaGroup;
import org.videolan.vlma.common.programs.IVlProgram;

public class VlSatChannel
extends VlMedia {
    private static final Logger logger = Logger.getLogger(VlSatChannel.class);
    private int frequency;
    private char polarisation;
    private int sid;
    private String fullname;
    private String country;
    private String category;
    private String encryption;
    private int errorCorrection;
    private int symbolRate;
    private String coverage;
    public static final String SAT_SAP_GROUP = "Satellite";
    public static final String RADIO_SAP_GROUP = "Radio";

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
        this.updateSapGroup();
    }

    public void setProgram(IVlProgram program) {
        super.setProgram(program);
        this.updateSapGroup();
    }

    protected void updateSapGroup() {
        if (this.program != null) {
            if (this.category.equals("R-DIG")) {
                this.program.setSapGroup(RADIO_SAP_GROUP);
            } else {
                this.program.setSapGroup(SAT_SAP_GROUP);
            }
        }
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public void setEncryption(String encryption) {
        this.encryption = encryption;
    }

    public int getErrorCorrection() {
        return this.errorCorrection;
    }

    public void setErrorCorrection(int errorCorrection) {
        this.errorCorrection = errorCorrection;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public char getPolarisation() {
        return this.polarisation;
    }

    public void setPolarisation(char polarisation) {
        this.polarisation = polarisation;
    }

    public int getSid() {
        return this.sid;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public int getSymbolRate() {
        return this.symbolRate;
    }

    public void setSymbolRate(int symbolRate) {
        this.symbolRate = symbolRate;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getCoverage() {
        return this.coverage;
    }

    public void setCoverage(String coverage) {
        this.coverage = coverage;
    }

    public boolean equals(Object o) {
        if (o.getClass().equals(VlSatChannel.class)) {
            VlSatChannel c = (VlSatChannel)o;
            logger.log((Priority)Level.DEBUG, (Object)("Comparison of " + this.getName() + " with " + c.getName()));
            return c.getCoverage().equals(this.coverage) && c.getFrequency() == this.frequency && c.name.equals(this.name);
        }
        return false;
    }

    public boolean sameGroup(IVlMedia media) {
        if (media.getClass() == VlSatChannel.class) {
            VlSatChannel c = (VlSatChannel)media;
            return c.getCoverage().equals(this.coverage) && c.getFrequency() == this.frequency;
        }
        return false;
    }

    public boolean belongsToGroup(VlMediaGroup group) {
        if (!group.medias.isEmpty()) {
            return this.sameGroup(group.medias.get(0));
        }
        return false;
    }

    public int hashCode() {
        return this.frequency + this.coverage.hashCode() + this.name.hashCode();
    }

    public int getId() {
        return this.hashCode();
    }

    public boolean getIsRadio() {
        return this.category.contains("R-DIG");
    }

    public boolean getIsCrypted() {
        return this.category.contains("CRYPT");
    }

    public int compareTo(IVlMedia other) {
        if (other == null) {
            return -1;
        }
        if (other.getClass().equals(VlSatChannel.class)) {
            VlSatChannel channel = (VlSatChannel)other;
            if (channel.getFrequency() < this.frequency) {
                return 1;
            }
            if (channel.getFrequency() > this.frequency) {
                return -1;
            }
            return this.name.compareTo(channel.getName());
        }
        return -1;
    }
}

