/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.common.programs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.programs.IVlProgram;

public class VlIpBank {
    private static final Logger logger = Logger.getLogger(VlIpBank.class);
    private HashMap<InetAddress, Boolean> usedIps;
    private IVlData data;

    public void initIps(boolean IPsDevel) throws UnknownHostException {
        int iMax;
        int iMin;
        this.usedIps = new HashMap();
        this.usedIps.clear();
        if (!IPsDevel) {
            iMin = 100;
            iMax = 120;
        } else {
            iMin = 200;
            iMax = 220;
        }
        for (int i = iMin; i < iMax; ++i) {
            for (int j = 1; j < 255; ++j) {
                byte[] b = new byte[]{-17, -1, (byte)i, (byte)j};
                this.usedIps.put(InetAddress.getByAddress(b), Boolean.FALSE);
            }
        }
        for (IVlMedia m : this.data.getMedias()) {
            IVlProgram p = m.getProgram();
            if (p == null) continue;
            logger.log((Priority)Level.DEBUG, (Object)("The media " + m.getName() + " has a prohram"));
            if (!this.usedIps.containsKey(p.getIp())) continue;
            this.usedIps.put(p.getIp(), Boolean.TRUE);
        }
    }

    public InetAddress getIp() {
        for (Map.Entry<InetAddress, Boolean> i : this.usedIps.entrySet()) {
            if (i.getValue().booleanValue()) continue;
            i.setValue(Boolean.TRUE);
            return i.getKey();
        }
        return null;
    }

    public VlIpBank(IVlData data) {
        this.data = data;
    }
}

