/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.jrobin.core.ArcDef;
import org.jrobin.core.DsDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;

public class RrdDef {
    public static final long DEFAULT_STEP = 300L;
    public static final long DEFAULT_INITIAL_SHIFT = -10L;
    private String path;
    private long startTime = Util.getTime() + -10L;
    private long step = 300L;
    private ArrayList dsDefs = new ArrayList();
    private ArrayList arcDefs = new ArrayList();

    public RrdDef(String string) throws RrdException {
        if (string == null || string.length() == 0) {
            throw new RrdException("No path specified");
        }
        this.path = string;
    }

    public RrdDef(String string, long l) throws RrdException {
        this(string);
        if (l <= 0L) {
            throw new RrdException("Invalid RRD step specified: " + l);
        }
        this.step = l;
    }

    public RrdDef(String string, long l, long l2) throws RrdException {
        this(string, l2);
        if (l < 0L) {
            throw new RrdException("Invalid RRD start time specified: " + l);
        }
        this.startTime = l;
    }

    public String getPath() {
        return this.path;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStep() {
        return this.step;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public void setStartTime(Date date) {
        this.startTime = Util.getTimestamp(date);
    }

    public void setStartTime(GregorianCalendar gregorianCalendar) {
        this.startTime = Util.getTimestamp(gregorianCalendar);
    }

    public void setStep(long l) {
        this.step = l;
    }

    public void addDatasource(DsDef dsDef) throws RrdException {
        if (this.dsDefs.contains(dsDef)) {
            throw new RrdException("Datasource already defined: " + dsDef.dump());
        }
        this.dsDefs.add(dsDef);
    }

    public void addDatasource(String string, String string2, long l, double d, double d2) throws RrdException {
        this.addDatasource(new DsDef(string, string2, l, d, d2));
    }

    public void addDatasource(String string) throws RrdException {
        long l;
        RrdException rrdException = new RrdException("Wrong rrdtool-like datasource definition: " + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 6) {
            throw rrdException;
        }
        String[] stringArray = new String[6];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        if (!stringArray[0].equalsIgnoreCase("DS")) {
            throw rrdException;
        }
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        try {
            l = Long.parseLong(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            throw rrdException;
        }
        double d = Double.NaN;
        if (!stringArray[4].equalsIgnoreCase("U")) {
            try {
                d = Double.parseDouble(stringArray[4]);
            }
            catch (NumberFormatException numberFormatException) {
                throw rrdException;
            }
        }
        double d2 = Double.NaN;
        if (!stringArray[5].equalsIgnoreCase("U")) {
            try {
                d2 = Double.parseDouble(stringArray[5]);
            }
            catch (NumberFormatException numberFormatException) {
                throw rrdException;
            }
        }
        this.addDatasource(new DsDef(string2, string3, l, d, d2));
    }

    public void addDatasource(DsDef[] dsDefArray) throws RrdException {
        for (int i = 0; i < dsDefArray.length; ++i) {
            this.addDatasource(dsDefArray[i]);
        }
    }

    public void addArchive(ArcDef arcDef) throws RrdException {
        if (this.arcDefs.contains(arcDef)) {
            throw new RrdException("Archive already defined: " + arcDef.dump());
        }
        this.arcDefs.add(arcDef);
    }

    public void addArchive(ArcDef[] arcDefArray) throws RrdException {
        for (int i = 0; i < arcDefArray.length; ++i) {
            this.addArchive(arcDefArray[i]);
        }
    }

    public void addArchive(String string, double d, int n, int n2) throws RrdException {
        this.addArchive(new ArcDef(string, d, n, n2));
    }

    public void addArchive(String string) throws RrdException {
        int n;
        int n2;
        double d;
        RrdException rrdException = new RrdException("Wrong rrdtool-like archive definition: " + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 5) {
            throw rrdException;
        }
        String[] stringArray = new String[5];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        if (!stringArray[0].equalsIgnoreCase("RRA")) {
            throw rrdException;
        }
        String string2 = stringArray[1];
        try {
            d = Double.parseDouble(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            throw rrdException;
        }
        try {
            n2 = Integer.parseInt(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            throw rrdException;
        }
        try {
            n = Integer.parseInt(stringArray[4]);
        }
        catch (NumberFormatException numberFormatException) {
            throw rrdException;
        }
        this.addArchive(new ArcDef(string2, d, n2, n));
    }

    void validate() throws RrdException {
        if (this.dsDefs.size() == 0) {
            throw new RrdException("No RRD datasource specified. At least one is needed.");
        }
        if (this.arcDefs.size() == 0) {
            throw new RrdException("No RRD archive specified. At least one is needed.");
        }
    }

    public DsDef[] getDsDefs() {
        return this.dsDefs.toArray(new DsDef[0]);
    }

    public ArcDef[] getArcDefs() {
        return this.arcDefs.toArray(new ArcDef[0]);
    }

    public int getDsCount() {
        return this.dsDefs.size();
    }

    public int getArcCount() {
        return this.arcDefs.size();
    }

    public String dump() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer("create \"");
        stringBuffer.append(this.path + "\"");
        stringBuffer.append(" --start " + this.getStartTime());
        stringBuffer.append(" --step " + this.getStep() + " ");
        for (n = 0; n < this.dsDefs.size(); ++n) {
            object = (DsDef)this.dsDefs.get(n);
            stringBuffer.append(((DsDef)object).dump() + " ");
        }
        for (n = 0; n < this.arcDefs.size(); ++n) {
            object = (ArcDef)this.arcDefs.get(n);
            stringBuffer.append(((ArcDef)object).dump() + " ");
        }
        return stringBuffer.toString().trim();
    }

    String getRrdToolCommand() {
        return this.dump();
    }

    void removeDatasource(String string) throws RrdException {
        for (int i = 0; i < this.dsDefs.size(); ++i) {
            DsDef dsDef = (DsDef)this.dsDefs.get(i);
            if (!dsDef.getDsName().equals(string)) continue;
            this.dsDefs.remove(i);
            return;
        }
        throw new RrdException("Could not find datasource named '" + string + "'");
    }

    void removeArchive(String string, int n) throws RrdException {
        ArcDef arcDef = this.findArchive(string, n);
        if (!this.arcDefs.remove(arcDef)) {
            throw new RrdException("Could not remove archive " + string + "/" + n);
        }
    }

    ArcDef findArchive(String string, int n) throws RrdException {
        for (int i = 0; i < this.arcDefs.size(); ++i) {
            ArcDef arcDef = (ArcDef)this.arcDefs.get(i);
            if (!arcDef.getConsolFun().equals(string) || arcDef.getSteps() != n) continue;
            return arcDef;
        }
        throw new RrdException("Could not find archive " + string + "/" + n);
    }

    public void exportXmlTemplate(OutputStream outputStream) {
        XmlWriter xmlWriter = new XmlWriter(outputStream);
        xmlWriter.startTag("rrd_def");
        xmlWriter.writeTag("path", this.getPath());
        xmlWriter.writeTag("step", this.getStep());
        xmlWriter.writeTag("start", this.getStartTime());
        DsDef[] dsDefArray = this.getDsDefs();
        for (int i = 0; i < dsDefArray.length; ++i) {
            xmlWriter.startTag("datasource");
            xmlWriter.writeTag("name", dsDefArray[i].getDsName());
            xmlWriter.writeTag("type", dsDefArray[i].getDsType());
            xmlWriter.writeTag("heartbeat", dsDefArray[i].getHeartbeat());
            xmlWriter.writeTag("min", dsDefArray[i].getMinValue(), "U");
            xmlWriter.writeTag("max", dsDefArray[i].getMaxValue(), "U");
            xmlWriter.closeTag();
        }
        ArcDef[] arcDefArray = this.getArcDefs();
        for (int i = 0; i < arcDefArray.length; ++i) {
            xmlWriter.startTag("archive");
            xmlWriter.writeTag("cf", arcDefArray[i].getConsolFun());
            xmlWriter.writeTag("xff", arcDefArray[i].getXff());
            xmlWriter.writeTag("steps", arcDefArray[i].getSteps());
            xmlWriter.writeTag("rows", arcDefArray[i].getRows());
            xmlWriter.closeTag();
        }
        xmlWriter.closeTag();
        xmlWriter.flush();
    }

    public String exportXmlTemplate() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportXmlTemplate(byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    public void exportXmlTemplate(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string, false);
        this.exportXmlTemplate(fileOutputStream);
        fileOutputStream.close();
    }

    public long getEstimatedSize() {
        int n = this.dsDefs.size();
        int n2 = this.arcDefs.size();
        int n3 = 0;
        for (int i = 0; i < this.arcDefs.size(); ++i) {
            ArcDef arcDef = (ArcDef)this.arcDefs.get(i);
            n3 += arcDef.getRows();
        }
        return RrdDef.calculateSize(n, n2, n3);
    }

    static long calculateSize(int n, int n2, int n3) {
        return 64L + 128L * (long)n + 56L * (long)n2 + 20L * (long)n * (long)n2 + 8L * (long)n * (long)n3;
    }

    public boolean equals(Object object) {
        ArcDef[] arcDefArray;
        int n;
        DsDef[] dsDefArray;
        if (object == null || !(object instanceof RrdDef)) {
            return false;
        }
        RrdDef rrdDef = (RrdDef)object;
        if (this.step != rrdDef.step) {
            return false;
        }
        DsDef[] dsDefArray2 = this.getDsDefs();
        if (dsDefArray2.length != (dsDefArray = rrdDef.getDsDefs()).length) {
            return false;
        }
        for (int i = 0; i < dsDefArray2.length; ++i) {
            boolean bl = false;
            for (n = 0; n < dsDefArray.length; ++n) {
                if (!dsDefArray2[i].exactlyEqual(dsDefArray[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        ArcDef[] arcDefArray2 = this.getArcDefs();
        if (arcDefArray2.length != (arcDefArray = rrdDef.getArcDefs()).length) {
            return false;
        }
        for (n = 0; n < arcDefArray2.length; ++n) {
            boolean bl = false;
            for (int i = 0; i < arcDefArray.length; ++i) {
                if (!arcDefArray2[n].exactlyEqual(arcDefArray[i])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }
}

