/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.RrdBackend;

public class RrdMemoryBackend
extends RrdBackend {
    private byte[] buffer = new byte[0];

    protected RrdMemoryBackend(String string) {
        super(string);
    }

    protected synchronized void write(long l, byte[] byArray) throws IOException {
        int n = (int)l;
        for (int i = 0; i < byArray.length; ++i) {
            this.buffer[n++] = byArray[i];
        }
    }

    protected synchronized void read(long l, byte[] byArray) throws IOException {
        int n = (int)l;
        if (n + byArray.length <= this.buffer.length) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = this.buffer[n++];
            }
        } else {
            throw new IOException("Not enough bytes available in memory " + this.getPath());
        }
    }

    public long getLength() {
        return this.buffer.length;
    }

    protected void setLength(long l) throws IOException {
        if (l > Integer.MAX_VALUE) {
            throw new IOException("Cannot create this big memory backed RRD");
        }
        this.buffer = new byte[(int)l];
    }

    public void close() {
    }
}

