/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.util.Map;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.TransactionRequiredException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaObjectRetrievalFailureException;
import org.springframework.orm.jpa.JpaOptimisticLockingFailureException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class EntityManagerFactoryUtils {
    public static final int ENTITY_MANAGER_SYNCHRONIZATION_ORDER = 900;
    private static final Log logger = LogFactory.getLog(EntityManagerFactoryUtils.class);

    public static EntityManagerFactory findEntityManagerFactory(ListableBeanFactory beanFactory, String unitName) throws NoSuchBeanDefinitionException {
        String[] candidateNames;
        Assert.notNull(beanFactory, "ListableBeanFactory must not be null");
        Assert.hasLength(unitName, "Unit name must not be empty");
        for (String candidateName : candidateNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(beanFactory, EntityManagerFactory.class)) {
            EntityManagerFactory emf = (EntityManagerFactory)beanFactory.getBean(candidateName);
            if (!(emf instanceof EntityManagerFactoryInfo) || !unitName.equals(((EntityManagerFactoryInfo)emf).getPersistenceUnitName())) continue;
            return emf;
        }
        return (EntityManagerFactory)beanFactory.getBean(unitName, EntityManagerFactory.class);
    }

    public static EntityManager getTransactionalEntityManager(EntityManagerFactory emf) throws DataAccessResourceFailureException {
        return EntityManagerFactoryUtils.getTransactionalEntityManager(emf, null);
    }

    public static EntityManager getTransactionalEntityManager(EntityManagerFactory emf, Map properties) throws DataAccessResourceFailureException {
        try {
            return EntityManagerFactoryUtils.doGetTransactionalEntityManager(emf, properties);
        }
        catch (PersistenceException ex) {
            throw new DataAccessResourceFailureException("Could not obtain JPA EntityManager", ex);
        }
    }

    public static EntityManager doGetTransactionalEntityManager(EntityManagerFactory emf, Map properties) throws PersistenceException {
        EntityManager em;
        Assert.notNull(emf, "No EntityManagerFactory specified");
        EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource(emf);
        if (emHolder != null) {
            if (!emHolder.isSynchronizedWithTransaction() && TransactionSynchronizationManager.isSynchronizationActive()) {
                try {
                    emHolder.getEntityManager().joinTransaction();
                }
                catch (TransactionRequiredException ex) {
                    logger.debug((Object)"Could not join JTA transaction because none was active", (Throwable)ex);
                }
                Object transactionData = EntityManagerFactoryUtils.prepareTransaction(emHolder.getEntityManager(), emf);
                TransactionSynchronizationManager.registerSynchronization(new EntityManagerSynchronization(emHolder, emf, transactionData, false));
                emHolder.setSynchronizedWithTransaction(true);
            }
            return emHolder.getEntityManager();
        }
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return null;
        }
        logger.debug((Object)"Opening JPA EntityManager");
        EntityManager entityManager = em = !CollectionUtils.isEmpty(properties) ? emf.createEntityManager(properties) : emf.createEntityManager();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug((Object)"Registering transaction synchronization for JPA EntityManager");
            emHolder = new EntityManagerHolder(em);
            Object transactionData = EntityManagerFactoryUtils.prepareTransaction(em, emf);
            TransactionSynchronizationManager.registerSynchronization(new EntityManagerSynchronization(emHolder, emf, transactionData, true));
            emHolder.setSynchronizedWithTransaction(true);
            TransactionSynchronizationManager.bindResource(emf, emHolder);
        }
        return em;
    }

    private static Object prepareTransaction(EntityManager em, EntityManagerFactory emf) {
        EntityManagerFactoryInfo emfInfo;
        JpaDialect jpaDialect;
        if (emf instanceof EntityManagerFactoryInfo && (jpaDialect = (emfInfo = (EntityManagerFactoryInfo)emf).getJpaDialect()) != null) {
            return jpaDialect.prepareTransaction(em, TransactionSynchronizationManager.isCurrentTransactionReadOnly(), TransactionSynchronizationManager.getCurrentTransactionName());
        }
        return null;
    }

    private static void cleanupTransaction(Object transactionData, EntityManagerFactory emf) {
        EntityManagerFactoryInfo emfInfo;
        JpaDialect jpaDialect;
        if (emf instanceof EntityManagerFactoryInfo && (jpaDialect = (emfInfo = (EntityManagerFactoryInfo)emf).getJpaDialect()) != null) {
            jpaDialect.cleanupTransaction(transactionData);
        }
    }

    public static DataAccessException convertJpaAccessExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof IllegalStateException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof IllegalArgumentException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof EntityNotFoundException) {
            return new JpaObjectRetrievalFailureException((EntityNotFoundException)ex);
        }
        if (ex instanceof NoResultException) {
            return new EmptyResultDataAccessException(ex.getMessage(), 1);
        }
        if (ex instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1);
        }
        if (ex instanceof OptimisticLockException) {
            return new JpaOptimisticLockingFailureException((OptimisticLockException)ex);
        }
        if (ex instanceof EntityExistsException) {
            return new DataIntegrityViolationException(ex.getMessage(), ex);
        }
        if (ex instanceof TransactionRequiredException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof PersistenceException) {
            return new JpaSystemException((PersistenceException)((Object)ex));
        }
        return null;
    }

    public static void closeEntityManager(EntityManager em) {
        if (em != null) {
            logger.debug((Object)"Closing JPA EntityManager");
            try {
                em.close();
            }
            catch (PersistenceException ex) {
                logger.debug((Object)"Could not close JPA EntityManager", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.debug((Object)"Unexpected exception on closing JPA EntityManager", ex);
            }
        }
    }

    private static class EntityManagerSynchronization
    extends TransactionSynchronizationAdapter {
        private final EntityManagerHolder entityManagerHolder;
        private final EntityManagerFactory entityManagerFactory;
        private final Object transactionData;
        private final boolean newEntityManager;
        private boolean holderActive = true;

        public EntityManagerSynchronization(EntityManagerHolder emHolder, EntityManagerFactory emf, Object transactionData, boolean newEntityManager) {
            this.entityManagerHolder = emHolder;
            this.entityManagerFactory = emf;
            this.transactionData = transactionData;
            this.newEntityManager = newEntityManager;
        }

        public int getOrder() {
            return 900;
        }

        public void suspend() {
            if (this.holderActive) {
                TransactionSynchronizationManager.unbindResource(this.entityManagerFactory);
            }
        }

        public void resume() {
            if (this.holderActive) {
                TransactionSynchronizationManager.bindResource(this.entityManagerFactory, this.entityManagerHolder);
            }
        }

        public void beforeCompletion() {
            if (this.newEntityManager) {
                TransactionSynchronizationManager.unbindResource(this.entityManagerFactory);
                this.holderActive = false;
                EntityManagerFactoryUtils.closeEntityManager(this.entityManagerHolder.getEntityManager());
            }
        }

        public void afterCompletion(int status) {
            if (!this.newEntityManager) {
                if (status != 0) {
                    this.entityManagerHolder.getEntityManager().clear();
                }
                EntityManagerFactoryUtils.cleanupTransaction(this.transactionData, this.entityManagerFactory);
            }
            this.entityManagerHolder.setSynchronizedWithTransaction(false);
        }
    }
}

