/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.web.context.WebApplicationContext;

public class ContextExposingHttpServletRequest
extends HttpServletRequestWrapper {
    private final WebApplicationContext webApplicationContext;
    private Set explicitAttributes;

    public ContextExposingHttpServletRequest(HttpServletRequest originalRequest, WebApplicationContext context) {
        super(originalRequest);
        this.webApplicationContext = context;
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    public Object getAttribute(String name) {
        if ((this.explicitAttributes == null || !this.explicitAttributes.contains(name)) && this.webApplicationContext.containsBean(name)) {
            return this.webApplicationContext.getBean(name);
        }
        return super.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        if (this.explicitAttributes == null) {
            this.explicitAttributes = new HashSet(8);
        }
        this.explicitAttributes.add(name);
    }
}

