/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.io.File;
import javax.servlet.ServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.util.WebUtils;

public abstract class WebApplicationObjectSupport
extends ApplicationObjectSupport
implements ServletContextAware {
    private ServletContext servletContext;

    public final void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        if (servletContext != null) {
            this.initServletContext(servletContext);
        }
    }

    protected boolean isContextRequired() {
        return true;
    }

    protected void initApplicationContext(ApplicationContext context) {
        ServletContext servletContext;
        super.initApplicationContext(context);
        if (context instanceof WebApplicationContext && (servletContext = ((WebApplicationContext)context).getServletContext()) != null) {
            this.initServletContext(servletContext);
        }
    }

    protected void initServletContext(ServletContext servletContext) {
    }

    protected final WebApplicationContext getWebApplicationContext() throws IllegalStateException {
        ApplicationContext ctx = this.getApplicationContext();
        if (!(ctx instanceof WebApplicationContext)) {
            throw new IllegalStateException("WebApplicationObjectSupport instance [" + this + "] does not run in a WebApplicationContext but in: " + ctx);
        }
        return (WebApplicationContext)this.getApplicationContext();
    }

    protected final ServletContext getServletContext() throws IllegalStateException {
        if (this.servletContext != null) {
            return this.servletContext;
        }
        ServletContext servletContext = this.getWebApplicationContext().getServletContext();
        if (servletContext == null) {
            throw new IllegalStateException("WebApplicationObjectSupport instance [" + this + "] does not run within a ServletContext. Make sure the object is fully configured!");
        }
        return servletContext;
    }

    protected final File getTempDir() throws IllegalStateException {
        return WebUtils.getTempDir(this.getServletContext());
    }
}

