/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import rath.msnm.Debug;
import rath.msnm.MSNMessenger;
import rath.msnm.entity.Callback;
import rath.msnm.entity.ServerInfo;
import rath.msnm.msg.IncomingMessage;
import rath.msnm.msg.MimeMessage;
import rath.msnm.msg.OutgoingMessage;

public abstract class AbstractProcessor
extends Thread {
    public final MSNMessenger msn;
    private static final Class[] PARAM_TYPE = new Class[]{class$rath$msnm$msg$IncomingMessage == null ? (class$rath$msnm$msg$IncomingMessage = AbstractProcessor.class$("rath.msnm.msg.IncomingMessage")) : class$rath$msnm$msg$IncomingMessage};
    private ServerInfo info = null;
    private boolean autoOut = false;
    private int trId;
    private String name = "";
    protected HashMap callbackMap = new HashMap();
    protected volatile boolean isLive;
    protected Socket socket = null;
    protected InputStream in = null;
    protected OutputStream out = null;
    private ByteArrayOutputStream inbuf = new ByteArrayOutputStream();
    static /* synthetic */ Class class$rath$msnm$msg$IncomingMessage;

    protected AbstractProcessor(MSNMessenger msn) {
        this(msn, null, 1);
    }

    protected AbstractProcessor(MSNMessenger msn, ServerInfo info) {
        this(msn, info, 1);
    }

    protected AbstractProcessor(MSNMessenger msn, ServerInfo info, int trId) {
        this.msn = msn;
        this.info = info;
        this.trId = trId;
    }

    public void setServerName(String name) {
        this.name = name;
        this.setName("MSN Channel(" + name + ")");
    }

    public String getServerName() {
        return this.name;
    }

    public void setAutoOutSend(boolean autoOut) {
        this.autoOut = autoOut;
    }

    public boolean isAutoOutSend() {
        return this.autoOut;
    }

    protected void setServerInfo(ServerInfo info) {
        this.info = info;
    }

    protected ServerInfo getServerInfo() {
        return this.info;
    }

    protected void makeConnection() throws IOException {
        this.closeConnection();
        this.socket = new Socket(this.info.getHostAddress(), this.info.getPort());
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
    }

    protected void closeConnection() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.out != null) {
            this.out.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public abstract void init() throws IOException;

    public synchronized void sendMessage(OutgoingMessage msg) throws IOException {
        if (this.out == null) {
            return;
        }
        if (this.trId != -1 && msg.getBackProcess() != null) {
            this.callbackMap.put(new Integer(this.trId), msg.getBackProcess());
        }
        if (Debug.printOutput) {
            System.out.println("=> " + msg.toString());
        }
        this.println(msg.toString());
        ++this.trId;
    }

    public void println(String str) throws IOException {
        this.out.write((str + "\r\n").getBytes("UTF-8"));
        this.out.flush();
    }

    public String readLine() throws IOException {
        this.inbuf.reset();
        while (true) {
            int v;
            if ((v = this.in.read()) == -1) {
                return null;
            }
            if (v == 13) continue;
            if (v == 10) break;
            this.inbuf.write(v);
        }
        return new String(this.inbuf.toByteArray(), "UTF-8");
    }

    public synchronized void sendMimeMessage(OutgoingMessage msg, MimeMessage mime) throws IOException {
        if (this.trId != -1 && msg.getBackProcess() != null) {
            this.callbackMap.put(new Integer(this.trId), msg.getBackProcess());
        }
        byte[] raw = mime.getBytes();
        int len = raw.length;
        msg.add(len);
        this.println(msg.toString());
        this.out.write(raw);
        if (Debug.printMime) {
            System.out.println(new String(raw, "UTF-8"));
        }
        this.out.flush();
        ++this.trId;
    }

    public synchronized void sendCHLResponse(OutgoingMessage msg, String hash) throws IOException {
        this.out.write(msg.toString().concat("\r\n").concat(hash).getBytes("UTF-8"));
        this.out.flush();
        ++this.trId;
    }

    public void markTransactionId(OutgoingMessage msg) {
        msg.setTransactionId(this.trId);
    }

    public int getCurrentTransactionId() {
        return this.trId;
    }

    protected Method lookupMethod(Callback cb) throws NoSuchMethodException, SecurityException {
        return cb.getClassRef().getMethod(cb.getMethodName(), PARAM_TYPE);
    }

    protected void registerCallback(Integer trId, Callback cb) {
        this.callbackMap.put(trId, cb);
    }

    public void processMessage(IncomingMessage msg) throws Exception {
    }

    public void processNotifyMessage(IncomingMessage msg) throws Exception {
        if (msg.getHeader().equals("MSG")) {
            int len = msg.getInt(2);
            int readlen = 0;
            byte[] b = new byte[len];
            for (int offset = 0; offset < len && (readlen = this.in.read(b, offset, len - offset)) != -1; offset += readlen) {
            }
            MimeMessage mime = MimeMessage.parse(b);
            this.filterMimeMessage(mime);
            if (Debug.printMime) {
                System.out.println(new String(b, "UTF-8"));
            }
        }
    }

    protected void filterMimeMessage(MimeMessage msg) {
    }

    public void removeInfiniteTransactionId(int trId) {
        this.callbackMap.remove(new Integer(trId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void run() {
        block46: {
            Exception e5;
            block42: {
                this.isLive = true;
                this.makeConnection();
                this.init();
                while (this.isLive) {
                    String line = this.readLine();
                    if (Debug.printInput) {
                        System.out.println("<= " + line);
                    }
                    if (line == null) break;
                    IncomingMessage msg = null;
                    try {
                        msg = IncomingMessage.getInstance(line);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (msg == null) continue;
                    try {
                        if (!msg.isNotify()) {
                            Integer trId = new Integer(msg.getTransactionId());
                            Callback cb = (Callback)this.callbackMap.get(trId);
                            if (cb != null) {
                                if (!cb.isInfinite()) {
                                    this.callbackMap.remove(trId);
                                }
                                this.lookupMethod(cb).invoke((Object)this, msg);
                                continue;
                            }
                            this.processMessage(msg);
                            continue;
                        }
                        this.processNotifyMessage(msg);
                    }
                    catch (IOException e3) {
                        throw e3;
                    }
                    catch (Exception e4) {
                        this.processError(e4);
                    }
                }
                Object var6_10 = null;
                this.cleanUp();
                if (this.in == null) break block42;
                try {
                    this.in.close();
                }
                catch (Exception e5) {
                    // empty catch block
                }
                this.in = null;
            }
            if (this.out != null) {
                try {
                    if (this.autoOut) {
                        this.sendMessage(new OutgoingMessage("OUT"));
                    }
                    this.out.close();
                }
                catch (Exception e5) {
                    // empty catch block
                }
                this.out = null;
            }
            if (this.socket == null) break block46;
            try {
                this.socket.close();
            }
            catch (Exception e5) {
                // empty catch block
            }
            this.socket = null;
            {
                break block46;
                catch (SocketException e6) {
                    Object var6_11 = null;
                    this.cleanUp();
                    if (this.in != null) {
                        try {
                            this.in.close();
                        }
                        catch (Exception e5) {
                            // empty catch block
                        }
                        this.in = null;
                    }
                    if (this.out != null) {
                        try {
                            if (this.autoOut) {
                                this.sendMessage(new OutgoingMessage("OUT"));
                            }
                            this.out.close();
                        }
                        catch (Exception e5) {
                            // empty catch block
                        }
                        this.out = null;
                    }
                    if (this.socket == null) break block46;
                    try {
                        this.socket.close();
                    }
                    catch (Exception e5) {
                        // empty catch block
                    }
                    this.socket = null;
                    break block46;
                }
                catch (Throwable e7) {
                    this.processError(e7);
                    Object var6_12 = null;
                    this.cleanUp();
                    if (this.in != null) {
                        try {
                            this.in.close();
                        }
                        catch (Exception e5) {
                            // empty catch block
                        }
                        this.in = null;
                    }
                    if (this.out != null) {
                        try {
                            if (this.autoOut) {
                                this.sendMessage(new OutgoingMessage("OUT"));
                            }
                            this.out.close();
                        }
                        catch (Exception e5) {
                            // empty catch block
                        }
                        this.out = null;
                    }
                    if (this.socket == null) break block46;
                    try {
                        this.socket.close();
                    }
                    catch (Exception e5) {
                        // empty catch block
                    }
                    this.socket = null;
                }
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                this.cleanUp();
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (Exception e5) {
                        // empty catch block
                    }
                    this.in = null;
                }
                if (this.out != null) {
                    try {
                        if (this.autoOut) {
                            this.sendMessage(new OutgoingMessage("OUT"));
                        }
                        this.out.close();
                    }
                    catch (Exception e5) {
                        // empty catch block
                    }
                    this.out = null;
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (Exception e5) {
                        // empty catch block
                    }
                    this.socket = null;
                }
                throw throwable;
            }
        }
    }

    public abstract void cleanUp();

    public void processError(Throwable e) {
        System.err.println(this.getClass().getName() + ":");
        e.printStackTrace();
    }

    public MSNMessenger getMsn() {
        return this.msn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

