" Vim support file to detect file types in scripts
"
" Maintainer:	Bram Moolenaar <Bram@vim.org>
" Last change:	2001 Aug 24

" This file is called by an autocommand for every file that has just been
" loaded into a buffer.  It checks if the type of file can be recognized by
" the file contents.  The autocommand is in $VIMRUNTIME/filetype.vim.


" Load the user defined scripts file first
" Only do this when the FileType autocommand has not been triggered yet
if !did_filetype() && exists("myscriptsfile") && file_readable(expand(myscriptsfile))
  execute "source " . myscriptsfile
endif

" Only do this when the FileType autocommand has not been triggered yet
if did_filetype()
  finish
endif

" Line continuation is used here, remove 'C' from 'cpoptions'
let s:cpo_save = &cpo
set cpo&vim

let s:line1 = getline(1)

" Check for a line like "#!/usr/bin/env bash".  Turn it into "#!/usr/bin/bash"
" to make matching easier.
if s:line1 =~ '^#!.*[/\\]env\s'
  let s:line1 = substitute(s:line1, '\<env\s\+', '', '')
endif

" Bourne-like shell scripts: sh ksh bash bash2
if s:line1 =~ '^#!.*[/\\]\(bash\|bash2\|ksh\|sh\)\>' || s:line1 =~ '^:$'
  call SetFileTypeSH(s:line1)	" defined in filetype.vim

" csh and tcsh scripts
elseif s:line1 =~ '^#!.*[/\\]t\=csh\>'
  set ft=csh

" Z shell scripts
elseif s:line1 =~ '^#!.*[/\\]zsh\>'
	\ || s:line1 =~ '^#compdef\>'
	\ || s:line1 =~ '^#autoload\>'
  set ft=zsh

" TCL scripts
elseif s:line1 =~ '^#!.*[/\\]\(tclsh\|wish\|expectk\|itclsh\|itkwish\)\>'
  set ft=tcl

" ELM Mail files
elseif s:line1 =~ '^From [a-zA-Z][a-zA-Z_0-9\.=-]*\(@[^ ]*\)\= .*[12][09]\d\d$'
  set ft=mail

" Expect scripts
elseif s:line1 =~ '^#!.*[/\\]expect\>'
  set ft=expect

" Gnuplot scripts
elseif s:line1 =~ '^#!.*[/\\]gnuplot\>'
  set ft=gnuplot

" Makefiles
elseif s:line1 =~ '^#!.*[/\\][^/\\]*make\>'
  set ft=make

" Mason
elseif s:line1 =~ '^<[%&].*>'
  set ft=mason

" Perl
elseif s:line1 =~ '^#!.*[/\\][^/\\]*perl[^/\\]*\>'
  set ft=perl

" Python
elseif s:line1 =~ '^#!.*[/\\][^/\\]*python[^/\\]*\>'
  set ft=python

" Ruby
elseif s:line1 =~ '^#!.*[/\\][^/\\]*ruby[^/\\]*\>'
  set ft=ruby

" BC calculator
elseif s:line1 =~ '^#!.*[/\\]bc\>'
  set ft=bc

" sed
elseif s:line1 =~ '^#!.*sed\>'
  set ft=sed

" Vim scripts (must have '" vim' as the first line to trigger this)
elseif s:line1 =~ '^" *[vV]im$'
  set ft=vim

" Diff file:
" - "diff" in first line (context diff)
" - "Only in " in first line
" - "--- " in first line and "+++ " in second line (unified diff).
" - "*** " in first line and "--- " in second line (context diff).
" - "# It was generated by makepatch " in the second line (makepatch diff).
" - "Index: <filename>" in the first line (CVS file)
elseif s:line1 =~ '^diff\>' || s:line1 =~ '^Only in '
	\ || (s:line1 =~ '^--- ' && getline(2) =~ '^+++ ')
	\ || (s:line1 =~ '^\*\*\* ' && getline(2) =~ '^--- ')
	\ || s:line1 =~ '^\d\+\(,\d\+\)\=[cda]\d\+\>'
	\ || getline(2) =~ '^# It was generated by makepatch '
	\ || s:line1 =~ '^Index:\s\+\f\+$'
	\ || s:line1 =~ '^==== //\f\+#\d\+'
  set ft=diff

" PostScript Files (must have %!PS as the first line, like a2ps output)
elseif s:line1 =~ '^%![ \t]*PS'
  set ft=postscr

" Awk scripts
elseif s:line1 =~ '^#!.*awk\>'
  set ft=awk

" M4 scripts: Guess there is a line that starts with "dnl".
elseif s:line1 =~ '^\s*dnl\>'
	\ || getline(2) =~ '^\s*dnl\>'
	\ || getline(3) =~ '^\s*dnl\>'
	\ || getline(4) =~ '^\s*dnl\>'
	\ || getline(5) =~ '^\s*dnl\>'
  set ft=m4

" AmigaDos scripts
elseif $TERM == "amiga"
	\ && (s:line1 =~ "^;" || s:line1 =~ '^\.[bB][rR][aA]')
  set ft=amiga

" SiCAD scripts (must have procn or procd as the first line to trigger this)
elseif s:line1 =~ '^ *[pP][rR][oO][cC][nNdD] *$'
  set ft=sicad

" Purify log files start with "****  Purify"
elseif s:line1 =~ '^\*\*\*\*  Purify'
  set ft=purifylog

" XML
elseif s:line1 =~ '<?\s*xml.*?>'
  set ft=xml

" XXD output
elseif getline(1) =~ '^\x\{7}: \x\{2} \=\x\{2} \=\x\{2} \=\x\{2} '
  set ft=xxd

" RCS/CVS log output
elseif s:line1 =~ '^RCS file:' || getline(2) =~ '^RCS file:'
  set ft=rcslog

" CVS commit
elseif getline(2) =~ '^CVS:'
   set ft=cvs

" SNNS files
elseif s:line1 =~ '^SNNS network definition file'
  set ft=snnsnet
elseif s:line1 =~ '^SNNS pattern definition file'
  set ft=snnspat
elseif s:line1 =~ '^SNNS result file'
  set ft=snnsres

" Virata
elseif s:line1 =~ '^%.\{-}[Vv]irata'
	\ || getline(2) =~ '^%.\{-}[Vv]irata'
	\ || getline(3) =~ '^%.\{-}[Vv]irata'
	\ || getline(4) =~ '^%.\{-}[Vv]irata'
	\ || getline(5) =~ '^%.\{-}[Vv]irata'
  set ft=virata

" Website MetaLanguage
elseif s:line1 =~ '^#!.*wml.*'
  set ft=wml

" Strace
elseif s:line1 =~ '^execve('
  set ft=strace

" VSE JCL
elseif s:line1 =~ '^\* $$ JOB\>' || s:line1 =~ '^// *JOB\>'
  set ft=vsejcl

" TAK and SINDA
elseif getline(4) =~ 'K & K  Associates' || getline(2) =~ 'TAK 2000'
  set ft=takout
elseif getline(3) =~ 'S Y S T E M S   I M P R O V E D '
  set ft=sindaout
elseif getline(6) =~ 'Run Date: '
  set ft=takcmp
elseif getline(9) =~ 'Node    File  1'
  set ft=sindacmp

" DNS zone files
elseif getline(1) =~ '\($ORIGIN\|$TTL\|IN\s*SOA\)'
      \ || getline(2) =~ '\($ORIGIN\|$TTL\|IN\s*SOA\)'
      \ || getline(1).getline(2).getline(3).getline(4) =~ 'BIND.*named'
  set ft=dns


endif

" Restore 'cpoptions'
let &cpo = s:cpo_save

unlet s:cpo_save s:line1
