" Vim syntax file
" Language:	IDL (Interface Description Language)
" Maintainer:	Jody Goldberg <jgoldberg@home.com>
" Last Change:	2001 Mar 19

" This is an experiment.  IDL's structure is simple enough to permit a full
" grammar based approach to rather than using a few heuristics.  The result
" is large and somewhat repetative but seems to work.

" Quit when a syntax file was already loaded
if exists("b:current_syntax")
  finish
endif

" Misc basic
syn match	idlId		contained "[a-zA-Z][a-zA-Z0-9_]*"
syn match	idlSemiColon	contained ";"
syn match	idlCommaArg	contained ","			skipempty skipwhite nextgroup=idlSimpDecl
syn region	idlArraySize1	contained start=:\[: end=:\]:	skipempty skipwhite nextgroup=idlArraySize1,idlSemiColon,idlCommaArg contains=idlArraySize1,idlLiteral
syn match   idlSimpDecl	 contained "[a-zA-Z][a-zA-Z0-9_]*"	skipempty skipwhite nextgroup=idlSemiColon,idlCommaArg,idlArraySize1
syn region  idlSting	 contained start=+"+  skip=+\\\(\\\\\)*"+  end=+"+
syn match   idlLiteral	 contained "[1-9]\d*\(\.\d*\)\="
syn match   idlLiteral	 contained "\.\d\+"
syn keyword idlLiteral	 contained TRUE FALSE

" Comments
syn keyword idlTodo contained	TODO FIXME XXX
syn region idlComment		start="/\*"  end="\*/" contains=idlTodo
syn match  idlComment		"//.*" contains=idlTodo
syn match  idlCommentError	"\*/"

" C style Preprocessor
syn region idlIncluded contained start=+"+  skip=+\\\(\\\\\)*"+  end=+"+
syn match  idlIncluded contained "<[^>]*>"
syn match  idlInclude		"^[ \t]*#[ \t]*include\>[ \t]*["<]" contains=idlIncluded,idlString
syn region idlPreCondit	start="^[ \t]*#[ \t]*\(if\>\|ifdef\>\|ifndef\>\|elif\>\|else\>\|endif\>\)"  skip="\\$"  end="$" contains=idlComment,idlCommentError
syn region idlDefine	start="^[ \t]*#[ \t]*\(define\>\|undef\>\)" skip="\\$" end="$" contains=idlLiteral, idlString

" Constants
syn keyword idlConst	const	skipempty skipwhite nextgroup=idlBaseType,idlBaseTypeInt

" Attribute
syn keyword idlROAttr	readonly	skipempty skipwhite nextgroup=idlAttr
syn keyword idlAttr	attribute	skipempty skipwhite nextgroup=idlBaseTypeInt,idlBaseType

" Types
syn region  idlD4	contained start="<" end=">"	skipempty skipwhite nextgroup=idlSimpDecl	contains=idlSeqType,idlBaseTypeInt,idlBaseType,idlLiteral
syn keyword idlSeqType	contained sequence		skipempty skipwhite nextgroup=idlD4
syn keyword idlBaseType		contained	float double char boolean octet any	skipempty skipwhite nextgroup=idlSimpDecl
syn keyword idlBaseTypeInt	contained	short long		skipempty skipwhite nextgroup=idlSimpDecl
syn keyword idlBaseType		contained	unsigned		skipempty skipwhite nextgroup=idlBaseTypeInt
syn region  idlD1		contained	start="<" end=">"	skipempty skipwhite nextgroup=idlSimpDecl	contains=idlString,idlLiteral
syn keyword idlBaseType		contained	string	skipempty skipwhite nextgroup=idlD1,idlSimpDecl
syn match   idlBaseType		contained	"[a-zA-Z0-9_]\+[ \t]*\(::[ \t]*[a-zA-Z0-9_]\+\)*"	skipempty skipwhite nextgroup=idlSimpDecl

" Modules
syn region  idlModuleContent contained start="{" end="}"	skipempty skipwhite nextgroup=idlSemiColon contains=idlUnion,idlStruct,idlEnum,idlInterface,idlComment,idlTypedef,idlConst,idlException,idlModule
syn match   idlModuleName contained	"[a-zA-Z0-9_]\+"	skipempty skipwhite nextgroup=idlModuleContent,idlSemiColon
syn keyword idlModule			module			skipempty skipwhite nextgroup=idlModuleName

" Interfaces
syn region  idlInterfaceContent contained start="{" end="}"	skipempty skipwhite nextgroup=idlSemiColon contains=idlUnion,idlStruct,idlEnum,idlComment,idlROAttr,idlAttr,idlOp,idlOneWayOp,idlException,idlConst,idlTypedef
syn match   idlInheritFrom2 contained "," skipempty skipwhite nextgroup=idlInheritFrom
syn match idlInheritFrom contained "[a-zA-Z0-9_]\+[ \t]*\(::[ \t]*[a-zA-Z0-9_]\+\)*" skipempty skipwhite nextgroup=idlInheritFrom2,idlInterfaceContent
syn match idlInherit contained	":"		skipempty skipwhite nextgroup=idlInheritFrom
syn match   idlInterfaceName contained	"[a-zA-Z0-9_]\+"	skipempty skipwhite nextgroup=idlInterfaceContent,idlInherit,idlSemiColon
syn keyword idlInterface		interface		skipempty skipwhite nextgroup=idlInterfaceName


" Raises
syn keyword idlRaises	contained raises	skipempty skipwhite nextgroup=idlRaises,idlContext,idlSemiColon

" Context
syn keyword idlContext	contained context	skipempty skipwhite nextgroup=idlRaises,idlContext,idlSemiColon

" Operation
syn match   idlParmList	contained "," skipempty skipwhite nextgroup=idlOpParms
syn region  idlArraySize contained start="\[" end="\]"	skipempty skipwhite nextgroup=idlArraySize,idlParmList contains=idlArraySize,idlLiteral
syn match   idlParmName contained "[a-zA-Z0-9_]\+"	skipempty skipwhite nextgroup=idlParmList,idlArraySize
syn keyword idlParmInt	contained short long		skipempty skipwhite nextgroup=idlParmName
syn keyword idlParmType	contained unsigned		skipempty skipwhite nextgroup=idlParmInt
syn region  idlD3	contained start="<" end=">"	skipempty skipwhite nextgroup=idlParmName	contains=idlString,idlLiteral
syn keyword idlParmType	contained string		skipempty skipwhite nextgroup=idlD3,idlParmName
syn keyword idlParmType	contained void float double char boolean octet any	  skipempty skipwhite nextgroup=idlParmName
syn match   idlParmType	contained "[a-zA-Z0-9_]\+[ \t]*\(::[ \t]*[a-zA-Z0-9_]\+\)*" skipempty skipwhite nextgroup=idlParmName
syn keyword idlOpParms	contained in out inout		skipempty skipwhite nextgroup=idlParmType

syn region idlOpContents contained start="(" end=")"	skipempty skipwhite nextgroup=idlRaises,idlContext,idlSemiColon contains=idlOpParms
syn match   idlOpName   contained "[a-zA-Z0-9_]\+"	skipempty skipwhite nextgroup=idlOpContents
syn keyword idlOpInt	contained short long		skipempty skipwhite nextgroup=idlOpName
syn region  idlD2	contained start="<" end=">"	skipempty skipwhite nextgroup=idlOpName	contains=idlString,idlLiteral
syn keyword idlOp	contained unsigned		skipempty skipwhite nextgroup=idlOpInt
syn keyword idlOp	contained string		skipempty skipwhite nextgroup=idlD2,idlOpName
syn keyword idlOp	contained void float double char boolean octet any		skipempty skipwhite nextgroup=idlOpName
syn match   idlOp	contained "[a-zA-Z0-9_]\+[ \t]*\(::[ \t]*[a-zA-Z0-9_]\+\)*"	skipempty skipwhite nextgroup=idlOpName
syn keyword idlOp	contained void			skipempty skipwhite nextgroup=idlOpName
syn keyword idlOneWayOp	contained oneway		skipempty skipwhite nextgroup=idOp

" Enum
syn region  idlEnumContents contained start="{" end="}"		skipempty skipwhite nextgroup=idlSemiColon, idlSimpDecl contains=idlId,idlComment
syn match   idlEnumName contained	"[a-zA-Z0-9_]\+"	skipempty skipwhite nextgroup=idlEnumContents
syn keyword idlEnum			enum			skipempty skipwhite nextgroup=idlEnumName

" Typedef
syn keyword idlTypedef			typedef			skipempty skipwhite nextgroup=idlBaseType, idlBaseTypeInt, idlSeqType

" Struct
syn region  idlStructContent contained start="{" end="}" skipempty skipwhite nextgroup=idlSemiColon, idlSimpDecl	contains=idlBaseType, idlBaseTypeInt, idlSeqType,idlComment, idlEnum, idlUnion
syn match   idlStructName contained	"[a-zA-Z0-9_]\+" skipempty skipwhite nextgroup=idlStructContent
syn keyword idlStruct			struct		 skipempty skipwhite nextgroup=idlStructName

" Exception
syn keyword idlException exception skipempty skipwhite nextgroup=idlStructName

" Union
syn match   idlColon contained ":"	skipempty skipwhite nextgroup=idlCase,idlSeqType,idlBaseType,idlBaseTypeInt
syn region  idlCaseLabel contained start="" skip="::" end=":"me=e-1	skipempty skipwhite nextgroup=idlColon contains=idlLiteral,idlString
syn keyword idlCase		contained case				skipempty skipwhite nextgroup=idlCaseLabel
syn keyword idlCase		contained default			skipempty skipwhite nextgroup=idlColon
syn region  idlUnionContent	contained start="{" end="}"		skipempty skipwhite nextgroup=idlSemiColon,idlSimpDecl	contains=idlCase
syn region  idlSwitchType	contained start="(" end=")"		skipempty skipwhite nextgroup=idlUnionContent
syn keyword idlUnionSwitch	contained switch			skipempty skipwhite nextgroup=idlSwitchType
syn match   idlUnionName	contained "[a-zA-Z0-9_]\+"		skipempty skipwhite nextgroup=idlUnionSwitch
syn keyword idlUnion		union				skipempty skipwhite nextgroup=idlUnionName

syn sync lines=200

" The default highlighting.
hi def link idlInclude		Include
hi def link idlPreProc		PreProc
hi def link idlPreCondit	PreCondit
hi def link idlDefine		Macro
hi def link idlIncluded		String
hi def link idlString		String
hi def link idlComment		Comment
hi def link idlTodo		Todo
hi def link idlLiteral		Number

hi def link idlModule		Keyword
hi def link idlInterface	Keyword
hi def link idlEnum		Keyword
hi def link idlStruct		Keyword
hi def link idlUnion		Keyword
hi def link idlTypedef		Keyword
hi def link idlException	Keyword

hi def link idlModuleName	Typedef
hi def link idlInterfaceName	Typedef
hi def link idlEnumName		Typedef
hi def link idlStructName	Typedef
hi def link idlUnionName	Typedef

hi def link idlBaseTypeInt	idlType
hi def link idlBaseType		idlType
hi def link idlSeqType		idlType
hi def link idlD1		Paren
hi def link idlD2		Paren
hi def link idlD3		Paren
hi def link idlD4		Paren
"hi def link idlArraySize	Paren
"hi def link idlArraySize1	Paren
hi def link idlModuleContent	Paren
hi def link idlUnionContent	Paren
hi def link idlStructContent	Paren
hi def link idlEnumContents	Paren
hi def link idlInterfaceContent	Paren

hi def link idlSimpDecl		Identifier
hi def link idlROAttr		StorageClass
hi def link idlAttr		Keyword
hi def link idlConst		StorageClass

hi def link idlOneWayOp		StorageClass
hi def link idlOp		idlType
hi def link idlParmType		idlType
hi def link idlOpName		Function
hi def link idlOpParms		StorageClass
hi def link idlParmName		Identifier
hi def link idlInheritFrom	Identifier

hi def link idlId		Constant
"hi def link idlCase		Keyword
hi def link idlCaseLabel	Constant

let b:current_syntax = "idl"

" vim: ts=8
